define(["tiny-common/UnifyValid"], function(UnifyValid){
	var ctrl = ["$scope", "message", "appUtils", "model","constsService",
	     function($scope, message, appUtils, Model, Consts){

			var resource  = appUtils.resource();
			var transdata = appUtils.getWinData();

			//testPo可写,需用深拷贝
			$scope.testPo = angular.copy(transdata.po);
			$scope.pgId   = transdata.pgId;
			$scope.Consts = Consts;

		    $scope.text = {
				dbName : resource.getWithColon("ism.drm.proetct.group.appdb.dbname.column"),
				dbInsName : resource.getWithColon("ism.drm.proetct.group.appdb.instance.column"),
				username : resource.getWithColon("common_term_username_label"),
				password : resource.getWithColon("common_term_password_label"),
				asmInsName : resource.getWithColon("ism.drm.protect.group.asm.asmInstanceName"),
				asmUsername : resource.getWithColon("ism.drm.protect.group.asm.usename"),
				asmPassword : resource.getWithColon("ism.drm.protect.group.asm.password"),
				valiType : resource.getWithColon("common_term_authenticationMode_label"),
				modifyVerify : resource.get("ism.drm.protectgroup.db.modify.verify"),
				asmVerify : resource.get("ism.drm.protectgroup.db.modify.asmVerify")
			};

			if($scope.testPo.poType == 16){
				$scope.text.dbName = resource.getWithColon("site_term_system_id_label");
				$scope.text.dbInsName = resource.getWithColon("site_term_instance_number_label");
			};

		    var disable = $scope.testPo.props.IS_ASM == "1";
		    var isOsValidate = $scope.testPo.props.AUTH_TYPE == "1";
			$scope.model = {
				labelwidth : "65",
				dbName : $scope.testPo.name,
				instanceName : Model.util.formatIstName($scope.testPo.props.INSTANCENAME),
				isAsm : $scope.testPo.props.IS_ASM == "1",
				isOracle : $scope.testPo.poType == "1",
				username : {
					id : "username",
					validate : $scope.testPo.poType == 16 ? "required;maxSize(128):" + appUtils.getString("validate_term_expr_length") : Consts.VALID.AUTH_NAME,
					disable : disable,
					value : $scope.testPo.props.USERNAME
				},
				password : {
					id : "password",
					validate : $scope.testPo.poType == 16 ? "required;maxSize(128):" + appUtils.getString("validate_term_expr_length") : Consts.VALID.AUTH_PWD,
					type : "password",
					disable : disable
				},
				asmInsName : {
					id : "asmInsName",
					validate : Consts.VALID.AUTH_NAME,
					value : $scope.testPo.props.ASM_INSTANCENAME,
					disable : disable
				},
				asmUsername : {
					id : "asmUsername",
					validate : Consts.VALID.AUTH_NAME,
					value : $scope.testPo.props.ASM_USERNAME,
					disable : disable
				},
				asmPassword : {
					id : "asmPassword",
					validate : Consts.VALID.AUTH_PWD,
					type : "password",
					disable : disable
				},
				type : {
					id : "type",
					values : [{label:resource.get("common_term_authenticationMode_value_database_value"), selectId:"0"},{label:resource.get("common_term_authenticationMode_value_os_value"), selectId:"1"}],
					defaultSelectid : "0",
					message : appUtils.getString("pg_certification_mode_message"),
					change : function(p){
						var typeId = $("#type").widget().getSelectedId();
						if( typeId == "1" ){
							enableInput(false);
						}else{
							enableInput(true);
						}
					}
				}
			};

			$scope.dbChBox = {
	                "id" : "dbChBox",
	                "items" : [{label:resource.get("common_term_disable_label"),value:"off"},{label:resource.get("common_term_enable_label"),value:"on"}],
	                "selected" : "off",
	                "standard" : true,
	                "disable" : false,
	                "change" : function(){
	                	var oldId = $("#dbChBox").widget().option("selected");
	                	setDbStatus(oldId == "on" ? true : false);
	                }
		        };

			$scope.asmChBox = {
                "id" : "asmChBox",
                "items" : [{label:resource.get("common_term_disable_label"),value:"off"},{label:resource.get("common_term_enable_label"),value:"on"}],
                "selected" : "off",
                "standard" : true,
                "disable" : false,
                "change" : function(){
                	var oldId = $("#asmChBox").widget().option("selected");
                	setASMStatus(oldId == "on" ? true : false);
                }
		    };

			if( $scope.testPo.props.AUTH_TYPE == "1" ){
				$scope.model.type.defaultSelectid = "1";
				enableInput(false);
			}

			function enableInput(enable){
				if(enable){
					if( $scope.testPo.props.IS_ASM == "1" ){
						//原来是os认证,改为数据认证则必须输入用户名密码
						if( isOsValidate ){
							$scope.dbChBox.disable = true;
							$scope.asmChBox.disable = true;
							$scope.dbChBox.selected = "on";
							$scope.asmChBox.selected = "on";
							$scope.model.username.disable = false;
							$scope.model.password.disable = false;
							$scope.model.asmInsName.disable = false;
							$scope.model.asmUsername.disable = false;
							$scope.model.asmPassword.disable = false;
						}
						else{
							$scope.dbChBox.disable = false;
							$scope.asmChBox.disable = false;
							if( $("#dbChBox").widget().option("selected") == "on" ){
								$scope.model.username.disable = false;
								$scope.model.password.disable = false;
							}else{
								$scope.model.username.disable = true;
								$scope.model.password.disable = true;
							}

							if( $("#asmChBox").widget().option("selected") == "on" ){
								$scope.model.asmInsName.disable = false;
								$scope.model.asmUsername.disable = false;
								$scope.model.asmPassword.disable = false;
							}else{
								$scope.model.asmInsName.disable = true;
								$scope.model.asmUsername.disable = true;
								$scope.model.asmPassword.disable = true;
							}

							//os认证只能修改asm实例名
							if( $("#type").widget().getSelectedId() == "1" ){
								$scope.model.asmUsername.disable = true;
								$scope.model.asmPassword.disable = true;
							}
						}
					}else{
						$scope.model.username.disable = false;
						$scope.model.password.disable = false;
					}
				}else{
					$scope.dbChBox.disable = true;
					$scope.asmChBox.disable = false;
					$scope.model.username.disable = true;
					$scope.model.password.disable = true;
					$scope.model.asmInsName.disable = true;
					$scope.model.asmUsername.disable = true;
					$scope.model.asmPassword.disable = true;

					if( $("#asmChBox").widget() && $("#asmChBox").widget().option("selected") == "on" ){
						$scope.model.asmInsName.disable = false;
					}
				}
			}

			function setDbStatus(disable){
				$scope.model.username.disable = disable;
				$scope.model.password.disable = disable;
			}

			function setASMStatus(disable){
				$scope.model.asmInsName.disable = disable;
				$scope.model.asmUsername.disable = disable;
				$scope.model.asmPassword.disable = disable;

				if( $("#type").widget().getSelectedId() == "1" ){
					$scope.model.asmUsername.disable = true;
					$scope.model.asmPassword.disable = true;
				}
			}

			$("#"+Consts.MODIFY_DB_TEST_WIN.winId).widget().option("buttons",[{
                    label : resource.get("common_term_yes_button"),
                    handler : function(event) {

                    	if( $scope.model.isOracle ){
                    		//操作系统认证
                    		if( $("#type").widget().getSelectedId() == "1" ){
                    			$scope.testPo.props.AUTH_TYPE = "1";
                    			if( $("#asmChBox").widget().option("selected") == "on" ){
                                	var ok = UnifyValid.FormValid($("#modifyDbTestWinDiv"), {focusInvalid: true});
                                	if(!ok) return;

                    				$scope.testPo.props.ASM_INSTANCENAME = $("#asmInsName").widget().getValue();
                    			}else{
                    				delete $scope.testPo.props.ASM_INSTANCENAME;
                    			}
                    			testDB();
                    			return;
                    		}
                    		else{
                    			$scope.testPo.props.AUTH_TYPE = "0";
                    		}
                    	}

                    	//校验不通过
                    	var ok = UnifyValid.FormValid($("#modifyDbTestWinDiv"), {focusInvalid: true});
                    	if(!ok) return;

                    	//没有修改,直接关闭
                    	if( $scope.model.isAsm && $("#dbChBox").widget().option("selected") == "off" &&  $("#asmChBox").widget().option("selected") == "off" ){
                    		appUtils.closeWin(true);
                    		return;
                    	}

						if($scope.testPo.props.IS_ASM == "1"){
							if( $("#dbChBox").widget().option("selected") == "on" ){
	                    		$scope.testPo.props.USERNAME = $("#username").widget().getValue();
	                    		$scope.testPo.props.PASSWD = $("#password").widget().getValue();
	                    	}else{
	                    		delete $scope.testPo.props.USERNAME;
	                    		delete $scope.testPo.props.PASSWD;
	                    	}
							if( $("#asmChBox").widget().option("selected") == "on" ){
	                    		$scope.testPo.props.ASM_INSTANCENAME =  $("#asmInsName").widget().getValue();
	                    		$scope.testPo.props.ASM_USERNAME = $("#asmUsername").widget().getValue();
	                    		$scope.testPo.props.ASM_PASSWD = $("#asmPassword").widget().getValue();
	                    	}else{
	                    		delete $scope.testPo.props.ASM_INSTANCENAME;
	                    		delete $scope.testPo.props.ASM_USERNAME;
	                    		delete $scope.testPo.props.ASM_PASSWD;
	                    	}
						}else{
							$scope.testPo.props.USERNAME = $("#username").widget().getValue();
                    		$scope.testPo.props.PASSWD = $("#password").widget().getValue();
						}

                    	testDB();
                    }
			}]);

			function testDB(){
				var poModel = new Model.ProtectObject($scope.testPo);
				poModel.validateAuthInfo({
					"maskClose": false,
					"timeout"  : Consts.AJAX_TIMEOUT,
					"success"  : function(){
						//入库
						poModel.updateAuthInfo($scope.pgId,{
							"success" : function(){
								message.success({
									content : resource.get("common_term_operation_success_label"),
									ok : function(){appUtils.closeWin(true);}
								});
							}
						});
					}
				});
			}

	}];

	var modifyDbTestWinModule = angular.module("recoverydirector.protection.config");
	modifyDbTestWinModule.tinyController("modifyDbTestWinCtrl", ctrl);
    return modifyDbTestWinModule;
});
