define([], function() {
    "use strict";
    var ctrl = ["$scope", "constsService", "appUtils", "restService", "model", "message", function($scope, Consts, appUtils, Rest, Model, message) {
        var resource = appUtils.resource();

        var winData = appUtils.getWinData();
        var siteId = winData.siteId;
        var providerName = winData.providerName;
        var checkedNas = winData.checkedNas;
        var crtStorageId;
        var G_pg = new Model.ProtectGroup(winData.protectGroup);

        $scope.storageSelectShow = !providerName;


        $scope.desc = resource.get("protection_oracle_task_create_addNAS_selFS_des_label");

        var tableFixer = appUtils.tableFixer("nasPoTable", "moUuid", checkedNas);
        //初始数据updateDb时不清空,
        tableFixer.search = true;

        $scope.avalablePoText = resource.get("protection_term_availableObject_label");
		$scope.storageLabel = appUtils.getStringWithColon("common_term_ower_storage_label");

        $scope.table = {
            id: "nasPoTable",
            displayLength: Consts.TABLE_COUNT_PER_PAGE,
            checkbox: true,
            tableFixer: tableFixer,
            columns: [{
                "bVisible": false,
                "mData": "moUuid"
            }, {
                "sTitle": appUtils.getString("current_alarm_term_name_column"),
                "mData": "name",
                "bSortable": false
            }, {
                "sTitle": "ID",
                "mData": "props.nasFsId",
                "bSortable": false
            }, {
                "sTitle": appUtils.getString("ism.drm.host.fs.capacity"),
                "mData": "props.totalCapacityAndUnit",
                "bSortable": false
            }, {
                "sTitle": appUtils.getString("common_term_ower_storage_label"),
                "mData": "providerName",
                "bSortable": false
            }],
            tHeadCheckboxFn: function() {
                var sid = $("#storageSelect").widget().getSelectedId();
                if (sid && crtStorageId != sid) {
                    tableFixer.clear();
                    crtStorageId = sid;
                }
                tableFixer.click();
            },
            renderRow: function(nRow, aData, iDataIndex) {
            },
            click: function(event, cell) {
                //跨存储时清除原来选中的NAS
                var sid = $("#storageSelect").widget().getSelectedId();
                if (sid && crtStorageId != sid) {
                    tableFixer.clear();
                    crtStorageId = sid;
                }

                tableFixer.click();
            },
            drawCallback: function() {
                tableFixer.selectRow();
            }
        };

        var updateDb = appUtils.newUpdateTable($scope.table, $scope);

        $scope.storage = {
            id: "storageSelect",
            defaultSelectid: "-1",
            values: [{
                selectId: "-1",
                label: appUtils.getString("common_term_pleaseSelect_listbox")
            }],
            width : appUtils.isEn() ? 200 : 260,
            select: function() {
                $("#nasSearchBox").widget().setValue("");

                if (providerName) return;

                appUtils.doSelect("storageSelect", function(storageId) {
                    //切换数据updateDb不清空,
                    tableFixer.search = true;

                    $scope.maskHandle = $.Deferred();
                    $scope.$apply();
                    Rest.queryProtectObjects([14, storageId], {
                        mask : false,
                        success : updateDb,
                        callback : function(){
                            $scope.maskHandle.resolve();
                        }
                    });
                });
            }
        };

        $("#" + Consts.NAS_PO_WIN.winId).widget().option("buttons", [{
            label: appUtils.getString("common_term_confirm_button"),
            handler: function() {
                if (providerName) {
                    G_pg.polist = Model.util.generatePoListFromTable(tableFixer);
                    G_pg.addProtectObject(function() {
                        message.prompt({
                            content: appUtils.getString(resource.get("site_term_refresh_message")),
                            ok: function() {
                                appUtils.closeWin(true);
                            }
                        });
                    });
                } else {
                    checkedNas = tableFixer.getSelectedRow();
                    appUtils.closeWin({
                        ok: true,
                        checkedNas: checkedNas
                    });
                }
            }
        }]);


        init();

        function init() {
            //添加时providerSN已经确定
			if( providerName ){
				$scope.storage.values = [{selectId: 1, label : providerName}];
				$scope.storage.defaultSelectid = 1;
				Rest.getAddAvailableProtectObject({pgId: G_pg.pgId, poType: 14},updateDb);
				return;
			}

			//查询站点下的存储
			Rest.queryStorageBySite(siteId,function(data){
				appUtils.updateSelectValues("storageSelect",data,"deviceSn","name");
				//默认查询第一个存储下的NAS
				var defaultSelectid = (angular.isArray(data) && data[0] && data[0].deviceSn) || "-1";
				//如果已经选中存储,则选中此项
				if( angular.isArray(checkedNas) && checkedNas.length > 0 ){
					defaultSelectid = checkedNas[0].providerSN;
				}

				if( defaultSelectid ){
					crtStorageId = defaultSelectid;
					$scope.storage.defaultSelectid = defaultSelectid;

                    $scope.maskHandle = $.Deferred();
                    $scope.$apply();

					Rest.queryProtectObjects([14,defaultSelectid],{
                        mask : false,
                        success : updateDb,
                        callback : function(){
                            $scope.maskHandle.resolve();
                        }
                    });
				}
				else{
					updateDb();
				}
			});
        }

        $scope.init = init;
        $scope.nasSearch = {
            searchSelect: {
                id: "searchSelect",
                values: [{
                    selectId: "name",
                    label: appUtils.getString("current_alarm_term_name_column")
                }],
                defaultSelectid: "name"
            },
            search: {
                id: "nasSearchBox",
                searchFn: function(query) {
                    query = appUtils.formatSearchVal(query);

                    var key = $("#searchSelect").widget().getSelectedId(),
                        filter = "extFilter." + key + "=" + query;

		                    //添加时providerSN已经确定
					if( providerName ){
						appUtils.doSelect("storageSelect", function(storageId) {
							$scope.storage.values = [{selectId: 1, label : providerName}];
							$scope.storage.defaultSelectid = 1;
		                    //切换数据updateDb不清空,
		                    tableFixer.search = true;
		                    Rest.getAddAvailableProtectObject({pgId: G_pg.pgId, poType: 14, _FILTER : filter},updateDb);
		                });
						return;
					}
                    var selectSn = $("#storageSelect").widget().getSelectedId();
                    if(!selectSn){
                        return;
                    }
					appUtils.doSelect("storageSelect", function(storageId) {
	                    //切换数据updateDb不清空,
	                    tableFixer.search = true;

                        $scope.maskHandle = $.Deferred();
                        $scope.$apply();

	                    Rest.queryProtectObjects({poType : 14,deviceSn : storageId,_FILTER : filter}, {
                            mask : false,
                            success : updateDb,
                            callback : function(){
                                $scope.maskHandle.resolve();
                            }
                        });
	                });
                }
            }
        }
    }];

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("nasPoCtrl", ctrl);
    return module;
});
