define([], function() {
    "use strict";
    var hostGroupRefreshCtrl = [
        "$scope",
        "communicationService",
        "utilService",
        "constsService",
        "statusEnumService",
        "appUtils",
        "mask",
        "restService",
        function($scope, communicationService, utilService, constsService, statusEnumService, appUtils, mask, Rest) {

            var winData = $("#" + constsService.PG_OPERATION_RESULT_WIN.winId).widget().option("data")["pgs"];
            var handdlerType = $("#" + constsService.PG_OPERATION_RESULT_WIN.winId).widget().option("data")["type"];
            $scope.operationResult = {
                id: "operationResultTable",
                data: [],
                columns: [{
                    "sTitle": appUtils.getString("task_term_operation_obj_label"),
                    "mData": "name",
                    "bSortable": false,
                    "sWidth": "200px"
                }, {
                    "sTitle": appUtils.getString("common_term_status_column"),
                    "mData": "statusCode",
                    "bSortable": false,
                    "sWidth": "100px"
                }, {
                    "sTitle": appUtils.getString("common_term_detail_label"),
                    "bSortable": false
                }],
                renderRow: function(nRow, aData, iDataIndex) {

                    var errorStr = "";
                    if (aData["statusCode"]) {
                        errorStr = "lego.err." + aData["statusCode"];
                        errorStr = appUtils.getString(errorStr);
                        aData["statusCode"] = "0";
                    }

                    if (_.isEmpty(errorStr)) {
                        errorStr = "--";
                        aData["statusCode"] = "1";
                    }

                    $('td:eq(2)', nRow).html(errorStr);
                    $("td:eq(1)", nRow).html(statusEnumService.getStatus("PG_HISTORY_RESULT", String(aData["statusCode"])));
                }
            };


            function init() {
                if (_.isEmpty(winData)) {
                    return;
                }
                _.each(winData, function(pg) {
                    var excuteMesssage = {};
                    if (handdlerType == "disable") {
                        Rest.disableProtectGroup(pg.uuid, {
                            success: function(result) {
                                var details = [];
                                excuteMesssage.statusCode = !_.isEmpty(result.responseText) ? (JSON.parse(result.responseText)).errorCode : "";
                                excuteMesssage.name = pg.name;
                                details.push(excuteMesssage);
                                $scope.operationResult.data = appUtils.encodeForHTML($scope.operationResult.data.concat(details));
                                $scope.$apply();
                            }
                        })
                    } else {
                        Rest.enableProtectGroup(pg.uuid, {
                            "success": function(result) {
                                var details = [];
                                excuteMesssage.statusCode = !_.isEmpty(result.responseText) ? (JSON.parse(result.responseText)).errorCode : "";
                                excuteMesssage.name = pg.name;
                                details.push(excuteMesssage);
                                $scope.operationResult.data = appUtils.encodeForHTML($scope.operationResult.data.concat(details));
                                $scope.$apply();
                            }
                        });
                    }
                });
            };

            init();
        }
    ];
    var operationResultModule = angular.module("recoverydirector.protection.config");
    operationResultModule.tinyController("operation-result-win-ctrl", hostGroupRefreshCtrl);
    return operationResultModule;
})
