define([], function() {
	"use strict";
	var ctrl = ["$scope","$timeout","constsService","appUtils","restService","statusEnumService","exception","treeTableRenderService",
			function($scope,$timeout, Consts ,appUtils, Rest, Status, exception, treeTableRenderService) {

				var data = appUtils.getWinData();
				var resource = appUtils.resource();

				Rest.queryProtectGroupLogDetail([data.pgId,data.logId],function(data){
					var treeData = formatTreeDate(data);
					treeTableRenderService.treeTableBuf = "";
                    treeTableRenderService.initTreeTabelHead();
                    treeTableRenderService.initTreeTabContent(treeData, true);
                    treeTableRenderService.initTableFinalTag();
                    treeTableRenderService.showDetails(treeTableRenderService.saveChildrenId(treeData));
                    treeTableRenderService.historyBindEvent();
				 });

				function formatTreeDate(data, parentDetailId) {
                    var keyMap = {
                        "title": "processName",
                        "result": "processStatus",
                        "protectGroupLogDetails": "children",
                        "titleParams": "processNameParams",
                        "infoParams": "processDetailParams",
                        "info": "processDetail"
                    };

                    var statusMap = {
                        "1": "0",
                        "0": "1",
                        "2": "3",
                        "3": "--"
                    };

                    if (angular.isArray(data) && data.length > 0) {
                        data.forEach(function(item) {
                            if (parentDetailId) {
                                item.parentDetailId = parentDetailId;
                            }

                            item.result = statusMap[item.result + ""];

                            angular.forEach(keyMap, function(v, k) {
                                //这两个参数需要转换为数组
                                if( k == "titleParams" || k == "infoParams" ){
                                    item[k] && (item[v] = item[k].split(";"));
                                }
                                else{
                                    item[v] = item[k];
                                }

                                delete item[k];
                            });

                            if (angular.isArray(item.children) && item.children.length > 0) {
                                formatTreeDate(item.children, item.detailId);
                            }
                        });
                    }

                    return data;
                }

			}];

	var module = angular.module("recoverydirector.protection.config");
	module.tinyController("pgExecDetailCtrl", ctrl);
	return module;
});
