define([], function(){
	var ctrl = ["$scope","appUtils","constsService","restService","model",function($scope,appUtils,Consts,Rest,Model){

		if(!$scope.$parent.tabShow) return;
		$scope.pt = $scope.protectGroup.template;
		$scope.primary = $scope.protectGroup.primary;
		if( !$scope.pt ) return;

		var resource = appUtils.resource();
		$scope.Consts = Consts;
		var copyRate;

		$scope.checkRight = appUtils.checkRight;

		$scope.panelVM = Model.ViewModel.create({
			data: $scope.pt,
			pg: $scope.protectGroup,
			ok: function(){
				init();
			}
		});


		function init(){
			var status = $scope.protectGroup.status;
			var statusTypes = Consts.PROTECT_GROUP_STATUS;

	    	//修改策略
			var enable = status == statusTypes.DISABLED ? false //禁用不能修改策略
                : status == statusTypes.INVALID ? false //失效不能修改策略
                : status == statusTypes.LOCKED ? false //锁定不能修改策略
                : status == statusTypes.RUNNING ? false //正在执行不能修改策略
                : $scope.protectGroup.primary; //boolean 本端可以操作，远端不能操作

            //云主备屏蔽修改策略
            if(_.isObject($scope.protectGroup.props) && $scope.protectGroup.props.serviceInstanceType == "replication"){
            	enable = false;
            };
            //VHA+CSDR环形3DC屏蔽修改接口
            if(_.isObject($scope.protectGroup.template) && _.contains([34,37], +$scope.protectGroup.template.type)){
            	enable = false;
            };
			$scope.maskHandle = $.Deferred();
			$scope.$apply();

			Rest.getPolicyTemplateDetail($scope.pt.ptId, {
			    mask: false,
			    success: function(data) {
			    	//需要先查询原来的接口，再调用schedules接口
			    	Rest.queryPgSchedules([$scope.protectGroup.uuid], {
			    		mask: false,
			    		success: function(result){
			    			!_.contains([11], +$scope.pt.type) && (data.schedules = angular.copy(result));
			    			$scope.pt = data;
			    			$scope.imgSrc = "../theme/recoverydirector/images/protectiongroup/policytemplate/" + $scope.pt.sketch;
			    			$scope.showSchedule = angular.isUndefined($scope.pt.editTemplateUrl) ? false : true;
			    			if( [0,1,3,4,5,6,21,22,23,24].indexOf(parseInt($scope.pt.type,10)) != -1 ){
			    				$scope.showSchedule = true;
			    			}
			    			//私有云同步复制没有策略
			    			if(angular.isUndefined($scope.pt.editTemplateUrl) && $scope.pt.type == 21){
			    				$scope.showSchedule = false;
			    			}

			    			$scope.ptName = resource.get($scope.pt.name);
			    			$scope.ptDesc = resource.get($scope.pt.description);

			    			$scope.panelVM.data = $scope.pt;
			    			$scope.panelVM.settingEnable = enable;
			    			//防止被写入脏数据
			    			$scope.panelVM = _.pick($scope.panelVM, "data", "pg", "ok", "settingEnable");
			    			$scope.$apply();
			    		}
			    	});
			    },
			    callback: function() {
			        $scope.maskHandle.resolve();
			    }
			});

		}

		init();

		//监听保护组对象的改变
		$scope.$on(Consts.PG_SELECT_EVENT,function(evt,msg){
			$scope.primary = msg.protectGroup.primary;
			$scope.panelVM.pg = msg.protectGroup;
			$scope.pt = msg.protectGroup.template;
			init();
		});

	}];

	var module = angular.module('recoverydirector.protection.config');
	module.tinyController('protection.pg.policy.ctrl', ctrl);
	return module;
});
