define(["tiny-common/UnifyValid"], function(UnifyValid) {
	"use strict";
	var ctrl = ["$scope", "message", "constsService", "appUtils" , "model", "restService",
			function($scope, message, Consts , appUtils, Model, Rest) {

				var pgId = appUtils.getWinData();
				var resource = appUtils.resource();

				$scope.tip = null;

				$scope.model = {
						labels: {
							name: appUtils.getStringWithColon("common_term_name_label"),
	                    	des: appUtils.getStringWithColon("common_term_description_label")
						},
		                name: {
		                    id : "name",
		                    width : Consts.W4,
		                    validate : Consts.VALID.union(Consts.VALID.NAME_REQUIRED,[{validFn:"notEqual", params:["null"], errorDetail:resource.get("ism.drm.protect.group.not.null")}]),
		                	blur : function(){
		    					if( !$("#name input").hasClass("valid_error_input") ){
		    						var name = $("#name").widget().getValue();
		    						name != $scope.oldName && checkName(name);
		    					}
		    				},
		    				focus : function(){
		    					$scope.tip && $scope.tip.hide();
		    				}
		                },
		                des: {
		                    id : "description",
		                    type :"multi",
		                    height:Consts.DESCR_HEIGHT,
		                    width:Consts.W4,
		                    validate : Consts.VALID.DES_REMARK
		                }
			    };


				function checkName(name,cb){
					Rest.checkNameExisted(encodeURIComponent(name),{
						mask    : false,
						success : function(data){
							if( data.isExisted ){
								$scope.nameValid = false;

								if( !$scope.tip ){
									var content = '<span class="valid_tip_error">'+resource.get("ism.drm.protect.policy.name.isexist")+'</span>';
									$scope.tip = new tinyWidget.Tip({element:$("#name"),position:"right",content:content});
								}
								$scope.tip.show();
								$("#name").unbind("mouseout");
								$("#name").unbind("mouseover");
							}
							else{
								angular.isFunction(cb) && cb();
							}
						}
					});
				}

				 $("#"+Consts.MODIFY_PG_WIN.winId).widget().option("buttons",[{
                     label : appUtils.getString("common_term_confirm_button"),
                     handler : function() {
                	    if ( !UnifyValid.FormValid($("#modify-pg-div"), {focusInvalid: true}) ) {
                            return;
                        }

                	    var name = $.trim($("#name").widget().getValue());
                        if( name != $scope.oldName ){
                        	checkName(name,doCmd);
                        }else{
                        	doCmd();
                        }

                        function doCmd(){
                        	var param = {};
                        	param.name = $.trim($("#name").widget().getValue());
                        	param.description = $.trim($("#description").widget().getValue());

                            var pgModel = new Model.ProtectGroup({
                            	uuid : pgId,
                            	name : param.name,
                            	description : param.description
                            });

                            pgModel.updateProtectGroup(function(){
                                message.success( {
                                	 content : appUtils.getString("common_term_operation_success_label"),
                            		 ok : function(){
                            			 //供刷新使用
                            			 appUtils.closeWin(true);
                            		 }
                                });
                            });
                        }
                     }
				 }]);

				 function init(pgId){
					 Rest.queryProtectGroupById(pgId,function(data){
						 $scope.oldName = appUtils.NCRDecode(data.name);
						 $("#name").widget().option("value",$scope.oldName);
						 $("#description").widget().option("value",data.description === null ? "null" : $.trim(data.description));
					 });
				 }
				 init(pgId);
			} ];

	var module = angular.module("recoverydirector.protection.config");
	module.tinyController("pgModifyCtrl", ctrl);
	return module;
});