define(["tiny-extra-widgets/CheckPanel", "app/business/recoverydirector/protection/configures/appMgr"],
    function(CheckPanel, App) {
        "use strict";
        var ctrler = ["$scope", "$state", "$stateParams", "appUtils", "$timeout", "constsService", "message", "restService", "statusEnumService", "infoTransferredService","widgetService", "servicesPlugin",
        function( $scope, $state, $stateParams, appUtils, $timeout, Consts, message, Rest, Status, infoTransferredService, widgetService, servicesPlugin) {
                var resource = appUtils.resource();
                var PROTECT_GROUP_STATUS = Consts.PROTECT_GROUP_STATUS;
                var execActive = false;
                var poType = $stateParams.poType;

                var queryCondition = Rest.createQueryCondition({poType: poType});
                var updateTableFn;

                var TIMEOUT_ID;
                var AUTO_TIMEOUT = 15000;        //自动刷新频率15s
                var AUTO_TIMEOUT_IN_EXEC = 1000; //保护组执行中的自动刷新频率1s

                $scope.checkRight = appUtils.checkRight;
                $scope.refresh = refresh;
                $scope.tabShow = false;
                $scope.executeStepTip = {}; //保存执行步骤的tipContainer
                $scope.isPrivateConsole = window.isPrivateConsole;

                //操作按钮[创建,导出]
                $scope.btn = {
                    export: {
                        id: "pg_export",
                        text: resource.get("common_term_exportall_button"),
                        display: true,
                        click: function() {
                            message.confirm({content: appUtils.getString("pg_export_confirm_download_label"), ok: function() {
                                Rest.exportProtectGroup([], function() {
                                    message.prompt(appUtils.getString("common_term_operationsyn_success_label"));
                                })
                            }})
                        }
                    },
                    enableBtn: {
                        id: "pg_enable",
                        text: resource.get("common_term_actived_button"),
                        disable: true,
                        click: function(){
                            if (this.disable) {
                                return;
                            };

                            var checkedData = $("#pgTable").widget().getTableCheckedItems();
                            var win = angular.copy(Consts.PG_OPERATION_RESULT_WIN);
                            win.data = {
                                pgs: checkedData,
                                type: "enable"
                            };
                            win.title = appUtils.getString(win.title);
                            win.buttons = [{
                                key: "close",
                                label: appUtils.getString('common_term_close_button'),
                                focused: true,
                                handler: function() {
                                    $scope.pgTable.clearCheckedItems();
                                    updateTable();
                                    $("#" + win.winId).widget().destroy();
                                }
                            }];
                            !_.isEmpty(checkedData) && appUtils.showWindow(win);
                        }
                    },
                    disableBtn: {
                        id: "pg_disable",
                        text: resource.get("common_term_disable_label"),
                        disable: true,
                        click: function(){
                            var checkedData = $("#pgTable").widget().getTableCheckedItems();
                            if (this.disable || _.isEmpty(checkedData)) {
                                return;
                            };
                            var win = angular.copy(Consts.PG_OPERATION_RESULT_WIN);
                            win.data = {
                                pgs: checkedData,
                                type: "disable"
                            };
                            win.title = appUtils.getString(win.title);
                            win.buttons = [{
                                key: "close",
                                label: appUtils.getString('common_term_close_button'),
                                focused: true,
                                handler: function() {
                                    $scope.pgTable.clearCheckedItems();
                                    updateTable();
                                    $("#" + win.winId).widget().destroy();
                                }
                            }];
                            var pgsName = [];
                            _.each(checkedData, function(pg){
                                pgsName.push(pg.name)
                            });
                            var msg = appUtils.getDangerMsg([
                                {key: "ism.drm.protect.group.disable.prompt.1", params: [$.encoder.encodeForHTML(pgsName.join())]},
                                "ism.drm.protect.group.disable.prompt.2",
                                "ism.drm.protect.group.disable.prompt.3"
                            ]);
                            message.warn({
                                content: msg,
                                ok: function() {
                                    appUtils.showWindow(win);
                                }
                            });
                        }
                    }
                };

                function checkBtn() {
                    var checkedDatas = $("#pgTable").widget().getTableCheckedItems();
                    if (!!!_.size(checkedDatas)) {
                        $scope.btn.enableBtn.disable = true;
                        $scope.btn.disableBtn.disable = true;
                        $scope.$apply();
                        return;
                    };
                    var enablePgs = _.filter(checkedDatas, function(pg) {
                        return (!shouldExcludeTemplate(pg.template.type) || pg.props.serviceInstanceType == "replication") && pg.status != PROTECT_GROUP_STATUS.NORMAL && pg.status != PROTECT_GROUP_STATUS.INVALID && pg.status != PROTECT_GROUP_STATUS.LOCKED && pg.status != PROTECT_GROUP_STATUS.RUNNING && pg.primary
                    });
                    var disablePgs = _.filter(checkedDatas, function(pg) {
                        return (!shouldExcludeTemplate(pg.template.type) || pg.props.serviceInstanceType == "replication") && pg.status != PROTECT_GROUP_STATUS.DISABLED && pg.status != PROTECT_GROUP_STATUS.INVALID && pg.status != PROTECT_GROUP_STATUS.LOCKED && pg.status != PROTECT_GROUP_STATUS.RUNNING && pg.primary
                    });
                    if (_.size(enablePgs) == _.size(checkedDatas)) {
                        $scope.btn.enableBtn.disable = false;
                        $scope.btn.disableBtn.disable = true;
                        $scope.$apply();
                        return;
                    };
                    if (_.size(disablePgs) == _.size(checkedDatas)) {
                        $scope.btn.enableBtn.disable = true;
                        $scope.btn.disableBtn.disable = false;
                        $scope.$apply();
                        return;
                    };
                    $scope.btn.enableBtn.disable = true;
                    $scope.btn.disableBtn.disable = true;
                    $scope.$apply();
                };

                function displayTab() {
                    $scope.tabShow = _.size($("#pgTable").widget().getTableCheckedItems()) == 1;
                    $scope.$apply();
                }

                function clearChekced() {
                    //清空之前选择的
                    $scope.pgTable.clearCheckedItems();
                    var trs = $("#pgTable .tinyTable.dataTable tbody tr");
                    trs.each(function() {
                        $(this).removeClass("clickTrColor").find("div.table_checkbox_select").removeClass("table_checkbox_select");
                    });
                }

                //保护组表格数据
                $scope.pgTable = new widgetService.tableTempalte({
                    id: "pgTable",
                    paginationStyle:"full_numbers",
                    queryCondition: queryCondition,
                    isDraggedRemember: true,
                    buttonContainerPosition: "right",
                    operateButtonCount: 1,
                    lengthMenu: Consts.TABLE_LENGTH_AUTO_MENU,
                    checkbox: true,
                    rowId: "uuid",
                    columns: [{
                        "mData": "uuid",
                        "bVisible": false
                    }, {
                        "sTitle": resource.get("common_term_status_label"),
                        "mData": "status",
                        "bSortable": false,
                    }, {
                        "sTitle": resource.get("common_term_name_label"),
                        "mData": "name",
                    }, {
                        "sTitle": resource.get("pg_list_po_type_label"),
                        "mData": "poType",
                    }, {
                        "sTitle": resource.get("ism.drm.protect.group.template"),
                        "mData": "template.name",
                        "bSortable": false,
                    }, {
                        "sTitle": resource.get("ism.drm.protect.group.productSite"),
                        "mData": "productSiteName",
                    }, {
                        "sTitle": resource.get("ism.drm.protect.group.lastExcuteTime"),
                        "mData": "lastExecTime",
                        "bSortable": false,
                    }],

                    opAreaConfig: [
                    //执行保护组
                    {
                        id: "btnExecuteCopyPg",
                        authKey: "ism.drm.protectgroup.auth.execute",
                        template: "<div class='iconbutton-start' title='" + resource.get("ism.drm.protectgroup.auth.execute") + "'></div>",
                        classConfig: ["iconbutton-start","iconbutton-start-disabled"],
                        clickActive: function(pg){
                            var ptType = parseInt(pg.template.type, 10);
                            var pgName = $.encoder.encodeForHTML(pg.name);
                            //克隆
                            if(ptType == 16){
                                var msg = appUtils.getDangerMsg([
                                    {key: "protectionGroup_task_enableProtectionTaskByClone_warm_msg1", params: [pgName]},
                                    "protectionGroup_task_enableProtectionTaskByClone_warm_msg2",
                                    "protectionGroup_task_enableProtectionTaskByClone_warm_msg3"
                                ]);
                                message.warn({
                                    content: msg,
                                    ok: function () {
                                        //查询scheudleId
                                        Rest.queryPgSchedules([pg.pgId], function(result){
                                            if(_.isEmpty(result)){
                                                return;
                                            };
                                            Rest.excuteBackupAction([pg.pgId, result[0].scheduleId], {
                                                success: function(){
                                                    message.success({
                                                        content: resource.get("common_term_command_send_success_label"),
                                                        ok: function() {
                                                            execActive = true;
                                                            updateTable();
                                                        }
                                                    });
                                                }
                                            })
                                        });
                                    }
                                });
                                return;
                            };
                            //NAS一体化备份
                            if(ptType == 17){
                                var win = angular.copy(Consts.PROTECTGROUP_EXECUTE_17_WIN);
                                win.data = { protectGroupId : pg.pgId };

                                appUtils.showWindow(win, function(options) {
                                    execActive = true;
                                    updateTable();
                                    $("#" + Consts.PROTECTGROUP_EXECUTE_17_WIN.winId).widget().destroy();
                                });
                                return;
                            };
                            //NAS双活+一体化备份
                            if (ptType == 28 || ptType == 11 || ptType == 14) {
                                var descType = _.contains([1, 3, 4, 5, 6, 7, 13, 18, 20], ptType) ? "remote" : "local";
                                var msg = appUtils.getDangerMsg([{
                                        key: "ism.drm.protect.group.execute.prompt." + descType + ".1",
                                        params: pgName
                                    },
                                    "ism.drm.protect.group.execute.prompt." + descType + ".2",
                                    "ism.drm.protect.group.execute.prompt." + descType + ".3"
                                ]);
                                message.confirm({
                                    content: msg,
                                    ok: function() {
                                        //查询scheudleId
                                        Rest.queryPgSchedules([pg.pgId], function(result) {
                                            if (_.isEmpty(result)) {
                                                return;
                                            };
                                            var excuteScheduleId = result[0].scheduleId;
                                            //主机复制如果有2个schedule，取手动的执行
                                            if (ptType == 11 && result.length > 1) {
                                                var manualSchedule = _.filter(result, function(item){
                                                    return item["scheduleMode"] == 1
                                                })[0];
                                                !_.isEmpty(manualSchedule) && (excuteScheduleId = manualSchedule.scheduleId)
                                            };
                                            var obj = {
                                                success: function() {
                                                    message.success({
                                                        content: resource.get("common_term_command_send_success_label"),
                                                        ok: function() {
                                                            execActive = true;
                                                            updateTable();
                                                        }
                                                    });
                                                }
                                            };
                                            ptType == 28 && _.extend(obj, {
                                                data: {"executeProtectLocation_4": true}
                                            })
                                            Rest.excuteBackupAction([pg.pgId, excuteScheduleId], obj);
                                        });
                                    }
                                });
                                return;
                            };
                            var win = angular.copy(Consts.PROTECTGROUP_EXECUTE_BACKUP_WIN);
                            win.data = { pg : pg };
                            appUtils.showWindow(win, function(options) {
                                var param = this.options.data.param;
                                Rest.excuteBackupAction([pg.pgId, param.scheduleId], {
                                    data: param,
                                    success: function(){
                                        message.success({
                                            content: resource.get("common_term_command_send_success_label"),
                                            ok: function() {
                                                execActive = true;
                                                updateTable();
                                            }
                                        });
                                    }
                                })
                                $("#" + Consts.PROTECTGROUP_EXECUTE_BACKUP_WIN.winId).widget().destroy();
                            });
                        },
                        mouseActive: function(pg){
                            //openstack云双活操作全部屏蔽
                            if(pg.poType == 12 && pg.template.type == 25){
                                return false
                            };
                            if(pg.poType == 12 && (pg.props.serviceInstanceType == "replication" || pg.props.serviceInstanceType == "csdr")){
                                return false
                            };
                            //vha不支持执行
                            if(pg.poType == 12 && pg.template.type == 29){
                                return false
                            };
                            //VHA+CSDR
                            if (pg.poType == 12 && _.contains([34,37], +pg.template.type)) {
                                return false;
                            };
                            var status = pg.status;
                            return shouldExcludeTemplate(pg.template.type) ? false //特定模板不能执行
                                : status == PROTECT_GROUP_STATUS.DISABLED ? false //禁用不能执行
                                : status == PROTECT_GROUP_STATUS.INVALID ? false //失效不能执行
                                : status == PROTECT_GROUP_STATUS.LOCKED ? false //锁定不能执行
                                : status == PROTECT_GROUP_STATUS.RUNNING ? false //正在执行不能执行
                                : pg.primary;
                        }
                    },
                    //卷重映射
                    {
                        id: "btnReMappingPg",
                        authKey: "ism.drm.protectgroup.auth.enable",
                        template: "<div class='iconbutton-enabled' title='" + resource.get("protection_term_pg_re_map_label") + "'></div>",
                        classConfig: ["iconbutton-enabled","iconbutton-enabled-disabled"],
                        clickActive: function(pg){
                            Rest.reMappingOpenstackPg(pg.uuid, {
                                "success": function() {
                                    message.prompt({
                                        content: appUtils.getString("common_term_operationsyn_success_label"),
                                        ok: updateTable
                                    });
                                }
                            });
                        },
                        mouseActive: function(pg){
                            return shouldRemappingVol(pg);
                        }
                    },
                    //激活保护组
                    {
                        id: "btnEnablePg",
                        authKey: "ism.drm.protectgroup.auth.enable",
                        template: "<div class='iconbutton-enabled' title='" + resource.get("common_term_actived_button") + "'></div>",
                        classConfig: ["iconbutton-enabled","iconbutton-enabled-disabled"],
                        clickActive: function(pg){
                            Rest.enableProtectGroup(pg.uuid, {
                                "success": function() {
                                    message.success({
                                        content: resource.get("common_term_operation_success_label"),
                                        ok: updateTable
                                    });
                                }
                            });
                        },
                        mouseActive: function(pg){
                            var status = pg.status;
                            //csdr同步支持激活
                            if(pg.template.type == 21 && (pg.props.serviceInstanceType == "replication" || pg.props.serviceInstanceType == "csdr")){
                                return status == PROTECT_GROUP_STATUS.NORMAL ? false //正常不能激活
                                    : status == PROTECT_GROUP_STATUS.INVALID ? false //失效不能禁用
                                    : status == PROTECT_GROUP_STATUS.LOCKED ? false //锁定不能禁用
                                    : status == PROTECT_GROUP_STATUS.RUNNING ? false //正在执行不能激活
                                    : pg.primary;
                            };
                            return shouldExcludeTemplate(pg.template.type) ? false //特定模板不能激活
                                : status == PROTECT_GROUP_STATUS.NORMAL ? false //正常不能激活
                                : status == PROTECT_GROUP_STATUS.INVALID ? false //失效不能禁用
                                : status == PROTECT_GROUP_STATUS.LOCKED ? false //锁定不能禁用
                                : status == PROTECT_GROUP_STATUS.RUNNING ? false //正在执行不能激活
                                : pg.primary;
                        }
                    },
                    //禁用保护组
                    {
                        id: "btnDisablePg",
                        authKey: "ism.drm.protectgroup.auth.disable",
                        template: "<div class='iconbutton-forbidden' title='" + resource.get("common_term_disable_label") + "'></div>",
                        classConfig: ["iconbutton-forbidden","iconbutton-forbidden-disabled"],
                        clickActive: function(pg){
                            Rest.disableProtectGroup(pg.uuid, {
                                "interceptor": function(next) {
                                    var msg = appUtils.getDangerMsg([
                                        {key: "ism.drm.protect.group.disable.prompt.1", params: [$.encoder.encodeForHTML(pg.name)]},
                                        "ism.drm.protect.group.disable.prompt.2",
                                        "ism.drm.protect.group.disable.prompt.3"
                                    ]);

                                    message.warn({
                                        content: msg,
                                        ok: function() {
                                            next();
                                        }
                                    });
                                },

                                "success": function() {
                                    message.success({
                                        content: resource.get("common_term_operation_success_label"),
                                        ok: updateTable
                                    });
                                }
                            });
                        },
                        mouseActive: function(pg){
                            var status = pg.status;
                            //csdr同步支持禁用
                            if(pg.template.type == 21 && (pg.props.serviceInstanceType == "replication" || pg.props.serviceInstanceType == "csdr")){
                                return status == PROTECT_GROUP_STATUS.DISABLED ? false //禁用不能禁用
                                : status == PROTECT_GROUP_STATUS.INVALID ? false //失效不能禁用
                                : status == PROTECT_GROUP_STATUS.LOCKED ? false //锁定不能禁用
                                : status == PROTECT_GROUP_STATUS.RUNNING ? false //正在执行不能禁用
                                : pg.primary;
                            };
                            return shouldExcludeTemplate(pg.template.type) ? false //特定模板不能禁用
                            : status == PROTECT_GROUP_STATUS.DISABLED ? false //禁用不能禁用
                            : status == PROTECT_GROUP_STATUS.INVALID ? false //失效不能禁用
                            : status == PROTECT_GROUP_STATUS.LOCKED ? false //锁定不能禁用
                            : status == PROTECT_GROUP_STATUS.RUNNING ? false //正在执行不能禁用
                            : pg.primary;
                        }
                    },
                    //刷新保护组
                    {
                        id: "btnRefreshPg",
                        authKey: "ism.drm.protectgroup.auth.refresh",
                        template: "<div class='iconbutton-pg-refresh' title='" + resource.get("common_term_refresh_button") + "'></div>",
                        classConfig: ["iconbutton-pg-refresh","iconbutton-pg-refresh-disabled"],
                        clickActive: function(pg){
                            Rest.refreshProtectGroup(pg.uuid, {
                                "interceptor": function(next) {
                                    var msg = appUtils.getDangerMsg([
                                        {key: "ism.drm.protect.group.refresh.prompt.1", params: [$.encoder.encodeForHTML(pg.name)]},
                                        "ism.drm.protect.group.refresh.prompt.2",
                                        "ism.drm.protect.group.refresh.prompt.3"
                                    ]);

                                    message.warn({
                                        content: msg,
                                        ok: function() {
                                            next();
                                        }
                                    });
                                },
                                "success": function() {
                                    message.prompt({
                                        content: resource.get("site_term_refresh_message"),
                                        ok: updateTable
                                    });
                                }
                            });
                        },
                        mouseActive: function(pg){
                            if(pg.poType == 12 && pg.template.type == 25){
                                return false
                            };

                            if(pg.poType == 12 && (pg.props.serviceInstanceType == "replication" || pg.props.serviceInstanceType == "csdr")){
                                return false
                            };
                            //vha
                            if(pg.poType == 12 && pg.template.type == 29){
                                return false
                            };
                            //VHA+CSDR
                            if (pg.poType == 12 && _.contains([34,37], +pg.template.type)) {
                                return false;
                            };
                            var status = pg.status;
                            var isAvaliable = pg.props.IS_MANUAL != 1 && (status == PROTECT_GROUP_STATUS.NORMAL || status == PROTECT_GROUP_STATUS.INVALID) && pg.primary;

                            //vmware只有vis镜像和vis双活可以刷新 //3dc ring可以刷新
                            if( isAvaliable && pg.poType == 10 ){
                                isAvaliable = _.contains([8, 10, 26, 27], parseInt(pg.template.type, 10));
                            }

                            //openstack保护组无效状态不支持刷新功能
                            if (isAvaliable && pg.poType == 12) {
                                isAvaliable = _.contains([21, 22], parseInt(pg.template.type, 10));
                            }

                            return isAvaliable;
                        }
                    },
                    //编辑保护组
                    {
                        id: "btnEditPg",
                        authKey: "ism.drm.protectgroup.auth.modify",
                        template: "<div class='iconbutton-edit' title='" + resource.get("common_term_edit_button") + "'></div>",
                        classConfig: ["iconbutton-edit","iconbutton-edit-disabled"],
                        clickActive: function(pg){
                            var winConfig = angular.copy(Consts.MODIFY_PG_WIN);
                            winConfig.title = resource.get(winConfig.title);
                            winConfig.close = function() {
                                appUtils.getWinData() && updateTable();
                            };
                            appUtils.openWin(winConfig, pg.pgId);
                        },
                        mouseActive: function(pg){
                            if(pg.poType == 12 && pg.template.type == 25){
                                return false
                            };

                            if(pg.poType == 12 && (pg.props.serviceInstanceType == "replication" || pg.props.serviceInstanceType == "csdr")){
                                return false
                            };

                            if(pg.poType == 12 && pg.template.type == 29){
                                return false
                            };
                            //VHA+CSDR
                            if (pg.poType == 12 && _.contains([34,37], +pg.template.type)) {
                                return false;
                            };
                            var status = pg.status;
                            return status == PROTECT_GROUP_STATUS.DISABLED ? false //禁用不能修改
                            : status == PROTECT_GROUP_STATUS.INVALID ? false //失效不能修改
                            : status == PROTECT_GROUP_STATUS.LOCKED ? false //锁定不能修改
                            : status == PROTECT_GROUP_STATUS.RUNNING ? false : true; //正在执行不能修改
                        }
                    },
                    //删除保护组
                    {
                        id: "btnDeletePg",
                        authKey: "ism.drm.protectgroup.auth.delete",
                        template: "<div class='iconbutton-delete' title='" + resource.get("common_term_delete_button") + "'></div>",
                        classConfig: ["iconbutton-delete","iconbutton-delete-disabled"],
                        clickActive: function(pg){
                            Rest.delProtectGroup(pg.uuid, {
                                "interceptor": function(next) {
                                    var delMessage_2 = "ism.drm.protect.group.delete.prompt.2";
                                    if(pg.props.PG_PROP_REPLICATION_SPLIT_KEY == "true"){
                                        delMessage_2 = "ism.drm.protect.group.openstack.delete.prompt.2";
                                    };
                                    var msg = appUtils.getDangerMsg([
                                        {key: "ism.drm.protect.group.delete.prompt.1", params: [$.encoder.encodeForHTML(pg.name)]},
                                        delMessage_2,
                                        "ism.drm.protect.group.delete.prompt.3"
                                    ]);
                                    //小lun保护组无效删除提示
                                    if(pg.template.type == 33 && pg.status == 3){
                                        msg = appUtils.getDangerMsg([
                                            {key: "ism.drm.protect.group.delete.prompt.1", params: [$.encoder.encodeForHTML(pg.name)]},
                                            delMessage_2,
                                            "ism.drm.protect.group.delete.prompt.invalid",
                                            "ism.drm.protect.group.delete.prompt.3"
                                        ])
                                    };

                                    message.warn({
                                        content: msg,
                                        ok: function() {
                                            next();
                                        }
                                    });
                                },
                                "success": function(data) {
                                    //隐藏表格操作按钮,避免重复删除
                                    $("#pgTable .OpButton_main").hide();

                                    message.prompt({
                                        content: resource.get("site_term_refresh_message"),
                                        ok: function() {
                                            //删除成功后跳转到首页
                                            queryCondition.startPage = 0;
                                            queryCondition.$fn.query();
                                        }
                                    });
                                }
                            });
                        },
                        mouseActive: function(pg){
                            if(pg.poType == 12 && pg.template.type == 25){
                                return false
                            };

                            if(pg.poType == 12 && (pg.props.serviceInstanceType == "replication" || pg.props.serviceInstanceType == "csdr")){
                                return false
                            };

                            if(pg.poType == 12 && pg.template.type == 29){
                                return false
                            };
                            //VHA+CSDR
                            if (pg.poType == 12 && _.contains([34,37], +pg.template.type)) {
                                return false;
                            };
                            var status = pg.status;
                            return status == PROTECT_GROUP_STATUS.LOCKED ? false //锁定不能删除
                                : status == PROTECT_GROUP_STATUS.RUNNING ? false : true; //正在执行不能删除
                        }
                    }],
                    cellClickActive: function(event, cell) {
                        if ($(event.target).hasClass("dataTables_checkboxs")) {
                            var currentItem = $("#pgTable").widget().getTableCheckedItems();
                            $scope.protectGroup = currentItem[0] || cell;
                            window.G_APP = App.init($scope.protectGroup.poType);
                        } else {
                            //初始化应用
                            window.G_APP = App.init(cell.poType);
                            $scope.protectGroup = cell;
                        }

                        displayTab();

                        var crtName = $state.current.name;

                        //默认选择摘要页
                        if( crtName == "protection.pg.list" ){
                            $state.go("protection.pg.list.abstract");
                        }
                        //执行跳转到编辑步骤
                        else if( execActive ){
                            if( crtName == "protection.pg.list.executionStep" ){
                                $scope.tabShow && $scope.$broadcast(Consts.PG_SELECT_EVENT, {
                                    protectGroup: $scope.protectGroup
                                });
                            }
                            else{
                                $("#tabs li:eq(5)").click();
                                $state.go("protection.pg.list.executionStep");
                            }

                            execActive = false;
                        }
                        else if (crtName.indexOf("protection.pg.list.protectobjects") != "-1"){
                            //不同应用保护组页签不一样
                            crtName != G_APP.getPoTabState() ? $state.go(G_APP.getPoTabState()) : $state.reload(G_APP.getPoTabState());
                            $scope.tabShow && $scope.$broadcast(Consts.PG_SELECT_EVENT, {
                                protectGroup: $scope.protectGroup
                            });
                        }
                        else{
                            $scope.tabShow && $scope.$broadcast(Consts.PG_SELECT_EVENT, {
                                protectGroup: $scope.protectGroup
                            });
                        }

                        $scope.tabs[2] = {
                            openState: G_APP.getPoTabState(),
                            name: resource.get("ism.drm.protect.group.tab.protectedObject"),
                            id: "pgPoListTab"
                        };

                        $scope.$apply();
                        $timeout(function() {
                            var dom = $("li[cid=2]", $("#tabs")).find("a#pgPoListTab");
                            if (!dom.hasClass("tinyTab-a tinyTab-tab-center")) {
                                dom.addClass('tinyTab-a tinyTab-tab-center').css({padding: '0 10px 0'});
                                if (_.contains(["protection.pg.list.protectobjects_vmware", "protection.pg.list.protectobjects_fusionsphere", "protection.pg.list.protectobjects"], crtName)
                                    && !$("li[cid=2]", $("#tabs")).hasClass("tinyTabActive")) {
                                    $("li[cid=2]", $("#tabs")).addClass("tinyTabActive");
                                }
                            }
                        }, 0);
                        if(!$(event.target).hasClass("dataTables_checkboxs")){
                            clearChekced();
                            var index = appUtils.getIndexFromArray($scope.pgTable.data, "uuid", cell.uuid);
                            $("#pgTable tbody tr:eq(" + index + ") td:eq(0)").children(".dataTables_checkboxs").click();
                        };
                        checkBtn();
                    },
                    hoverActive: function(e, param){
                        var instanceType = param.props.serviceInstanceType;
                        //vha+csdr也需要重映射功能
                        if(param.poType == 12 && (instanceType == "csha" || instanceType == "vha" || instanceType == "hypermetro" || _.contains([34, 37], +param.template.type))){
                            $("#btnReMappingPg").show();
                        }else{
                            $("#btnReMappingPg").hide();
                        }
                        $scope.$apply();
                    },
                    renderRow: function(nRow, aData, iDataIndex) {
                        var rpoRto = getRpoRto(aData);

                        Status.setRenderRowStatus(arguments, {
                            1: ["PROTECTGROUP_STATUS", "status"],
                            2: ["I18N", aData.name],
                            3: ["I18N", appUtils.getString("protect_object")[aData.poType]],
                            4: ["I18N", appUtils.getPtFullName(aData.template.name)]
                        });
                    },
                    changeSelect: function(evtObj){
                        queryCondition.startPage = 0;
                        queryCondition.pageSize = evtObj.displayLength;
                        queryCondition.$fn.query();
                    },
                    tHeadCheckboxFn: function(){
                        checkBtn();
                        displayTab();
                    },
                    callback: function(){
                        clearChekced();
                        displayTab();
                    }
                });
                
                $scope.searchSelect = {
                    id: "pgSearchSelect",
                    values: [{
                        selectId: "name",
                        label: resource.get("common_term_name_label")
                    }, {
                        selectId: "productSiteName",
                        label: resource.get("group_count_term_site_name")
                    }, {
                        selectId: "status",
                        label: resource.get("common_term_status_label")
                    }],
                    defaultSelectid: "name",
                    display: true,
                    disable: false,
                    showTip: true,
                    isSearchbox: true,
                    textWidth: Consts.W2,
                    width: Consts.W2,
                    "textOptions": {
                        "id": "choiseStatus",
                        "values": function (params) {
                            var arrays = [], status = Status.getJsonArray("PROTECTGROUP_STATUS");
                            status.unshift({"": appUtils.getString("common_term_all_label")});
                            _.each(status, function (obj) {
                                var id = _.first(_.keys(obj)),  label = _.first(_.values(obj));
                                this.push({
                                    selectId: id,
                                    label: label
                                });
                            }, arrays);
                            return arrays;
                        }(),
                        "display" : true,
                        "default-selectid": "",
                    },
                    "change": function() {
                        var widget = $("#pgSearchSelect").widget(),
                            searchId = widget.getSelectedId();
                        if (searchId == "status") {
                            this.isSearchbox = false;
                            widget.changeTextBox(false, this.textOptions);
                        } else {
                            this.isSearchbox = true;
                            widget.changeTextBox(true);
                        }
                    },
                    click: function() {
                        var key = $("#pgSearchSelect").widget().getSearchboxValue().type;
                        var query = $("#pgSearchSelect").widget().getSearchboxValue().inputValue;

                        queryCondition._FILTER = query ? "filterName=" + key + "&filterValue=" + encodeURIComponent($.trim(query)) : "";
                        queryCondition.$fn.search();
                    }
                };

                //tabs
                $scope.tabs = [{
                    openState: "protection.pg.list.abstract",
                    name: resource.get("ism.drm.protect.group.tab.abstract"),
                    active: true,
                    id: "pgAbstractTab"
                }, {
                    openState: "protection.pg.list.topogoly",
                    name: resource.get("ism.drm.protect.group.tab.topology"),
                    id: "pgTopogolyTab",
                    hidden: $scope.isPrivateConsole
                }, {
                    openState: G_APP.getPoTabState(),
                    name: resource.get("ism.drm.protect.group.tab.protectedObject"),
                    id: "pgPoListTab"
                }, {
                    openState: "protection.pg.list.policy",
                    name: resource.get("ism.drm.protect.group.tab.policy"),
                    id: "pgPolicyTab"
                }, {
                    openState: "protection.pg.list.duplica",
                    name: resource.get("ism.drm.protect.group.tab.duplica"),
                    id: "pgDuplicaTab"
                }, {
                    openState: "protection.pg.list.executionStep",
                    name: resource.get("recovery.term.procedureTitle.tab"),
                    id: "pgExecutionStepTab"
                }, {
                    openState: "protection.pg.list.executionhistory",
                    name: resource.get("ism.drm.protect.group.tab.excuteHistory"),
                    id: "pgExecutionhistoryTab"
                }];

                init();

                //初始化(只调用一次)
                function init(){
                    queryCondition.$fn.query = updateTable;
                    queryCondition.$type = "Table";
                    queryCondition.$widget = $scope.pgTable;

                    updateTableFn = widgetService.createUpdateTableFn($scope.pgTable, $scope);

                    //主机跳转添加过滤参数
                    hostPageForwardFilter();

                    initTabs();
                    initListener();

                    updateTable();

                    TIMEOUT_ID = $timeout(autoUpdate, AUTO_TIMEOUT);
                    if($("svg").length == 0 && $(".tiny-cirque-tip").length != 0){
                        $(".tiny-cirque-tip").remove()
                    }
                }

                //更新表格
                function updateTable(config){
                    Rest.queryProtectGroups(queryCondition, config || updateUI)
                }

                //刷新界面(不发送请求)
                function updateUI(data, autoRef, restConfig) {

                    //无数据禁用导出按钮控制
                    var exportBtn = $("#pg_export").widget();
                    if( exportBtn ){
                        if( data && data.totalCount > 0 ){
                            exportBtn.option("disable", false);
                            $("#noPgDataImg").addClass("tiny-img-confirm ti ti-info-circle");
                            $("#noPgData").html(appUtils.getString("pg_list_checked_no_data_label"));
                        }
                        else{
                            exportBtn.option("disable", true);
                            $("#noPgDataImg").removeClass("tiny-img-confirm ti ti-info-circle");
                            $("#noPgData").html("");
                        }
                    }

                    //当前未选中行,则选中第一行
                    try {
                        var tbWidget = $("#pgTable").widget();
                        var checkedPg = tbWidget.getTableCheckedItems();
                        if (!_.isEmpty(checkedPg) && _.size(checkedPg) == 1) {
                            $scope.protectGroup = _.first(checkedPg);
                        };
                    } catch (err) {}

                    //表格刷新
                    updateTableFn(data, restConfig);

                    if (!!_.size($("#pgTable").widget().getTableData())) {
                        _.isFunction(checkBtn) && checkBtn();
                    };
                    displayTab();
                }

                //刷新操作(清空搜索,排序条件,跳转第一页)
                function refresh() {
                    $("#pgSearchSelect").widget().setSearchboxValue("");
                    $("#pgSearchSelect").widget().opChecked("name");
                    $("#pgSearchSelect").widget().changeTextBox(true);

                    queryCondition.$fn.reset(["poType"]);
                    queryCondition.$fn.query();
                }

                //自动刷新
                function autoUpdate(timeout, successCb, increase) {
                    if( !$state.includes("protection.pg.list") || $scope.$$destroyed ){
                        $timeout.cancel(TIMEOUT_ID);
                    }
                    else{
                        var restConfig = {
                            "mask": false,
                            "success": function(data) {
                                updateUI(data, true, restConfig);
                                _.isFunction(increase) &&  increase();
                                _.isFunction(successCb) && successCb(data);
                            }
                        };

                        updateTable(restConfig);

                        TIMEOUT_ID = $timeout(function(){
                            autoUpdate(timeout, successCb, increase);
                        }, timeout || AUTO_TIMEOUT);
                    }
                }

                //scope监听事件初始化
                function initListener(){
                    $scope.$on(Consts.TOPIC.PG_STATUS_CHANGE, function(evt, param){
                        $timeout.cancel(TIMEOUT_ID);

                        if( !param ){
                            autoUpdate();
                        }
                        else{
                            var execOverCb = param.execOverCb;
                            var pgUuid = param.pgUuId;
                            var ttl = 0;

                            var cb = function(data){
                                if( ttl >= 10 || $scope.protectGroup.uuid != pgUuid || !data || data.totalCount == 0 ){
                                    $timeout.cancel(TIMEOUT_ID);
                                    TIMEOUT_ID = $timeout(autoUpdate, AUTO_TIMEOUT);
                                }
                                else{
                                    //由执行变为非执行状态后,执行回调
                                    if( $scope.protectGroup.status != 5 ){
                                        $timeout.cancel(TIMEOUT_ID);
                                        TIMEOUT_ID = $timeout(autoUpdate, AUTO_TIMEOUT);

                                        var success = $scope.protectGroup.lastExecResult == 1 ? true : false;
                                        execOverCb(success);
                                    }
                                }
                            };

                            autoUpdate(AUTO_TIMEOUT_IN_EXEC, cb, function(){ttl += 1;});
                        }
                    });

                    $scope.$on(Consts.TOPIC.PG_LIST_UPDATE, function(){
                        queryCondition.$fn.query();
                    });

                    $scope.$on("$destroy",function(){
                        $timeout.cancel(TIMEOUT_ID);
                    });
                }

                //tab页初始化
                function initTabs() {
                    $timeout(function(){
                        new tinyWidget.Tabs({id: "tabs", "setActiveClass": true});
                        //tiny bug: 2个tab页同时高亮
                        $("ul li", "#tabs").click(function() {
                            $("ul li", "#tabs").not(this).removeClass("tinyTabActive");
                        });
                    });
                }

                //使用如下策略模板的保护组需要灰化执行、激活、禁用按钮
                function shouldExcludeTemplate(ptType) {
                    return _.contains([0, 8, 10, 12, 15, 21, 23, 24], parseInt(ptType, 10));
                }

                //重映射卷按钮的控制
                function shouldRemappingVol(pg) {
                    var instanceType = pg.props.serviceInstanceType;
                    if(pg.poType == 12 && (instanceType == "csha" || instanceType == "vha" || instanceType == "hypermetro" || pg.template.type == 34 || instanceType == "hyperMetroReplication")) {
                        return pg.status == PROTECT_GROUP_STATUS.NORMAL && pg.primary;
                    } else if (pg.poType == 12 && instanceType == 'hyperMetroReplication') {
                        return pg.status == PROTECT_GROUP_STATUS.NORMAL && pg.primary && pg.props.originalAvailableZone == pg.props.regionId;
                    } else if (pg.template.type == 37) {
                        return pg.status == PROTECT_GROUP_STATUS.NORMAL && pg.primary && pg.props.originalAvailableRegion == pg.props.regionId;
                    }
                    else {
                        return false;
                    }
                }

                //计算rpo|rto
                function getRpoRto(pg){
                    var rpo = pg["RPO_ITEM_KEY"];
                    var rto = pg["RTO_ITEM_KEY"];

                    var configRpo = "--";
                    var actualRpo = "--";
                    var estimateRto = "--";

                    if( angular.isArray(rpo) && rpo.length != 0 ){
                        configRpo = "";
                        actualRpo = "";

                        rpo.forEach(function(rpoItem) {
                            configRpo += appUtils.maxMsTimeUnit(rpoItem.configuredRPO) + " , ";
                            actualRpo += appUtils.maxMsTimeUnit(rpoItem.actualRPO) + " , ";
                        });

                        configRpo = configRpo.replace(/ , $/, "");
                        actualRpo = actualRpo.replace(/ , $/, "");
                    }

                    if( angular.isArray(rto) && rto.length != 0 ){
                        estimateRto = "";

                        rto.forEach(function(rtoItem) {
                            estimateRto += appUtils.maxMsTimeUnit(rtoItem.estimateRTO) + " , ";
                        });

                        estimateRto = estimateRto.replace(/ , $/, "");
                    }

                    return {
                        configRpo: configRpo,
                        actualRpo: actualRpo,
                        estimateRto: estimateRto
                    }
                }

                //主机跳转添加过滤参数
                function hostPageForwardFilter(){
                    var linkPg = infoTransferredService.get("resource", "linkPg");
                    if( linkPg ){
                        infoTransferredService.remove("resource", "linkPg");
                        var filterName = linkPg.pgName || "";
                        queryCondition._FILTER = "filterName=name&filterValue=" + encodeURIComponent(filterName);
                        setTimeout(function(){
                            $("#pgSearchSelect").widget().setSearchboxValue(filterName);
                        });
                    }
                }


                $scope.$on("$stateChangeSuccess", function(){
                    $('#pgTable_container').width($('#service-content').width() * 0.97);
                    _.each($("#tabs li"), function(tab){
                        $(tab).hasClass("tinyTabActive") && tab.click();
                    });
                });
            }
        ];

        var module = angular.module('recoverydirector.protection.config');
        module.tinyController('protection.pg.listCtrl', ctrler);
        return module;
    });
