define([], function(){
	var ctrl = ["$scope","$injector","message","appUtils","constsService","model","restService",
	function($scope,$injector, message, appUtils,Consts,Model,Rest){
		if(!$scope.$parent.tabShow) return;
		var protectGroup = $scope.protectGroup;
		var pgArr = [protectGroup];
		var resource = appUtils.resource();
		var page = 1, orderBy, orderType;
		$scope.addBtnName = resource.get("common_term_add_button");
		$scope.refresh = resource.get("common_term_refresh_button");
		var providerName;

		$scope.checkRight = appUtils.checkRight;
		$scope.maskFlag = false;
		/**默认配置**/

		//增加保护对象 vmware 异步复制和一致性组不支持
		$scope.showAdd = true;
		var G_addPopWinConf = angular.copy(Consts.ADD_PO_WIN);
		G_addPopWinConf.title = resource.get(G_addPopWinConf.title);
        G_addPopWinConf.close = function(){
            appUtils.getWinData("ADD_PO_WIN") === true && $scope.$emit(Consts.TOPIC.PG_LIST_UPDATE);
        };


        $scope.btnConfig = [{
			"name"  : "Add" ,
			"id"    : "Add_po_btn",
			"class" : "iconbutton-add",
			"click" : function(){
				//增加nas保护对象
				if( $scope.typeSelectShow && $("#typeSelect").widget().getSelectedId() == "nasfs" ){

					var data = $("#nasTable").widget().getTableData()[0];

					var NAS_PO_WIN = angular.copy(Consts.NAS_PO_WIN);
					NAS_PO_WIN.title = resource.get(NAS_PO_WIN.title);
		        	NAS_PO_WIN.close = function(){
		        		var data = appUtils.getWinData();
		        		if(!data || !data.ok) return;
		        		// 更新选中的NAS
		        		$scope.$digest();
		        	};

					appUtils.openWin(NAS_PO_WIN,{
						protectGroup : protectGroup,
						providerName: (data && data.providerName) || "unknow"
					});
				}
				//增加数据库保护对象
				else{
					if( protectGroup.poType=="11" ){
						G_addPopWinConf.width = "550";
					}else{
						G_addPopWinConf.width = Consts.WIN_SIZE.S3[0];
					}
		            appUtils.openWin(G_addPopWinConf , {
		            	protectGroup : protectGroup,
		            	providerName : providerName,
		        		poLen  : $scope.poTable.data.length
		        	});
	        	}
            }
		}];

		//查看插件数据库信息
		var showPoConlistWin = function (){
			var pgTable = $scope.dbTableShow ? "poTable" : "nasTable";
			var showPo = JSON.parse($("#"+pgTable).widget().getHoverData()[0].props.PDB);
			var pdbArray = _.filter(showPo,function(val){
				return val.type == "PDB"
			});
			var win = angular.copy(Consts.SHOW_POCONLIST_WIN);
			win.data = {
				pro:pdbArray
			};
			win.buttons = [{
			    key: "ok",
			    label: appUtils.getString('common_term_close_button'),
			    focused: true,
			    handler: function(event){
			        $("#" + win.winId).widget().destroy();
			    }
			}];
			appUtils.showWindow(win);
		}

    	//删除保护对象
		var G_delPoConf = {
			"id"          : "btnDeletePo",
			"authKey"     : "ism.drm.protectgroup.auth.modify",
			"template"    : "<div class='iconbutton-delete' title='" + resource.get("common_term_delete_button") + "'></div>",
			"clickActive" : delPoAction
		};
		//查看容器数据库下的插件数据库列表
		var G_showPoConlist = {
			"id"          : "showConPoList",
			"authKey"     : "ism.drm.protectgroup.auth.scan",
			"template"    : "<div class='iconbutton-edit' title='" + resource.get("common_term_showConPoList_button") + "'></div>",
			"clickActive" : showPoConlistWin
		};

		//绑定删除按钮状态
		function delBtnCtrl() {
			var pgTable = $scope.dbTableShow ? "poTable" : "nasTable";
			if(!$scope.protectGroup.primary || _.contains([0, 4, 5], $scope.protectGroup.status)){
				$scope.del.disable = true;
				return;
			};
			if($("#"+pgTable).length == 0 || $("#"+pgTable).widget().getTableCheckedItems().length == 0){
				$scope.del.disable = true;
				$scope.$apply();
				return;
			}
			//NAS双活保护对象不能手动移除、添加
			if(protectGroup.template.type == 15 && !_.isEmpty(protectGroup.props.PROP_KEY_VSTORE_PAIR_ID) && !_.isEmpty(protectGroup.props.PROP_KEY_VSTORE_ID)){
				$scope.del.disable = true;
				$scope.$apply();
				return;
			}
			//NAS+一体化备份保护对象不能手动移除、添加
			if(protectGroup.template.type == 28){
				$scope.del.disable = true;
				$scope.$apply();
				return;
			}
			//NAS+双活保护对象不能手动移除、添加
			if(_.contains([18,20],parseInt(protectGroup.template.type ,10)) && !_.isEmpty(protectGroup.props.PROP_KEY_VSTORE_PAIR_ID)){
				$scope.del.disable = true;
				$scope.$apply();
				return;
			};
			$scope.del.disable = false;
			$scope.$apply();
		}

		//批量删除保护对象
		$scope.del = {
			name: appUtils.getString("common_term_delete_button"),
			disable: true,
			click: function(){
				if(this.disable){
					return;
				}
				var tableId;
				if( $scope.dbTableShow ){
					tableId = "poTable";
				}else{
					tableId = "nasTable";
				}
				var delPo = angular.copy($("#"+tableId).widget().getTableCheckedItems());
				if(delPo){
					_.each(delPo,function(val){
						delete val.props
					})
				};
				var pg = new Model.ProtectGroup({
					pgId   : protectGroup.pgId,
					polist : delPo,
					poType : protectGroup.poType
				});
				pg.delProtectObject({
					"interceptor"  : function(next){
	        			var promt;

	        			if (protectGroup.template.type == 2 || protectGroup.template.type == 14 || protectGroup.template.type == 19 ) {
	        				promt = appUtils.getString("protection_term_task_removeChoseProtectedObject", $.encoder.encodeForHTML(protectGroup.name));
	        			}
	        			else if( protectGroup.template.type == 9 || protectGroup.template.type == 1){
	        				promt = resource.get("protection_term_removeChoseProtectedObject",$.encoder.encodeForHTML(protectGroup.name)) + "</br>" +
	        				resource.get("protection.VISSnapshot.task.removeProtectedObject.danger.message2") + "</br>" +
	        				resource.get("protection.VISSnapshot.task.removeProtectedObject.danger.message3");
	        			}
	        			else{
	        				promt = resource.get("protection_term_removeChoseProtectedObject",$.encoder.encodeForHTML(protectGroup.name)) + "</br>" +
		        			resource.get("ism.drm.protect.group.delete.element.prompt.2") + "</br>" +
		        			resource.get("ism.drm.protect.group.delete.element.prompt.3");
	        			}

	        			message.warn({
	        				content : promt,
	        				ok : function(){
	        					next();
	        				}
	        			});
	        		},
					"success" : function(){
						var msg = resource.get("site_term_refresh_message");

						message.prompt({content:msg,ok:function(){
							page = 1;
							if( $scope.dbTableShow ){
								$scope.poTable.curPage = {"pageIndex": 1};
							}else{
								$scope.nasTable.curPage = {"pageIndex": 1};
							}
							initTable();
						}});
					}
				});
			}
		};

		function delPoAction(){

			var tableId;
			if( $scope.dbTableShow ){
				tableId = "poTable";
			}else{
				tableId = "nasTable";
			}

			var po = Model.util.generatePoListFromTable(tableId,true)[0];
			if(po && po.props){
				delete po.props;
			}

			var pg = new Model.ProtectGroup({
				pgId   : protectGroup.pgId,
				polist : [po],
				poType : protectGroup.poType
			});

			var poName = po.name;
			pg.delProtectObject({
				"interceptor"  : function(next){
        			var promt;

        			if (protectGroup.template.type == 2 || protectGroup.template.type == 14 || protectGroup.template.type == 19 ) {
        				promt = appUtils.getString("protection_term_task_removeProtectedObject", $.encoder.encodeForHTML(protectGroup.name), $.encoder.encodeForHTML(poName));
        			}
        			else if( protectGroup.template.type == 9 || protectGroup.template.type == 1){
        				promt = resource.get("protection.VISSnapshot.task.removeProtectedObject.danger.message1",$.encoder.encodeForHTML(protectGroup.name),$.encoder.encodeForHTML(poName)) + "</br>" +
        				resource.get("protection.VISSnapshot.task.removeProtectedObject.danger.message2") + "</br>" +
        				resource.get("protection.VISSnapshot.task.removeProtectedObject.danger.message3");
        			}
        			else{
        				promt = resource.get("ism.drm.protect.group.delete.element.prompt.1",$.encoder.encodeForHTML(protectGroup.name),$.encoder.encodeForHTML(poName)) + "</br>" +
	        			resource.get("ism.drm.protect.group.delete.element.prompt.2") + "</br>" +
	        			resource.get("ism.drm.protect.group.delete.element.prompt.3");
        			}

        			message.warn({
        				content : promt,
        				ok : function(){
        					next();
        				}
        			});
        		},
				"success" : function(){
					var msg = resource.get("site_term_refresh_message");

					message.prompt({content:msg,ok:function(){
						page = 1;
						if( $scope.dbTableShow ){
							$scope.poTable.curPage = {"pageIndex": 1};
						}else{
							$scope.nasTable.curPage = {"pageIndex": 1};
						}
						initTable();
					}});
				}
			});
		}

		$scope.dbTableShow = true;

		//保护对象列表
		$scope.poTable = {
			id : "poTable",
			paginationStyle:"full_numbers",
			displayLength : Consts.TABLE_COUNT_PER_PAGE,
			hoverActive : function(e, po){
		    	var status = protectGroup.status;
		    	var statusTypes = Consts.PROTECT_GROUP_STATUS;

		    	if(po.props.IS_CDB != "1"){
		    		$("#showConPoList").hide();
		    	}else{
		    		$("#showConPoList").show();
		    	}


		    	//修改认证信息
		    	$scope.btnEditPo = status == statusTypes.DISABLED ? false //禁用不能修改
                    : status == statusTypes.LOCKED ? false //锁定不能修改
                    : status == statusTypes.RUNNING ? false //正在执行不能修改
                    : protectGroup.primary; // boolean 本端可以操作，远端不能操作

		    	//移除保护对象
		    	$scope.btnDeletePo = status == statusTypes.DISABLED ? false //禁用不能移除
	                    : status == statusTypes.LOCKED ? false //锁定不能移除
	                    : status == statusTypes.RUNNING ? false //正在执行不能移除
	                    : protectGroup.primary; // boolean 本端可以操作，远端不能操作


		    	$scope.btnSetArchiveLog = $scope.btnEditPo;
		    	//oracle归档日志保护,vis快照不能修改
		    	if( protectGroup.template.type == 9 ){
		    		$scope.btnSetArchiveLog = false;
		    	}

		    	var ops = [ {id:"btnSetArchiveLog"  , enable :$scope.btnSetArchiveLog},
		    				{id:"btnEditPo"  , enable :$scope.btnEditPo},
				    	    {id:"btnDeletePo", enable :$scope.btnDeletePo},
				    	 ];

		    	appUtils.setOpAreaEnable(ops);

		    },
		    callback:function(oPage){
		    	page = oPage.currentPage;
		    	pageQuery();
			},
			sortCallback: function (nNode, sortArr) {
				orderBy = $scope.poTable.columns[sortArr[0][0]-1].mData;
                orderType = sortArr[0][1];
                page = 1;
				pageQuery();
            },
            click: function(){
            	delBtnCtrl()
            },
            tHeadCheckboxFn: function(){
            	delBtnCtrl()
            },
            drawCallback: function(){

            }
		};

		//nas保护对象
		$scope.nasTable = {
			id : "nasTable",
			paginationStyle:"full_numbers",
			displayLength : Consts.TABLE_COUNT_PER_PAGE,
			opAreaConfig : [],
			checkbox : true,
			columns : [{
				"bVisible" : false,
				"mData" : "moUuid"
			}, {
				"sTitle" : appUtils.getString("current_alarm_term_name_column"),
				"mData" : "name",
				"bSortable" : false
			}, {
				"sTitle" : "ID",
				"mData" : "props.nasFsId",
				"bSortable" : false
			}, {
				"sTitle" : appUtils.getString("ism.drm.host.fs.capacity"),
				"mData" : "props.totalCapacityAndUnit",
				"bSortable" : false
			}, {
				"sTitle" : appUtils.getString("common_term_ower_storage_label"),
				"mData" : "providerName",
				"bSortable" : false
			}],
			hoverActive : function(e,po){},
			callback:function(oPage){
		    	page = oPage.currentPage;
		    	pageQuery();
			},
			sortCallback: function (nNode, sortArr) {
				orderBy = $scope.poTable.columns[sortArr[0][0]].mData;
                orderType = sortArr[0][1];
                page = 1;
				pageQuery();
            },
            click: function(){
            	delBtnCtrl();
            },
            tHeadCheckboxFn: function(){
            	delBtnCtrl();
            }
		}

		//更新表格
		var updateTable = appUtils.newUpdateTable($scope.poTable,$scope,function(data){
			if( data && data.records && data.records.length > 0 ){
				providerName = $("<div/>").html(data.records[0].providerName).text();
			}

			$scope.poTable.curPage = { "pageIndex": page };
		});

		//更新nas表格
		var updateNasTable = appUtils.newUpdateTable($scope.nasTable,$scope,function(data){
			if( data && data.records && data.records.length > 0 ){
				providerName = $("<div/>").html(data.records[0].providerName).text();
			}

			$scope.nasTable.curPage = { "pageIndex": page };
		});

		$scope.typeSelect = {
			id : "typeSelect",
			values : [{selectId : "db", label : resource.get("performance_term_database_title")},
			          {selectId : "nasfs", label : resource.get("protection.term.NAS.label")}],
			defaultSelectid : "db",
			change: function(){
				$scope.dbTableShow = $("#typeSelect").widget().getSelectedId() == "db";

				orderBy = "";
                orderType = "";
                page = 1;
				pageQuery();
			}
		};


		//解析配置
		function initConf(){
			var config = G_APP.getPoTabConfig();

			//增加保护对象按钮配置
			angular.extend(G_addPopWinConf , config.addPo.popWindowConfig);
			/**表格配置**/

			//column
			var columns = config.table.columns;
			if($scope.protectGroup.poType == 1){
				columns.splice(4,0,{
					"sTitle": "common_term_pdb_type_label",
					"mData": "props.IS_CDB",
					"bSortable": false,
					"sWidth":"12%"
				})
			};
			angular.forEach(columns,function(col){
				if(col.sTitle == "protection_VM_task_setarchiveLogProtection_checkbox" || col.sTitle == "ism.drm.proetct.group.appdb.version.column"){
					col.sWidth="9%"
				};
				if( angular.isDefined(col.sTitle) ){
					col.sTitle = resource.get(col.sTitle);
				};
				if($(window).width() <= 1440){
					if(_.isUndefined(col.bVisible) && protectGroup.poType == 1){
						col.sWidth="12%";
					}
				}
			});

			//opAreaConfig
			config.table.opAreaConfig = config.table.opAreaConfig || [];
			($scope.protectGroup.poType == 1) && (config.table.opAreaConfig.push(G_showPoConlist));
			angular.forEach(config.table.opAreaConfig,function(i){
				var template = i.template;

				if(angular.isString(template)){
					var matchResult = template.match(/title='(.*?)'/);
					var resKey = matchResult ? matchResult[1] : "";
					i.template = template.replace(/title='(.*?)'/,"title='" + resource.get(resKey) + "'");
				}

				var clickActive = i.clickActive;
				if( angular.isArray(clickActive) ){
					var fn = clickActive.pop(),deps = [];
					angular.forEach(clickActive,function(i){
						deps.push($injector.get(i));
					});

					deps.push(pgArr);
					deps.push(resource);
					deps.push($scope);
					i.clickActive = fn.apply(null,deps);
				}
			});

			$scope.poTable.checkbox = true;
			$scope.showDel = true;

			//renderRow
			var renderRow = config.table.renderRow;
			//支持服务注入
			if( angular.isArray(renderRow) ){
				var fn = renderRow.pop(),deps = [];
				angular.forEach(renderRow,function(i){
					deps.push($injector.get(i));
				});
				//把当前保护组注入
				deps.push(protectGroup);
				config.table.renderRow = fn.apply(null,deps);
			}
			//操作列为空的话就去掉
			_.isEmpty(config.table.opAreaConfig) && (delete config.table.opAreaConfig)
			angular.extend($scope.poTable , config.table);
		}

		//分页查询
        function pageQuery(){
        	var oQuery = {
			  	protectgroupId : protectGroup.pgId,
			  	_PAGE : appUtils.queryFilter(page-1,10,orderBy,orderType),
			  	poType: protectGroup.poType
			};


			if( $scope.typeSelectShow ){
				var typeSelect = $("#typeSelect").widget();
				if( typeSelect && typeSelect.getSelectedId() == "nasfs" ){
					oQuery.poType = "14";
				}
			}
			$scope.maskFlag = false;
			$scope.maskHandle = $.Deferred();
            $scope.$apply();
            Rest.queryProtectObjectsByPage(oQuery, {
                mask: false,
                callback: function() {
                    $scope.maskHandle.resolve();
                    $scope.maskFlag = true;
                },
                success: function(data) {
                    if ($scope.dbTableShow) {
                        updateTable(data);
                        delBtnCtrl();
                        //exchange dbVersion: 1->2007 2,3->2010,2013
                        if (protectGroup.poType == 8) {
                            if (protectGroup.props.dbVersion == "1") {
                                $("#poTable").find("table:eq(1) tr:eq(0) th:eq(1) div:eq(0) label").text(resource.get("ism.drm.proetct.group.appdb.storagegroup.column"));
                            } else {
                                $("#poTable").find("table:eq(1) tr:eq(0) th:eq(1) div:eq(0) label").text(resource.get("ism.drm.proetct.group.appdb.dbname.column"));
                            }
                            var firstPo = _.first(data.records);
							if (!_.isEmpty(firstPo) && protectGroup.props.dbVersion == "4" && firstPo.props.IS_CLUSTER == "true") {
							    $scope.showAdd = false;
							    $scope.showDel = false;
							} else {
							    $scope.showAdd = true;
							    $scope.showDel = true;
							};
                        }
                    } else {
                        updateNasTable(data);
                    }

                    if (appUtils.checkPageForward(page, data)) {
                        page = 1;
                        pageQuery();
                    }
                }
            });
		}

		//表格初始化
		function initTable(){
			pageQuery();
		}

		function initBtn(){
			var status = protectGroup.status;
			var statusTypes = Consts.PROTECT_GROUP_STATUS;

	    	//添加保护对象
	    	$scope.btnAddPo = status == statusTypes.DISABLED ? false //禁用不能添加
                : status == statusTypes.INVALID ? false //失效不能添加
                : status == statusTypes.LOCKED ? false //锁定不能添加
                : status == statusTypes.RUNNING ? false //正在执行不能添加
                : protectGroup.primary; // boolean 本端可以操作，远端不能操作
                //NAS双活保护对象不能手动移除、添加
			if( !$scope.btnAddPo || (protectGroup.template.type == 15 && !_.isEmpty(protectGroup.props.PROP_KEY_VSTORE_PAIR_ID) && !_.isEmpty(protectGroup.props.PROP_KEY_VSTORE_ID))
				|| protectGroup.template.type == 28 ||
				(_.contains([18,20],parseInt(protectGroup.template.type ,10)) && !_.isEmpty(protectGroup.props.PROP_KEY_VSTORE_PAIR_ID))){
				disableAddBtn();
			}else{
				enableAddBtn();
			}

			//刷新
			$("#refreshPo").unbind().click(function(){
				initTable();
			});

			//vmware 异步/同步复制不支持增加/移除保护对象
			if( protectGroup.poType == 10 ){
			   if(protectGroup.template.name == "array.replica.async.name" || protectGroup.template.name == "array.replica.sync.name" ){
				   $scope.showAdd = false;
				   appUtils.removeItemFromArray($scope.poTable.opAreaConfig,"id","btnDeletePo");
				   $scope.poTable.opAreaConfig = angular.copy($scope.poTable.opAreaConfig);
			   }else{
				   $scope.showAdd = true;
				   if( !appUtils.getItemFromArray($scope.poTable.opAreaConfig,"id","btnDeletePo") ){
					   $scope.poTable.opAreaConfig = angular.copy($scope.poTable.opAreaConfig);
				   }
			   }
			}else if( protectGroup.poType == 11 ){
				//一致性组不能添加删除
				if( protectGroup.props.cgUuid ){
					 $scope.showAdd = false;
					 $scope.poTable.checkbox = false;
					 $scope.showDel = false;
				}else{
					$scope.showAdd = true;
					$scope.poTable.checkbox = true;
					$scope.showDel = true;
				}
			}else if(protectGroup.poType == 14){
				//NAS双活不支持添加/移除保护对象
				if(protectGroup.template.type == 15 && !_.isEmpty(protectGroup.props.PROP_KEY_VSTORE_PAIR_ID) && !_.isEmpty(protectGroup.props.PROP_KEY_VSTORE_ID)){
					$scope.showAdd = false;
					$scope.showDel = false;
				}else{
					$scope.showAdd = true;
					$scope.showDel = true;
				}
			}



			!_.isUndefined($scope.poTable.opAreaConfig) && appUtils.flilterOperRight($scope.poTable.opAreaConfig);
		}

		function enableAddBtn(){
			var addDiv = $("#Add_po_btn");
			addDiv.find("div").attr("class","iconbutton-add");
			addDiv.find("span").css("color","#009ae7");
			addDiv.unbind("click").click($scope.btnConfig[0].click);
		}
		function disableAddBtn(){
			var addDiv = $("#Add_po_btn");
			addDiv.find("div").attr("class","iconbutton-add-disabled");
			addDiv.find("span").css("color","#666");
			addDiv.unbind("click");
		}

		//监听选择保护组事件,刷新界面
		$scope.$on(Consts.PG_SELECT_EVENT,function(){
			protectGroup = $scope.protectGroup;

			page = 1;
			orderBy = "";
			orderType = "";
			$scope.poTable.curPage = {"pageIndex": 1};

			pgArr.splice(0,1,protectGroup);
			init();
		});


		function init(){
			//oracle,db2,sqlserver 阵列异步复制可以增加nas
			$scope.typeSelectShow = ([1,2,3].indexOf( parseInt(protectGroup.poType,10) ) != -1) && (protectGroup.template.type == 1);
			initBtn();
			initTable();
		}

		initConf();
		init();

	}];

	var module = angular.module('recoverydirector.protection.config');
	module.tinyController('protection.pg.protectobjects.ctrl', ctrl);
	return module;
});
