define([], function() {
	"use strict";
	var ctrl = ["$scope","constsService","appUtils", function($scope, Consts, appUtils) {
		 var resource = appUtils.resource();
		 $scope.failPtData = appUtils.getWinData();
		 $scope.tableShow = true;
		 if( !angular.isArray($scope.failPtData) || $scope.failPtData.length == 0 ){
		 	$scope.tableShow = false;
		 }

		 $scope.noPtDesc = resource.get("protection_object_task_selPolicy_check_NoSupportPolicy_message");

		$scope.table = {
			id : "pgFailTable",
			displayLength : Consts.TABLE_COUNT_PER_PAGE,
			data : $scope.failPtData,
			enablePagination : false,
            columns : [{
				"sTitle" : resource.get("common_term_name_label"),
				sWidth: '169px',
				"mData" : "name"
			},{
				"sTitle" : resource.get("common_term_DRSolution_label"),
				sWidth: '169px',
				"mData" : "type",
				"bSortable" : false
			},{
				"sTitle" : resource.get("common_term_description_column"),
				sWidth: '169px',
				"mData" : "description",
				"bSortable" : false
			},{
				"sTitle" : resource.get("ism.drm.pg.policytemplate.match.cause"),
				sWidth: '169px',
				"mData" : "errorCode",
				"bSortable" : false
			}],
			renderRow : function(nRow, aData, iDataIndex){
				$('td:eq(0)', nRow).text(resource.get(aData.name));
				$('td:eq(1)', nRow).text(appUtils.getPtSolutionName(aData.name));
		    	$('td:eq(2)', nRow).text(resource.get(aData.description));

		    	var errorText = aData.errorCode ? resource.get("lego.err."+aData.errorCode) : "--";
		    	if( angular.isArray(aData.parameters) && aData.parameters.length > 0 ){
		    		aData.parameters.forEach(function(param,i){
		    			errorText = errorText.replace("{"+i+"}",param);
		    		});
		    	}
		    	$('td:eq(3)', nRow).text( errorText );
		    }
		};
	}];

	var module = angular.module("recoverydirector.protection.config");
	module.tinyController("ptFailedCtrl", ctrl);
	return module;
});