define([], function() {
    var ctrl = ["$scope", "appUtils", "constsService", "restService", "model", "infoTransferredService", "message", function($scope, appUtils, Consts, Rest, Model, infoTransferredService, message) {
        var resource = appUtils.resource();

        $scope.vm = $scope.viewModel;

        var pg = $scope.vm.pg;
        var pt = $scope.vm.data;
        var schedulesTemp = angular.copy(pt.schedules);
        //构造model
        var createVMs = function(item, schedules){
            var modelItem = Model.ViewModel.create({
                data: $scope.vm.data,
                pg: $scope.vm.pg,
                ok: $scope.vm.ok,
                scheduleData: {
                    protectLocation: item.protectLocation,
                    sourceSn: item.detail.recoveryStorageSN,
                    sourceSiteId: item.detail.recoverySiteId,
                    targetSn: item.detail.recoveryStorageSN,
                    targetSiteId: item.detail.recoverySiteId
                },
                _3dc: item.protectLocation == 0 || (_.contains([31], parseInt(pt.type,10)) && item.protectLocation == 4) ? 1 : 2,
                settingTitle: item.detail.recoverySiteName,
                createFlag: $scope.vm.createFlag,
                poListIds: $scope.vm.poListIds,
                settingEnable: $scope.vm.settingEnable
            });
            $scope.quickBackDatas.push({
                view: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html",
                ctrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl",
                vm: function(){
                    var copyData = angular.copy(modelItem);
                    if(!_.isEmpty(schedules)){
                        var scheduleTemp = _.filter(schedules, function(temp){
                            return temp.protectLocation == item.protectLocation && temp.targetSn == item.detail.recoveryStorageSN && (temp.protectedType == 2 || temp.protectedType == 100)
                        })[0];
                        !_.isEmpty(scheduleTemp) && (copyData.scheduleData = scheduleTemp);
                    };
                    return copyData
                }()
            });
            $scope.cloudBackupDatas.push({
                view: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html",
                ctrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl",
                vm: function() {
                    var copyData = angular.copy(modelItem);
                    delete copyData._3dc;
                    _.extend(copyData.scheduleData, {
                        protectedType: 101
                    });
                    if(!_.isEmpty(schedules)){
                        var scheduleTemp = _.filter(schedules, function(temp){
                            return temp.protectLocation == item.protectLocation && temp.targetSn == item.detail.recoveryStorageSN && temp.protectedType == 101
                        })[0];
                        !_.isEmpty(scheduleTemp) && (copyData.scheduleData = scheduleTemp);
                    };
                    return copyData
                }()
            });
        };
        //NAS+一体化备份去掉本地备份
        $scope.isHyperMetroVaultPolicy = pt.type == "28";
        //SAN一体化备份和双活+一体化备份
        $scope.isSanHyperVault = pt.type == "30" || pt.type == "31" || pt.type == "32";
        //双活+快照增加挂载策略
        $scope.isHyperMetroSnapShot = pt.type == "19";
        //支持云备份的应用：lun、数据库、vmware
        $scope.isSupportCloudbackup = _.contains([1,2,3,10,11,16,99], parseInt(pg.poType));

        if (!$scope.isHyperMetroVaultPolicy) {
            $scope.view1 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html";
            $scope.ctrl1 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl";
        }
        $scope.view2 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html";
        $scope.ctrl2 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl";

        if (pt.type == "3" || pt.type == "5") {
            $scope.view1 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelSyncContent.html";
            $scope.ctrl1 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelSyncContentCtrl";
        }
        //SAN一体化备份挂载策略
        //快速备份
        $scope.quickBackDatas = [];
        //云备份
        $scope.cloudBackupDatas = [];
        if (!$scope.vm.createFlag && ($scope.isSanHyperVault || $scope.isHyperMetroSnapShot)) {
            //先查询保护对象poList
            Rest.queryProtectObjectsByPage({
                protectgroupId: pg.uuid,
                _PAGE: appUtils.queryFilter(0, 10000)
            }, {
                mask: false,
                success: function(result) {
                    $scope.copyPolist = result.records;
                    if (!_.isEmpty(result) && !_.isEmpty(result.records)) {
                        //查询保护路径
                        Rest.getScheduleSiteInfo([pg.poType, pt.uuid], {
                            data: result.records,
                            isShowMsgBox: false,
                            success: function(data) {
                                if (!_.isEmpty(data)) {
                                    var productSite, recoverySite;
                                    _.each(data, function(item, index) {
                                        //构造model
                                        var schedules = angular.copy(schedulesTemp);
                                        if (item.protectLocation == 1) {
                                            productSite = item.detail.protectedSiteName;
                                            recoverySite = item.detail.recoverySiteName;
                                        };
                                        createVMs(item, schedules);
                                        $scope.$apply();
                                    });
                                    $scope.isSanHyperVault && ($scope.vm4.settingTitle = productSite + " --> " + recoverySite);
                                }
                            }
                        });
                    };
                }
            })
        };
        //4dc查询站点关系
        if(!$scope.vm.createFlag && (pt.type == "35" || pt.type == "36" || _.contains([4,6],parseInt(pt.type)) || (pt.type == "3" && pt.sketch != "policy_template_3_cascaded_sa_dr_star.png") || (pt.type == "5" && pt.sketch != "policy_template_5_concurrent_sa_dr_star.png"))){
            //先查询保护对象poList
            Rest.queryProtectObjectsByPage({
                protectgroupId: pg.uuid,
                _PAGE: appUtils.queryFilter(0, 10000)
            }, {
                mask: false,
                success: function(result) {
                    if (!_.isEmpty(result) && !_.isEmpty(result.records)) {
                        //查询保护路径
                        Rest.getScheduleSiteInfo([pg.poType, pt.uuid], {
                            data: result.records,
                            isShowMsgBox: false,
                            success: function(data) {
                                if (!_.isEmpty(data)) {
                                    var preTitle = resource.get("protection.copyrate.policy.label");
                                    _.each(data, function(item) {
                                        if (item.protectLocation == 1) {
                                            $scope.vm1.settingTitle = preTitle + "(" + item.detail.protectedSiteName + "->" + item.detail.recoverySiteName + ")";
                                        } else {
                                            $scope.vm2.settingTitle = preTitle + "(" + item.detail.protectedSiteName + "->" + item.detail.recoverySiteName + ")";
                                        }
                                    });
                                }
                            }
                        });
                    };
                }
            })
        };
        //环形3dc（级联同步+异步、并联同步+异步）站点关系
        if(!$scope.vm.createFlag && ((pt.type == "3" && pt.sketch == "policy_template_3_cascaded_sa_dr_star.png") || (pt.type == "5" && pt.sketch == "policy_template_5_concurrent_sa_dr_star.png"))){
            Rest.queryProtectObjectsByPage({
                protectgroupId: pg.uuid,
                _PAGE: appUtils.queryFilter(0, 10000)
            }, {
                mask: false,
                success: function(result) {
                    if (!_.isEmpty(result) && !_.isEmpty(result.records)) {
                        //查询保护路径
                        Rest.getScheduleSiteInfo([pg.poType, pt.uuid], {
                            data: result.records,
                            isShowMsgBox: false,
                            success: function(data) {
                                if (!_.isEmpty(data)) {
                                    var preTitle = resource.get("protection.copyrate.policy.label");
                                    _.each(data, function(item) {
                                        if (item.protectLocation == 1) {
                                            $scope.vm1.settingTitle = preTitle + "(" + item.detail.protectedSiteName + "->" + item.detail.recoverySiteName + ")";
                                        };
                                    });
                                }
                            }
                        });
                    };
                }
            })
        };
        if ($scope.isSanHyperVault || $scope.isHyperMetroSnapShot) {
            //封装数据
            $scope.title3 = {
                policyTitle: appUtils.getString("protection_step3_mount_title"),
                policyDesc: appUtils.getString("pg_step2_mount_desc_label"),
                policyIcon: "policy_auto_mount_icon"
            };
            $scope.title4 = {
                policyTitle: appUtils.getString("array.replica.async.name"),
                policyDesc: appUtils.getString("pg_step2_async_desc_label"),
                policyIcon: "policy_async_icon"
            };
            $scope.title5 = {
                policyTitle: appUtils.getString("pg_create_fastcloudback_label"),
                policyDesc: appUtils.getString("pg_step2_fastcloudback_desc_label"),
                policyIcon: "policy_cloudbackup_icon"
            };
            $scope.title6 = {
                policyTitle: appUtils.getString("pg_create_cloudback_label"),
                policyDesc: appUtils.getString("pg_step2_cloudback_desc_label"),
                policyIcon: "policy_quick_cloudbackup_icon"
            };
            $scope.view3 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/scheduleMountPolicy.html";
            $scope.ctrl3 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/scheduleMountPolicyCtrl";
            $scope.vm3 = Model.ViewModel.create({
                data: $scope.vm.data,
                pg: $scope.vm.pg,
                createFlag: $scope.vm.createFlag,
                titleText: appUtils.getString("protection_step3_mount_title"),
                ok: $scope.vm.ok,
                settingEnable: $scope.vm.settingEnable,
                settingShow: true,
                valid: false,
                settingTitle: appUtils.getString("pg_create_autoMountPolicy_label"),
                click: function() {
                    var win = angular.copy(Consts.SAN_MOUNT_POLICY_WIN);
                    win.title = appUtils.getString("protection_set_mount_policy_win_title");
                    //vmware一体化备份挂载策略
                    if ($scope.vm.pg.poType == 10) {
                        win.content = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/vmwareMountPolicyWin.html";
                        win.controller = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/vmwareMountPolicyWinCtrl";
                    };
                    appUtils.isEn() && (win.width = 720);
                    win.data = $scope.vm;
                    win.close = function(evt) {
                        var mountConfigs = infoTransferredService.get("SAN_MOUNT_POLICY", "MOUNT_CONFIGS");
                        if (!_.isEmpty(mountConfigs)) {
                            infoTransferredService.remove("SAN_MOUNT_POLICY", "MOUNT_CONFIGS");
                            $scope.$broadcast("SET_MOUNT_POLICY", mountConfigs);
                        };
                    };

                    //VMware CDM是否为rdm盘的虚拟机
                    if ($scope.vm.createFlag) {
                        $scope.copyPolist = angular.copy($scope.vm.pg.polist);
                    };

                    var isPhysicalMode = !_.isUndefined(_.find($scope.copyPolist, function(v, k) {
                        var virtualDisks = angular.fromJson(v["props"]["VirtualDisk"]);
                        return !_.isUndefined(_.findWhere(virtualDisks, {storageType: "physicalMode"}));
                    }));

                    //CDM场景下：如果VMware是rdm盘的虚拟机，不支持设置备份策略，只允许设置复制策略。
                    if ($scope.vm.pg.poType == 10 && isPhysicalMode && _.contains([30, 31, 32], parseInt(pt.type, 10))) {
                        message.warn({
                            content: appUtils.getString("pg_mountschedule_warn_label"),
                            ok: function() {
                                appUtils.showWindow(win);
                            }
                        })
                    } else {
                        appUtils.showWindow(win);
                    }
                }
            });
            if ($scope.isSanHyperVault) {
                $scope.view4 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html";
                $scope.ctrl4 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl";
                $scope.vm4 = Model.ViewModel.create({
                    data: $scope.vm.data,
                    pg: $scope.vm.pg,
                    createFlag: $scope.vm.createFlag,
                    ok: $scope.vm.ok,
                    settingEnable: $scope.vm.settingEnable,
                    scheduleData: function(){
                        var temp = _.filter(schedulesTemp, function(item){
                            return item.protectedType == 1
                        })[0]
                        return temp || {protectedType: 1};
                    }(),
                    cdmDuplicate: true,
                    settingShow: true,
                    valid: false
                });
            };
        };


        if (!$scope.isHyperMetroVaultPolicy) {
            $scope.vm1 = Model.ViewModel.create({
                data: $scope.vm.data,
                pg: $scope.vm.pg,
                ok: $scope.vm.ok,
                _3dc: 1,
                createFlag: $scope.vm.createFlag,
                poListIds: $scope.vm.poListIds,
                settingEnable: $scope.vm.settingEnable
            });
        }

        $scope.vm2 = Model.ViewModel.create({
            data: $scope.vm.data,
            pg: $scope.vm.pg,
            ok: $scope.vm.ok,
            _3dc: 2,
            createFlag: $scope.vm.createFlag,
            poListIds: $scope.vm.poListIds,
            settingEnable: $scope.vm.settingEnable
        });

        if (pt.type == 17 || pt.type == 30 || pt.type == 31 || pt.type == 32) {
            $scope.vm1.titleText = resource.get("protection_hyperVault_localSchedule_title");
            $scope.vm2.titleText = resource.get("protection_hyperVault_remoteSchedule_title");
        }

        if (pt.type == 28) {
            $scope.vm2.titleText = resource.get("protection_hyperVault_remoteSchedule_title");
        }

        if ($scope.vm.createFlag) {
            $scope.$on($scope.vm.event, function() {
                if (pt.type == 28) {
                    $scope.vm.valid = $scope.vm2.valid;
                } else if ($scope.isSanHyperVault) {
                    //SAN一体化备份
                    $scope.vm.valid = $scope.vm4.valid;
                } else if ($scope.isHyperMetroSnapShot){
                    //双活+快照校验
                    $scope.vm.valid = !_.isUndefined(_.find($scope.cloudBackupDatas, function(value, key, list) {
                        return value.vm.valid === true;
                    })) || !_.isUndefined(_.find($scope.quickBackDatas, function(value, key, list) {
                        return value.vm.valid === true;
                    }));
                } else {
                    $scope.vm.valid = $scope.vm1.valid && $scope.vm2.valid;
                };
                if (!$scope.vm.valid) return;


                if (pt.type == 28) {
                    $scope.vm.data.schedules = [$scope.vm2.schedule];
                } else if ($scope.isSanHyperVault || $scope.isHyperMetroSnapShot) {
                    var scheduleArray = [];
                    //一体化和双活+一体化的复制策略
                    $scope.isSanHyperVault && scheduleArray.push($scope.vm4.schedule);
                    _.each($scope.quickBackDatas, function(val) {
                        (!_.isEmpty(val.vm.schedule) && val.vm.schedule.enable === true) && scheduleArray.push(val.vm.schedule);
                    });
                    _.each($scope.cloudBackupDatas, function(val) {
                        (!_.isEmpty(val.vm.schedule) && val.vm.schedule.enable === true) && scheduleArray.push(val.vm.schedule);
                    });
                    $scope.vm.data.schedules = scheduleArray;
                } else {
                    $scope.vm.data.schedules = [$scope.vm1.schedule, $scope.vm2.schedule];
                }
                var props = {};

				var syncRate = [];
				if( [3,4,5,6,35,36].indexOf(parseInt(pt.type,10))!=-1 ){
					var syncRate1 = $scope.vm1.data.props.syncRateRecords;
					var syncRate2 = $scope.vm2.data.props.syncRateRecords;
					if( syncRate1 && _.isString(syncRate1) ){
						syncRate = syncRate.concat(JSON.parse(syncRate1));
					}
					if( syncRate2 && _.isString(syncRate2) ){
						syncRate = syncRate.concat(JSON.parse(syncRate2));
					}
				}

                if (pt.type == 28) {
                    _.extend(props, $scope.vm2.data.props);
                    if (!_.isUndefined($scope.vm2.data.props.ReplicaRetentionPolicy)) {
                        var ReplicaRetentionPolicy = {};
                        _.extend(ReplicaRetentionPolicy, JSON.parse($scope.vm2.data.props.ReplicaRetentionPolicy));
                        props.ReplicaRetentionPolicy = JSON.stringify(ReplicaRetentionPolicy);
                    };
                    if (!_.isUndefined($scope.vm2.data.props.RPO_SETTINGS)) {
                        var rpoSettings = {};
                        _.extend(rpoSettings, JSON.parse($scope.vm2.data.props.RPO_SETTINGS));
                        props.RPO_SETTINGS = JSON.stringify(rpoSettings);
                    }
                } else {
                    _.extend(props, $scope.vm1.data.props, $scope.vm2.data.props);
                    if (pt.type == 30 || pt.type == 31 || pt.type == 32 || pt.type == 19) {
                        if (!$scope.vm3.valid) {
                            _.extend($scope.vm3.data.props, {
                                AUTOMOUNTCONFIGS: JSON.stringify({
                                    enabled: false
                                })
                            })
                        } else {
                            var mountProps = {};
                            try {
                                mountProps = JSON.parse($scope.vm3.data.props.AUTOMOUNTCONFIGS);
                            } catch (err) {}
                            _.each(mountProps.mountConfigs, function(val) {
                                delete val.hostName;
                                delete val.siteName
                            });
                            _.extend($scope.vm3.data.props, {
                                AUTOMOUNTCONFIGS: JSON.stringify(mountProps)
                            });
                        }
                        _.extend(props, _.pick($scope.vm3.data.props, "AUTOMOUNTCONFIGS"));
                    };

                    if (syncRate.length > 0) {
                        props.syncRateRecords = JSON.stringify(syncRate);
                    }

                    if ((pt.type == 17 || pt.type == 19 || pt.type == 30 || pt.type == 31 || pt.type == 32) && (!_.isUndefined($scope.vm1.data.props.ReplicaRetentionPolicy) && !_.isUndefined($scope.vm2.data.props.ReplicaRetentionPolicy))) {
                        var ReplicaRetentionPolicy = {};
                        _.extend(ReplicaRetentionPolicy, JSON.parse($scope.vm1.data.props.ReplicaRetentionPolicy), JSON.parse($scope.vm2.data.props.ReplicaRetentionPolicy));
                        props.ReplicaRetentionPolicy = JSON.stringify(ReplicaRetentionPolicy);
                    }

                    if (!_.isUndefined($scope.vm1.data.props.RPO_SETTINGS) && !_.isUndefined($scope.vm2.data.props.RPO_SETTINGS)) {
                        var rpoSettings = {};
                        _.extend(rpoSettings, JSON.parse($scope.vm1.data.props.RPO_SETTINGS), JSON.parse($scope.vm2.data.props.RPO_SETTINGS));
                        props.RPO_SETTINGS = JSON.stringify(rpoSettings);
                    }
                }
                $scope.vm.data.props = props;
            });

            var preTitle = resource.get("ism.drm.protect.group.template");
            //查询名称
            var poType = pg.poType;
            //一体化备份不用查询站点名称
            if (pt.type == 17 || pt.type == 28) return;

            var ptUuid = pt.uuid;

            var config = {};
            config.data = $scope.vm.poListIds;
            config.success = function(data) {
                if (!angular.isArray(data) || data.length < 2) return;
                //protectLocation: A(0);A-B(1);A-C(2);B-C(3).B(4)

                //CDM不用查询两端title
                if ($scope.isSanHyperVault) {
                    var productSite, recoverySite, productSiteId, recoverySiteId;
                    _.each(data, function(item) {
                        if (item.protectLocation == 0) {
                            infoTransferredService.put("getStorageSnModuel", "usedStorageSnA", item.detail.protectedStorageSN);
                        } else if (item.protectLocation == 1) {
                            infoTransferredService.put("getStorageSnModuel", "usedStorageSnB", item.detail.protectedStorageSN);
                            productSite = item.detail.protectedSiteName;
                            recoverySite = item.detail.recoverySiteName;
                            $scope.vm4.scheduleData.sourceSn = item.detail.protectedStorageSN;
                            $scope.vm4.scheduleData.sourceSiteId = item.detail.protectedSiteId;
                            $scope.vm4.scheduleData.targetSn = item.detail.recoveryStorageSN;
                            $scope.vm4.scheduleData.targetSiteId = item.detail.recoverySiteId;
                        } else {
                            infoTransferredService.put("getStorageSnModuel", "usedStorageSnC", item.detail.protectedStorageSN);
                        }
                        createVMs(item);
                    });
                    $scope.vm4.settingTitle = productSite + " --> " + recoverySite;
                    $scope.$apply();
                    return;
                };

                //双活+快照
                if (data[0].protectLocation == 0 || data[1].protectLocation == 0) {
                    if (data[0].protectLocation != 0) {
                        data.reverse();
                    }
                    data.forEach(function(item, i) {
                        var detail = data[i].detail;
                        if (item.protectLocation == 0) {
                            $scope.vm1.titleText = preTitle + "(" + detail.protectedSiteName + ")";
                            $scope.vm1.scheduleName = detail.protectedSiteId + ";" + detail.recoverySiteId;
                            $scope.vm1.scheduleNameText = resource.get("protection.term.scheduleProduction.label", detail.protectedSiteName);
                            infoTransferredService.put("getStorageSnModuel", "usedStorageSnA", detail.protectedStorageSN);
                        } else {
                            $scope.vm2.titleText = preTitle + "(" + detail.protectedSiteName + ")";
                            $scope.vm2.scheduleName = detail.protectedSiteId + ";" + detail.recoverySiteId;
                            $scope.vm2.scheduleNameText = resource.get("protection.term.scheduleProduction.label", detail.protectedSiteName);
                            infoTransferredService.put("getStorageSnModuel", "usedStorageSnB", detail.protectedStorageSN);
                        }
                        //构造model
                        createVMs(item);
                    });
                }
                //3dc
                else {
                    if (data[0].protectLocation != 1) {
                        data.reverse();
                    }
                    preTitle = resource.get("protection.copyrate.policy.label");
                    data.forEach(function(item, i) {
                        var detail = data[i].detail;
                        if (item.protectLocation == 1) {
                            $scope.vm1.titleText = preTitle + "(" + detail.protectedSiteName + "->" + detail.recoverySiteName + ")";
                            $scope.vm1.scheduleName = detail.protectedSiteId + ";" + detail.recoverySiteId;
                            $scope.vm1.scheduleNameText = resource.get("protection.term.scheduleProduction.label", detail.protectedSiteName + "->" + detail.recoverySiteName);
                            $scope.vm1.sourceSiteId = detail.protectedSiteId;
                            $scope.vm1.targetSiteId = detail.recoverySiteId;
                        } else {
                            $scope.vm2.titleText = preTitle + "(" + detail.protectedSiteName + "->" + detail.recoverySiteName + ")";
                            $scope.vm2.scheduleName = detail.protectedSiteId + ";" + detail.recoverySiteId;
                            $scope.vm2.scheduleNameText = resource.get("protection.term.scheduleProduction.label", detail.protectedSiteName + "->" + detail.recoverySiteName);
                            $scope.vm2.sourceSiteId = detail.protectedSiteId;
                            $scope.vm2.targetSiteId = detail.recoverySiteId;
                            //同步+异步的环形串并联
                            if (item.protectLocation == 5 && _.contains([3, 5], parseInt(pt.type))) {
                                $scope.vm2.titleText = preTitle + "(" + detail.protectedSiteName.replace(":", "+") + "->" + detail.recoverySiteName + ")";
                                $scope.vm2.scheduleNameText = resource.get("protection.term.scheduleProduction.label", detail.protectedSiteName.replace(":", "+") + "->" + detail.recoverySiteName);
                            };
                        }
                    });
                }

                $scope.$digest();
            };

            Rest.getScheduleSiteInfo([poType, ptUuid], config);
        }
    }];

    return ctrl;
});
