define(["tiny-common/UnifyValid"],
function(UnifyValid){
	var ctrl = ["$scope", "appUtils", "constsService","message","restService","$stateParams",
	     function($scope,  appUtils, Consts, message, Rest, $stateParams){
			var vm = $scope.viewModel;
			var schedule = vm.data.schedule;
			var props = vm.data.props;
			var resource = appUtils.resource();
			var ptType = parseInt(vm.ptType,10);
			var _3dc = vm._3dc;
			//是否是阵列复制
			var isStorageReplication = ([1,3,4,5,6,17,18,20,28,30,31,32,33,35,36].indexOf(ptType) != -1);
			if(_.contains([30,31,32], ptType) && schedule.protectedType != 1){
				isStorageReplication = false;
			};
			//是否是SAN一体化或双活+一体化备份，并且不是云备份。
			var isSanHyperVault = (ptType == 30 || ptType == 31 || ptType == 32) && vm.data.schedule.protectedType != 101 && vm.isSupportSecondPolicy;
			//增加秒级策略(双活+快照),并且不是云备份。
			var isAddSecondSchedule = _.contains([19, 2], parseInt(ptType)) && vm.data.schedule.protectedType != 101 && vm.isSupportSecondPolicy;
			//hana快照
			var isHanaSnapshot = ptType == 2 && $stateParams.poType == 16;
			isHanaSnapshot && (isAddSecondSchedule = false);
			//hana的一体化备份
			var isHanaHyperCdp = _.contains([30,31,32], parseInt(ptType, 10)) && $stateParams.poType == 16;
			//快照、双活+快照增加hypercdp
			var isSupportedHyperCdp = (_.contains([19, 2], parseInt(ptType)) || isHanaHyperCdp) && vm.data.schedule.protectedType != 101;
			$scope.isSanHyperVaultSecond = (isSanHyperVault && _3dc == 1) || isAddSecondSchedule;
			$scope.typeTimeChange = false;
			$scope.modeTypeTimeChange = false;
			$scope.scheduleTimeTypeHelpTip = appUtils.getString("protection_policy_time_help_tips");
			$scope.defaultTimeTypeValue = "5";
			//HANA异步复制强制启用一致性策略时不允许设置小于15分钟
			var isHanaDisableApp = _.isObject(props) && props['SUPPORT_FREEZE_FLAG_DISABLE'] == "0";
			//HANA异步复制强制启用一致性策略时不允许设置秒级策略
			isHanaDisableApp && (isSanHyperVault = false);
			//CDM的支持hyperCDP
			var isCDMSupportedHyperCdp = (ptType == 30 || ptType == 31 || ptType == 32) && vm.data.schedule.protectedType != 101;
			function enableDownBtn(){
				$("#minute .tiny-spinner-down-arrow").removeClass("tiny-spinner-down-disabled");
				$("#minute .tiny-spinner-downbtn").removeClass("tiny-downbtn-disabled");
			};

			function disableDownBtn(){
				$("#minute .tiny-spinner-down-arrow").addClass("tiny-spinner-down-disabled");
				$("#minute .tiny-spinner-downbtn").addClass("tiny-downbtn-disabled");
			};

			$scope.Consts = Consts;
			$scope.isEn = appUtils.isEn();
			$scope.isSupportCustomSecondPolicy = vm.isSupportCustomSecondPolicy;

			//控件在中英文下的调整zh/en
			var widthAdaptor = {
				interval: [286,268],
				execPeriod: [128,119],
				execPoint: [125,116],
				abortTaskTime: [286,268],
				validTime: [270,255],
				minSpinner: [120,111],
				dateSelect: [241,223],
				datePanel: [284,266]
			}

			$scope.widthAdaptor = {};

			var _i = $scope.isEn ? 1 : 0;
			_.each(widthAdaptor,function(v,k){
				$scope.widthAdaptor[k] = v[_i];
			});

			var adWidth = $("#preAdjustSpan").width();
			$("#showExecPeriodTipDiv").css("margin-left",adWidth);

			var protectLocation = vm.protectLocation || 0;

			/*
				3dc策略模版包含两个时间表,而控件取值采用$(id)方式.
				所有这里需要设置context保证id的唯一.
			*/

			var CONTEXT = vm.context || "";
			//CDM、双活+快照显示快照类型
			var initSnapType = function(){
				//创建完成后不允许修改快照类型
				if($("#snapShotTypeRadio").widget()){
					//传递事件，显示快照类型
					$scope.$emit("SHOW_SNAPSHOTTYPE_TIP",{isHyperDcp: schedule.protectedType == 100});
					if(schedule.protectedType == 100){
						$("#snapShotTypeRadio").widget().opChecked("cdp",true);
						(!vm.createFlag && !_.isEmpty(schedule.scheduleId)) && $("#snapShotTypeRadio").widget().opDisabled("snapshot",true);
						$scope.scondTypeSelect.values = [{
						    label: "10",
						    selectId: "10",
						}, {
							label: "20",
							selectId: "20",
						}, {
							label: "30",
							selectId:"30",
						}, {
							label: "40",
							selectId:"40",
						}, {
							label: "50",
							selectId:"50",
						}, {
						    label: "60",
						    selectId: "60",
						}, {
						    label: "120",
						    selectId: "120",
						}, {
						    label: "180",
						    selectId: "180",
						}, {
						    label: "240",
						    selectId: "240",
						}];
						if ($scope.isSupportCustomSecondPolicy) {
							for(var i = 9;i >= 3; i--){
								$scope.scondTypeSelect.values.unshift({
									label: $.trim(i),
									selectId: $.trim(i)
								})
							}
						};
					}else{
						$("#snapShotTypeRadio").widget().opChecked("snapshot",true);
						(!vm.createFlag && !_.isEmpty(schedule.scheduleId)) && $("#snapShotTypeRadio").widget().opDisabled("cdp",true);
						$scope.scondTypeSelect.values = [{
							label: "30",
							selectId:"30",
						}, {
						    label: "60",
						    selectId: "60",
						}, {
						    label: "120",
						    selectId: "120",
						}, {
						    label: "180",
						    selectId: "180",
						}, {
						    label: "240",
						    selectId: "240",
						}];
					}
				};
			};

			/**时间表设置**/
			$scope.scheduleText   = resource.getWithColon("ism.drm.protect.policy.schedule");
			$scope.dayText        = resource.get("ism.drm.protectpolicy.schedule.type.day");
			$scope.hourText       = resource.get("ism.drm.protectpolicy.schedule.type.hour");
			$scope.secondText     = resource.get("common_term_second_label");
			$scope.minuteText     = resource.get("ism.drm.protectpolicy.schedule.type.minute");
			$scope.hourLabel      = resource.get("ism.drm.protectpolicy.schedule.type.clock");
			$scope.minuteLabel	  = resource.get("ism.drm.protectpolicy.schedule.type.minutes");
			$scope.monthText      = resource.get("ism.drm.protectpolicy.schedule.type.monthDay");
			$scope.weekText       = resource.get("ism.drm.protectpolicy.schedule.type.week");
			$scope.timePeroidText = resource.getWithColon("com.huawei.ism.drm.policy.schedule.timePeroid");
			$scope.runoneText     = resource.get("recovery.term.procedure.filter.values.lunRollback");
			$scope.periodExclude  = resource.get("ism.drm.protectpolicy.schedule.period.exclude.label");
			$scope.fromText       = resource.get("common_term_from_label");
			$scope.toText         = resource.get("common_term_to_label");
			$scope.execPointText  = resource.getWithColon("ism.drm.protectpolicy.schedule.execPoint.label");
			$scope.validTimeText  = resource.getWithColon("securtiy_term_time_field_label");
			$scope.peroidExecText = resource.get("protection.policy.period_exec.label");
			$scope.minuteValueHelpTip = resource.get("protection_policy_minute_help_label");
			try {
			    if (!_.isEmpty($("#tabtitle-3").parent()) && $("#tabtitle-3").parent().css("display") == "none") {
			        $scope.minuteValueHelpTip = resource.get("protection_policy_minute_limit_help_label")
			    }
			    //主机复制一致性和策略时间没关系
				if (11 == ptType) {
				    $scope.minuteValueHelpTip = resource.get("protection_policy_minute_limit_help_label")
				};
			} catch (err) {};



			/*设置自动执行或手动执行(默认自动执行)*/
			$scope.showAutoExecSetting = true;
			$scope.showAutoExecRPO = ptType != 11 && !(isSanHyperVault && _3dc == 1) && !isAddSecondSchedule;
			$scope.scheduleModelTitle = resource.getWithColon("protection.term.exeHistory.label");
			$scope.scheduleModeSelect = {
				id : CONTEXT + "scheduleModeSelect",
				values :[{
					selectId : "1",
					label : resource.get("protection.term.exeHistory.value.manual.value")
				},{
					selectId : "0",
					label : resource.get("protection.term.exeHistory.value.auto.value")
				}],
				defaultSelectid : "0",
				change : function(){
					$scope.showAutoExecSetting = $("#"+$scope.scheduleModeSelect.id).widget().getSelectedId() == "0";
					$scope.showAutoExecRPO = (ptType != 11 && $("#"+$scope.scheduleModeSelect.id).widget().getSelectedId() == "0" && $("#"+$scope.timeTypeSelect.id).widget().getSelectedId() != "5");
					//传递事件，如果手动执行，允许设置日、周、月的快照保留策略
					$scope.typeTimeChange = false;
					if(!vm.createFlag && $("#"+$scope.timeTypeSelect.id).widget().getSelectedId() == "5" && !_.isEmpty(schedule.scheduleId)){
						$scope.modeTypeTimeChange = true;
						$scope.changeModeTypeTips = $scope.showAutoExecSetting ? appUtils.getString("protection_policy_mode_change_second_label") : appUtils.getString("protection_policy_mode_change_not_second_label");
					};
					if(!_.isEmpty($("#snapShotTypeRadio").widget()) && $("#snapShotTypeRadio").widget().opChecked("cdp")){
						$scope.scondTypeSelect.defaultSelectid = "10";
					}else{
						$scope.scondTypeSelect.defaultSelectid = "30";
					};
					$scope.$emit("DISABLE_SNAPSHOTNUMBER",{modeType:$("#"+$scope.scheduleModeSelect.id).widget().getSelectedId() == "1",type:$("#"+$scope.timeTypeSelect.id).widget().getSelectedId(), minute:$("#"+$scope.minIntervalTextbox.id).widget().getValue()});
				}
			}

			//执行策略的帮助提示
			var manualExecText = resource.getWithColon("protection.term.exeHistory.value.manual.value");
			var manualExecDesc = resource.get("protection.term.exeHistory.value.manual.des.label");
			var autoExecText   = resource.getWithColon("protection.term.exeHistory.value.auto.value");
			var autoExecDesc   = resource.get("protection.term.exeHistory.value.auto.des.label");
			$scope.scheduleHelpTip =
				"<p>" + manualExecText + "</p>" +
				"<p>" + manualExecDesc + "</p>" +
				"<p style='margin-top:20px;'>" + autoExecText + "</p>" +
				"<p>" + autoExecDesc + "</p>";

			/*自动执行的设置面板*/

			//日期&时间设置
			$scope.dateText = resource.getWithColon("notify_alarm_term_general_dateTime_label");
			$scope.startTimeText = resource.getWithColon("common.term.startTime.column");
			$scope.endTimeText = resource.getWithColon("common.term.endTime.column");

			$scope.startTimeDateTime = {
				id : CONTEXT + "startTimeDateTime",
				type : "datetime",
				dateFormat : 'yy-mm-dd',
				timeFormat : "hh:mm:ss"
			};

			$scope.endTimeCheckbox = {
                id : CONTEXT + "endTimeCheckbox",
                text : $scope.toText,
                checked : false,
                change : function(){
                	var checked = $("#"+$scope.endTimeCheckbox.id).widget().option("checked");
                	$("#"+$scope.endTimeDateTime.id).widget().option("disable",!checked);
                }
            };

			$scope.endTimeDateTime = {
				id : CONTEXT + "endTimeDateTime",
				type : "datetime",
				disable : true,
				dateFormat : 'yy-mm-dd',
				timeFormat : "hh:mm:ss"
			};

			//时间类型(分钟,小时,天,周,月)
			$scope.timeTypeSelect = {
				id : CONTEXT + "timeTypeSelect",
				values : [{label:$scope.minuteText,selectId:"0"},{label:$scope.hourText,selectId:"1"},
				          {label:$scope.dayText,selectId:"2"},{label:$scope.weekText,selectId:"3"},{label:$scope.monthText,selectId:"4"}],
				defaultSelectid : "0",
				change : function(){
					var type = $("#"+$scope.timeTypeSelect.id).widget().getSelectedId();
					switchToSettingPanel(type);
					//修改时才提示
					$scope.modeTypeTimeChange = false;
					if(!vm.createFlag && !_.isEmpty(schedule.scheduleId)){
						$scope.typeTimeChange = true;
						$scope.defaultTimeTypeValue != "5" && type != "5" && ($scope.typeTimeChange = false);
						if(type == "5"){
							$scope.changeTimeTypeTips = appUtils.getString("protection_policy_change_second_label");
						}else{
							$scope.changeTimeTypeTips = appUtils.getString("protection_policy_change_not_second_label");
						}
						$scope.defaultTimeTypeValue = type;
					};
					if(!_.isEmpty($("#snapShotTypeRadio").widget()) && $("#snapShotTypeRadio").widget().opChecked("cdp")){
						$scope.scondTypeSelect.defaultSelectid = "10";
					}else{
						$scope.scondTypeSelect.defaultSelectid = "30";
					};
					//传递事件，如果快照自动执行时间间隔大于5分钟时，允许设置日、周、月的快照保留策略
					$scope.$emit("DISABLE_SNAPSHOTNUMBER",{type:type, minute:$("#"+$scope.minIntervalTextbox.id).widget().getValue()});
				}
			};

			//SAN一体化备份本段增加按秒执行
			$scope.showSecondPeriod = (isSanHyperVault && _3dc == 1) || isAddSecondSchedule;
			$scope.scondTypeSelect = {
				id : CONTEXT + "secondTypeSelect",
				values: [{
					label: "30",
					selectId: "30",
				},{
					label: "60",
					selectId: "60",
				},{
					label: "120",
					selectId: "120",
				},{
					label: "180",
					selectId: "180",
				},{
					label: "240",
					selectId: "240",
				}],
				defaultSelectid : "30",
				openFn: function(){
					_.each($('.tiny-select-popup-container'), function(val) {
					    val.scrollTop = 0;
					});
				}
			};
			if((isSanHyperVault && _3dc == 1) || isAddSecondSchedule){
				$scope.timeTypeSelect.values.unshift({
					label: $scope.secondText,
					selectId: "5"
				});
				$scope.timeTypeSelect.defaultSelectid = "5";
				$scope.isSanHyperVaultSecondType = true;
				$scope.$apply();
			};

			//CDM的云备份和快速备份备端没有RPO和周期调度
			if(_.contains([30,31,32], parseInt(ptType, 10)) && schedule.protectLocation == 1 && schedule.protectedType != 1){
				$scope.scheduleModeSelect.values = [{
					selectId : "1",
					label : resource.get("pg_excute_after_duplica_label")
				}];
				$scope.scheduleModeSelect.defaultSelectid = "1";
				//问号后面描述要改
				$scope.scheduleHelpTip = resource.get("pg_policy_cloudbackup_help_label");
			};

			//间隔时间设置( 每[?]分钟|小时|天 )
			$scope.showTimeInterval = true;

			$scope.timeIntervalAdj = resource.get("ism.drm.protectpolicy.schedule.every");
			$scope.timePointAdj = resource.get("common_term_at");

			/*-------------------------------------*/

			//每[?]分
			$scope.minIntervalTextbox = {
				id : CONTEXT + "minIntervalTextbox",
				validate : isHanaDisableApp || isHanaSnapshot ? appUtils.numberValidateStr(15,59,resource.get("policy.schedule.hana.minute.err.msg")) : appUtils.numberValidateStr(5,59,resource.get("policy.schedule.minute.err.msg")),
				value : "15",
				show : true,
				contentChange: function(){
					$scope.$emit("DISABLE_SNAPSHOTNUMBER",{type:"0", minute:$("#"+$scope.minIntervalTextbox.id).widget().getValue()});
				}
			};

			//每[?]小时
			$scope.hourIntervalTextbox = {
				id : CONTEXT + "hourIntervalTextbox",
				validate : appUtils.numberValidateStr(1,23,resource.get("policy.schedule.hour.err.msg")),
				value : "1",
				show : false
			};

			$scope.showMultiExecPointSelect = true;
			$scope.showSingleExecPointSelect = false;

			//每[?]天
			$scope.dayIntervalTextbox = {
				id : CONTEXT + "dayIntervalTextbox",
				validate : appUtils.numberValidateStr(1,31,resource.get("policy.schedule.day.err.msg")),
				value : "1",
				show : false,
				keyup: function(){
					var val = $("#"+$scope.dayIntervalTextbox.id).widget().getValue();
					//此时执行时间点hour可多选
					if(val == 1){
						$scope.showMultiExecPointSelect = true;
						$scope.showSingleExecPointSelect = false;
						var ids = $("#"+$scope.execPointSelect.id).widget().getSelectedId();
						$scope.showAbortTaskTime = ids.length == 1 && isStorageReplication;
					}
					else{
						$scope.showMultiExecPointSelect = false;
						$scope.showSingleExecPointSelect = true;
						$scope.showAbortTaskTime = isStorageReplication;
					}
				}
			};

			//执行时间点
			//小时
			$scope.execPointSelect = {
				id : CONTEXT + "execPointSelect",
				values : [],
				defaultSelectid : "",
				mode: "multiple",
				change: function(){
					var ids = $("#"+$scope.execPointSelect.id).widget().getSelectedId();
					var type = $("#"+$scope.timeTypeSelect.id).widget().getSelectedId();
					if(type == "2"){
						$scope.showAbortTaskTime = ids.length == 1 && isStorageReplication;
					}
				}
			}

			$scope.singleExecPointSelect = {
				id : CONTEXT + "singleExecPointSelect",
				values : [],
				defaultSelectid : "",
				mode: "single",
			};

			//00:00 -> 23:00
			for(var i=0;i<=23;i++){
				var temp = (i < 10 ? ("0" + i) : i) + ":00";
				$scope.execPointSelect.values.push({label:temp,selectId:i});
				$scope.singleExecPointSelect.values.push({label:temp,selectId:i});
			}

			//分钟
			$scope.pointStartMinSpinner = {
            	id:"pointStartMinSpinner",
            	width:120,
            	min:"0",
            	value:"0",
            	max:"59",
            	disabled:false,
            	validate:"required",
            	change: function(){
            		if ($("#pointStartMinSpinner").widget().option("value") === "") {
            		    $("#pointStartMinSpinner").widget().option("value", 0);
            		};
            	}
            };

			/*-------------------------------------*/

			$scope.timeIntervalUnitText = (isSanHyperVault && _3dc == 1) || isAddSecondSchedule ? $scope.secondText : $scope.minuteText;

			$scope.minIntervalTipShow = !((isSanHyperVault && _3dc == 1) || isAddSecondSchedule);

			//执行日期(一月中的某一天执行,对应时间类型为month)
			$scope.showExecDate = false;
			$scope.execDateText = resource.getWithColon("ism.drm.policy.schedule.month.day.info");
			var lastSelectIds = ["1"];

			$scope.execDateSelect = {
				id : CONTEXT + "execDateSelect",
				values : [],
				defaultSelectid : "1",
				mode: "multiple",
				change: function(evt){
					var widget = $("#"+$scope.execDateSelect.id).widget();
					var ids = angular.copy(widget.getSelectedId());
					//当前选择包含最后一天(最后一天和其他天互斥)
					if( ids.indexOf("lastday")!=-1 ){
						//若是选择最后一天,则清除其他选项
						if( lastSelectIds.indexOf("lastday") == -1 ){
							widget.opChecked("lastday");
						}
						//若是选择其他天,则清除最后一天
						else{
							var tmp = _.filter(ids,function(id){
								return id != "lastday";
							});
							widget.opChecked(tmp);
						}
					}
					lastSelectIds = ids;
				}
			};

			//1-31天
			for(var i=1;i<=31;i++){
				$scope.execDateSelect.values.push({
					label : String(i) ,
					selectId : String(i)
				});
			}
			//每月最后一天
			$scope.execDateSelect.values.push({
				label : resource.get("ism.drm.protect.policy.lastDay") ,
				selectId : "lastday"
			});

			/** 执行时间段 **/
			$scope.execPeroidTip = resource.get("com.huawei.ism.drm.policy.schedule.exec.period.day",["00:00","23:45"]);
			$scope.showExecPeriod = !(isSanHyperVault && _3dc == 1) && !isAddSecondSchedule;
			$scope.execPeriodCheckbox = {
				id : CONTEXT + "execPeriodCheckbox",
                text : $scope.periodExclude,
                checked : false,
                change : function(){
                	var ch = $("#"+$scope.execPeriodCheckbox.id).widget().option("checked");
                	$("#"+$scope.execPeriodStartTimeSelect.id).widget().option("disable",!ch);
                	$("#"+$scope.execPeriodEndTimeSelect.id).widget().option("disable",!ch);
                	$scope.showExecPeriodTip = ch;
                }
			};

			$scope.execPeriodStartTimeSelect = {
				id : CONTEXT + "execPeriodStartTimeSelect",
				values : [],
				defaultSelectid : "start_00:00",
				disable : true,
				change: function(){
					execPeroidTipHandler();
				}
			};

			$scope.execPeriodEndTimeSelect = {
				id : CONTEXT + "execPeriodEndTimeSelect",
				values : [],
				defaultSelectid : "end_23:45",
				disable : true,
				change: function(){
					execPeroidTipHandler();
				}
			};

			function execPeroidTipHandler(sTime,eTime){
				var startTime = sTime || $("#"+$scope.execPeriodStartTimeSelect.id).widget().getSelectedLabel();
				var endTime = eTime || $("#"+$scope.execPeriodEndTimeSelect.id).widget().getSelectedLabel();

				var startArr = startTime.split(":");
				var startHour = parseInt(startArr[0],10);
				var startMin = parseInt(startArr[1],10);

				var endArr = endTime.split(":");
				var endHour = parseInt(endArr[0],10);
				var endMin = parseInt(endArr[1],10);

				if(endHour == 0 && endMin == 0){
					$scope.execPeroidTip = resource.get("com.huawei.ism.drm.policy.schedule.exec.period.day",[startTime,endTime]);
				}
				else if( startHour > endHour || (startHour == endHour && startMin > endMin) ){
					$scope.execPeroidTip = resource.get("com.huawei.ism.drm.policy.schedule.exec.period.nextday",[startTime,endTime]);
				}
				else{
					$scope.execPeroidTip = resource.get("com.huawei.ism.drm.policy.schedule.exec.period.day",[startTime,endTime]);
				}
			}

			//00:00 -> 23:45 间隔15分钟
			for(var i=0;i<=23;i++){
				var sep = 0;
				while( sep != 60 ){
					var label = (i<10?"0"+i:i) + ":" + (sep==0?"00":sep) + "";
					$scope.execPeriodStartTimeSelect.values.push({label:label,selectId:"start_"+label});
					$scope.execPeriodEndTimeSelect.values.push({label:label,selectId:"end_"+label});
					sep += 15;
				}
			};

			//选择每周的某天执行(对应时间类型中的周)
			$scope.showWeekday = false;

			var weeks = [
				resource.get("ism.drm.protectpolicy.schedule.week2"),
				resource.get("ism.drm.protectpolicy.schedule.week3"),
				resource.get("ism.drm.protectpolicy.schedule.week4"),
				resource.get("ism.drm.protectpolicy.schedule.week5"),
				resource.get("ism.drm.protectpolicy.schedule.week6"),
				resource.get("ism.drm.protectpolicy.schedule.week7"),
				resource.get("ism.drm.protectpolicy.schedule.week1")
				]

			$scope.weekdaySelect = {
				id: "weekdaySelect",
				values: [],
				defaultSelectid: "2",
				mode: "multiple"
			};

			angular.forEach(weeks,function(val,index){
				var selectId = index == 6 ? "1" : String(index + 2);
				$scope.weekdaySelect.values.push({
					selectId: selectId,
					label: val
				});
			});

			//按天执行时,强制终止
			$scope.abortTaskTip =  resource.get("protection_object_task_setTimePolicy_para_forceStop_tip");
			$scope.abortTaskCheckbox = {
				id: "abortTaskCheckbox",
				checked: false,
				change: function(){
					var checked = $("#"+$scope.abortTaskCheckbox.id).widget().option("checked");
					$("#"+$scope.abortTaskSelect.id).widget().option("disable",!checked);
				},
				text: resource.get("protection_object_task_setTimePolicy_para_forceStop_label2")
			}

			$scope.abortTaskSelect = {
				id: "abortTaskSelect",
				defaultSelectid:"end_00:00",
				values: $scope.execPeriodEndTimeSelect.values,
				disable: true
			}

			var _checkRpoTime = function() {
				if($("#hour").widget().option("value") == 0 && $("#day").widget().option("value") == 0) {
					$scope.rpoModel.rpo.minute.min = 5;
					$("#minute .tiny-spinner-container").removeClass("valid_error_input");
   					if($("#minute").widget().option("value") <= 5) {
   						disableDownBtn();
   					}
				} else {
					$scope.rpoModel.rpo.minute.min = 0;
					enableDownBtn();
				}

				$scope.$apply();
			};

			var setRpoTimes = 0;
			UnifyValid.checkMinute = function(){
                var val = $("#minute").widget().option("value");
                if ($.trim(val) == "") {
                    return appUtils.getString("common_term_empty_label");
                };
                if($("#hour").widget().option("value") == 0 && $("#day").widget().option("value") == 0){
          	     	//规避minute值在改变时会等于14的情况
                	if(setRpoTimes < 1) {
                		(val == 4) && (val = 5);
                		setRpoTimes++;
                	};
                	if(val < 5) {
                		disableDownBtn();
                		return appUtils.getString("policy.schedule.minute.min.msg");
                	} else if(val == 5) {
                		disableDownBtn();
                		return "";
                	} else {
                		enableDownBtn();
                		return "";
                	}
                };
                return "";
            };

            $scope.$on('$destroy', function() {
                delete UnifyValid.checkMinute;
            });

			//配置RPO
			$scope.autoExecRPOHelpTip = appUtils.getString("protection_term_rpo_check_help_tips");
			$scope.rpoModel = {
				title: appUtils.getString("common_term_RPOPolicy_tab"),
			    check: {
			        id: "enable_rpo_checking",
			        text: appUtils.getString("protection_term_rpo_check_label"),
			        checked: false,
			        change: function() {
			            _.each($scope.rpoModel.rpo, function(model) {
			                if (_.isObject(model)) {
			                	model.disable = !model.disable;
			                	$scope.rpoModel.check.check = !model.disable;
			                }
			            });
			        }
			    },
			    rpo: {
			        required: false,
			        label: appUtils.getStringWithColon("protection_term_rpo_policy_label"),
			        day: {
			            id: "day",
			            value: 0,
			            max: 31,
			            width: 80,
			            min: 0,
			            step: 1,
			            disable: true,
			            unit: appUtils.getString("ism.drm.protectpolicy.schedule.type.day"),
			            validate: "required",
			            change: function() {
			            	if ($("#day").widget().option("value") === "") {
			            	    $("#day").widget().option("value", 0);
			            	};
			            	_checkRpoTime();
			            }
			        },
			        hour: {
			            id: "hour",
			            value: 0,
			            max: 23,
			            min: 0,
			            step: 1,
			            width: 80,
			            disable: true,
			            validate: "required",
			            unit: appUtils.getString("ism.drm.protectpolicy.schedule.type.hour"),
			            change: function() {
			            	if ($("#hour").widget().option("value") === "") {
			            	    $("#hour").widget().option("value", 0);
			            	};
			            	_checkRpoTime();
			            }
			        },
			        minute: {
			            id: "minute",
			            value: 15,
			            max: 59,
			            step: 1,
			            min: 0,
			            width: 80,
			            disable: true,
			            extendFunction:["checkMinute"],
			            validate:"checkMinute:extend function;",
			            unit: appUtils.getString("ism.drm.protectpolicy.schedule.type.minute"),
			            change: function() {
			            	if ($("#minute").widget().option("value") === "") {
			            	    $("#minute").widget().option("value", 5);
			            	};
			            	_checkRpoTime();
			            }
			        },
			        tip: appUtils.getString("protection_policy_rpoLimit_tip")
			    },
			    getValue: function() {
			        var result = {};
			        _.each($scope.rpoModel.rpo, function(model) {
			            _.isObject(model) && (result[model.id] = parseInt($("#" + model.id).widget().option("value"), 10));
			        });
			        return {
			        	"ENABLE_RPO_CHECKING": true,
			        	"RPO_SETTING_VALUE": result
			        };
			    },
			    setValue: function() {
			    	var rpoProps = undefined;
			    	try {
			    		rpoProps = vm.data.schedule.expectedRPO;
			    		vm.data.schedule['enableRpoCheck'] && ($scope.rpoModel.rpo.day.value = rpoProps.day);
			    		vm.data.schedule['enableRpoCheck'] && ($scope.rpoModel.rpo.hour.value = rpoProps.hour);
			    		vm.data.schedule['enableRpoCheck'] && ($scope.rpoModel.rpo.minute.value = rpoProps.minute);
			    		$scope.rpoModel.rpo.day.disable = !vm.data.schedule['enableRpoCheck'];
			    		$scope.rpoModel.rpo.hour.disable = !vm.data.schedule['enableRpoCheck'];
			    		$scope.rpoModel.rpo.minute.disable = !vm.data.schedule['enableRpoCheck'];
			    		$scope.rpoModel.check.checked =  vm.data.schedule['enableRpoCheck'];
			    		$scope.$apply();
			    	} catch(e) {}

			    }
			}

	/*----------------------初始化---------------------------------*/


			//监听数据采集事件
			$scope.$on(vm.event,function(){
				//针对快照、一体化备份、双活+快照
				var isEnable = !_.isEmpty($("#startBack").widget()) ? $("#startBack").widget().option("checked") : true;
				 _.contains([2,19,30,31,32], parseInt(ptType, 10)) && (schedule.enable = isEnable);
				if (!isEnable) {
					vm.valid = true;
					return;
				};

				if ($scope.protectedType == 101 && isEnable) {
					var id = $("#storageRespo").widget().getSelectedId();
					if (id == "-1") {
						message.error(appUtils.getString("validate_select_value_label", "pg_create_backuprespo_label"));
						vm.valid = false;
						return;
					};
					if(_.isUndefined(schedule.extParameters)){
						schedule.extParameters = {};
					};
					_.extend(schedule.extParameters, {
						dataLayout: $("#dataLayout").widget().option("checked") ? 2 : 0,  //数据布局
						repositoryName: $("#storageRespo").widget().getSelectedId() //备份库名称
					});
					(_.isEmpty(schedule.scheduleId) && $scope.model.offlineTransfer.display) && _.extend(schedule.extParameters, {
						offlineTransferStatus: $("#offlineTransfer").widget().option("checked") ? 1 : 0
					});
				};

				//采集数据
				schedule.scheduleMode = $("#"+$scope.scheduleModeSelect.id).widget().getSelectedId();
				vm.valid = true;

				//手动执行
				if( schedule.scheduleMode == 1 ){
					delete vm.data.props.RPO_SETTINGS;
					//CDM、双活+快照增加protectedType字段
					if((isCDMSupportedHyperCdp || isSupportedHyperCdp) && !_.isEmpty($("#snapShotTypeRadio").widget())){
						vm.data.schedule.protectedType = $("#snapShotTypeRadio").widget().opChecked("checked") == "cdp" ? 100 : 2
					}
					//删除不需要的属性
					!_.isUndefined(vm.data.schedule.periodType) && (delete vm.data.schedule.periodType);
					!_.isUndefined(vm.data.schedule.periodInterval) && (delete vm.data.schedule.periodInterval);
					!_.isUndefined(vm.data.schedule.scheduleRanges) && (delete vm.data.schedule.scheduleRanges);
				}
				//自动执行
				else{
					//设置开始时间
					var tiny_startTime = $("#"+$scope.startTimeDateTime.id).widget().getDateTime();
					var timeSelectType = $("#"+$scope.timeTypeSelect.id).widget().getSelectedId();
					if( !tiny_startTime && timeSelectType != "5"){
						message.error(resource.get("com.huawei.ism.drm.policy.schedule.start.time.blank"));
						vm.valid = false;
						return;
					}

					var startTime = appUtils.convertString2Date(tiny_startTime,true);
					schedule.startTime = tiny_startTime;

					//设置结束时间
					if( $("#"+$scope.endTimeCheckbox.id).widget().option("checked") && timeSelectType != "5"){
						var tiny_endTime = $("#"+$scope.endTimeDateTime.id).widget().getDateTime();
						if( tiny_endTime ){
							var endTime = appUtils.convertString2Date(tiny_endTime,true);
							if( endTime <= startTime || tiny_startTime == tiny_endTime ){
								message.error(resource.get("ism.drm.schedule.starttime.greatthan.endtime"));
								vm.valid = false;
								return;
							}
							schedule.endTime = tiny_endTime;
						}
						else{
							message.error(resource.get("com.huawei.ism.drm.policy.schedule.end.time.blank"));
							vm.valid = false;
							return;
						}
					}
					else{
						delete schedule.endTime;
					}

					//时间表类型
					var timeType = $("#"+$scope.timeTypeSelect.id).widget().getSelectedId();
					schedule.periodType = timeType;

					//分钟
					if(timeType == "0"){
						if( UnifyValid.FormValid($("#"+$scope.minIntervalTextbox.id), {focusInvalid: true}) ){
							schedule.periodInterval = $("#"+$scope.minIntervalTextbox.id).widget().getValue();
							setExecTimeInterval();
						}
						else{
							vm.valid = false;
						}
					}
					//小时
					else if(timeType == "1"){
						if( UnifyValid.FormValid($("#"+$scope.hourIntervalTextbox.id), {focusInvalid: true}) ){
							schedule.periodInterval = $("#"+$scope.hourIntervalTextbox.id).widget().getValue();
							setExecTimeInterval();
						}
						else{
							vm.valid = false;
						}
					}
					//天
					else if(timeType == "2"){
						if( UnifyValid.FormValid($("#"+$scope.dayIntervalTextbox.id), {focusInvalid: true}) ){
							schedule.periodInterval = $("#"+$scope.dayIntervalTextbox.id).widget().getValue();
							delete schedule.scheduleRanges;

							//执行时间点
							//一天:执行时间点为多选
							if( schedule.periodInterval == 1 ){
								var ids = $("#"+$scope.execPointSelect.id).widget().getSelectedId();
								if(!ids || ids.length ==0){
									message.error(resource.get("protection.modifyPolicy.task.info.execPoint.message"));
									vm.valid = false;
									return;
								}

								schedule.hours = ids.join(",");
								schedule.minutes = $("#"+$scope.pointStartMinSpinner.id).widget().option("value");
							}
							//执行时间点为单选
							else{
								if(_.isEmpty($("#"+$scope.singleExecPointSelect.id).widget().getSelectedId())){
									message.error(resource.get("protection.modifyPolicy.task.info.execPoint.message"));
									vm.valid = false;
									return;
								};
								schedule.hours = $("#"+$scope.singleExecPointSelect.id).widget().getSelectedId();
								schedule.minutes = $("#"+$scope.pointStartMinSpinner.id).widget().option("value");
								delete schedule.abortTaskTime;
							}

							//强制终止时间
							if( $scope.showAbortTaskTime && $("#"+$scope.abortTaskCheckbox.id).widget().option("checked") ){
								var abortTaskTime = $("#"+$scope.abortTaskSelect.id).widget().getSelectedLabel();
								//2015-06-18 21:25:16
								var startTime = $("#"+$scope.startTimeDateTime.id).widget().getDateTime().split(" ")[1];
								startTime = startTime.substring(0,startTime.length-3);

								if( abortTaskTime == startTime ){
									message.error( resource.get("protection_object_task_setTimePolicy_para_forceStop_time_validation") );
									vm.valid = false;
								}
								else{
									schedule.abortTaskTime = abortTaskTime;
								}
							}
							else{
								delete schedule.abortTaskTime;
							}


						}
						else{
							vm.valid = false;
						}
					}
					//周
					else if(timeType == "3"){
						delete schedule.abortTaskTime;
						var checkedWeekdays = $("#"+$scope.weekdaySelect.id).widget().getSelectedId();
						if( angular.isArray(checkedWeekdays) &&  checkedWeekdays.length > 0 ){
							schedule.daysOfWeek = checkedWeekdays.join(",");
							delete schedule.scheduleRanges;

							var hours = $("#"+$scope.execPointSelect.id).widget().getSelectedId();
							if(hours.length == 0){
								message.error(resource.get("protection.modifyPolicy.task.info.execPoint.message"));
								vm.valid = false;
								return;
							}

							schedule.hours = hours.join(",");
							schedule.minutes = $("#"+$scope.pointStartMinSpinner.id).widget().option("value");
						}
						else{
							message.error(resource.get("protection.modifyPolicy.task.info.execData.message"));
							vm.valid = false;
						}
					}
					//月
					else if(timeType == "4"){
						delete schedule.abortTaskTime;
						var execData = $("#"+$scope.execDateSelect.id).widget().getSelectedId();
						if(!execData || execData.length ==0){
							message.error(resource.get("protection.modifyPolicy.task.info.execData.message"));
							vm.valid = false;
							return;
						}


						schedule.daysOfMonth = execData.join(",");
						schedule.lastDayOfMonth = schedule.daysOfMonth == "lastday" ? 1 : 0;
						delete schedule.scheduleRanges;

						var hours = $("#"+$scope.execPointSelect.id).widget().getSelectedId();
						if(hours.length == 0){
							message.error(resource.get("protection.modifyPolicy.task.info.execPoint.message"));
							vm.valid = false;
							return;
						}

						schedule.hours = hours.join(",");
						schedule.minutes = $("#"+$scope.pointStartMinSpinner.id).widget().option("value");
					}
					//按秒
					else if(timeType == "5"){
						delete schedule.abortTaskTime;
						var secondWidget = $("#"+$scope.scondTypeSelect.id).widget();
						if(secondWidget){
							schedule.periodInterval = secondWidget.getSelectedId();
						};
						//删除执行时间段
						delete schedule.scheduleRanges;
					}
					//CDM、双活+快照增加protectedType字段
					if((isCDMSupportedHyperCdp || isSupportedHyperCdp) && !_.isEmpty($("#snapShotTypeRadio").widget())){
						schedule.protectedType = $("#snapShotTypeRadio").widget().opChecked("checked") == "cdp" ? 100 : 2
					};

					if (angular.isDefined(vm.protectedType)) {
						schedule.protectedType = vm.protectedType;
					}

					//主机复制
					if( ptType != 11 ) {
						//RPO数据封装,数据从schedule中获取
						var checkRpo = $("#enable_rpo_checking").widget().option("checked");
						schedule.enableRpoCheck = checkRpo;
						checkRpo && (schedule.expectedRPO = $scope.rpoModel.getValue().RPO_SETTING_VALUE);
						//秒级删除预期RPO
						if (timeType == "5") {
						    !_.isUndefined(schedule.enableRpoCheck) && delete schedule.enableRpoCheck;
						    !_.isUndefined(schedule.expectedRPO) && delete schedule.expectedRPO;
						};
					}

				}
			});

			init();

			//监听事件，高密快照之前切换
			$scope.$on("CHANGE_SANPSHOT_TYPE", function(obj, snapType) {
			    if (snapType == "cdp") {
			    	//需要增加秒级
					if (!vm.isSupportSecondPolicy) {
						$scope.timeTypeSelect.values.unshift({
							label: $scope.secondText,
							selectId: "5"
						});
						$scope.isSanHyperVaultSecond = true;
					};
			        $scope.scondTypeSelect.values = [{
			            label: "10",
			            selectId: "10",
			        }, {
			        	label: "20",
			        	selectId: "20",
			        }, {
			        	label: "30",
			        	selectId:"30",
			        }, {
			        	label: "40",
			        	selectId:"40",
			        }, {
			        	label: "50",
			        	selectId:"50",
			        }, {
			            label: "60",
			            selectId: "60",
			        }, {
			            label: "120",
			            selectId: "120",
			        }, {
			            label: "180",
			            selectId: "180",
			        }, {
			            label: "240",
			            selectId: "240",
			        }];
			        if ($scope.isSupportCustomSecondPolicy) {
			        	for(var i = 9;i >= 3; i--){
			        		$scope.scondTypeSelect.values.unshift({
			        			label: $.trim(i),
			        			selectId: $.trim(i)
			        		})
			        	};
			        };
			        $scope.scondTypeSelect.defaultSelectid = "10";
			    } else {
			    	if (!vm.isSupportSecondPolicy) {
			    		//去掉秒级
			    		$scope.timeTypeSelect.values = _.filter(angular.copy($scope.timeTypeSelect.values), function(value){
			    			return value.selectId != "5";
			    		});
			    		$scope.isSanHyperVaultSecond = false;
			    		//默认选择分钟级
			    		$scope.timeTypeSelect.defaultSelectid = "0";
			    		switchToSettingPanel("0");
					} else {
					    $scope.scondTypeSelect.values = [{
					        label: "30",
					        selectId: "30",
					    }, {
					        label: "60",
					        selectId: "60",
					    }, {
					        label: "120",
					        selectId: "120",
					    }, {
					        label: "180",
					        selectId: "180",
					    }, {
					        label: "240",
					        selectId: "240",
					    }];
					    $scope.scondTypeSelect.defaultSelectid = "30";
					}
			    };
			    $scope.$apply();
			});

	/*--------------------------------------------------------------*/

			function init(){
				var scheduleMode = schedule.scheduleMode;
				//hyperCdp增加秒级
				if (!vm.isSupportSecondPolicy && schedule.protectedType == 100) {
				    $scope.timeTypeSelect.values.unshift({
				        label: $scope.secondText,
				        selectId: "5"
				    });
				    $scope.isSanHyperVaultSecond = true;
				};
				_setDate();

				setTimeout(function(){
					_checkRpoTime();
				},0);
				//自动执行(默认自动执行)
				if( angular.isUndefined(scheduleMode) || scheduleMode == 0 ) {
					$scope.scheduleModeSelect.defaultSelectid = "0";
					$scope.showAutoExecSetting = true;
					$scope.showAutoExecRPO = ptType != 11 && !(isSanHyperVault && _3dc == 1) && !isAddSecondSchedule;
					initAutoExecSetting();
					$scope.showAutoExecRPO && $scope.rpoModel.setValue();
					//CDM快速备份和云备份备端没有周期调度
					if(_.contains([30,31,32], parseInt(ptType, 10)) && schedule.protectLocation == 1 && schedule.protectedType != 1){
						$scope.scheduleModeSelect.defaultSelectid = "1";
						$scope.showAutoExecSetting = false;
						$scope.showAutoExecRPO = false;
					};
				}
				//手动执行
				else if( scheduleMode == 1 ){
					$scope.scheduleModeSelect.defaultSelectid = "1";
					$scope.showAutoExecSetting = false;
					$scope.showAutoExecRPO = false;
				}
				//错误参数
				else{
				}
				//CDM、双活+快照
				(isCDMSupportedHyperCdp || isSupportedHyperCdp) && initSnapType();

			}

			//初始化自动设置
			function initAutoExecSetting(){
				if( angular.isUndefined(schedule.scheduleMode) ) return;

				var periodType     = parseInt(schedule.periodType,10);
				var periodInterval = schedule.periodInterval;
				$scope.defaultTimeTypeValue = periodType;
				//时间策略类型
				switch (periodType) {
					//分
					case 0:
						$scope.minIntervalTextbox.value = periodInterval;
						initExecTimeInterval();
						break;
					//小时
					case 1:
						$scope.hourIntervalTextbox.value = periodInterval;
						initExecTimeInterval();
						break;
					//间隔天
					case 2:
						$scope.dayIntervalTextbox.value = periodInterval;
						$scope.showSingleExecPointSelect = periodInterval > 1;
						$scope.showMultiExecPointSelect  = periodInterval == 1;

						var selectOneHour = false;
						if( $scope.showMultiExecPointSelect ){
							$scope.execPointSelect.defaultSelectid = schedule.hours;
							$scope.pointStartMinSpinner.value = $.trim(parseInt(schedule.minutes));
							selectOneHour = schedule.hours.indexOf(",")==-1;
						}

						if( $scope.showSingleExecPointSelect ){
							$scope.singleExecPointSelect.defaultSelectid = schedule.hours;
							$scope.pointStartMinSpinner.value = schedule.minutes;
							selectOneHour = true;
						}

						$scope.showAbortTaskTime = false;
						var abortTaskTime = schedule.abortTaskTime;
						if(selectOneHour && isStorageReplication){
							if( abortTaskTime ){
								$scope.abortTaskCheckbox.checked = true;
								$scope.abortTaskSelect.disable = false;
								$scope.abortTaskSelect.defaultSelectid = "end_"+abortTaskTime;
							}
							else{
								$scope.abortTaskCheckbox.checked = false;
								$scope.abortTaskSelect.disable = true;
								$scope.abortTaskSelect.defaultSelectid = "end_00:00";
							}

							$scope.showAbortTaskTime = true;
						}

						break;
					//每周天
					case 3:
						$scope.weekdaySelect.defaultSelectid = schedule.daysOfWeek;
						$scope.execPointSelect.defaultSelectid = schedule.hours;
						$scope.pointStartMinSpinner.value = schedule.minutes;
						break;
					//每月天
					case 4:
						$scope.execDateSelect.defaultSelectid = schedule.lastDayOfMonth == 1 ? "lastday" : schedule.daysOfMonth;
						lastSelectIds = $scope.execDateSelect.defaultSelectid.split(",");
						$scope.execPointSelect.defaultSelectid = schedule.hours;
						$scope.pointStartMinSpinner.value = schedule.minutes;
						break;
					//秒
					case 5:
						$scope.scondTypeSelect.defaultSelectid = $.trim(periodInterval);
						break;
				}

				//切换到对应面板
				switchToSettingPanel(periodType);
			}

			//根据时间类型切换到对应界面
			function switchToSettingPanel(type){
				$scope.minIntervalTextbox.show  = type == "0";
				$scope.hourIntervalTextbox.show = type == "1";
				$scope.dayIntervalTextbox.show  = type == "2";
				$scope.isSanHyperVaultSecondType = type == "5";
				$scope.showSecondPeriod = type == "5";
				$scope.minIntervalTipShow = type == "0";
				(isSanHyperVault || isAddSecondSchedule) && ($scope.showAutoExecRPO = type != "5");
				if (!vm.isSupportSecondPolicy && _.contains([2,19,30,31,32], parseInt(ptType, 10))) {
				    $scope.showAutoExecRPO = type != "5";
				    if (_.contains([30, 31, 32], parseInt(ptType, 10)) && schedule.protectLocation == 1 && schedule.protectedType != 1) {
					    $scope.showAutoExecRPO = false;
					};
				};
				$scope.timeTypeSelect.defaultSelectid = String(type);
				$scope.timeIntervalUnitText = {"0":$scope.minuteText,"1":$scope.hourText,"2":$scope.dayText,"5":$scope.secondText}[type];
				$scope.showTimeInterval = (type == "0" || type == "1" || type == "2");
				$scope.showExecDate = (type == "4");
				$scope.timeIntervalAdj = type == "4" ? resource.get("common_term_monthly_listbox") : resource.get("ism.drm.protectpolicy.schedule.every");
				$scope.showExecPeriod = (type == "0" || type == "1");
				$scope.showWeekday = (type == "3");
				$scope.showTimePoint = (type == "2" || type == "3" || type == "4");
				if( type == "3" || type == "4" ){
					$scope.showMultiExecPointSelect = true;
					$scope.showSingleExecPointSelect = false;
				}

				if( type == "4" ){
					setTimeout(function(){
						var dataInput = $("#execDateSelect input");
						if(dataInput.length!=0){
							$("#execDateSelect input").width($scope.widthAdaptor.dateSelect);
						}
					});
				}

				if( type == "2" ){
					var widget = $("#"+$scope.dayIntervalTextbox.id).widget();
					if(!widget) return;

					var selectOneHour = false;
					var val = widget.getValue();
					if( val == 1 ){
						$scope.showMultiExecPointSelect = true;
						$scope.showSingleExecPointSelect = false;
						var pointSelectWidget = $("#"+$scope.execPointSelect.id).widget();
						if(!pointSelectWidget) return;
						selectOneHour = pointSelectWidget.getSelectedId().length == 1;
					}else{
						$scope.showMultiExecPointSelect = false;
						$scope.showSingleExecPointSelect = true;
						selectOneHour = true;
					}

					$scope.showAbortTaskTime = selectOneHour && isStorageReplication;
				}
				else{
					$scope.showAbortTaskTime = false;
				}
			}

			//初始化时间间隔
			function initExecTimeInterval(){
				var ranges = schedule.scheduleRanges;
				var startTime,endTime;
				if( angular.isArray(ranges) && ranges.length != 0 ){
					$scope.execPeriodCheckbox.checked = true;
					$scope.showExecPeriodTip = true;
					if(ranges.length == 1){
						startTime = ranges[0].startTime,
						endTime = ranges[0].endTime;
					}
					else if(ranges.length == 2){
						if( angular.isDate(ranges[0].startTime) ){
							startTime = ranges[0].startTime;
							endTime = ranges[1].endTime;
						}
						else{
							if( ranges[0].startTime.indexOf("00:00:") == -1 ){
								startTime = ranges[0].startTime;
								endTime = ranges[1].endTime;
							}
							else{
								startTime = ranges[1].startTime;
								endTime = ranges[0].endTime;
							}
						}
					}

					if( angular.isDate(startTime) ){
						startTime = appUtils.convertDate2String(startTime.getTime());
					}
					if( angular.isDate(endTime) ){
						endTime = appUtils.convertDate2String(endTime.getTime());
					}

					startTime = startTime.match(/\d{2}:\d{2}/)[0];
					endTime   = endTime.match(/\d{2}:\d{2}/)[0];

					//跨天设置
					if(endTime == "23:59"){
						endTime = "00:00";
					}

					$scope.execPeriodStartTimeSelect.defaultSelectid = "start_" + startTime;
					$scope.execPeriodStartTimeSelect.disable = false;

					$scope.execPeriodEndTimeSelect.defaultSelectid = "end_"   + endTime;
					$scope.execPeriodEndTimeSelect.disable = false;

					execPeroidTipHandler(startTime,endTime);
				}
			}

			function formatTimeUnit(unit){
				if(unit < 10){
					return "0" + unit;
				}
				return unit;
			}

			//设置开始时间和结束时间
			function _setDate(){
				Rest.getSystemTime([],function(systemtime){
					$scope.systemtime = systemtime;
					var systemDate = appUtils.convertString2Date(systemtime.time);
					var minDate = new Date(300000 + systemDate.getTime());

					var minDateStr = minDate.getFullYear()+"-"+
									formatTimeUnit( (minDate.getMonth() + 1) ) +"-"+
									formatTimeUnit( minDate.getDate() ) + " " +
									formatTimeUnit( minDate.getHours() ) + ":" +
									formatTimeUnit( minDate.getMinutes() ) + ":" +
									formatTimeUnit( minDate.getSeconds() );
					var minDataArr = minDateStr.split(" ");

					$scope.startTimeDateTime.minDate = minDateStr;
					$scope.endTimeDateTime.minDate = minDateStr;
					$scope.startTimeDateTime.defaultDate = minDateStr;
					$scope.endTimeDateTime.defaultDate = minDateStr;

					$scope.startTimeDateTime.defaultTime = minDataArr[1];
					$scope.endTimeDateTime.defaultTime = minDataArr[1];

					var scheduleMode = schedule.scheduleMode;
					if( angular.isUndefined(scheduleMode) || scheduleMode == 0 ){
						var startTime = schedule.startTime;
						var endTime   = schedule.endTime;

						if( angular.isNumber(startTime) ){
							startTime = appUtils.convertDate2String(startTime-window.timezoneOffset);
						}
						if( angular.isNumber(endTime) ){
							endTime = appUtils.convertDate2String(endTime-window.timezoneOffset);
						}

						//开始时间
						if( angular.isString(startTime) ){
							startTime = startTime.replace(/.UTC.*/,"").split(" ");
							$scope.startTimeDateTime.defaultDate = startTime[0];
							$scope.startTimeDateTime.defaultTime = startTime[1];
						}

						//结束时间
						if( angular.isString(endTime) && endTime != "--" ){
							$scope.endTimeCheckbox.checked = true;
							$scope.endTimeDateTime.disable = false;
							endTime = endTime.replace(/.UTC.*/,"").split(" ");
							$scope.endTimeDateTime.defaultDate = endTime[0];
							$scope.endTimeDateTime.defaultTime = endTime[1];
						}
					}

					$scope.$apply();
				});
			}

			//执行时间段设置
			function setExecTimeInterval(){
				if( $("#"+$scope.execPeriodCheckbox.id).widget().option("checked") ){
					var startTime = $("#"+$scope.execPeriodStartTimeSelect.id).widget().getSelectedId().replace("start_","");
					var endTime   = $("#"+$scope.execPeriodEndTimeSelect.id).widget().getSelectedId().replace("end_","");
					var startArr  = startTime.split(":")     , endArr = endTime.split(":"),
						startHour = parseInt(startArr[0],10) , startMin = parseInt(startArr[1],10),
						endHour   = parseInt(endArr[0],10)   , endMin = parseInt(endArr[1],10);

					if( startHour == endHour && startMin == endMin ){
						message.error(resource.get("ism.drm.protectpolicy.schedule.period.exclude.endtime.err"));
						vm.valid = false;
					}

					//23:00->00:00,需要传23:00->23:59:59
					if(endHour == 0 && endMin == 0){
						var startDate = new Date();
						startDate.setHours(startHour);
						startDate.setMinutes(startMin);

						var endDate = new Date();
						endDate.setHours(23);
						endDate.setMinutes(59);
						endDate.setSeconds(59);

						schedule.scheduleRanges = [{
							startTime : startDate,
							endTime : endDate
						}];
					}
					//跨天,如23:00->2:00
					else if( startHour > endHour || (startHour == endHour && startMin > endMin) ){
						var startDate1 = new Date();
						startDate1.setHours(startHour);
						startDate1.setMinutes(startMin);

						var endDate1 = new Date();
						endDate1.setHours(23);
						endDate1.setMinutes(59);
						endDate1.setSeconds(59);

						schedule.scheduleRanges = [];

						schedule.scheduleRanges.push({
							startTime : startDate1,
							endTime : endDate1
						});

						var startDate2 = new Date();
						startDate2.setHours(0);
						startDate2.setMinutes(0);

						var endDate2 = new Date();
						endDate2.setHours(endHour);
						endDate2.setMinutes(endMin);

						schedule.scheduleRanges.push({
							startTime : startDate2,
							endTime : endDate2
						});
					}
					else{
						var startDate = new Date();
						startDate.setHours(startHour);
						startDate.setMinutes(startMin);

						var endDate = new Date();
						endDate.setHours(endHour);
						endDate.setMinutes(endMin);

						schedule.scheduleRanges = [{
							startTime : startDate,
							endTime : endDate
						}];
					}
				}
				else{
					delete schedule.scheduleRanges;
				}
			}


			//云备份策略设置
			$scope.protectedType = vm.data.schedule.protectedType;
			$scope.model = {
				labels: {
					storageRespo: appUtils.getStringWithColon("pg_create_backuprespo_label"),
					createStorageRespo: appUtils.getString("site_backuprespo_create_label"),
					dataLayout: appUtils.getStringWithColon("pg_create_datalayout_label"),
					retry: appUtils.getStringWithColon("pg_create_retry_label"),
					retryCount: appUtils.getStringWithColon("pg_create_retrycount_label"),
					retryWindow: appUtils.getStringWithColon("pg_create_retrywindow_label"),
					retryCountUnit: appUtils.getString("securtiy_term_times_field_label"),
					retryWindowUnit: appUtils.getString("common_term_hour_label"),
					offlineTransfer: appUtils.getStringWithColon("pg_create_enableofflinetransfer_label")
				},
				storageRespo: {
					id: "storageRespo",
					disabled: false,
					values: [{
					        selectId: !_.isEmpty(schedule.extParameters) ? schedule.extParameters.repositoryName : "-1",
					        label: !_.isEmpty(schedule.extParameters) ? schedule.extParameters.repositoryName : appUtils.getString("common_term_pleaseSelect_listbox")
					}],
					defaultId: !_.isEmpty(schedule.extParameters) ? schedule.extParameters.repositoryName : "-1",
					disabled: !_.isEmpty(schedule.scheduleId),
					width: Consts.W4 - 50,
					tempData: [],
					change: function() {},
					openFn: function(object) {
						var that = this;
						//查询备份存储库
						var params = {
							"backup_engine_id": schedule.sourceSn,
							"storageType": 100
						};
						Rest.queryStorageRespos(params, {
							success: function(result){
								if(!_.isEmpty(result)){
									appUtils.updateSelectValues("storageRespo",result.records,"name","name",appUtils.getString("common_term_pleaseSelect_listbox"));
									that.tempData = angular.copy(result.records);
									object.open();
								}else{
									object.open();
								}
							}
						})
					},
					closeFn: function() {
						var selectId = $("#" + this.id).widget().getSelectedId();
						var temp = _.filter(this.tempData, function(value) {
						    return value.name == selectId;
						})[0];
						if (!_.isEmpty(temp) && !_.isEmpty(temp.storagePoolId)) {
						    var params = {
						        "backup_engine_id": schedule.sourceSn,
						        "poolId": temp.storagePoolId
						    };
						    Rest.queryStoragePool(params, {
						        success: function(result) {
						            //所用储存池是否启用了离线存储单元
						            $scope.model.offlineTransfer.display = !_.isEmpty(result) && result.useOfflineStorage;
						            $scope.model.offlineTransfer.display && ($scope.model.offlineTransfer.checked = true);
						            $scope.$apply();
						        },
						        fail: function(err) {
						            $scope.model.offlineTransfer.display = false;
						            $scope.$apply();
						        }
						    });
						};
					},
					click: function() {
						var win = angular.copy(Consts.BACKUPSTORAGERESPO_ADD_EDIT_WIN);
						appUtils.isEn() ? (win.width = 650) : "";
						win.data = {
						    "backup_engine_id": schedule.sourceSn,
						    "is_backupRespoAdd": true
						};
						win.title = appUtils.getString(win.title);
						appUtils.showWindow(win, function() {
							var options = this.options;
							if (!UnifyValid.FormValid($("#" + options.verifyId), { focusInvalid: true })) {
							    return;
							};
							var params = {};
							var storagePoolId = $("#storagePool").widget().getSelectedId();
							if (_.isEqual("-1", storagePoolId)) {
							    message.error(appUtils.getString(
							        "validate_select_value_label", appUtils.getString("site_backuppool_tab_label")));
							    return;
							}
							var capacityVal = $("#capacity").widget().option("value"),
							capacityUnit = $("#capacityUnit").widget().getSelectedId();
							params.storagePoolId = storagePoolId;
							params.storagePoolName = $("#storagePool").widget().getSelectedLabel();
							params.name = $("#backupStorageRespoName").widget().getValue();
							params.description = $("#backupStorageRespoDescription").widget().getValue();
							params.useFullQuota = $("#useFullQuota").widget().option("checked");
							params.capacity = appUtils.capacityToKB(capacityVal,capacityUnit);
							params.alarmThreshold = +($("#respoAlarmThreshold").widget().option("value"));
							Rest.createStorageRespo(schedule.sourceSn, {
							    data: params,
							    success: function(result) {
							        message.success({
							            content: appUtils.getString("common_term_operation_success_label"),
							            ok: function() {
							                $("#" + options.winId).widget().destroy();
							            }
							        })
							    }
							});
						})
					}
				},
				offlineTransfer: {
					id: "offlineTransfer",
					text: appUtils.getString("common_term_enable_label"),
					display: !_.isEmpty(schedule.extParameters) ? !_.isUndefined(schedule.extParameters.offlineTransferStatus) : false,
					checked: !_.isEmpty(schedule.extParameters) ? schedule.extParameters.offlineTransferStatus == 1 : true,
					disabled: !_.isEmpty(schedule.scheduleId)
				},
				dataLayout: {
					id: "dataLayout",
					width: Consts.W4,
					text: appUtils.getString("pg_create_datalayoutcompress_label"),
					value: "",
					disabled: !_.isEmpty(schedule.scheduleId),
					checked: !_.isEmpty(schedule.extParameters) ? schedule.extParameters.dataLayout == 2 : false,
					change: function() {
					    var isChecked = $("#" + this.id).widget().option("checked");
					}
				},
				retry: {
					id: "retry",
					width: Consts.W4,
					text: appUtils.getString("common_term_enable_label"),
					value: "",
					checked: !_.isEmpty(schedule.extParameters) ? schedule.extParameters.retryEnable === "true" : true,
					change: function() {
					    var isChecked = $("#" + this.id).widget().option("checked");
					    $scope.model.retryCount.display = isChecked;
					    $scope.model.retryWindow.display = isChecked;
					}
				},
				retryCount: {
					id: "retryCount",
                    width: Consts.W4 - 50,
                    value: !_.isEmpty(schedule.extParameters) ? schedule.extParameters.retry : "3",
                    min: "1",
                    max: "10",
                    change: function() {
                        var v = $("#" + this.id).widget().options.value;
                        if (!/^\d+$/.test(v)) {
                            $("#" + this.id).widget().option("value", "3");
                        }
                    },
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 10],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 10)
                    }, {
                        validFn: "integer"
                    }],
                    display: false
				},
				retryWindow: {
					id: "retryWindow",
                    width: Consts.W4 - 50,
                    value: !_.isEmpty(schedule.extParameters) ? schedule.extParameters.retryDuration : "4",
                    min: "1",
                    max: "168",
                    change: function() {
                        var v = $("#" + this.id).widget().options.value;
                        if (!/^\d+$/.test(v)) {
                            $("#" + this.id).widget().option("value", "4");
                        }
                    },
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "rangeValue",
                        params: [1, 168],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 168)
                    }, {
                        validFn: "integer"
                    }],
                    display: false
				}
			}

	}];

    return ctrl;
});
