define([], function() {
    var ctrl = ["$scope", "$sce", "$timeout", "$compile", "appUtils", "constsService", "restService", "model", "infoTransferredService", function($scope, $sce, $timeout, $compile, appUtils, constsService, restService, Model, infoTransferredService) {

        var array = [],
            data = [],
            volumesMap = [];
        $scope.model = {
            table: {
                id: "volumesDiffTable",
                columns: [{
                    "bVisible": false,
                    "mData": "volumeId",
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_product_volume"),
                    "mData": "volumeType",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_type_volume_count"),
                    "mData": "volumeCount",
                    "bSortable": false,
                    "sWidth": "100px"
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_dr_type"),
                    "mData": "drType",
                    "bSortable": false
                }],
                data: [],
                pagination: false,
                callback: function(evtObj) {},
                cellClickActive: function(e, param, isFind) {},
                drawCallback: function(oSetting) {},
                renderRow: function(nRow, aData, iDataIndex) {
                    var select = "<tiny-select id='smodel.id' values='smodel.values' width='smodel.width' select='smodel.select' default-selectid='smodel.defaultId' auto-open='smodel.autoOpen' close-fn='smodel.closeFn' open-fn='smodel.openFn'></tiny-select>";
                    var selectLink = $compile(select);
                    var selectScope = $scope.$new();
                    selectScope.smodel = {
                        id: aData["volumeId"],
                        defaultId: "-1",
                        values: [{
                            "selectId": "-1",
                            "label": appUtils.getString("common_term_pleaseSelect_listbox")
                        }],
                        width: 150,
                        select: function() {},
                        autoOpen: function() {},
                        closeFn: function() {},
                        openFn: function(object) {
                            var openstackId = "-1", regionId = "-1", projectId = "-1";
                            if (_.size($("#productFusionsphere")) == 0) {
                                openstackId = infoTransferredService.get("OpenstackFusionSphereIdModuel", "fusionSphereId");
                            } else {
                                openstackId = $("#productFusionsphere").widget().getSelectedId();
                            }

                            if (_.size($("#productRegion")) == 0) {
                                regionId = infoTransferredService.get("OpenstackRegionIdModuel", "regionId");
                            } else {
                                regionId = $("#productRegion").widget().getSelectedId();
                            }

                            if (_.size($("#productProject")) == 0) {
                                projectId = infoTransferredService.get("OpenstackProjectIdModuel", "projectId");
                            } else {
                                projectId = $("#productProject").widget().getSelectedId();
                            }

                            var params = {
                                openstackId: openstackId,
                                regionId: $("#drRegion").widget().getSelectedId(),
                                projectId: $("#drProject").widget().getSelectedId(),
                                srcRegionId: regionId,
                                srcProjectId: projectId,
                                srcVolumeTypeName: this.id,
                            };
                            var context = this;
                            restService.getOpenStackVolumeType(params, {
                                success: function(result) {
                                    var vals = [];
                                    _.each(result, function(r) {
                                        vals.push({
                                            selectId: r.volumeTypeId,
                                            label: r.volumeTypeName
                                        })
                                    });

                                    vals.push({
                                        selectId: "-1",
                                        label: appUtils.getString("common_term_pleaseSelect_listbox")
                                    });
                                    if(context.id.indexOf(".") != "-1"){
                                        $('#' + context.id.replace(/\./g,'\\.')).widget().option("values", vals);
                                    }else{
                                        $("#" + context.id).widget().option("values", vals);
                                    }
                                    object.open();
                                }
                            })
                        }
                    }
                    var selectNode = selectLink(selectScope);
                    selectScope.$evalAsync();
                    $("td[tdtitle='" + appUtils.getString("rm_term_volumn_column_dr_type") + "']", nRow).html(selectNode);
                }
            }
        }

        function init() {
            _.each($("#" + constsService.OPENSTACK_DR_VOLUMN_SETTING_WIN.winId).widget().option("data"), function(data) {
                volumesMap = volumesMap.concat(data.volumes);
            });

            var index = 0;
            _.each(_.groupBy(volumesMap, "volumeType"), function(v, k) {
                var temp = {};
                temp.volumeId = k;
                temp.volumeType = k;
                temp.volumeCount = v.length;
                array.push(temp);
                index++;
            });

            $scope.model.table.data = array;
            $scope.$apply();
        }

        init();
    }]

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("openstack-dr-volumn-setting-ctrl", ctrl);
    return module;
})
