define([],function(){
	var ctrl = function($scope, appUtils, constsService){
        var resource = appUtils.resource();
        $scope.title = resource.get("protection_lun_task_selPolicy_checkStorageConfigInfo_des_label");

        $scope.table = {
            id : "cloneStorageInfoTable",
            displayLength : constsService.TABLE_COUNT_PER_PAGE,
            enablePagination : false,
            columns : [{
                "sTitle": resource.get("protection_lun_term_lunSpecification_column"),
                "mData": "displayCapacity",
                "bSortable": false
            },{
                "sTitle": resource.get("common_term_itemNO_column"),
                "mData": "count",
                "bSortable": false
            },{
                "sTitle": resource.get("common_term_belongedController_column"),
                "mData": "controllerId",
                "bSortable": false
            }]
        };

        var updateTable = appUtils.newUpdateTable($scope.table,$scope);
        var winData = appUtils.getWinData();
        if(winData.type == "scanMatchDetal"){
            $scope.table.columns = [{
                "sTitle": resource.get("protection_lun_term_lunSpecification_column"),
                "mData": "displayCapacity",
                "bSortable": false
            },{
                "sTitle": resource.get("common_term_belongedController_column"),
                "mData": "controllerId",
                "bSortable": false
            },{
                "sTitle": resource.get("protection_lun_term_useWithinNeedItems_column"),
                "mData": "matchCount",
                "bSortable": false
            },{
                "sTitle": resource.get("protection_lun_term_isSatisfiedResConfig_column"),
                "mData": "result",
                "bSortable": false
            }];

            $scope.table.renderRow = function(nRow, aData, iDataIndex){
                $('td:eq(2)', nRow).text(aData.matchCount[0]+"/"+aData.matchCount[1]);
                $('td:eq(3)', nRow).text(aData.result ? resource.get("common_term_yes_label") : resource.get("common_term_no_label"));
            }

            updateTable(winData.data);
        }
        else{
            updateTable(winData);
        }
    };

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("cloneStorageInfoCtrl",ctrl);

    return module;
})