define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = ["$scope", "$compile", "constsService", "appUtils", "message", function($scope, $compile, constsService, appUtils, message) {
        var isEn = appUtils.isEn();
        var winData = $("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.winId).widget().option("data");
        //props参数
        var winProps = winData["props"] || {};
        //预置的脚本
        var systemScripts = winData["data"];
        //公共的脚本
        var publicScripts = winData["publicData"];
        //用户自定义的脚本参数
        var userDefined = winData.type == "freeze" ? winProps["userFreezeParam"] : winData.type == "thaw" ? winProps["userUnfreezeParam"] : winData.type == "queryFreeze" ? winProps["userQueryParam"] : winData.type == "before" ? winProps["userBeforeParam"] : winProps["userAfterParam"];
        _.isString(userDefined) && (userDefined = JSON.parse(userDefined));
        //预置的脚本参数
        var systemDefined = winData.type == "freeze" ? winProps["freezeParams"] : winData.type == "thaw" ? winProps["unfreezeParam"] : winData.type == "queryFreeze" ? winProps["queryParam"] : winData.type == "before" ? winProps["beforeParam"] : winProps["afterParam"];
        _.isString(systemDefined) && (systemDefined = JSON.parse(systemDefined));
        //公共脚本参数
        var publicDefined = winProps["publicParam"];
        _.isString(publicDefined) && (publicDefined = JSON.parse(publicDefined));
        //用户自定义模板
        var customScriptTemp = {
            "description": {
                "en": "",
                "zh": ""
            },
            "sensitive": "false",
            "optional": "false",
            "isCustom": "true",
            "childId": "customUuid"
        };
        var publicChildScript = [],
            customChildScript = [];
        !_.isEmpty(publicScripts) && _.each(publicScripts, function(value, index) {
            publicChildScript.push(_.extend(value, {
                key: value.name,
                childId: "publicUuid",
                id: value.name
            }));
        });
        !_.isEmpty(systemScripts) && _.each(systemScripts, function(value, index) {
            customChildScript.push(_.extend(value, {
                key: value.name,
                childId: "customUuid",
                isUserAdd: false,
                isCustom: false,
                id: value.name
            }));
        });
        //用户设置公共脚本的值回显
        if (!_.isEmpty(publicDefined)) {
            _.each(publicChildScript, function(item0) {
                _.each(publicDefined, function(item1, key) {
                    if (item0.key == key) {
                        _.extend(item0, {
                            value: item1
                        });
                    };
                    if (item0.sensitive == "true" && _.isUndefined(publicDefined[item0.key])) {
                        _.extend(item0, {
                            value: "aaaaaaaa",
                            changeFlag: false
                        })
                    };
                });
            });
        };
        //用户设置的系统预置的脚本的值回显
        if (!_.isEmpty(systemDefined)) {
            _.each(customChildScript, function(item0) {
                _.each(systemDefined, function(item1, key) {
                    if (item0.key == key) {
                        _.extend(item0, {
                            value: item1
                        });
                    };
                    if (item0.sensitive == "true" && _.isUndefined(systemDefined[item0.key])) {
                        _.extend(item0, {
                            value: "aaaaaaaa",
                            changeFlag: false
                        });
                    };
                });
            });
        };
        //用户自定义的脚本值回显
        if (!_.isEmpty(userDefined)) {
            _.each(userDefined, function(value, key) {
                var temp = _.extend(angular.copy(customScriptTemp), {
                    key: key,
                    value: value,
                    //标识是用户新增加的参数
                    isUserAdd: true,
                    id: key
                });

                var existScript = _.findWhere(customChildScript, {key: key});
                if (!_.isUndefined(existScript)) {
                    _.find(customChildScript, function(script) {
                        if (script.key == key) {
                            _.extend(script, existScript, {value: value});
                        }
                        return script.key == key;
                    });
                }
                else {
                    customChildScript.push(temp)
                }
            })

        };
        var tableData = [];
        //构造折叠表格
        !_.isEmpty(publicChildScript) && tableData.push({
            id: "publicUuid",
            key: appUtils.getString("protection_lun_use_public_script_label"),
            childResources: publicChildScript,
            "detail": {
                content: "",
                contentType: "simple"
            }
        });
        tableData.push({
            id: "customUuid",
            key: appUtils.getString("protection_lun_use_user_script_label"),
            childResources: customChildScript,
            "detail": {
                content: "",
                contentType: "simple"
            }
        });
        var createInput = function(child) {
            var newScope = $scope.$new();
            var valueInput = "<span><tiny-textbox id='scriptValue.id' value='scriptValue.value' width='scriptValue.width' type='scriptValue.type' validate='scriptValue.validate' content-change='scriptValue.contentChange()' focus='scriptValue.focus()'></tiny-textbox></span><span ng-if='scriptValue.show' style='display:inline-block;position:relative;top:4px;left:10px;' class='iconbutton-delete' ng-click='scriptValue.delRow($event)'></span><span style='display: inline-block;position: relative;top:5px;' ng-if='scriptValue.showTip'><tiny-icontip tip='scriptValue.tip'></tiny-icontip></span>"
            newScope.scriptValue = {
                id: child.key + "_val",
                value: child.value || "",
                type: child.sensitive == "true" ? "password" : "input",
                show: child.isCustom == "true",
                width: "160",
                showTip: !_.isEmpty(child["description"]["zh"]),
                validate: !_.isEmpty(child["expr"]) ? [{
                    validFn: child.optional == "false" ? "required" : ""
                }, {
                    validFn: "regularCheck",
                    params: ["/" + child["expr"] + "/"],
                    errorDetail: isEn ? child["validate"]["en"] : child["validate"]["zh"]
                }, {
                    validFn: "maxSize",
                    params: [parseInt(child.length, 10)]
                }] : [{
                    validFn: "required"
                }, {
                    validFn: "maxSize",
                    params: [512],
                    errorDetail: appUtils.getString("validate_term_common_length_range_msg", 1, 512)
                }],
                tip: isEn ? child["description"]["en"] : child["description"]["zh"],
                contentChange: function() {
                    var that = this;
                    _.extend(child, {
                        value: $("#" + that.id).widget().getValue()
                    })
                },
                focus: function() {
                    if(child.changeFlag === false){
                        child.changeFlag = true;
                        this.value = "";
                        $scope.$apply();
                    };
                },
                delRow: function(event) {
                    //先移除里面数据
                    var removeKey = $(event.target).parent("td").attr("id");
                    _.each($("#scrpitParamsTable").widget().getTableData(), function(val) {
                        if (val.id == "customUuid") {
                            appUtils.removeItemFromArray(val.childResources, "id", removeKey);
                        };
                    });
                    //再移除dom
                    $(event.target).parents("tr").remove();
                }
            };
            var valueInputDom = $compile(valueInput)(newScope);
            $("#" + child.id).html(valueInputDom);
            var keyInput = "<span><tiny-textbox id='scriptKey.id' value='scriptKey.value' width='scriptKey.width' type='scriptKey.type' validate='scriptKey.validate' content-change='scriptKey.contentChange()'></tiny-textbox></span>";
            newScope.scriptKey = {
                id: child.key + "_key",
                value: child.isUserAdd ? child.key : "",
                width: "160",
                validate: [{
                    validFn: "required"
                }, {
                    validFn: "maxSize",
                    params: [128],
                    errorDetail: appUtils.getString("validate_term_common_length_range_msg", 1, 128)
                }],
                contentChange: function() {
                    var that = this;
                    _.extend(child, {
                        isUserAdd: !_.isEmpty($("#" + that.id).widget().getValue()),
                        key: $("#" + that.id).widget().getValue() || ($.trim(new Date().getTime()))
                    })
                }
            };
            var keyInputDom = $compile(keyInput)(newScope);
            if (child.isCustom == "true") {
                $("#" + child.id).prev("td").html(keyInputDom)
            };
            $scope.$apply();
        };
        $scope.scrpitParamsTable = {
            id: "scrpitParamsTable",
            columns: [{
                "sTitle": "",
                "mData": "id",
                "bVisible": false
            }, {
                "sTitle": "",
                "mData": "detail",
                "bSearchable": false, // childResources
                "bSortable": false,
                "sWidth": "40px"
            }, {
                "sTitle": "childResources",
                "mData": "childResources",
                "bVisible": false
            }, {
                "sTitle": appUtils.getString("protection_lun_use_script_param_key_label"),
                "mData": "key",
                "bSortable": false,
                "sWidth": "180px"
            }, {
                "sTitle": appUtils.getString("protection_lun_use_script_param_value_label"),
                "mData": "value",
                "bSortable": false
            }],
            data: angular.copy(tableData),
            showDetails: {
                "colIndex": 0,
                "domPendType": "nopend",
                "openClick": function(event, aData) {
                    var tr = $(event.target).parents("tr")[0],
                        trObj = $("#scrpitParamsTable").widget().getTableData(tr);
                    var child = trObj.childResources;
                    var html = "";
                    for (var i = 0; i < child.length; i++) {
                        html += '<tr class="odd clickTrColor" parentId="' + child[i].childId + '">';
                        html += '<td tdname="detail" class="tiny-tdStyle"></td>';
                        html += '<td tdname="key" class="tiny-tdStyle"><span>' + child[i]["key"] + '</span></td>';
                        html += '<td tdname="scriptValue" id="' + child[i]["id"] + '" class="tiny-tdStyle"></td></tr>';
                    };
                    $(event.target).parents("tr").eq(0).after(html);
                    _.each(child, function(value) {
                        createInput(value, trObj);
                    });
                },
                "closeClick": function(event, aData) {
                    var trObj = $(event.target).parents("tr")[0]
                    trObj = $("#scrpitParamsTable").widget().getTableData(trObj);
                    $(event.target).parents("tr").eq(0).nextAll("tr").filter(
                        function() {
                            return $(this).attr("parentId") == $("#scrpitParamsTable").widget().getTableData($(event.target).parents("tr")[0]).id;
                        }).unbind().remove();
                }
            },
            renderRow: function(nRow, aData, iDataIndex) {},
            drawCallback: function() {
                !_.isEmpty($(".default_show_style ")) && $(".default_show_style ").click();
            }
        };
        $scope.paramsAdd = {
            text: appUtils.getString("common_term_add_button"),
            click: function() {
                if (!UnifyValid.FormValid($("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.verifyId), {focusInvalid: true})) {
                    return;
                };
                //最多允许用户自行加入128个参数
                var userAddParams = _.filter($("#scrpitParamsTable").widget().getTableData(), function(val) {
                    return val.id == "customUuid"
                })[0].childResources;
                if(_.size(userAddParams) == 128){
                    message.error(appUtils.getString("protection_lun_script_max_key_validate_label"));
                    return;
                };
                //如果当前步骤参数未展开详情，此时添加后需要让它展开
                if ($($("tr:contains('" + appUtils.getString("protection_lun_use_user_script_label") + "')").children()[0]).children().hasClass("default_show_style")) {
                    var addData = _.extend(angular.copy(customScriptTemp), {
                        "key": $.trim(new Date().getTime()),
                        "id": "td_" + $.trim(new Date().getTime())
                    });
                    _.each($("#scrpitParamsTable").widget().getTableData(), function(val) {
                        val.id == "customUuid" && (val.childResources.push(addData))
                    });
                    $($("tr:contains('" + appUtils.getString("protection_lun_use_user_script_label") + "')").children()[0]).children().click();
                } else {
                    var addData = _.extend(angular.copy(customScriptTemp), {
                        "key": $.trim(new Date().getTime()),
                        "id": "td_" + $.trim(new Date().getTime())
                    });
                    var customeChildData = _.filter($("#scrpitParamsTable").widget().getTableData(), function(val) {
                        return val.id == "customUuid"
                    })[0].childResources;
                    var html = "";
                    html += '<tr class="odd clickTrColor" parentId="' + addData.childId + '">';
                    html += '<td tdname="detail" class="tiny-tdStyle"></td>';
                    html += '<td tdname="key" class="tiny-tdStyle">' + (isEn ? addData.en : addData.zh) + '</td>';
                    html += '<td tdname="scriptValue" id="' + addData["id"] + '" class="tiny-tdStyle"></td></tr>';
                    if (_.isEmpty(customeChildData)) {
                        $("tr:contains('" + appUtils.getString("protection_lun_use_user_script_label") + "')").after(html)
                    } else {
                        var afterTrId = _.last(customeChildData).id;
                        $("#" + afterTrId).parent("tr").after(html);
                    };
                    _.each($("#scrpitParamsTable").widget().getTableData(), function(val) {
                        val.id == "customUuid" && (val.childResources.push(addData))
                    });
                    createInput(addData);
                };
                $scope.$apply();
            }
        };
    }];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("config-public-script-ctrl", ctrl);
    return module;
})
