define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = ["$scope", "$compile", "constsService", "appUtils", "message", function($scope, $compile, constsService, appUtils, message) {
        var isEn = appUtils.isEn();
        var winData = $("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.winId).widget().option("data");
        var scripts = winData["data"];
        var tempData = {
            "key": "",
            "value": ""
        };
        var tableData = [];
        !_.isEmpty(scripts) && _.each(scripts, function(item, key) {
            tableData.push({
                key: key,
                value: item
            })
        });
        $scope.scrpitParamsTable = {
            id: "scrpitParamsTable",
            columns: [{
                "sTitle": appUtils.getString("protection_lun_use_script_param_key_label"),
                "mData": "key",
                "bSortable": false
            }, {
                "sTitle": appUtils.getString("protection_lun_use_script_param_value_label"),
                "mData": "value",
                "bSortable": false
            }],
            data: angular.copy(tableData),
            renderRow: function(nRow, aData, iDataIndex) {
                var valColumn = "<span><tiny-textbox id='scriptValue.id' value='scriptValue.value' width='scriptValue.width' type='scriptValue.type' validate='scriptValue.validate' content-change='scriptValue.contentChange()'></tiny-textbox></span><span style='display:inline-block;position:relative;top:4px;left:3px;' class='iconbutton-delete' ng-click='scriptValue.delRow()'></span>";
                var newScope = $scope.$new();
                newScope.scriptValue = {
                    id: !_.isEmpty(aData["key"]) ? $.trim(aData["key"]) + "_val" : iDataIndex + "_val",
                    value: aData["value"] || "",
                    width: "160px",
                    type: "input",
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [512],
                        errorDetail: appUtils.getString("validate_term_common_length_range_msg", 1, 512)
                    }],
                    contentChange: function(){
                        var that = this;
                        _.extend(aData,{
                            value: $("#" + that.id).widget().getValue()
                        })
                    },
                    delRow: function() {
                        $("#scrpitParamsTable").widget().deleteTableRow(nRow);
                    }
                };
                $("td:eq(1)", nRow).html($compile($(valColumn))(newScope));
                var keyColumn = "<span><tiny-textbox id='scriptKey.id' value='scriptKey.value' width='scriptKey.width' validate='scriptKey.validate' content-change='scriptKey.contentChange()'></tiny-textbox></span>";
                newScope.scriptKey = {
                    id: !_.isEmpty(aData["key"]) ? $.trim(aData["key"]) + "_key" : iDataIndex + "_key",
                    value: aData["key"] || "",
                    width: "160px",
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "maxSize",
                        params: [128],
                        errorDetail: appUtils.getString("validate_term_common_length_range_msg", 1, 128)
                    }],
                    contentChange: function(){
                        var that = this;
                        _.extend(aData,{
                            key: $("#" + that.id).widget().getValue()
                        })
                    }
                };
                $("td:eq(0)", nRow).html($compile($(keyColumn))(newScope));
            }
        };
        $scope.paramsAdd = {
            text: appUtils.getString("common_term_add_button"),
            click: function() {
                if (!UnifyValid.FormValid($("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.verifyId), {focusInvalid: true})) {
                    return;
                };
                if(_.size($("#scrpitParamsTable").widget().getTableData()) == 128){
                    message.error(appUtils.getString("protection_lun_script_max_key_validate_label"));
                    return;
                };
                var addData = angular.copy(tempData);
                $("#scrpitParamsTable").widget().addTableRows(addData);
            }
        };
    }];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("config-script-ctrl", ctrl);
    return module;
})
