define([], function() {
    var ctrl = ["$scope", "$compile", "appUtils", "constsService", "restService",
        function($scope, $compile, appUtils, constsService, restService) {
            var winData = $("#" + constsService.TARGET_STORAGE_POOL_WIN.winId).widget().option("data");
            var drPoolData = [],
                drPoolResourceData = [];
            //重置灾备资源池
            var resetDrPoolVal = function() {
                var tableData = $("#storagePoolTable").widget().getTableData();
                if (_.isEmpty(tableData)) return;
                _.each(tableData, function(item) {
                    if (!_.isEmpty($("#" + item.poolId).widget())) {
                        $("#" + item.poolId).widget().option("values", [{
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox"),
                            checked: true
                        }])
                    }
                })
            };
            $scope.labelCls = {
                drStorageRelation: appUtils.getString("protection_create_set_dr_resource_title"),
                drSite: appUtils.getStringWithColon("site_term_remote_label"),
                drStorage: appUtils.getStringWithColon("protection_create_dr_storage_select_label"),
                drStoragePool: appUtils.getString("protection_create_set_pool_mapping_title")
            };
            $scope.model = {
                site: {
                    id: "drSite",
                    values: [{
                        selectId: "-1",
                        label: appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectid: !_.isEmpty(winData.drSiteId) ? winData.drSiteId : "-1",
                    change: function() {
                        $("#drStorage").widget().option("values", [{
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox"),
                            checked: true
                        }]);
                        resetDrPoolVal();
                    }
                },
                storage: {
                    id: "drStorage",
                    values: [{
                        selectId: "-1",
                        label: appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectid: "-1",
                    openFn: function(){
                        var selectId = $("#drSite").widget().getSelectedId();
                        if(selectId == "-1") {
                            return;
                        };
                        var storagesData = _.filter(drPoolData, function(val) {
                            return val.siteId == selectId
                        })[0];
                        if (_.isEmpty(storagesData)) return;
                        var storageValues = []
                        _.each(storagesData.storages, function(value) {
                            storageValues.push({
                                selectId: value.deviceSn,
                                label: value.deviceName
                            })
                        });
                        storageValues.unshift({
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox"),
                            checked: true
                        });
                        $("#drStorage").widget().option("values", storageValues);
                        $scope.$apply();
                    },
                    change: function() {
                        resetDrPoolVal();
                    }
                },
                poolTable: {
                    id: "storagePoolTable",
                    enablePagination: false,
                    data: [],
                    columns: [{
                        "sTitle": appUtils.getString("protection_create_product_pool_label"),
                        "mData": "poolName",
                        "sWidth":"140px",
                        "bSortable": false
                    }, {
                        "sTitle": "",
                        "mData": "",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("protection_create_dr_pool_label"),
                        "mData": "",
                        "bSortable": false
                    }],
                    renderRow: function(nRow, aData, iDataIndex) {
                        var optColumn = "<tiny-select id='id' default-selectid='defaultId' values='values' width='width' disable='disable' open-fn='openFn' close-fn='closeFn'></tiny-select>";
                        var optScope = $scope.$new();
                        optScope.id = aData.poolId;
                        optScope.values = [{
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        }];
                        optScope.width = "140";
                        optScope.defaultId = "-1";
                        //回显参数
                        if(!_.isEmpty(winData.poolMapping)){
                            var rowPool = _.filter(winData.poolMapping, function(val){
                                return val.poolId == aData.poolId
                            })[0];
                            optScope.values = [{
                                selectId: rowPool.drPoolId,
                                label: rowPool.drPoolName
                            }];
                            optScope.defaultId = rowPool.drPoolId;
                        };
                        optScope.openFn = function(){
                            var siteId = $("#drSite").widget().getSelectedId();
                            var storageId = $("#drStorage").widget().getSelectedId();
                            if(siteId == "-1" || storageId == "-1"){
                                return;
                            };
                            //过滤出存储
                            var storagesData = _.filter(drPoolData, function(val) {
                                return val.siteId == siteId
                            })[0];
                            //过滤出备端的资源池
                            var drPoolResource = _.filter(storagesData.storages, function(item) {
                                return item.deviceSn == storageId
                            })[0];
                            drPoolResourceData = angular.copy(drPoolResource.pools);
                            if (!_.isEmpty($("#" + aData.poolId).widget())) {
                                var drPool = []
                                _.each(drPoolResourceData, function(poolVal) {
                                    drPool.push({
                                        selectId: poolVal.poolId,
                                        label: poolVal.poolName
                                    })
                                });
                                drPool.unshift({
                                    selectId: "-1",
                                    label: appUtils.getString("common_term_pleaseSelect_listbox"),
                                    checked: true
                                });
                                $("#" + aData.poolId).widget().option("values", drPool);
                                $scope.$apply();
                            }
                        };
                        var setDrPool = $compile($(optColumn))(optScope);
                        $("td:eq(2)", nRow).html(setDrPool);
                        var imgHtml = "<div><img src='/theme/recoverydirector/images/resourceMapping/quickStart/arrow.png'></div>";
                        $("td:eq(1)", nRow).html(imgHtml);
                    },
                    drawCallback: function() {
                        $("#storagePoolTable .tiny-th-content").eq(0).children('div').removeClass("tiny-th-vertival-line");
                    }
                }
            };
            //查询待创建保护组中保护对象所用存储资源
            var getStoragePool = function() {
                var poParam = [];
                if (!_.isEmpty(winData.pg) && _.isArray(winData.pg.polist)) {
                    _.each(winData.pg.polist, function(val) {
                        poParam.push({
                            uuid: val.uuid,
                            moUuid: val.moUuid
                        })
                    })
                };
                if (_.isEmpty(poParam)) {
                    return;
                };
                restService.getStorageResources([winData.pg.poType, winData.data.type], {
                    data: poParam,
                    success: function(result) {
                        if (_.isEmpty(result)) {
                            return;
                        };
                        //去掉同一存储池
                        var poolData = appUtils.uniqArrayWithKey(result, "poolId");
                        //查询可配置的灾备存储池
                        var drSites = [];
                        _.each(poolData, function(item){
                            restService.queryTargetStorages([item.devSn], {
                                success: function(response) {
                                    if (_.isEmpty(response)) {
                                        return;
                                    };
                                    drPoolData = drPoolData.concat(response.sites);
                                    //去掉重复的灾备存储池
                                    drPoolData = appUtils.uniqArrayWithKey(drPoolData, "siteId")
                                    _.each(response.sites, function(val) {
                                        //已经存在的站点就不需要添加进去了
                                        var existData = _.filter(drSites, function(drId){
                                            return drId.selectId == val.siteId
                                        });
                                        _.isEmpty(existData) && drSites.push({
                                            selectId: val.siteId,
                                            label: val.siteName
                                        })
                                    });
                                }
                            })
                        });
                        drSites.unshift({
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        });
                        $scope.model.site.values = drSites;
                        //回显之前设置的参数
                        if(!_.isEmpty(winData.drSiteId)){
                            var seclectValue = [];
                            seclectValue.push({
                                selectId: winData.drStorageId,
                                label: winData.drStorageValue
                            })
                            seclectValue.unshift({
                                selectId: "-1",
                                label: appUtils.getString("common_term_pleaseSelect_listbox")
                            });
                            $scope.model.storage.values = seclectValue;
                            $scope.model.storage.defaultSelectid = winData.drStorageId;
                        };
                        $scope.model.poolTable.data = appUtils.encodeForHTML(poolData);
                        $scope.$apply();
                    }
                })
            };
            getStoragePool()
        }
    ];

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController('storage-pool-ctrl', ctrl);
    return module;
})
