define([],
function(){
	var ctrl = ["$scope", "message", "appUtils", "model","constsService",
	     function($scope, message, appUtils, Model, Consts){

			var resource = appUtils.resource();
			$scope.Consts = Consts;

			var winData = appUtils.getWinData();

			var crtLevel = winData.level;

			var levelMap = {
				1: resource.get("protection.copyrate.low.desc"),
				2: resource.get("protection.copyrate.mid.desc"),
				3: resource.get("protection.copyrate.high.desc"),
				4: resource.get("protection.copyrate.extremely.high.desc")
			}
			$scope.level = !_.isEmpty(crtLevel) ? levelMap[crtLevel] : levelMap[2];
			$scope.text = {
                "low" : resource.get("protection.copyrate.low"),
                "mid" : resource.get("protection.copyrate.mid"),
                "high" : resource.get("protection.copyrate.high"),
                "extreHigh" : resource.get("protection.copyrate.extremely.high"),
                "copyrate" : resource.getWithColon("protection.copyrate.label"),
                "exclude" : resource.getWithColon("protection.copyrate.exclude.label"),
                "from" : resource.get("common_term_from_label"),
                "to" : resource.get("common_term_to_label")
            };

			$scope.fromTime = {
				id: "fromTime",
				disable: true,
				value: winData.time
			}

			var hour = parseInt(winData.time.split(":")[0],10);

			$scope.toTime = {
				id: "toTime",
				values: genToTimeValues(hour),
				defaultSelectid: String(hour+1)
			}

			$scope.copyrateSelect = {
				id: "copyrateSelect",
				defaultSelectid: String(crtLevel || 2),
				values: [{
					selectId: "1",
					label: $scope.text.low
				},{
					selectId: "2",
					label: $scope.text.mid
				},{
					selectId: "3",
					label: $scope.text.high
				},{
					selectId: "4",
					label: $scope.text.extreHigh
				}],
				selectFn: function(selectId){
					$scope.level = levelMap[selectId];
					$scope.$apply();
				}
			};

			function genToTimeValues(fromTime){
				var values = [];
				for(var i=fromTime+1;i<=24;i++){
					var label = "--";
					if(i == 24){
						var label = "00:00";
					}
					else{
						label = i>=10 ? i+":00" : ("0"+i)+":00";
					}
					values.push({
						selectId: String(i),
						label: label
					});
				}
				return values;
			}


			$("#"+Consts.COPYRATE_SETTING_WIN.winId).widget().option("buttons",[{
                label : resource.get("common_term_yes_button"),
                handler : function(event) {
                	crtLevel = $("#copyrateSelect").widget().getSelectedId();

                	var data = {
                		level: crtLevel,
                		time: winData.time + "->" + $("#toTime").widget().getSelectedLabel()
                	}
                	appUtils.closeWin(data,Consts.COPYRATE_SETTING_WIN.winId);
                }
			}]);
	}];

	var copyrateSettingModule = angular.module("recoverydirector.protection.config");
	copyrateSettingModule.tinyController("copyrateSettingCtrl", ctrl);
    return copyrateSettingModule;
});
