define([], function() {
    var ctrl = ["$scope", "model", "infoTransferredService", "constsService", "appUtils", "restService",
        function($scope, Model, infoTransferredService, Consts, appUtils, Rest) {
            $scope.vm = $scope.viewModel;
            $scope.view1 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html";
            $scope.ctrl1 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl";
            $scope.notSupportMountPolicy = $scope.vm.pg.poType == 8;
            var schedulesTemp = angular.copy($scope.vm.data.schedules);
            if ($scope.vm.createFlag) {
                var isDAG = infoTransferredService.get("getExchangeHost", "isChekcedDAG");
                $scope.notSupportMountPolicy = $scope.vm.pg.poType == 8 && isDAG && _.contains([4, 5], +$scope.vm.pg.props.dbVersion)
            } else {
                if ($scope.vm.pg.poType == 8) {
                    //暂不支持挂载策略
                    try {
                        Rest.queryProtectObjectsByPage({
                            protectgroupId: $scope.vm.pg.uuid,
                            _PAGE: appUtils.queryFilter(0, 10)
                        }, {
                            mask: false,
                            success: function(result) {
                                var poList = result.records;
                                if (!_.isEmpty(poList) && !_.isEmpty(_.first(poList)) && !_.isEmpty(_.first(poList).props) && _.first(poList).props.IS_CLUSTER == "true" && _.contains([4, 5], +$scope.vm.pg.props.dbVersion)) {
                                    $scope.notSupportMountPolicy = true;
                                } else {
                                    $scope.notSupportMountPolicy = false;
                                }
                            }
                        });
                    } catch (err) {
                        $scope.notSupportMountPolicy = false;
                    }
                };
            };
            $scope.vm1 = Model.ViewModel.create({
                data: $scope.vm.data,
                pg: $scope.vm.pg,
                createFlag: $scope.vm.createFlag,
                valid: false,
                poListIds: $scope.vm.poListIds,
                settingEnable: $scope.vm.settingEnable,
                settingTitle: $scope.vm.pg.productSiteName,
                scheduleData: function(){
                    var schedule = _.filter(schedulesTemp, function(item){
                        return item.protectedType != 101;
                    })[0]
                    return schedule || {protectLocation:0};
                }(),
                ok: $scope.vm.ok
            });
            $scope.title1 = {
                policyTitle: appUtils.getString("pg_create_fastcloudback_label"),
                policyDesc: appUtils.getString("pg_step2_fastcloudback_desc_label"),
                policyIcon: "policy_cloudbackup_icon"
            };
            $scope.title2 = {
                policyTitle: appUtils.getString("protection_step3_mount_title"),
                policyDesc: appUtils.getString("pg_step2_mount_desc_label"),
                policyIcon: "policy_auto_mount_icon"
            };
            $scope.title3 = {
                policyTitle: appUtils.getString("pg_create_cloudback_label"),
                policyDesc: appUtils.getString("pg_step2_cloudback_desc_label"),
                policyIcon: "policy_quick_cloudbackup_icon"
            };
            $scope.view2 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/scheduleMountPolicy.html";
            $scope.ctrl2 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/scheduleMountPolicyCtrl";
            $scope.vm2 = Model.ViewModel.create({
                data: $scope.vm.data,
                pg: $scope.vm.pg,
                createFlag: $scope.vm.createFlag,
                titleText: appUtils.getString("protection_step3_mount_title"),
                ok: $scope.vm.ok,
                settingEnable: $scope.vm.settingEnable,
                settingTitle: appUtils.getString("pg_create_autoMountPolicy_label"),
                settingShow: true,
                valid: false,
                click: function() {
                    var win = angular.copy(Consts.SAN_MOUNT_POLICY_WIN);
                    win.title = appUtils.getString("protection_set_mount_policy_win_title");
                    //vmware一体化备份挂载策略
                    if($scope.vm.pg.poType == 10){
                        win.content = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/vmwareMountPolicyWin.html";
                        win.controller = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/vmwareMountPolicyWinCtrl";
                    };
                    appUtils.isEn() && (win.width = 720);
                    win.data = $scope.vm;
                    win.close = function(evt) {
                        var mountConfigs = infoTransferredService.get("SAN_MOUNT_POLICY", "MOUNT_CONFIGS");
                        if (!_.isEmpty(mountConfigs)) {
                            infoTransferredService.remove("SAN_MOUNT_POLICY", "MOUNT_CONFIGS");
                            $scope.$broadcast("SET_MOUNT_POLICY", mountConfigs);
                        };
                    };
                    appUtils.showWindow(win);
                }
            });

            //云备份
            $scope.view3 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html";
            $scope.ctrl3 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl";
            $scope.vm3 = Model.ViewModel.create({
                data: $scope.vm.data,
                pg: $scope.vm.pg,
                createFlag: $scope.vm.createFlag,
                valid: false,
                poListIds: $scope.vm.poListIds,
                settingEnable: $scope.vm.settingEnable,
                ok: $scope.vm.ok,
                settingTitle: $scope.vm.pg.productSiteName,
                protectedType: 101, //云备份传入保护类型
                scheduleData: function(){
                    var schedule = _.filter(schedulesTemp, function(item){
                        return item.protectedType == 101;
                    })[0]
                    return schedule || {protectLocation:0, protectedType: 101};
                }()
            });

            //支持云备份的应用：lun、数据库、vmware
            $scope.isSupportCloudbackup = _.contains([1,2,3,10,11,16,99], parseInt($scope.vm.pg.poType));

            //创建保护组
            if ($scope.vm.createFlag) {
                $scope.$on($scope.vm.event, function() {
                    //收集数据
                    $scope.vm.valid = $scope.vm1.valid || $scope.vm3.valid;
                    var props = {};
                    if (!$scope.vm2.valid) {
                        _.extend($scope.vm2.data.props, {
                            AUTOMOUNTCONFIGS: JSON.stringify({
                                enabled: false
                            })
                        })
                    } else {
                        var mountProps = {};
                        try {
                            mountProps = JSON.parse($scope.vm2.data.props.AUTOMOUNTCONFIGS);
                        } catch (err) {}
                        _.each(mountProps.mountConfigs, function(val) {
                            delete val.hostName;
                            delete val.siteName
                        });
                        _.extend($scope.vm2.data.props, {
                            AUTOMOUNTCONFIGS: JSON.stringify(mountProps)
                        });
                    }
                    _.extend(props, $scope.vm1.data.props, _.pick($scope.vm2.data.props, "AUTOMOUNTCONFIGS"));
                    $scope.vm.data.schedules = [];
                    !_.isEmpty($scope.vm1.schedule) && $scope.vm1.schedule.enable === true && $scope.vm.data.schedules.push($scope.vm1.schedule);
                    !_.isEmpty($scope.vm3.schedule) && $scope.vm3.schedule.enable === true && $scope.vm.data.schedules.push($scope.vm3.schedule);
                    $scope.vm.data.props = props;
                })
            }
        }
    ]
    return ctrl;
});
