define(["tiny-common/UnifyValid"], function(UnifyValid){

	var ctrl = ["$scope", "appUtils", "constsService","restService", "model","message",
	     function($scope, appUtils, Consts, Rest, Model, message){

			//修改策略(scheduleWin.html)或者创建保护组(pgCreateStep3.js),传入viewModel
			var pVm = $scope.viewModel;
			$scope.pt = pVm.data;

			var resource = appUtils.resource();
			var ViewModel = Model.ViewModel;
			var pgName = pVm.pgName;

			var tabs = new tinyWidget.Tabs({
			        "id": "myTabs",
			        "setActiveClass": true
			});

			$scope.model = {
				tabTexts: [
					resource.get("protection.term.schedulePolicy.label"),
			        resource.get("protection_term_concsistentProtectPolicy_tab")
				],
			}

			var schedule = appUtils.getItemFromArray($scope.pt.schedules,"scheduleMode","0") || $scope.pt.schedules[0];

			//时间表VM
			$scope.baseScheduleVM = ViewModel.create({
				data: {
				    schedule: schedule,
				    props: $scope.pt.props
				},
				ptType: $scope.pt.type,
				event:Consts.SCHEDULE_DATA_COLLECTION_EVENT,
				titleFirst: true
			});

			//应用配置VM
			pVm.poType = 12;
			$scope.appScheduleVM = ViewModel.create({
				poType: pVm.poType,
				data: $scope.pt.props,
				fcRestoreNumSet: pVm.fcRestoreNumSet,
				event: Consts.SCHEDULE_APP_DATA_COLLECTION_EVENT
			});

			$scope.$on(pVm.event , function(){
				pVm.valid = true;

				//初次标签页被激活的地方
				var activeTab = $("#myTabs .tinyTabActive");
				//校验本窗口的全部标签页,并跳转到第一个校验不通过的控件
				pVm.valid = tabs.tabsOption.every(function(obj, index) {
				    var id = obj.tabId;
				    if ($('#tabtitle-' + id + ':hidden').length) return true; // 如果标签被隐藏了就不校验
				    var bool = UnifyValid.FormValid($('#tabs-' + id), {
				        checkHidden: true,
				        focusInvalid: false
				    });
				    if (!bool) {
				        $('#tabtitle-' + id).click();
				        bool = UnifyValid.FormValid($('#tabs-' + id), {
				            checkHidden: false,
				            focusInvalid: true
				        });
				    }
				    return bool;
				});
				//校验通过，重置到初次被点击的标签页
				pVm.valid && activeTab.click();
				if (!pVm.valid) return;

				//时间表数据收集
				$scope.$broadcast($scope.baseScheduleVM.event);
				if(!(pVm.valid = $scope.baseScheduleVM.valid)) return;

				//应用数据收集
				$scope.$broadcast($scope.appScheduleVM.event);
				if(!(pVm.valid = $scope.appScheduleVM.valid)) return;

				$scope.pt.schedules = [$scope.baseScheduleVM.data.schedule];

				//创建保护组
				if (pVm.createFlag) return;

				Rest.modifyHwHostTemplate(pVm.pgId,{
					data: $scope.pt ,
					interceptor: function(next){
						//手动不做任何提示
						if( $scope.baseScheduleVM.data.schedule.scheduleMode == 1 ){
							next();
						}
						else{
							var encodePgName = $.encoder.encodeForHTML(pgName);
							var msg = resource.get("ism.drm.pg.schedule.modify.msg1",encodePgName) + "<br>" +
								resource.get("ism.drm.pg.schedule.modify.msg2",encodePgName) + "<br>" +
								resource.get("ism.drm.pg.schedule.modify.msg3");

							message.warn({
								content: msg,
								ok: function() {
									next();
								}
							});
						}
					},
					success : function(){
						pVm.defer.resolve();
					}
				});
			});

			(function init() {
			    setTimeout(function() {
			        $('#myTabs #tab_head li:eq(0)').click();
			    }, 300);
			})();
	}];

	return ctrl;
});