define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = ["$scope", "appUtils", "restService", "model", "infoTransferredService", "constsService", "message",
        function($scope, appUtils, restService, Model, infoTransferredService, Consts, message) {
            var winData = $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().option("data");
            //oracle、db2、sqlserver、hana需要用户勾选是否启动数据库
            var startDbKey = _.isObject(winData.pg) && _.contains([1,2,3,16], parseInt(winData.pg.poType, 10));
            var defaultValue = {
                disableDel: true,
                startTime: {
                    id: "startTimeDate0",
                    type: "time",
                    timeFormat: "hh:mm",
                    defaultTime: "00:00",
                    width: "80px",
                    disable: true,
                    getVal: function() {
                        return $("#" + this.id).widget().getDateTime();
                    },
                    setVal: function(val) {
                        this.defaultTime = val;
                    }
                },
                endTime: {
                    id: "endTimeData0",
                    type: "time",
                    timeFormat: "hh:mm",
                    defaultTime: "00:00",
                    width: "80px",
                    disable: true,
                    getVal: function() {
                        return $("#" + this.id).widget().getDateTime();
                    },
                    setVal: function(val) {
                        this.defaultTime = val;
                    }
                },
                siteSelect: {
                    id: "siteSelect0",
                    width: "120",
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("protection_mount_site_select_label")
                    }],
                    disable: true,
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        restService.querySites([$scope.serverUuid], function(data) {
                            if (!_.isEmpty(data)) {
                                data = _.filter(data, function(item) {
                                    return !item.isCloudSite
                                });
                                appUtils.updateSelectValues(that.id, data, "siteId", "name", appUtils.getString("protection_mount_site_select_label"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function() {
                        var that = this;
                        var hostWidget = $("#hostSelect" + that.id.slice(10)).widget();
                        if (hostWidget) {
                            hostWidget.option("values", [{
                                "selectId": "-1",
                                "label": appUtils.getString("protection_mount_hosts_select_label")
                            }])
                        };
                        _.each($scope.model.mountValues, function(item) {
                               item.siteSelect.id == that.id && (item.hostSelect.defaultSelectid = "-1");
                            $scope.$apply();
                        });
                    },
                    getVal: function() {
                        return $("#" + this.id).widget().getSelectedId();
                    },
                    getName: function() {
                        return $("#" + this.id).widget().getSelectedLabel();
                    },
                    setVal: function(val) {
                        this.values = [{
                            selectId: val.id,
                            label: val.label
                        }];
                        this.defaultSelectid = val.id;
                    },
                    validateFn: function(){
                        return $("#" + this.id).widget().getSelectedId() != "-1";
                    }
                },
                hostSelect: {
                    id: "hostSelect0",
                    width: "120",
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("protection_mount_hosts_select_label")
                    }],
                    disable: true,
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        var selectSiteId = $("#siteSelect" + that.id.slice(10)).widget().getSelectedId();
                        if (selectSiteId == "-1") {
                            object.open();
                            return;
                        };
                        restService.queryHostBySite([selectSiteId, 0], function(data) {
                            if (!_.isEmpty(data)) {
                                var hosts = Model.util.formatHosts(data);
                                if(!_.isEmpty(winData.pg) && startDbKey){
                                    hosts = _.filter(hosts, function(value){
                                        return value.deviceSn != winData.pg.poProviderSN
                                    });
                                };
                                appUtils.updateSelectValues(that.id, hosts, "deviceSn", "name", appUtils.getString("protection_mount_hosts_select_label"));
                                object.open();
                            } else {
                                object.open();
                            }
                        })
                    },
                    getVal: function() {
                        return $("#" + this.id).widget().getSelectedId();
                    },
                    getName: function() {
                        return $("#" + this.id).widget().getSelectedLabel();
                    },
                    setVal: function(val) {
                        this.values = [{
                            selectId: val.id,
                            label: val.label
                        }];
                        this.defaultSelectid = val.id;
                    },
                    validateFn: function(){
                        return $("#" + this.id).widget().getSelectedId() != "-1";
                    }
                },
                unmountPreviousCopy: {
                    id: "unmountPreviousCopy0",
                    text: appUtils.getString("protection_unmount_previous_copy_label"),
                    checked: false,
                    disable: true,
                    change: function(){
                        var that = this;
                        var enabled = $("#" + that.id).widget().option("checked");
                        _.each($scope.model.mountValues, function(val) {
                            if (val.unmountPreviousCopy.id == that.id) {
                                val.delCopyPostviousUnmount.display = enabled;
                                enabled && (val.delCopyPostviousUnmount.checked = true);
                            }
                        })
                        if(!enabled){
                            message.prompt({
                                content: appUtils.getString("dataMount_create_unmount_previous_copy_tip_lable"),
                                ok: function() {
                                    appUtils.closeWin(true);
                                }
                            });
                        }
                    },
                    getVal: function() {
                        return $("#" + this.id).widget().option("checked");
                    },
                    setVal: function(val) {
                        this.checked = val;
                    }
                },
                delCopyPostviousUnmount: {
                    id: "delCopyPostviousUnmount0",
                    text: appUtils.getString("protection_delete_copy_postvious_unmount_label"),
                    checked: true,
                    display: false,
                    getVal: function(){
                        return $("#" + this.id).widget().option("checked");
                    },
                    setVal: function(val){
                        this.checked = val;
                    }
                },
                startDataBase: {
                    id: "startDataBase0",
                    text: appUtils.getString("protection_startDb_after_mount_label"),
                    checked: false,
                    display: startDbKey,
                    disable: true,
                    getVal: function(){
                        return $("#" + this.id).widget().option("checked");
                    },
                    setVal: function(val){
                        this.checked = val;
                    }
                },
                scriptShow: false,
                scriptDisble: true,
                scriptTextId: "scriptText0",
                scriptCheck: {
                    id: "scriptCheck0",
                    text: appUtils.getString("protection_mount_script_label"),
                    click: function() {
                        var that = this;
                        _.each($scope.model.mountValues, function(item) {
                            if (item.scriptCheck.id == that.id) {
                                item.scriptShow = !item.scriptShow;
                                item.scriptShow ? $("#" + that.id).removeClass("advance-icon-close").addClass("advance-icon-open") : $("#" + that.id).removeClass("advance-icon-open").addClass("advance-icon-close");
                                item.scriptShow ? $("#" + item.scriptTextId).removeClass("ng-hide").addClass("ng-show") : $("#" + item.scriptTextId).removeClass("ng-show").addClass("ng-hide");
                            }
                            $scope.$apply();
                        });
                    }
                },
                preScript: {
                    id: "preScript0",
                    value: "",
                    width: "300",
                    validate: [{
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }],
                    getVal: function() {
                        return $("#" + this.id).widget().getValue();
                    },
                    setVal: function(val) {
                        this.value = val;
                    }
                },
                postScript: {
                    id: "postScript0",
                    value: "",
                    width: "300",
                    validate: [{
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }],
                    getVal: function() {
                        return $("#" + this.id).widget().getValue();
                    },
                    setVal: function(val) {
                        this.value = val;
                    }
                },
                delValue: function() {
                    if (this.disableDel) {
                        return;
                    };
                    var mountValues = $scope.model.mountValues;
                    var index = mountValues.indexOf(this);
                    index != -1 && (mountValues.splice(index, 1));
                    disableFirstPolicy();
                }
            };
            //查询本地服务器信息
            restService.queryLocalServer([], function(data) {
                if (data) {
                    $scope.serverUuid = data.uuid;
                };
            });
            //当只有一条挂载策略数据时，才不允许被删除
            function disableFirstPolicy() {
                if (_.size($scope.model.mountValues) == 1) {
                    _.extend($scope.model.mountValues[0], {
                        disableDel: true
                    });
                } else {
                    _.extend($scope.model.mountValues[0], {
                        disableDel: false
                    });
                }
            };
            //自动挂载说明
            $scope.autoMountTooltip = {
                content: appUtils.getString("protection_auto_mount_explain_label"),
                width: "470",
                position:"bottom-right"
            };
            $scope.text = {
                mountTitle: appUtils.getString("protection_mount_policy_win_label"),
                timeLabel: appUtils.getString("protection_mount_configs_policy_label"),
                preScriptLabel: appUtils.getStringWithColon("protection_pre_script_label"),
                postScriptLabel: appUtils.getStringWithColon("protection_post_script_label"),
                addBtnLabel: appUtils.getString("common_term_add_button"),
                SCRIPT_TIP: appUtils.getString("others_script_label")
            };
            $scope.model = {
                enableCheck: {
                    id: "enableMountCheck",
                    text: appUtils.getString("protection_enable_auto_mount_label"),
                    checked: false,
                    change: function() {
                        var enabled = $("#enableMountCheck").widget().option("checked");
                        $scope.model.addBtn.disable = !enabled;
                        if (enabled) {
                            $("#add_icon_btn").removeClass("iconbutton-add-disabled").addClass("iconbutton-add");
                            $("#add_link_btn").removeClass("btn-link-disable").addClass("btn-link");
                        } else {
                            $("#add_icon_btn").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                            $("#add_link_btn").removeClass("btn-link").addClass("btn-link-disable");
                        };
                        _.each($scope.model.mountValues, function(val) {
                            val.startTime.disable = !enabled;
                            val.endTime.disable = !enabled;
                            val.siteSelect.disable = !enabled;
                            val.hostSelect.disable = !enabled;
                            val.unmountPreviousCopy.disable = !enabled;
                            val.unmountPreviousCopy.checked = enabled;
                            val.delCopyPostviousUnmount.display = enabled;
                            val.startDataBase.checked = enabled;
                            val.startDataBase.disable = !enabled;
                            val.scriptShow = false;
                            val.scriptDisble = !enabled;
                            $("#" + val.scriptCheck.id).removeClass("advance-icon-open").addClass("advance-icon-close");
                            $("#" + val.scriptTextId).removeClass("ng-show").addClass("ng-hide");
                        });
                        $scope.$apply();
                    },
                    setValue: function(val) {
                        this.checked = val;
                    }
                },
                mountValues: [angular.copy(defaultValue)],
                addBtn: {
                    disable: true,
                    click: function() {
                        if (this.disable) {
                            return;
                        };
                        var addValue = angular.copy(defaultValue);
                        var addId = parseInt($scope.model.mountValues[$scope.model.mountValues.length - 1].startTime.id.slice(13), 10) + 1;
                        _.each(addValue, function(val) {
                            if (!_.isUndefined(val.id) && val.id.indexOf("startTimeDate") != -1) {
                                val.id = "startTimeDate" + addId;
                                val.disable = false;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("endTimeData") != -1) {
                                val.id = "endTimeData" + addId;
                                val.disable = false;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("siteSelect") != -1) {
                                val.id = "siteSelect" + addId;
                                val.disable = false;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("hostSelect") != -1) {
                                val.id = "hostSelect" + addId;
                                val.disable = false;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("unmountPreviousCopy") != -1) {
                                val.id = "unmountPreviousCopy" + addId;
                                val.disable = false;
                                val.checked = true;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("startDataBase") != -1) {
                                val.id = "startDataBase" + addId;
                                val.disable = false;
                                val.checked = true;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("scriptCheck") != -1) {
                                val.id = "scriptCheck" + addId;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("preScript") != -1) {
                                val.id = "preScript" + addId;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("postScript") != -1) {
                                val.id = "postScript" + addId;
                            };
                            if(!_.isUndefined(val.id) && val.id.indexOf("delCopyPostviousUnmount") != -1){
                                val.id = "delCopyPostviousUnmount" + addId;
                                val.display = true;
                                val.checked = true;
                            };
                        });
                        _.extend(addValue, {
                            disableDel: false,
                            scriptDisble: false,
                            scriptTextId: "scriptText" + addId
                        });
                        $scope.model.mountValues.push(addValue);
                        disableFirstPolicy();
                        $scope.$apply();
                    }
                }
            };
            //回显
            if (!_.isEmpty(winData.data.props.AUTOMOUNTCONFIGS)) {
                var setConfigs = JSON.parse(winData.data.props.AUTOMOUNTCONFIGS);
                $scope.model.enableCheck.setValue(setConfigs.enabled);
                $scope.model.addBtn.disable = !setConfigs.enabled
                if (setConfigs.enabled) {
                    var mountArray = [];
                    _.each(setConfigs.mountConfigs, function(item, index) {
                        var defaultData = angular.copy(defaultValue);
                        _.extend(defaultData, {
                            disableDel: index == 0,
                            scriptTextId: "scriptText" + index,
                            scriptDisble: false
                        });
                        //开始时间
                        defaultData.startTime.id = "startTimeDate" + index;
                        defaultData.startTime.disable = false;
                        defaultData.startTime.setVal(item.startTime);
                        //结束时间
                        defaultData.endTime.id = "endTimeData" + index;
                        defaultData.endTime.disable = false;
                        defaultData.endTime.setVal(item.endTime);
                        //挂载站点信息
                        defaultData.siteSelect.id = "siteSelect" + index;
                        defaultData.siteSelect.disable = false;
                        //挂载主机信息
                        defaultData.hostSelect.id = "hostSelect" + index;
                        defaultData.hostSelect.disable = false;
                        //挂载前先卸载已挂载的副本
                        defaultData.unmountPreviousCopy.id = "unmountPreviousCopy" + index;
                        defaultData.unmountPreviousCopy.disable = false;
                        defaultData.unmountPreviousCopy.setVal(item.unmountPreviousCopy);
                        //卸载成功后自动删除副本
                        defaultData.delCopyPostviousUnmount.id = "delCopyPostviousUnmount" + index;
                        defaultData.delCopyPostviousUnmount.display = item.unmountPreviousCopy;
                        _.isBoolean(item.deleteReplica) && defaultData.delCopyPostviousUnmount.setVal(item.deleteReplica);
                        //是否启动数据库
                        defaultData.startDataBase.display = startDbKey;
                        defaultData.startDataBase.id = "startDataBase" + index;
                        defaultData.startDataBase.disable = false;
                        !_.isUndefined(item.startDB) && defaultData.startDataBase.setVal(item.startDB);
                        defaultData.scriptCheck.id = "scriptCheck" + index;
                        //前置脚本
                        defaultData.preScript.id = "preScript" + index;
                        var pre = _.filter(item.processors, function(val) {
                            return val.procName == "mountPreProcessor"
                        });
                        !_.isEmpty(pre) && defaultData.preScript.setVal(pre[0].props.scriptName);
                        //后置脚本
                        defaultData.postScript.id = "postScript" + index;
                        var postVal = _.filter(item.processors, function(val) {
                            return val.procName == "mountPostProcessor"
                        });
                        !_.isEmpty(postVal) && defaultData.postScript.setVal(postVal[0].props.scriptName);
                        restService.queryLocalServer([],{
                            success: function(server){
                                if( _.isObject(server) ){
                                    restService.querySites(server.uuid,{
                                        mask: false,
                                        success: function(sites){
                                            var useSite = _.filter(sites, function(siteVal){
                                                return siteVal.siteId == item.siteId
                                            });
                                            defaultData.siteSelect.setVal({
                                                id: item.siteId,
                                                label: useSite[0].name
                                            });
                                            //查询站点、主机，获取站点、主机名称
                                            restService.queryHostBySite([item.siteId, 0], {
                                                mask: false,
                                                success: function(hostData) {
                                                    if (!_.isEmpty(hostData)) {
                                                        var hosts = Model.util.formatHosts(hostData);
                                                        var useHost = _.filter(hosts, function(hostVal){
                                                            return hostVal.deviceSn == item.hostOrGroupSn
                                                        });
                                                        defaultData.hostSelect.setVal({
                                                            id: item.hostOrGroupSn,
                                                            label: useHost[0].name
                                                        });
                                                    }
                                                }
                                            })
                                        }
                                    });
                                }
                            }
                        });
                        mountArray.push(defaultData);
                    });
                    $scope.model.mountValues = mountArray;
                    disableFirstPolicy();
                    $scope.$apply();
                }
            };
            $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().option("buttons", [{
                key: "ok",
                label: appUtils.getString("common_term_confirm_button"),
                focused: true,
                handler: function() {
                    if (!UnifyValid.FormValid($("#san_mount_policy_win"), {focusInvalid: true})) {
                        return;
                    };
                    var enableMount = $("#enableMountCheck").widget().option("checked");
                    var vaildateFlag = true;
                    for (var i = 0; i < $scope.model.mountValues.length; i++) {
                        if(!$scope.model.mountValues[i].siteSelect.validateFn() && enableMount){
                            message.error(appUtils.getString("protection_hyperVault_selectSite_msg"));
                            vaildateFlag = false;
                            break;
                        };
                        if(!$scope.model.mountValues[i].hostSelect.validateFn() && enableMount){
                            message.error(appUtils.getString("recovery.term.recovery.hostGroup.message.least"));
                            vaildateFlag = false;
                            break;
                        };
                    };
                    //未选择站点、主机信息
                    if(!vaildateFlag) {
                        return;
                    };
                    var mountConfig = [];
                    _.each($scope.model.mountValues, function(item) {
                        var configs = {
                            startTime: item.startTime.getVal(),
                            endTime: item.endTime.getVal(),
                            siteId: item.siteSelect.getVal(),
                            siteName: item.siteSelect.getName(),
                            hostOrGroupSn: item.hostSelect.getVal(),
                            hostName: item.hostSelect.getName(),
                            unmountPreviousCopy: item.unmountPreviousCopy.getVal(),
                            processors: []
                        };
                        if(item.unmountPreviousCopy.getVal()){
                            _.extend(configs, {
                                deleteReplica: item.delCopyPostviousUnmount.getVal()
                            });
                        };
                        if (!_.isEmpty(item.preScript.getVal())) {
                            configs.processors.push({
                                procName: "mountPreProcessor",
                                isPreset: false,
                                props: {
                                    scriptName: item.preScript.getVal()
                                }
                            })
                        };
                        if (!_.isEmpty(item.postScript.getVal())) {
                            configs.processors.push({
                                procName: "mountPostProcessor",
                                isPreset: false,
                                props: {
                                    scriptName: item.postScript.getVal()
                                }
                            })
                        };
                        //oracle、db2、sqlserver需要增加是否启动数据库
                        startDbKey && _.extend(configs, {
                            startDB: item.startDataBase.getVal()
                        });
                        configs["extParameters"] = {};
                        mountConfig.push(configs);
                    });
                    var autoMountConfigs = {
                        enabled: enableMount,
                        mountConfigs: []
                    };
                    enableMount && (_.extend(autoMountConfigs, {
                        mountConfigs: mountConfig
                    }));
                    //修改保护策略
                    if(!winData["createFlag"]){
                        var modifyConf = angular.copy(winData.data);
                        var modifyMountConfigs = angular.copy(autoMountConfigs);
                        if(modifyMountConfigs.enabled){
                            _.each(modifyMountConfigs.mountConfigs, function(configVal){
                                delete configVal.siteName;
                                delete configVal.hostName;
                            });
                        };
                        //修改的策略的时候需要往后台增加一个参数
                        _.extend(modifyMountConfigs, {
                            modifyMountConfigs: true
                        });
                        _.extend(modifyConf.props, {
                            AUTOMOUNTCONFIGS: JSON.stringify(modifyMountConfigs)
                        });
                        //修改校验规则:modify挂载策略时，schedules出入空数组
                        modifyConf.schedules = [];
                        var reqConf = {
                            "data": modifyConf,
                            "interceptor": function(next) {
                                var pgName = winData.pg.name;
                                var encodePgName = $.encoder.encodeForHTML(pgName);
                                var msg = appUtils.getString("ism.drm.pg.schedule.modify.msg1", encodePgName) + "<br>" +
                                    appUtils.getString("ism.drm.pg.schedule.modify.msg2", encodePgName) + "<br>" +
                                    appUtils.getString("ism.drm.pg.schedule.modify.msg3");

                                message.warn({
                                    content: msg,
                                    ok: function() {
                                        next();
                                    }
                                });
                            },
                            "success": function() {
                                $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().destroy();
                                message.prompt({
                                    content: appUtils.getString("common_term_operationsyn_success_label"),
                                    ok: function() {
                                        _.isFunction(winData.ok) && winData.ok();
                                    }
                                });
                            }
                        };
                        restService.modifyPolicy(winData.pg.pgId, reqConf);
                    }else{
                        infoTransferredService.put("SAN_MOUNT_POLICY", "MOUNT_CONFIGS", autoMountConfigs);
                        $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().destroy();
                    }
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function() {
                    $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().destroy();
                }
            }]);
        }
    ];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("mount-policy-ctrl", ctrl);
    return module;
})
