define([], function() {
    var ctrl = ["$scope", "$compile", "$sce", "$timeout", "appUtils", "constsService", "restService", "model", "infoTransferredService", "message", function($scope, $compile, $sce, $timeout, appUtils, constsService, restService, Model, infoTransferredService, message) {

        var vm = $scope.viewModel;
        var vmTableData = [];
        var cacheDrTypeMap = {};
        $scope.model = {
            search: {
                "id": "rvmSearch",
                "values": [{
                    selectId: "0",
                    label: appUtils.getString("rm_term_volumn_column_virtual")
                }],
                "display": true,
                "disable": false,
                "showTip": true,
                "isSearchbox": true,
                "defaultSelectid": "0",
                "width": constsService.W1 + 40,
                "change": function() {},
                "click": function() {
                    var inputValue = $.trim($("#rvmSearch").widget().getSearchboxValue().inputValue);
                    $scope.model.table.data = _.filter(vmTableData, function(value, key, list) {
                        return value["moName"].indexOf(inputValue) != -1;
                    });
                    $scope.$apply();
                    if (_.size($scope.model.table.data) == 0) {
                        $("#drVolumnTypeDetail").unbind("click");
                        $("#drVolumnTypeDetail").removeClass('btn-link').addClass('btn-link-disable');
                        return;
                    };
                    $("#drVolumnTypeDetail").removeClass('btn-link-disable').addClass('btn-link');
                    $("#drVolumnTypeDetail").bind("click", linkcallback);
                    $scope.model.table.openNode();
                }
            },
            table: {
                id: "datasVolumesTable",
                data: [],
                columns: [{
                    "sTitle": "",
                    "mData": "detail",
                    "bSearchable": false,
                    "bSortable": false,
                    "sWidth": "60px"
                }, {
                    "sTitle": "",
                    "mData": "moUuid",
                    "bSortable": false,
                    "bVisible": false,
                }, {
                    "sTitle": appUtils.getString("common_term_name_label"),
                    "mData": "moName",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_type"),
                    "mData": "volumeType",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_dr_addOpenstackVirtual_type"),
                    "mData": "drVolumeType",
                    "bSortable": false
                }],
                openNode: function(callback) {
                    var switchDiv = $("div.default_show_style");
                    if (switchDiv && switchDiv.length != 0) {
                        switchDiv.click();
                    }
                    setTimeout(function() {
                        _.isFunction(callback) && callback();
                    }, 20);
                },
                showDetails: {
                    "colIndex": 0,
                    "domPendType": "nopend",
                    "openClick": function(event, aData) {
                        function createNode(volumeId, moUuid) {
                            var select = "<tiny-select id='smodel.id' select='smodel.select()' values='smodel.values' default-selectid='smodel.defaultId' width='smodel.width' auto-open='smodel.autoOpen' close-fn='smodel.closeFn' open-fn='smodel.openFn'></tiny-select>";
                            var selectLink = $compile(select);
                            var selectScope = $scope.$new();
                            selectScope.smodel = {
                                id: volumeId + moUuid,
                                defaultId: "-1",
                                values: [{
                                    "selectId": "-1",
                                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                                }],
                                width: constsService.W2,
                                select: function() {},
                                autoOpen: function() {},
                                closeFn: function() {
                                    var widget = $("#" + this.id).widget();
                                    var selectedObj = {selectId: widget.getSelectedId(),label: widget.getSelectedLabel()};
                                    cacheDrTypeMap[volumeId + moUuid] = {selectId: widget.getSelectedId(),label: widget.getSelectedLabel()};

                                    _.each(_.keys(cacheDrTypeMap),function(val){
                                        if(val.indexOf(volumeId) != -1){
                                            cacheDrTypeMap[val] = {selectId: widget.getSelectedId(),label: widget.getSelectedLabel()};
                                        }
                                    });

                                    var len = $('.tiny-select[id*=' + volumeId + ']').length;
                                    for (var index = 0; index < len; index++) {
                                        $('.tiny-select[id*=' + volumeId + ']').eq(index).widget().selected = [widget.getSelectedId()];
                                        $('.tiny-select[id*=' + volumeId + '] .tiny-select-text').eq(index).val(widget.getSelectedLabel());
                                    }
                                },
                                openFn: function(object) {
                                    var params = {
                                        openstackId: infoTransferredService.get("OpenstackFusionSphereIdModuel", "fusionSphereId"),
                                        srcProjectId: infoTransferredService.get("OpenstackProjectIdModuel", "projectId"),
                                        srcRegionId: infoTransferredService.get("OpenstackRegionIdModuel", "regionId"),
                                        regionId: $("#drRegion").widget().getSelectedId(),
                                        projectId: $("#drProject").widget().getSelectedId(),
                                        srcVolumeTypeName: $.trim($("#volumeType_" + volumeId).text())
                                    };
                                    var context = this;
                                    restService.getOpenStackVolumeType(params, {
                                        success: function(result) {
                                            var vals = [];
                                            _.each(result, function(r,index) {
                                                vals.push({
                                                    selectId: appUtils.covertSpecialChar(r.volumeTypeId),
                                                    label: r.volumeTypeName,
                                                    checked:index == 0
                                                })
                                            });

                                            vals.push({
                                                selectId: "-1",
                                                label: appUtils.getString("common_term_pleaseSelect_listbox")
                                            });
                                            $("#" + context.id).widget().option("values", vals);
                                            object.open();
                                        }
                                    })

                                }
                            }

                            if (_.has(cacheDrTypeMap, volumeId + moUuid)) {
                                selectScope.smodel.values = [cacheDrTypeMap[volumeId + moUuid]];
                                selectScope.smodel.defaultId = cacheDrTypeMap[volumeId + moUuid].selectId;
                            }
                            var selectNode = selectLink(selectScope);
                            selectScope.$evalAsync();
                            $("td[id='drVolumeType_" + volumeId + moUuid + "']").html(selectNode);
                        };

                        var tr = $(event.target).parents("tr")[0];
                        var dsData = $("#datasVolumesTable").widget().getTableData(tr);
                        var child = angular.copy(dsData.volumes);
                        var moUuid = appUtils.covertSpecialChar(dsData.moUuid);
                        var html = "";
                        for (var z = 0; z < child.length; z++) {
                            var volumeName = $.encoder.encodeForHTML(child[z].volumeName);
                            var volumeId = appUtils.covertSpecialChar(child[z].volumeId);
                            var volumeType = child[z].volumeType;
                            html += '<tr class="odd clickTrColor" parentId="' + dsData.moUuid + '">';
                            html += '<td tdname="detail" class="tiny-tdStyle"></td>';
                            html += '<td tdname="volumeName" class="tiny-tdStyle" style="padding-left:20px"  id="volumeName_' + volumeId + '"">' + volumeName + '</td>';
                            html += '<td tdname="volumeType" class="tiny-tdStyle" id="volumeType_' + volumeId + '">' + volumeType + '</td>';
                            html += '<td tdname="drVolumeType" class="tiny-tdStyle"id="drVolumeType_' + volumeId + moUuid + '"></td></tr>';
                        }
                        $(event.target).parents("tr").eq(0).after(html);
                        _.each(child, function(volume) {
                            createNode(appUtils.covertSpecialChar(volume["volumeId"]), this);
                        },moUuid);
                    },
                    "closeClick": function(event, aData) {
                        var trObj = $(event.target).parents("tr")[0]
                        trObj = $("#datasVolumesTable").widget().getTableData(trObj);

                        $(event.target).parents("tr").eq(0).nextAll().filter(
                            function() {
                                return $(this).attr("parentId") === $("#datasVolumesTable").widget().getTableData($(event.target).parents("tr")[0]).moUuid;
                            }).unbind().remove();
                    }
                },
                "closeClick": function(event, aData) {},
                callback: function(evtObj) {
                    $scope.model.table.defaultSelectId = undefined;
                },
                renderRow: function(nRow, aData, iDataIndex) {
                    $("td:eq(0)", nRow).html("<div class='default_show_style btn-link'>&nbsp;</div>");
                },
                cellClickActive: function(e, param, isFind) {},
                drawCallback: function(oSetting) {},
                defaultSelectId: undefined,
                desc: $sce.trustAsHtml(appUtils.getString("rm_term_volumn_table_desc", appUtils.getString("rm_term_volumn_table_desc_param"))),
                tip: appUtils.getString("protection_openstack_disasterVolume_tip")
            }
        }

        function init() {
            var queryData = {};
            var param = [];
            var data = $("#" + constsService.OPENSTACK_VOLUMN_SETTING_WIN.winId).widget().option("data");
            var regionId = infoTransferredService.get("OpenstackRegionIdModuel", "regionId");
            var projectId = infoTransferredService.get("OpenstackProjectIdModuel", "projectId");
            if(!_.isEmpty(data.polist)){
                _.each(data.polist,function(val){
                    _.each(JSON.parse(val.props.volumeConfig),function(val1){
                        cacheDrTypeMap[appUtils.covertSpecialChar(val1.volumeId) + appUtils.covertSpecialChar(val.moUuid)] = {selectId:"drVolumeType_1",label: val1.drVolumeType}
                    })
                })
            }
            _.each(infoTransferredService.get("OpenstackVmMoUuidsModuel", "moUuids"), function(vm) {
                param.push(vm.moUuid);
            });
            queryData.regionId = regionId;
            queryData.projectId = projectId;
            restService.getOpenStackVolumes(queryData, {
                data: param,
                success: function(result) {
                    var arr = [];
                    _.each(result, function(d, index) {
                        _.extend(d, {
                            "detail": {
                                contentType: "simple",
                                content: ""
                            }
                        })

                        var tmo = _.pick(d, "detail", "volumes", "moName", "moUuid");
                        arr.push(tmo);
                    });

                    $scope.model.table.data = appUtils.encodeForHTML(arr);
                    $scope.$apply();
                    $scope.model.table.openNode();
                    vmTableData = _.clone($scope.model.table.data);
                }
            });
        }


        $scope.$on(vm.event, function(event, params) {
            vm.valid = true;
            var result = {};
            var polist = [];
            var valid = true;

            var dataTable = $("#datasVolumesTable").widget().getTableData(), valid = true;

            $.each(dataTable, function(index, data) {
                var moUuid = appUtils.covertSpecialChar(data["moUuid"]);
                $.each(data.volumes, function(index, volume) {
                    var volumeId = appUtils.covertSpecialChar(volume.volumeId);
                    var drVolumeTypewidget = $("#" + volumeId + moUuid).widget();

                    //节点关闭，从缓存中获取数据进行判断
                    if (_.isUndefined(drVolumeTypewidget)) {
                        if (!_.has(cacheDrTypeMap, volumeId + moUuid) || cacheDrTypeMap[volumeId + moUuid].label == appUtils.getString("common_term_pleaseSelect_listbox")) {
                            valid = false;
                            return false;
                        }
                    } else {
                        if ( drVolumeTypewidget.getSelectedId() == "-1" && drVolumeTypewidget.getSelectedLabel() == appUtils.getString("common_term_pleaseSelect_listbox")) {
                            valid = false;
                            return false;
                        }
                    }
                })

                if (!valid) return false;
            });

            if (!valid) {
                message.error(appUtils.getString("rm_term_drVolumn_type_validate"));
                return false;
            }

            if (!valid) {
                return;
            }

            _.each(dataTable, function(d) {
                var temp = {},
                    volumeConfig = [];

                temp["moUuid"] = d.moUuid;
                _.each(d.volumes, function(v, index) {
                    var volumeId = appUtils.covertSpecialChar(v["volumeId"]);
                    var moUuid = appUtils.covertSpecialChar(temp["moUuid"]);
                    var drVolumeType = "";

                    if (_.isUndefined(cacheDrTypeMap[volumeId + moUuid])
                            || (!_.isUndefined(cacheDrTypeMap[volumeId + moUuid]) && cacheDrTypeMap[volumeId + moUuid].label == appUtils.getString("common_term_pleaseSelect_listbox"))) {
                        drVolumeType = $("#" + volumeId + moUuid).widget().getSelectedLabel();
                    } else {
                        drVolumeType = cacheDrTypeMap[volumeId + moUuid].label;
                    }

                    volumeConfig.push({
                        volumeId: v.volumeId,
                        drVolumeType: drVolumeType,
                        volumeType: $.trim(v.volumeType),
                        volumeName: $.trim(v.volumeName)
                    });
                });

                temp["props"] = {"volumeConfig": JSON.stringify(volumeConfig)};

                polist.push(temp);
            });

            infoTransferredService.put("VOLUMES_SETTING_MODULE", "VOLUMES_SETTING", { props: params, polist: polist });
            $("#" + constsService.OPENSTACK_VOLUMN_SETTING_WIN.winId).widget().destroy();
        });

        var linkcallback = function() {
            var win = _.clone(constsService.OPENSTACK_DR_VOLUMN_SETTING_WIN);
            win.title = appUtils.getString(win.title);
            win.data = $("#datasVolumesTable").widget().getTableData();
            appUtils.showWindow(win, function() {
                var options = this.options,
                    closeFlag = true,
                    batchVolumeData = $("#volumesDiffTable").widget().getTableData();

                $scope.model.table.openNode(function(){
                    $.each(batchVolumeData, function(index, v1) {
                        var v1widget;
                        if(v1.volumeId.indexOf(".") != "-1"){
                            v1widget = $('#' + v1.volumeId.replace(/\./g,'\\.')).widget();
                        }else{
                            v1widget = $("#" + v1.volumeId).widget();
                        }

                        if (v1widget.getSelectedId() == "-1") {
                            closeFlag = false;
                            message.error(appUtils.getString("rm_term_drVolumn_type_validate"));
                            return false;
                        }

                        _.each($("#datasVolumesTable").widget().getTableData(), function(v2) {

                            _.each(_.where(v2.volumes, {"volumeType": v1.volumeType}), function(v3) {

                                var v3widget = $("#" + appUtils.covertSpecialChar(v3.volumeId) + this).widget(),
                                    label = $.trim(v1widget.getSelectedLabel()),
                                    object = _.findWhere(v3widget.option("values"), {"label": label});

                                if (!_.isEmpty(object)){
                                    v3widget.opChecked(object.selectId);
                                } else {
                                    v3widget.opLabel(v3widget.getSelectedId(), label);
                                }

                                if (!_.has(cacheDrTypeMap, appUtils.covertSpecialChar(v3.volumeId) + appUtils.covertSpecialChar(v2.moUuid))) {
                                    cacheDrTypeMap[appUtils.covertSpecialChar(v3.volumeId) + appUtils.covertSpecialChar(v2.moUuid)] = {selectId: v1widget.getSelectedId(),label: label};
                                } else {
                                    _.extend(cacheDrTypeMap[appUtils.covertSpecialChar(v3.volumeId) + appUtils.covertSpecialChar(v2.moUuid)], {selectId: v1widget.getSelectedId(),label: label});
                                }

                            }, appUtils.covertSpecialChar(v2.moUuid));
                        });

                    });

                    closeFlag && $("#" + options.winId).widget().destroy();
                });
            });
        }

        setTimeout(function() {
            $("#drVolumnTypeDetail").bind("click", linkcallback);
        }, 0)

        init();

    }]
    return ctrl;
})
