define([], function() {
	var ctrl = ["$scope", "appUtils", "message", function($scope, appUtils, message) {
		var vm = $scope.viewModel;
		var poType = vm.poType;
		var ptProps = vm.data;

		$scope.showSetting = true;
		if( !$scope.showSetting ) return;


		/**********************************************************************
			       本地文件系统,db2,sqlserver,exchange一致性设置和vmware静默快照设置
		***********************************************************************/

		var resource = appUtils.resource();

		var keyType = "appConsistent";
		var failedContinueKey = "continueAppConsistentFailure";
		//SAN一体化备份
		var isSanHyperVault = vm.ptType == 30 || vm.ptType == 31 || vm.ptType == 32;
		//HANA异步复制强制启用一致性策略
		var isHanaDisableApp = poType == 16 && (ptProps["SUPPORT_FREEZE_FLAG_DISABLE"] == "0" || vm.ptType == 2);
		//增加秒级策略(双活+快照、快照)
		var isAddSecondSchedule = _.contains([19, 2], parseInt(vm.ptType));
		if(isHanaDisableApp){
			isSanHyperVault = false;
			isAddSecondSchedule = false;
		};
		//打静默失败后是否继续执行保护组
		var vmwareCdm = poType == 10;
		$scope.supportExcuteShow = vmwareCdm && !(isSanHyperVault && vm.protectLocation == 0) && !isAddSecondSchedule;
		//默认为数据库的数据一致性设置
		$scope.settingDesc = resource.get("protection_sql_task_setPolicy_option_executeConsist_des_label");
		$scope.settingCheckbox = {
			id : "settingCheckbox",
			text : resource.get("protection_sql_task_setPolicy_option_executeConsist_checkbox"),
			checked : !(isSanHyperVault && vm.protectLocation == 0) && !isAddSecondSchedule,
			disable: false,
			change : function(){
				!_.isUndefined(vm.schedule) && (vm.schedule[keyType] = $("#settingCheckbox").widget().option("checked") ? 1:0);
				if (vmwareCdm) {
				    $scope.supportExcuteShow = $("#settingCheckbox").widget().option("checked");
				};
			}
		};
		//vmware打静默快照失败后是否继续执行保护组
		$scope.continueExcuteBox = {
			id: "continueExcuteCheckbox",
			text: resource.get("pg_vmware_policy_enable_excute_checkbox_label"),
			checked: !_.isUndefined(vm.schedule) && !_.isUndefined(vm.schedule.extParameters) ? vm.schedule.extParameters[failedContinueKey] : false,
			change: function(){
				//启用要给出高危提示^-^
				if($("#continueExcuteCheckbox").widget().option("checked")){
					message.warn({
						content: appUtils.getString("pg_vmware_policy_enable_excute_warn_label"),
						cancel: function(){
							$("#continueExcuteCheckbox").widget().option("checked", false);
						}
					})
				};
			}
		};

		//数据收集触发事件
		$scope.$on(vm.event,function(){
			if (_.isUndefined(vm.schedule)) {
				return;
			};
			vm.schedule[keyType] = $("#settingCheckbox").widget().option("checked") ? 1:0;
			//针对vmware打快照失败后是否继续执行保护组
			if (vmwareCdm) {
			    if (_.isUndefined(vm.schedule.extParameters)) {
			        vm.schedule.extParameters = {};
			    };
			    $scope.supportExcuteShow && (vm.schedule.extParameters[failedContinueKey] = $("#continueExcuteCheckbox").widget().option("checked"));
			    !$scope.supportExcuteShow && (delete vm.schedule.extParameters[failedContinueKey]);
			};
		});

		init();

		//SAN一体化备份
		//回显是否可设置应用一致性
		if(!_.isUndefined(vm.schedule)){
		    try {
		        //HANA异步复制
		        if(isHanaDisableApp){
		        	$scope.settingCheckbox.disable = true;
		        };
		    } catch (err) {}

		};
		$scope.$on("DIABLE_SCHEDULEAPP", function(evt, disableFlag){});

		function init(){

			if( poType == 9 ){
				$scope.settingCheckbox.text = resource.get("common_term_dataConsistentProtect_label");
				$scope.settingDesc = resource.get("common_term_dataConsistentProtect_des_label");
			}

			//SQLServer
			if (poType == 2) {
				$scope.settingDesc = resource.get("pg_term_dataconsistentprotect_sqlserver_des_label");
			}

			//若为vmware,则初始化静默快照设置
			if( poType == 10 ){
				$scope.settingCheckbox.text = resource.get("protection_VMware_task_setSchedule_option_generateSnapshot_checkbox");
				$scope.settingDesc = resource.get("protection_VMware_task_setSchedule_option_generateSnapshot_des_label");
				if (vmwareCdm && !_.isUndefined(vm.schedule) && !_.isUndefined(vm.schedule[keyType])) {
				    $scope.supportExcuteShow = vm.schedule[keyType];
				};
			}
			//HANA数据库异步复制
			if(isHanaDisableApp){
				$scope.settingCheckbox.checked = true;
				$scope.settingCheckbox.disable = true;
				$scope.$apply();
			}

			if( vm.schedule[keyType] == 0 ){
				$scope.settingCheckbox.checked = false;
			}
			//SAN一体化
			if(vm.schedule[keyType] == 1 && (isSanHyperVault || isAddSecondSchedule)){
				$scope.settingCheckbox.checked = true;
			}
		};

	}];

	return ctrl;
});
