define(["tiny-common/UnifyValid"],function(UnifyValid){
	var ctrl = ["$scope","appUtils",function($scope,appUtils){
		var vm = $scope.viewModel;
		var ptProps = vm.data = vm.data || {}

		var resource = appUtils.resource();

		$scope.title = resource.get("ism.drp.drp.advanced.setup.label");
		var unitText = resource.get("common_term_unit_label");
		var rangeText = resource.get("common_term_range_label");
		$scope.copyRateTip = "("+unitText+":MB/s"+" "+rangeText+":20-10000)";

		$scope.restoreNumlabel   = resource.getWithColon("protection_HuaweiVM_task_create_selProtectionObject_para_VMRecoveryPoint_label");
		$scope.restoreNumTip     = resource.get("protection_HuaweiVM_task_create_selProtectionObject_para_VMRecoveryPoint_des_tip");
		var restoreNumInvalidTip = resource.get("protection_HuaweiVM_task_create_selProtectionObject_para_VMRecoveryPoint_range_validation",2,32);

		$scope.restoreNum = {
			id: "restoreNum",
			validate: "required:" + restoreNumInvalidTip + ";integer:" + restoreNumInvalidTip + ";minValue(2):" + restoreNumInvalidTip + ";maxValue(32):" + restoreNumInvalidTip,
			value: ptProps.FS_Snap_Restore_Num || 2
		};

		$scope.showFcRestoreNumSet = vm.fcRestoreNumSet || ptProps.hasOwnProperty("FS_Snap_Restore_Num");

		//compress
		$scope.checkbox1 = {
			id : "checkbox_props1",
			text : resource.get("protection.viewPolicy.task.para.compress.label"),
			checked : ptProps.COMPRESSION == "true" || ptProps.COMPRESSION == true
		};

		//encryption
		$scope.checkbox2 = {
			id : "checkbox_props2",
			text : resource.get("protection.viewPolicy.task.para.encryption.label"),
			checked : ptProps.ENTRYPTION == "true" || ptProps.ENTRYPTION == true
		};

		//replication rate
		$scope.checkbox3 = {
			id : "checkbox_props3",
			text : resource.get("protection.viewPolicy.task.para.copySpeedWithoutUnit.label"),
			checked : ptProps.COPYRATE == "true" || ptProps.COPYRATE == true,
			change : function(){
				$scope.copyRateValShow = $("#checkbox_props3").widget().option("checked");
			}
		};

		$scope.copyRateValShow = $scope.checkbox3.checked;
		$scope.copyRateHelpTip = resource.get("protection.viewPolicy.task.para.copySpeedWithoutUnit.des.label");

		var errorTip = resource.get("common_term_integer_range_tip",20,10000);
		var sInt = "integer:"+errorTip,
            sMin = ";minValue(20):" + errorTip,
            sMax = ";maxValue(10000):" + errorTip;


		$scope.copyRate = {
			id : "copyRate",
            validate : sInt + sMin + sMax + ";required:"+errorTip
		};

		$scope.copyRateValShow && ($scope.copyRate.value = ptProps.COPYRATEVALUE);

		$scope.$on(vm.event, function() {
			if ( !(vm.valid=UnifyValid.FormValid($("#FusionSphereSetting"), {focusInvalid: true})) ) return;

			if ($scope.showFcRestoreNumSet) {
				ptProps["FS_Snap_Restore_Num"] = $("#restoreNum").widget().getValue();
			}
			ptProps["COMPRESSION"] = $("#checkbox_props1").widget().option("checked") ? true : false;
			ptProps["ENTRYPTION"] = $("#checkbox_props2").widget().option("checked") ? true : false;
			ptProps["COPYRATE"] = $("#checkbox_props3").widget().option("checked") ? true : false;
			if (ptProps["COPYRATE"]) {
				ptProps["COPYRATEVALUE"] = $("#copyRate").widget().getValue();
			}
		});

	}];

	return ctrl;
});