define(["tiny-common/UnifyValid"], function(UnifyValid) {
    var ctrl = ["$scope", "message", "appUtils", "constsService", "restService", "infoTransferredService",
        function($scope, message, appUtils, constsService, restService, infoTransferredService) {

            var vm = $scope.viewModel;
            _.isEmpty(vm.schedule.extParameters) && (vm.schedule.extParameters = {});
            var lunProps = vm.schedule.extParameters;
            var hostOrGroupName = infoTransferredService.get("hostOrGroupNameModuel", "hostOrGroupName");
            var scriptConfigFlag = vm.poType == 11 && _.contains([2], parseInt(vm.ptType));
            var scriptProps = angular.copy(lunProps) || {};
            var configedScriptParamsLabel = appUtils.getString("protection_lun_script_config_enable_label");
            var notConfigScriptParamsLabel = appUtils.getString("protection_lun_please_set_script_label");

            /**
             * 筛选符合要求的主机信息
             * @param  {[type]} data [description]
             * @return {[type]}      [description]
             */
            var _formatHosts = function(data) {
                var hosts = [];
                if (angular.isArray(data)) {
                    data.forEach(function(item) {
                        if (item.isVirtualGroup) {
                            angular.isArray(item.childResources) && item.childResources.forEach(function(res) {
                                hosts.push({
                                    deviceSn: res.deviceSn,
                                    name: res.name
                                    });
                                });
                        }
                        else {
                            hosts.push({
                                deviceSn: item.deviceSn,
                                name: item.name + "(" + appUtils.getString("ism.drm.hostgroup") + ")"
                        });
                        }
                    });
                }
                return hosts;
            };
            var isEn = appUtils.isEn();
            //查询系统脚本
            var systemScriptTemp;
            //公共参数设置
            var publicParamsTemp;
            //设置选择脚本类型
            var selectScript = function(scriptId, cb){
                if(!_.isEmpty(scriptId) && !_.isEmpty(systemScriptTemp)){
                    var filterScript = _.filter(systemScriptTemp, function(val){
                        return val.id == scriptId
                    });
                    //填充脚本相关参数
                    !_.isEmpty(filterScript) && _.each(filterScript[0].steps, function(stepItem){
                        if(stepItem["position"] == "protect-freeze"){
                            $scope.model.freezeScriptSelect.freezeScriptValue = stepItem["script"];
                            $scope.model.freezeScriptSelect.scriptItem = stepItem["params"];
                        }
                        if(stepItem["position"] == "protect-thaw"){
                            $scope.model.thawScriptSelect.thawScriptValue = stepItem["script"];
                            $scope.model.thawScriptSelect.scriptItem = stepItem["params"];
                        }
                        if(stepItem["position"] == "protect-query"){
                            $scope.model.queryFreezeStatusScriptSelect.queryFreezeStatusScriptValue = stepItem["script"];
                            $scope.model.queryFreezeStatusScriptSelect.scriptItem = stepItem["params"];
                        }
                    });
                    !_.isEmpty(filterScript) && _.extend(scriptProps, {
                        recoveryScriptInfo: _.filter(filterScript[0].steps, function(item){
                            return !_.contains(["protect-freeze","protect-thaw","protect-query"],item["position"])
                        })
                    });
                    //填充前置脚本和后置脚本参数
                    if(!_.isEmpty(filterScript)){
                        var beforeScriptObj = _.filter(filterScript[0].steps, function(item){
                            return item["position"] == "protect-before"
                        });
                        var afterScriptObj = _.filter(filterScript[0].steps, function(item){
                            return item["position"] == "protect-after"
                        });
                        var isUserSet = $("#scriptSource").widget().getSelectedId() == "host";
                        _.extend(scriptProps, {
                            beforeScript: function(){
                                if(_.isEmpty(beforeScriptObj)){
                                    return "[]";
                                };
                                return angular.toJson([beforeScriptObj[0]["script"]])
                            }(),
                            afterScript: function(){
                                if(_.isEmpty(afterScriptObj)){
                                    return "[]";
                                };
                                return angular.toJson([afterScriptObj[0]["script"]])
                            }(),
                            beforeParam: function(){
                                var param = {}
                                if(!_.isEmpty(beforeScriptObj) && !_.isEmpty(beforeScriptObj[0]["params"])){
                                    _.each(beforeScriptObj[0]["params"], function(value, key){
                                        param[key] = "";
                                    });
                                };
                                //增加脚本方案标识
                                param["isUserDefined"] = isUserSet ? "1" : "0";
                                return param;
                            }(),
                            afterParam: function(){
                                var param = {}
                                if(!_.isEmpty(afterScriptObj) && !_.isEmpty(afterScriptObj[0]["params"])){
                                    _.each(afterScriptObj[0]["params"], function(value, key){
                                        param[key] = "";
                                    });
                                };
                                //增加脚本方案标识
                                param["isUserDefined"] = isUserSet ? "1" : "0";
                                return param;
                            }()
                        })
                    };
                    $scope.model.freezeTimeout.value = filterScript[0]["freezeTimeout"];
                    //公共参数改变，由原来的key、value变为list
                    publicParamsTemp = filterScript[0]["publicParams"];
                    _.isFunction(cb) && cb();
                };
            };
            //设置用户自己定义的脚本参数
            var setScriptParams = function(params){
                var win = angular.copy(constsService.CONFIG_SCRIPT_PARAMS_WIN);
                win.data = angular.copy(params);
                win.title = appUtils.getString("protection_lun_script_config_label");
                appUtils.showWindow(win, function(){
                    if (!UnifyValid.FormValid($("#config_script_params_win"), {focusInvalid: true})) {
                        return;
                    };
                    var configParams = {};
                    var tableData = $("#scrpitParamsTable").widget().getTableData();
                    var userKey = [];
                    !_.isEmpty(tableData) && _.each(tableData, function(item){
                        configParams[item.key] = item.value;
                        userKey.push(item.key);
                    });
                    //校验用户参数自定义输入的参数key是否相同
                    if(_.uniq(userKey).length != userKey.length){
                        message.error(appUtils.getString("protection_lun_script_same_key_validate_label"));
                        return;
                    };
                    if("freeze" == params.type){
                        _.extend(scriptProps, {
                            userFreezeParam: configParams
                        });
                        $scope.model.freezeScriptSelect.userFreezeParam = configParams;
                    }else if ("thaw" == params.type){
                        _.extend(scriptProps, {
                            userUnfreezeParam: configParams
                        });
                        $scope.model.thawScriptSelect.userUnfreezeParam = configParams;
                    }else{
                        _.extend(scriptProps, {
                            userQueryParam: configParams
                        });
                        $scope.model.queryFreezeStatusScriptSelect.userQueryParam = configParams;
                    };
                    $scope.$apply();
                    $("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.winId).widget().destroy();
                });
            };
            //设置公共脚本参数
            var setPublicScriptParams = function(params){
                _.extend(params, {
                    props: angular.copy(scriptProps)
                });
                var win = angular.copy(constsService.CONFIG_SCRIPT_PARAMS_WIN);
                win.data = angular.copy(params);
                win.title = appUtils.getString("protection_lun_script_config_label");
                win.content = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/configPublicScriptParamWin.html";
                win.controller = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/configPublicScriptParamWinCtrl";
                win.width = 550;
                win.height = 410;
                appUtils.showWindow(win, function(){
                    if (!UnifyValid.FormValid($("#config_script_params_win"), {focusInvalid: true})) {
                        return;
                    };
                    var tableData = $("#scrpitParamsTable").widget().getTableData();
                    //如果折叠框关闭，也需要校验
                    if(!!_.size($(".default_show_style "))){
                        $(".default_show_style ").click();
                        if (!UnifyValid.FormValid($("#config_script_params_win"), {focusInvalid: true})) {
                            return;
                        };
                    };
                    //预置参数
                    var configParams = {};
                    //公共参数
                    var publicData = {};
                    //自定义参数
                    var customData = {};
                    //保存用户自定义的参数key
                    var customDataKey = [];
                    _.each(tableData, function(val){
                        if(val.id == "publicUuid"){
                            _.each(val.childResources, function(item0){
                                item0.changeFlag !== false && (publicData[item0.key] = item0.value);
                            });
                            _.extend(scriptProps, {
                                publicParam: publicData
                            })
                        }else{
                            _.each(val.childResources, function(item3){
                                (item3.isCustom != "true" && item3.changeFlag !== false) && (configParams[item3.key] = item3.value)
                                if(item3.isCustom == "true"){
                                    customDataKey.push(item3.key);
                                    customData[item3.key] = item3.value
                                };
                            });
                        };
                    });
                    //不允许用户添加已经存在的键
                    var publicKey = [];
                    if(!_.isEmpty(publicParamsTemp)){
                        _.each(publicParamsTemp, function(item){
                            publicKey.push(item.name);
                        })
                    };
                    var configKeyData = "freeze" == params.type ? _.keys($scope.model.freezeScriptSelect.scriptItem) : "thaw" == params.type ? _.keys($scope.model.thawScriptSelect.scriptItem) : _.keys($scope.model.queryFreezeStatusScriptSelect.scriptItem);
                    //从以前的key、value变化为现在的list
                    var configKey = [];
                    if(!_.isEmpty(configKeyData)){
                        _.each(configKeyData, function(item){
                            configKey.push(item.name);
                        });
                    };
                    if(_.uniq(customDataKey).length != customDataKey.length || _.intersection(customDataKey, configKey).length != 0 || _.intersection(customDataKey, publicKey).length != 0){
                        message.error(appUtils.getString("protection_lun_script_same_key_validate_label"));
                        return;
                    };
                    if("freeze" == params.type){
                        _.extend(scriptProps, {
                            freezeParams: configParams,
                            userFreezeParam: customData
                        });
                    }else if ("thaw" == params.type){
                        _.extend(scriptProps, {
                            unfreezeParam: configParams,
                            userUnfreezeParam: customData
                        });
                    }else{
                        _.extend(scriptProps, {
                            queryParam: configParams,
                            userQueryParam: customData
                        });
                    };
                    $scope.$apply();
                    $("#" + constsService.CONFIG_SCRIPT_PARAMS_WIN.winId).widget().destroy();
                });
            };
            //控制脚本设置是否灰化
            var checkDisable = function(){
                var enableFlag = $("#lunFreezeFlag").widget().option("checked");
                $scope.model.freezeScriptSelect.disableClick = !(enableFlag && $("#scriptType").widget().getSelectedId() != "-1");
                $scope.model.thawScriptSelect.disableClick = !(enableFlag && $("#scriptType").widget().getSelectedId() != "-1");
                $scope.model.queryFreezeStatusScriptSelect.disableClick = !(enableFlag && $("#scriptType").widget().getSelectedId() != "-1");
                $scope.$apply();
            };
            //清空脚本设置参数
            var resetScriptsConfig = function(){
                delete scriptProps.publicParam;
                delete scriptProps.freezeParams;
                delete scriptProps.unfreezeParam;
                delete scriptProps.queryParam;
                delete scriptProps.userFreezeParam;
                delete scriptProps.userUnfreezeParam;
                delete scriptProps.userQueryParam;
            };
            //重置脚本选项
            var resetScriptSelect = function(){
                appUtils.resetSelectValues("freezeScriptSelect");
                $scope.model.freezeScriptSelect.defaultSelectId = "-1";
                $scope.model.freezeScriptSelect.showClick = false;
                appUtils.resetSelectValues("thawScriptSelect");
                $scope.model.thawScriptSelect.defaultSelectId = "-1";
                $scope.model.thawScriptSelect.showClick = false;
                appUtils.resetSelectValues("queryFreezeStatusScriptSelect");
                $scope.model.queryFreezeStatusScriptSelect.defaultSelectId = "-1";
                $scope.model.queryFreezeStatusScriptSelect.showClick = false;
                $scope.$apply();
            };
            //创建保护组校验脚本参数是否有设置,必填项必须设置，否则不让其下发
            var validateScriptsParams = function(){
                if(_.isEmpty(systemScriptTemp)){
                    return false;
                };
                var selectedScheme = _.filter(systemScriptTemp, function(val){
                    return val.id == $("#scriptType").widget().getSelectedId()
                })[0];
                if(_.isEmpty(selectedScheme)){
                    return false;
                };
                //校验公共参数
                var validateFlag = true;
                var publicObj = scriptProps["publicParam"] || {};
                var freezeObj = scriptProps["freezeParams"] || {};
                var unfreezeObj = scriptProps["unfreezeParam"] || {};
                var queryObj = scriptProps["queryParam"] || {};
                _.isString(publicObj) && (publicObj = JSON.parse(publicObj));
                _.isString(freezeObj) && (freezeObj = JSON.parse(freezeObj));
                _.isString(unfreezeObj) && (unfreezeObj = JSON.parse(unfreezeObj));
                _.isString(queryObj) && (queryObj = JSON.parse(queryObj));
                if(!_.isEmpty(selectedScheme["publicParams"])){
                    for(var i = 0; i < selectedScheme["publicParams"].length; i++){
                        var key = selectedScheme["publicParams"][i]['name'];
                        if(selectedScheme["publicParams"][i]["optional"] == "false" && selectedScheme["publicParams"][i]["sensitive"] != "true" && _.isEmpty(publicObj[key])){
                            validateFlag = false;
                            break;
                        }
                    };
                };
                if(!validateFlag){
                    return validateFlag
                };
                //校验步骤参数
                var freezeParams = _.filter(selectedScheme["steps"], function(val){
                    return val.position == "protect-freeze";
                })[0];
                var unFreezeParams = _.filter(selectedScheme["steps"], function(val){
                    return val.position == "protect-thaw";
                })[0];
                var queryParams = _.filter(selectedScheme["steps"], function(val){
                    return val.position == "protect-query";
                })[0];
                if(!_.isEmpty(freezeParams["params"])){
                    for(var i = 0;i < freezeParams["params"].length; i++){
                        var key = freezeParams["params"][i]["name"];
                        if(freezeParams["params"][i]["optional"] == "false" && freezeParams["params"][i]["sensitive"] != "true" && _.isEmpty(freezeObj[key])){
                            validateFlag = false;
                            break;
                        }
                    };
                };
                if(!validateFlag){
                    return validateFlag
                };
                if(!_.isEmpty(unFreezeParams["params"])){
                    for(var i = 0;i < unFreezeParams["params"].length; i++){
                        var key = unFreezeParams["params"][i]["name"];
                        if(unFreezeParams["params"][i]["optional"] == "false" && unFreezeParams["params"][i]["sensitive"] != "true" && _.isEmpty(freezeObj[key])){
                            validateFlag = false;
                            break;
                        }
                    };
                };
                if(!validateFlag){
                    return validateFlag
                };
                if(!_.isEmpty(queryParams["params"])){
                    for(var i = 0;i < queryParams["params"].length; i++){
                        var key = queryParams["params"][i]["name"];
                        if(queryParams["params"][i]["optional"] == "false" && queryParams["params"][i]["sensitive"] != "true" && _.isEmpty(freezeObj[key])){
                            validateFlag = false;
                            break;
                        }
                    };
                };
                return validateFlag;
            };
            //保存主机信息
            var hostsInfo = [];
            var _saveHosts = function(data) {
                var hosts = [];
                if (angular.isArray(data)) {
                    data.forEach(function(item) {
                        if (item.isVirtualGroup) {
                            angular.isArray(item.childResources) && item.childResources.forEach(function(res) {
                                hosts.push({
                                    deviceSn: res.deviceSn,
                                    name: res.name,
                                    osType: res.osType
                                    });
                                });
                        }
                        else {
                            hosts.push({
                                deviceSn: item.deviceSn,
                                name: item.name + "(" + appUtils.getString("ism.drm.hostgroup") + ")",
                                osType: item.osType
                        });
                        }
                    });
                }
                return hosts;
            };
            if(scriptConfigFlag){
                restService.queryHostBySite([vm.productSiteId || infoTransferredService.get("createPgModuel", "productSiteId"), 0], function(data) {
                    hostsInfo = _saveHosts(data);
                    var hostSn = lunProps["hostOrGroupId"];
                    if(!_.isEmpty(hostSn)){
                        var currentOs = _.filter(hostsInfo, function(val){
                            return val.deviceSn == hostSn
                        })[0]["osType"];
                        restService.getPresetScrpits([hostSn], function(result){
                            //过滤操作系统类型
                            result = _.filter(result, function(val){
                                return val["os"]["platform"] == currentOs && val.id == scriptProps["scriptSchemeId"]
                            });
                            if(_.isEmpty(result)){
                                return;
                            };
                            systemScriptTemp = angular.copy(result);
                            //接口变更由原来对应的key、value改为list
                            publicParamsTemp = angular.copy(result[0].publicParams);
                            _.each(result[0].steps, function(stepItem){
                                if(stepItem["position"] == "protect-freeze"){
                                    $scope.model.freezeScriptSelect.scriptItem = stepItem["params"];
                                }
                                if(stepItem["position"] == "protect-thaw"){
                                    $scope.model.thawScriptSelect.scriptItem = stepItem["params"];
                                }
                                if(stepItem["position"] == "protect-query"){
                                    $scope.model.queryFreezeStatusScriptSelect.scriptItem = stepItem["params"];
                                }
                            });
                        })
                    };
                });
            };
            //重置配置脚本参数
            var resetHostScriptParam = function(flag){
                $scope.model.freezeScriptSelect.showClick = flag && $("#freezeScriptSelect").widget().getSelectedId() != "-1";
                $scope.model.thawScriptSelect.showClick = flag && $("#thawScriptSelect").widget().getSelectedId() != "-1";
                $scope.model.queryFreezeStatusScriptSelect.showClick = flag && $("#queryFreezeStatusScriptSelect").widget().getSelectedId() != "-1";
                $scope.$apply();
            };
            //清空自定义脚本参数配置
            var resetUserDefined = function(){
                $scope.model.freezeScriptSelect.userFreezeParam = [];
                $scope.model.thawScriptSelect.userUnfreezeParam = [];
                $scope.model.queryFreezeStatusScriptSelect.userQueryParam = [];
                delete scriptProps["userFreezeParam"];
                delete scriptProps["userUnfreezeParam"];
                delete scriptProps["userQueryParam"];
                $scope.$apply();
            };
            $scope.scriptConfigFlag = scriptConfigFlag;
            //SAN一体化备份
            var isSanHyperVault = vm.ptType == 30 || vm.ptType == 31 || vm.ptType == 32;
            //增加秒级策略(双活+快照、快照)
            var isAddSecondSchedule = _.contains([2, 19], parseInt(vm.ptType));
            isSanHyperVault && (hostOrGroupName = infoTransferredService.get("hostOrGroupNameModuel", "hostOrGroupName" + vm.schedule.protectLocation));
            $scope.model = {
                labels: {
                    hostOrGroupId: appUtils.getStringWithColon("lun_term_dataConsistentProtect_hostOrGroupId"),
                    freezeScript: appUtils.getStringWithColon("lun_term_dataConsistentProtect_freezeScript"),
                    thawScript: appUtils.getStringWithColon("lun_term_dataConsistentProtect_thawScript"),
                    queryFreezeStatusScript: appUtils.getStringWithColon("lun_term_dataConsistentProtect_queryFreezeStatusScript"),
                    freezeTimeout: appUtils.getStringWithColon("lun_term_dataConsistentProtect_freezeTimeout"),
                    scriptConfig: appUtils.getStringWithColon("protection_lun_script_config_setting_label")
                },
                lunFreezeFlag: {
                    id: "lunFreezeFlag",
                    disable: false,
                    checked: vm.schedule["appConsistent"] == 1,
                    desc: appUtils.getString("lun_term_dataConsistentProtect_lunFreezeFlag_desc"),
                    text: appUtils.getString("lun_term_dataConsistentProtect_lunFreezeFlag"),
                    blocking: appUtils.getString("blocking_script_label"),
                    thawing: appUtils.getString("thawing_script_label"),
                    queryThawing: appUtils.getString("query_thawing_script_label"),
                    change: function() {
                        _.each($scope.model, function(model) {
                            if (!_.isUndefined(model.disable) && model.id != "lunFreezeFlag") {
                                $scope.model[model.id].disable = !model.disable;
                                $scope.model[model.id].required = !model.disable;
                            }
                        });
                        $scope.model.scriptConfig.required = this.checked;
                        scriptConfigFlag && checkDisable();
                        scriptConfigFlag && resetHostScriptParam(this.checked);
                    }
                },
                hostOrGroupId: {
                    id: "hostOrGroupId",
                    defaultSelectId: _.isUndefined(lunProps["hostOrGroupId"]) ? "-1"
                        : lunProps["hostOrGroupId"],
                    values: [{
                        selectId: _.isUndefined(lunProps["hostOrGroupId"]) ? "-1"
                        : lunProps["hostOrGroupId"],
                        label: _.isUndefined(hostOrGroupName) || _.isEmpty(lunProps["hostOrGroupId"]) ? appUtils.getString("common_term_pleaseSelect_listbox"): hostOrGroupName
                    }],
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    autoOpen: false,
                    required: false,
                    width: constsService.W3,
                    openFn: function(object) {
                        restService.queryHostBySite([vm.productSiteId || infoTransferredService.get("createPgModuel", "productSiteId"), 0], function(data) {
                            hostsInfo = _saveHosts(data);
                            var hosts = _formatHosts(data);
                            appUtils.updateSelectValues("hostOrGroupId", hosts, "deviceSn", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                        });
                        object.open();
                    },
                    closeFn: function(){
                        var hostSn = $("#" + this.id).widget().getSelectedId();
                        if(hostSn == "-1"){
                            return;
                        };
                        if(scriptConfigFlag){
                           $("#scriptSource").widget().getSelectedId() == "system" && resetScriptsConfig();
                           resetScriptSelect();
                           //重置方案选择下拉框
                           appUtils.resetSelectValues("scriptType");
                           $scope.model.scriptType.defaultSelectId = "-1";
                           $scope.$apply();
                        };
                    }
                },
                scriptConfig: {
                    required: false,
                    display: scriptConfigFlag
                },
                scriptSource: {
                    id: "scriptSource",
                    defaultSelectId: (_.isEmpty(lunProps["isUserDefined"]) && _.isEmpty(lunProps["freezeScript"])) ? "host" : lunProps["isUserDefined"] != "0" ? "host" : "system",
                    width: constsService.W3,
                    values: [{
                        selectId: "system",
                        label: appUtils.getString("protection_lun_use_system_script_label")
                    },{
                        selectId: "host",
                        label: appUtils.getString("protection_lun_use_hosts_script_label")
                    }],
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    change: function(){
                        var sourceId = $("#scriptSource").widget().getSelectedId();
                        $scope.model.scriptType.show = sourceId == "system";
                        $scope.model.freezeScriptSelect.show = sourceId == "host";
                        $scope.model.thawScriptSelect.show = sourceId == "host";
                        $scope.model.queryFreezeStatusScriptSelect.show = sourceId == "host";
                        //清空自定义脚本参数配置
                        resetUserDefined();
                    },
                    closeFn: function(){
                        checkDisable();
                        resetScriptsConfig();
                    }
                },
                scriptType: {
                    id: "scriptType",
                    defaultSelectId: !_.isEmpty(lunProps["scriptSchemeId"]) ? lunProps["scriptSchemeId"] : "-1",
                    width: constsService.W3,
                    show: (_.isEmpty(lunProps["isUserDefined"]) && _.isEmpty(lunProps["freezeScript"])) ? false : lunProps["isUserDefined"] == "0" ? true : false,
                    values: [{
                        selectId: "-1",
                        label: appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    autoOpen: false,
                    openFn: function(object){
                        var hostSn = $("#hostOrGroupId").widget().getSelectedId();
                        if(hostSn == "-1"){
                            return;
                        };
                        //当前所选主机的操作系统类型
                        var currentOs = _.filter(hostsInfo, function(val){
                            return val.deviceSn == hostSn
                        })[0]["osType"];
                        restService.getPresetScrpits([hostSn], function(result){
                            //过滤操作系统类型
                            result = _.filter(result, function(val){
                                return val["os"]["platform"] == currentOs
                            });
                            systemScriptTemp = angular.copy(result);
                            var typeValues = [];
                            _.each(result, function(item, index){
                                typeValues.push({
                                    checked: index == 0,
                                    selectId: item.id,
                                    label: item["app"]["type"] + item["app"]["version"] + "|" + item["app"]["tag"][1][isEn ? "en" : "zh"] + "|" + item["app"]["tag"][0][isEn ? "en" : "zh"]
                                });
                            });
                            $("#scriptType").widget().option("values", typeValues);
                            object.open();
                            $scope.$apply();
                        })
                    },
                    closeFn: function(){
                        var selectId = $("#" + this.id).widget().getSelectedId();
                        resetScriptsConfig();
                        selectScript(selectId, checkDisable)
                    }
                },
                freezeScriptSelect: {
                    id: "freezeScriptSelect",
                    width: constsService.W3,
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    values: [{
                        selectId: !_.isEmpty(lunProps["freezeScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["freezeScript"] : "-1",
                        label: !_.isEmpty(lunProps["freezeScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["freezeScript"] : appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectId: !_.isEmpty(lunProps["freezeScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["freezeScript"] : "-1",
                    show: (_.isEmpty(lunProps["isUserDefined"]) && _.isEmpty(lunProps["freezeScript"])) ? true : lunProps["isUserDefined"] != "0" ? true : false,
                    autoOpen: false,
                    freezeScriptValue: !_.isEmpty(lunProps["freezeScript"]) && lunProps["isUserDefined"] == "0" ? lunProps["freezeScript"] : "--",
                    scrpitParam: appUtils.getString("protection_lun_script_config_label"),
                    usedScrpitParam: appUtils.getString("protection_lun_script_config_label"),
                    openFn: function(object){
                        var hostSn = $("#hostOrGroupId").widget().getSelectedId();
                        if(hostSn == "-1"){
                            object.open();
                            return;
                        };
                        restService.getCustomScrpits([hostSn], {
                            success: function(result){
                                if(!_.isEmpty(result)){
                                    var scrpitArray = [];
                                    _.each(result["scripts"], function(val, index){
                                        scrpitArray.push({
                                            selectId: index,
                                            label: val
                                        })
                                    });
                                    scrpitArray.unshift({
                                        selectId: "-1",
                                        label: appUtils.getString("common_term_pleaseSelect_listbox"),
                                        checked: true
                                    });
                                    $("#freezeScriptSelect").widget().option("values", scrpitArray);
                                    $scope.$apply()
                                };
                                object.open();
                            }
                        })
                    },
                    closeFn: function(){
                        $scope.model.freezeScriptSelect.showClick = $("#" + this.id).widget().getSelectedId() != "-1";
                        $scope.$apply();
                    },
                    disableClick: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    showClick: vm.schedule["appConsistent"] == 1 && lunProps["isUserDefined"] == "1",
                    scriptItem: [],
                    userFreezeParam: !_.isEmpty(scriptProps.userFreezeParam) ? JSON.parse(scriptProps.userFreezeParam) : [],
                    click: function(){
                        if(this.disableClick){
                            return;
                        };
                        var scripts = this.scriptItem;
                        var params = {
                            type: "freeze",
                            data: scripts,
                            publicData: publicParamsTemp
                        };
                        setPublicScriptParams(params);
                    },
                    addClick: function(){
                        var scripts = this.userFreezeParam;
                        var params = {
                            type: "freeze",
                            data: scripts
                        };
                        setScriptParams(params);
                    }
                },
                thawScriptSelect: {
                    id: "thawScriptSelect",
                    width: constsService.W3,
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    values: [{
                        selectId: !_.isEmpty(lunProps["thawScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["thawScript"] : "-1",
                        label: !_.isEmpty(lunProps["thawScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["thawScript"] : appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectId: !_.isEmpty(lunProps["thawScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["thawScript"] : "-1",
                    show: (_.isEmpty(lunProps["isUserDefined"]) && _.isEmpty(lunProps["freezeScript"])) ? true : lunProps["isUserDefined"] != "0" ? true : false,
                    autoOpen: false,
                    thawScriptValue: !_.isEmpty(lunProps["thawScript"]) && lunProps["isUserDefined"] == "0" ? lunProps["thawScript"] : "--",
                    scrpitParam: appUtils.getString("protection_lun_script_config_label"),
                    usedScrpitParam: appUtils.getString("protection_lun_script_config_label"),
                    openFn: function(object){
                        var hostSn = $("#hostOrGroupId").widget().getSelectedId();
                        if(hostSn == "-1"){
                            object.open();
                            return;
                        };
                        restService.getCustomScrpits([hostSn], {
                            success: function(result){
                                if(!_.isEmpty(result)){
                                    var scrpitArray = [];
                                    _.each(result["scripts"], function(val, index){
                                        scrpitArray.push({
                                            selectId: index,
                                            label: val
                                        })
                                    });
                                    scrpitArray.unshift({
                                        selectId: "-1",
                                        label: appUtils.getString("common_term_pleaseSelect_listbox"),
                                        checked: true
                                    });
                                    $("#thawScriptSelect").widget().option("values", scrpitArray);
                                    $scope.$apply()
                                };
                                object.open();
                            }
                        })
                    },
                    closeFn: function(){
                        $scope.model.thawScriptSelect.showClick = $("#" + this.id).widget().getSelectedId() != "-1";
                        $scope.$apply();
                    },
                    disableClick: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    showClick: vm.schedule["appConsistent"] == 1 && lunProps["isUserDefined"] == "1",
                    scriptItem: [],
                    userUnfreezeParam: !_.isEmpty(scriptProps.userUnfreezeParam) ? JSON.parse(scriptProps.userUnfreezeParam) : [],
                    click: function(){
                        if(this.disableClick){
                            return;
                        };
                        var scripts = this.scriptItem;
                        var params = {
                            type: "thaw",
                            data: scripts,
                            publicData: publicParamsTemp
                        }
                        setPublicScriptParams(params);
                    },
                    addClick: function(){
                        var scripts = this.userUnfreezeParam;
                        var params = {
                            type: "thaw",
                            data: scripts
                        };
                        setScriptParams(params);
                    }
                },
                queryFreezeStatusScriptSelect: {
                    id: "queryFreezeStatusScriptSelect",
                    width: constsService.W3,
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    values: [{
                        selectId: !_.isEmpty(lunProps["queryFreezeStatusScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["queryFreezeStatusScript"] : "-1",
                        label: !_.isEmpty(lunProps["queryFreezeStatusScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["queryFreezeStatusScript"] : appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectId: !_.isEmpty(lunProps["queryFreezeStatusScript"]) && lunProps["isUserDefined"] == "1" ? lunProps["queryFreezeStatusScript"] : "-1",
                    show: (_.isEmpty(lunProps["isUserDefined"]) && _.isEmpty(lunProps["freezeScript"])) ? true : lunProps["isUserDefined"] != "0" ? true : false,
                    autoOpen: false,
                    queryFreezeStatusScriptValue: !_.isEmpty(lunProps["queryFreezeStatusScript"]) && lunProps["isUserDefined"] == "0" ? lunProps["queryFreezeStatusScript"] : "--",
                    scrpitParam: appUtils.getString("protection_lun_script_config_label"),
                    usedScrpitParam: appUtils.getString("protection_lun_script_config_label"),
                    openFn: function(object){
                        var hostSn = $("#hostOrGroupId").widget().getSelectedId();
                        if(hostSn == "-1"){
                            object.open();
                            return;
                        };
                        restService.getCustomScrpits([hostSn], {
                            success: function(result){
                                if(!_.isEmpty(result)){
                                    var scrpitArray = [];
                                    _.each(result["scripts"], function(val, index){
                                        scrpitArray.push({
                                            selectId: index,
                                            label: val
                                        })
                                    });
                                    scrpitArray.unshift({
                                        selectId: "-1",
                                        label: appUtils.getString("common_term_pleaseSelect_listbox"),
                                        checked: true
                                    });
                                    $("#queryFreezeStatusScriptSelect").widget().option("values", scrpitArray);
                                    $scope.$apply()
                                };
                                object.open();
                            }
                        })
                    },
                    closeFn: function(){
                        $scope.model.queryFreezeStatusScriptSelect.showClick = $("#" + this.id).widget().getSelectedId() != "-1";
                        $scope.$apply();
                    },
                    disableClick: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    showClick: vm.schedule["appConsistent"] == 1 && lunProps["isUserDefined"] == "1",
                    scriptItem: [],
                    userQueryParam: !_.isEmpty(scriptProps.userQueryParam) ? JSON.parse(scriptProps.userQueryParam) : [],
                    click: function(){
                        if(this.disableClick){
                            return;
                        };
                        var scripts = this.scriptItem;
                        var params = {
                            type: "queryFreeze",
                            data: scripts,
                            publicData: publicParamsTemp
                        };
                        setPublicScriptParams(params);
                    },
                    addClick: function(){
                        var scripts = this.userQueryParam;
                        var params = {
                            type: "queryFreeze",
                            data: scripts
                        };
                        setScriptParams(params);
                    }
                },
                freezeScript: {
                    id: "freezeScript",
                    value: lunProps["freezeScript"],
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    required: false,
                    width: constsService.W3,
                    "validate": [{
                        validFn: "required"
                    }, {
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }]
                },
                thawScript: {
                    id: "thawScript",
                    value: lunProps["thawScript"],
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    required: false,
                    width: constsService.W3,
                    "validate": [{
                        validFn: "required"
                    }, {
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }]
                },
                queryFreezeStatusScript: {
                    id: "queryFreezeStatusScript",
                    value: lunProps["queryFreezeStatusScript"],
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    required: false,
                    width: constsService.W3,
                    "validate": [{
                        validFn: "required"
                    }, {
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }]
                },
                freezeTimeout: {
                    id: "freezeTimeout",
                    value: _.isUndefined(lunProps["freezeTimeout"])
                        ? 60 : lunProps["freezeTimeout"],
                    required: false,
                    disable: vm.schedule["appConsistent"] == 0 || _.isUndefined(vm.schedule["appConsistent"]),
                    unit: appUtils.getString("common_term_second_label"),
                    width: constsService.W3,
                    validate: [{
                        validFn: "required"
                    }, {
                        validFn: "integer",
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 10, 600)
                    }, {
                        validFn: "rangeValue",
                        params: [10, 600],
                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 10, 600)
                    }]
                }
            }

            //回显是否可设置应用一致性
            $scope.$on("DIABLE_SCHEDULEAPP", function(evt, disableFlag){});
            //回显lun快照选用的脚本方案名称
            if (scriptConfigFlag && !_.isEmpty(lunProps["scriptSchemeId"])) {
                restService.getPresetScrpitsBySchemeId([lunProps["scriptSchemeId"]], function(result) {
                    if (!_.isEmpty(result)) {
                        $scope.model.scriptType.values = [{
                            selectId: lunProps["scriptSchemeId"],
                            label: result["app"]["type"] + result["app"]["version"] + "|" + result["app"]["tag"][1][isEn ? "en" : "zh"] + "|" + result["app"]["tag"][0][isEn ? "en" : "zh"]
                        }];
                        $scope.$apply();
                    };
                });
            };


            $scope.$on(vm.event, function() {
                vm.valid = true;
                if (!$("#lunFreezeFlag").widget().option("checked")) {
                    if( vm.ptType == 6 || vm.ptType == 19 || isSanHyperVault) {
                        vm.schedule["appConsistent"] = 0;
                        delete lunProps["hostOrGroupId"];
                        delete lunProps["hostOrGroupName"];
                        delete lunProps["freezeScript"];
                        delete lunProps["thawScript"];
                        delete lunProps["queryFreezeStatusScript"];
                        delete lunProps["freezeTimeout"];
                    } else {
                        vm.schedule["appConsistent"] = 0;
                        delete lunProps["hostOrGroupId"];
                        delete lunProps["hostOrGroupName"];
                        delete lunProps["freezeScript"];
                        delete lunProps["thawScript"];
                        delete lunProps["queryFreezeStatusScript"];
                        delete lunProps["freezeTimeout"];
                        //Lun快照删除不需要的参数
                        if (scriptConfigFlag) {
                            delete lunProps["userFreezeParam"];
                            delete lunProps["userUnfreezeParam"];
                            delete lunProps["userQueryParam"];
                            delete lunProps["freezeParams"];
                            delete lunProps["unfreezeParam"];
                            delete lunProps["queryParam"];
                            delete lunProps["isUserDefined"];
                            delete lunProps["beforeScript"];
                            delete lunProps["afterScript"];
                            delete lunProps["publicParam"];
                            delete lunProps["scriptScheme"];
                            delete lunProps["scriptSchemeId"];
                            delete lunProps["userFreezeParam"];
                            delete lunProps["userUnfreezeParam"];
                            delete lunProps["userQueryParam"];
                            delete lunProps["beforeParam"];
                            delete lunProps["userBeforeParam"];
                            delete lunProps["afterParam"];
                            delete lunProps["userAfterParam"];
                        }
                    }
                } else {
                    if (!(vm.valid = UnifyValid.FormValid($("#LunSetting")))) {
                        vm.valid = false;
                        return
                    }

                    var hostOrGroupId = $("#hostOrGroupId").widget().getSelectedId();
                    if (hostOrGroupId == "-1") {
                        message.error(appUtils.getString("recovery.term.recovery.hostGroup.message.least"));
                        vm.valid = false;
                        return;
                    }

                    if( vm.ptType == 6 || vm.ptType == 19 || isSanHyperVault) {
                        vm.schedule["appConsistent"] = 1;
                        lunProps["hostOrGroupId"] = hostOrGroupId;
                        lunProps["freezeScript" ] = $("#freezeScript").widget().getValue();
                        lunProps["thawScript"] = $("#thawScript").widget().getValue();
                        lunProps["queryFreezeStatusScript"] = $("#queryFreezeStatusScript").widget().getValue();
                        lunProps["freezeTimeout"] = $("#freezeTimeout").widget().getValue();
                    }else {
                        vm.schedule["appConsistent"] = 1;
                        lunProps["hostOrGroupId"] = hostOrGroupId;
                        lunProps["freezeScript" ] = $("#freezeScript").widget().getValue();
                        lunProps["thawScript"] = $("#thawScript").widget().getValue();
                        lunProps["queryFreezeStatusScript"] = $("#queryFreezeStatusScript").widget().getValue();
                        lunProps["freezeTimeout"] = $("#freezeTimeout").widget().getValue();
                        //Lun快照脚本参数
                        if (scriptConfigFlag) {
                             var isUserSet = $("#scriptSource").widget().getSelectedId() == "host";
                             lunProps["isUserDefined"] = isUserSet ? "1" : "0";
                             if (isUserSet) {
                                if($("#freezeScriptSelect").widget().getSelectedId() == "-1" || $("#thawScriptSelect").widget().getSelectedId() == "-1" || $("#queryFreezeStatusScriptSelect").widget().getSelectedId() == "-1"){
                                    message.error(appUtils.getString("protection_lun_script_empty_validate_label"));
                                    vm.valid = false;
                                    return;
                                };
                                lunProps["freezeScript"] = $("#freezeScriptSelect").widget().getSelectedLabel();
                                lunProps["thawScript"] = $("#thawScriptSelect").widget().getSelectedLabel();
                                lunProps["queryFreezeStatusScript"] = $("#queryFreezeStatusScriptSelect").widget().getSelectedLabel();
                                lunProps["userFreezeParam"] = _.isString(scriptProps["userFreezeParam"]) ? scriptProps["userFreezeParam"] : JSON.stringify(scriptProps["userFreezeParam"]);
                                lunProps["userUnfreezeParam"] = _.isString(scriptProps["userUnfreezeParam"]) ? scriptProps["userUnfreezeParam"] : JSON.stringify(scriptProps["userUnfreezeParam"]);
                                lunProps["userQueryParam"] = _.isString(scriptProps["userQueryParam"]) ? scriptProps["userQueryParam"] : JSON.stringify(scriptProps["userQueryParam"]);
                                lunProps["beforeScript"] = "[]";
                                lunProps["afterScript"] = "[]";
                                lunProps["userBeforeParam"] = "{}";
                                lunProps["userAfterParam"] = "{}";
                                delete lunProps["freezeParams"];
                                delete lunProps["unfreezeParam"];
                                delete lunProps["queryParam"];
                                delete lunProps["publicParam"];
                                delete lunProps["scriptScheme"];
                                delete lunProps["scriptSchemeId"];
                                delete lunProps["beforeParam"];
                                delete lunProps["afterParam"];

                             } else {
                                if($("#scriptType").widget().getSelectedId() == "-1"){
                                    message.error(appUtils.getString("protection_lun_script_scheme_empty_validate_label"));
                                    vm.valid = false;
                                    return;
                                };
                                //校验相关脚本参数是否已设置
                                if(!validateScriptsParams()){
                                    message.error(appUtils.getString("protection_lun_please_set_script_label") + appUtils.getString("common_label_stop"));
                                    vm.valid = false;
                                    return;
                                };
                                lunProps["freezeScript"] = $scope.model.freezeScriptSelect.freezeScriptValue;
                                lunProps["thawScript"] = $scope.model.thawScriptSelect.thawScriptValue;
                                lunProps["queryFreezeStatusScript"] = $scope.model.queryFreezeStatusScriptSelect.queryFreezeStatusScriptValue;
                                //前置脚本名
                                lunProps["beforeScript"] = scriptProps["beforeScript"];
                                //后置脚本名
                                lunProps["afterScript"] = scriptProps["afterScript"];
                                //脚本方案名称
                                lunProps["scriptScheme"] = $("#scriptType").widget().getSelectedLabel();
                                //脚本方案ID
                                lunProps["scriptSchemeId"] = $("#scriptType").widget().getSelectedId();
                                //公共参数
                                lunProps["publicParam"] = _.isString(scriptProps["publicParam"]) ? scriptProps["publicParam"] : JSON.stringify(scriptProps["publicParam"]);
                                /*--------------可传入参数------------------*/
                                lunProps["freezeParams"] = _.isString(scriptProps["freezeParams"]) ? scriptProps["freezeParams"] : JSON.stringify(scriptProps["freezeParams"]);
                                lunProps["unfreezeParam"] = _.isString(scriptProps["unfreezeParam"]) ? scriptProps["unfreezeParam"] : JSON.stringify(scriptProps["unfreezeParam"]);
                                lunProps["queryParam"] = _.isString(scriptProps["queryParam"]) ? scriptProps["queryParam"] : JSON.stringify(scriptProps["queryParam"]);
                                //用户自定义冻结脚本参数
                                lunProps["userFreezeParam"] = _.isString(scriptProps["userFreezeParam"]) ? scriptProps["userFreezeParam"] : JSON.stringify(scriptProps["userFreezeParam"]);
                                //用户自定义解冻脚本参数
                                lunProps["userUnfreezeParam"] = _.isString(scriptProps["userUnfreezeParam"]) ? scriptProps["userUnfreezeParam"] : JSON.stringify(scriptProps["userUnfreezeParam"]);
                                //用户自定义查询冻结状态脚本参数
                                lunProps["userQueryParam"] = _.isString(scriptProps["userQueryParam"]) ? scriptProps["userQueryParam"] : JSON.stringify(scriptProps["userQueryParam"]);
                                //前置脚本预置参数
                                lunProps["beforeParam"] = _.isString(scriptProps["beforeParam"]) ? scriptProps["beforeParam"] : JSON.stringify(scriptProps["beforeParam"]);
                                //用户自定义前置脚本参数
                                lunProps["userBeforeParam"] = "{}";
                                //后置脚本预置参数
                                lunProps["afterParam"] = _.isString(scriptProps["afterParam"]) ? scriptProps["afterParam"] : JSON.stringify(scriptProps["afterParam"]);
                                lunProps["userAfterParam"] = "{}";
                             }
                         }
                    }
                };
            });


        }
    ];

    return ctrl;
});
