define(["tiny-common/UnifyValid"],function(UnifyValid){
	var ctrl = ["$scope","appUtils",function($scope,appUtils){
		var vm = $scope.viewModel;
		var oracleProps = vm.schedule;
		if (!oracleProps.extParameters) {
		    oracleProps.extParameters = {};
		};

		$scope.showSetting = true;
		if( !$scope.showSetting ) return;

		/***************************************
			       Oracle热备模式设置
		****************************************/

		var resource = appUtils.resource();

		var freezeKey = "appConsistent";
		var capKey = "ORACLE_CAP_THREASHOLD";

		//设置热备模式的启用与禁用(默认启用)
		var hotBackupDescMap = {
			"replication": resource.get("protection.hotbackup.replication.desc"),
			"snapshot": resource.get("protection.hotbackup.snapshot.desc"),
			"clone": resource.get("protection.hotbackup.clone.desc")
		};

		var intPtType = parseInt(vm.ptType,10);
		if( intPtType == 16 ){
			$scope.hotBackupDesc = hotBackupDescMap.clone;
		}
		else if( [2,9,19].indexOf(intPtType) != -1 ){
			$scope.hotBackupDesc = hotBackupDescMap.snapshot;
		}
		else{
			$scope.hotBackupDesc = hotBackupDescMap.replication;
		}

		var isSanHyperVault = vm.ptType == 30 || vm.ptType == 31 || vm.ptType == 32;
		//增加秒级策略(双活+快照、快照)
		var isAddSecondSchedule = _.contains([19, 2], parseInt(vm.ptType));
		var isCheckHotBackupCheckbox = !(vm.protectLocation == 0 && isSanHyperVault) && !isAddSecondSchedule;
		$scope.hotBackupCheckbox = {
			id : "hotBackupCheckbox",
			text : resource.get("ism.drm.template.schedule.isSyncCache.label"),
			checked : isCheckHotBackupCheckbox,
			disable : false,
			change : function(){
				$scope.showMinArchiveSpace = $("#hotBackupCheckbox").widget().option("checked");
			}
		};

		//设置最小归档空间的启用与禁用(默认禁用)
		$scope.showMinArchiveSpace = isCheckHotBackupCheckbox;
		$scope.minArchiveSpaceCheckbox = {
			id : "minArchiveSpaceCheckbox",
			text : resource.getWithColon("ism.drm.template.schedule.isCheckCap.label"),
			checked : false,
			change : function(){
				var enableMinArchiveSpace = $("#minArchiveSpaceCheckbox").widget().option("checked");
				$scope.minArchiveSpaceValTextbox.disable = !enableMinArchiveSpace;
				$scope.minArchiveSpaceUnitSelect.disable = !enableMinArchiveSpace;
			}
		};

		//最小归档空间值的输入框
		var minArchiveSpaceInvalidInputTip = resource.get("common_term_integer_range_tip",1,1024);
		$scope.minArchiveSpaceValTextbox =  {
			id: "minArchiveSpaceValTextbox",
			validate: "required:"+minArchiveSpaceInvalidInputTip+";integer:"+minArchiveSpaceInvalidInputTip+";minValue(1):"+minArchiveSpaceInvalidInputTip+";maxValue(1024):"+minArchiveSpaceInvalidInputTip,
			disable: true
		};

		//最小归档空间单位的下拉框
		$scope.minArchiveSpaceUnitSelect = {
			id : "minArchiveSpaceUnitSelect",
			values :[{
				selectId : "0",
				label : "MB"
			},{
				selectId : "1",
				label : "GB"
			}],
			defaultSelectid : "0",
			disable: true
		}

		//最小归档空间帮助提示
		$scope.minArchiveSpaceHelpTip = resource.get("ism.drm.template.schedule.isCheckCap.tooltip");

		init();

		//初始化
		function init(){
			if( oracleProps[freezeKey] || angular.isUndefined(oracleProps[freezeKey]) ){
				oracleProps[freezeKey] && isSanHyperVault && ($scope.hotBackupCheckbox.checked = true)
				oracleProps[freezeKey] && isAddSecondSchedule && ($scope.hotBackupCheckbox.checked = true)
				if (angular.isUndefined(oracleProps[freezeKey])) {
					$scope.showMinArchiveSpace = isCheckHotBackupCheckbox;
				} else {
				    $scope.showMinArchiveSpace = oracleProps[freezeKey];
				}
				var ORACLE_CAP_THREASHOLD = oracleProps.extParameters[capKey];
				if( ORACLE_CAP_THREASHOLD && ORACLE_CAP_THREASHOLD != "0" ){
					$scope.minArchiveSpaceCheckbox.checked = true;

					var gbVal = parseInt(ORACLE_CAP_THREASHOLD)/1024;

					$scope.minArchiveSpaceValTextbox.value = gbVal >=1 ? gbVal : ORACLE_CAP_THREASHOLD;
					$scope.minArchiveSpaceValTextbox.disable = false;

					$scope.minArchiveSpaceUnitSelect.defaultSelectid = gbVal >= 1 ? "1" : "0";
					$scope.minArchiveSpaceUnitSelect.disable = false;
				}
			}
			else{
				$scope.hotBackupCheckbox.checked = false;
				$scope.showMinArchiveSpace = false;
			}

			if(!vm.event) return;

			//数据收集触发事件
			$scope.$on(vm.event,function(){
				vm.valid = true;
				if( $scope.showMinArchiveSpace ){
					oracleProps[freezeKey] = 1;
					if( $("#minArchiveSpaceCheckbox").widget().option("checked") ){
						if( UnifyValid.FormValid($("#minArchiveSpaceValTextbox"), {focusInvalid: true}) ){
							oracleProps.extParameters[capKey] = calculateCapacity();
							vm.valid = true;
						}
						else{
							vm.valid = false;
						}
					}
					else{
						oracleProps.extParameters[capKey] = 0;
					}
				}
				else{
					oracleProps[freezeKey] = 0;
					delete oracleProps.extParameters[capKey];
				}
			});

			//回显是否可设置应用一致性
			$scope.$on("DIABLE_SCHEDULEAPP", function(evt, disableFlag){});
		}

		//计算容量以MB返回
		function calculateCapacity(){
			var ORACLE_CAP_THREASHOLD = $("#minArchiveSpaceValTextbox").widget().getValue();
			if( $("#minArchiveSpaceUnitSelect").widget().getSelectedId() == "1" ){
				ORACLE_CAP_THREASHOLD = ORACLE_CAP_THREASHOLD * 1024;
			}
			return ORACLE_CAP_THREASHOLD;
		}

	}];

	return ctrl;
});
