define([], function() {
    var ctrl = ["$scope", "appUtils", "model", "constsService", "message",
        function($scope, appUtils, Model, constsService, message) {
            $scope.vm = $scope.viewModel;
            $scope.vm1 = Model.ViewModel.create({
                data: $scope.vm.data,
                pg: $scope.vm.pg,
                titleText: appUtils.getString("protection_create_copy_storage_policy_label"),
                settingEnable: $scope.vm.settingEnable,
                settingShow: true,
                noSettingShow: true,
                valid: false,
                click: function() {
                    var that = this
                    var win = angular.copy(constsService.TARGET_STORAGE_POOL_WIN);
                    win.title = appUtils.getString("protection_create_copy_storage_policy_win_label");
                    win.data = that;
                    appUtils.showWindow(win, function() {
                        var poolData = $("#storagePoolTable").widget().getTableData();
                        var siteIdSelect = $("#drSite").widget().getSelectedId();
                        var storageIdSelect = $("#drStorage").widget().getSelectedId();
                        //校验参数
                        if ("-1" == siteIdSelect) {
                            message.error(appUtils.getString("recovery_vm_clusterMapping_recoverySite_validate"));
                            return;
                        };
                        if ("-1" == storageIdSelect) {
                            message.error(appUtils.getString("protection_create_no_storage_error_label"));
                            return;
                        };
                        var poolValid = true;
                        var validTemp = [];
                        for (var i = 0; i < poolData.length; i++) {
                            if (!_.isEmpty($("#" + poolData[i].poolId).widget())) {
                                if ($("#" + poolData[i].poolId).widget().getSelectedId() == "-1") {
                                    poolValid = false;
                                    break;
                                }
                                validTemp.push($("#" + poolData[i].poolId).widget().getSelectedId());
                                _.extend(poolData[i], {
                                    drPoolId: $("#" + poolData[i].poolId).widget().getSelectedId(),
                                    drPoolName: $("#" + poolData[i].poolId).widget().getSelectedLabel()
                                })
                            }
                        };
                        if (!poolValid) {
                            message.error(appUtils.getString("protection_create_no_pool_error_label"));
                            return;
                        };
                        //一个灾备存储池只能对应一个生产存储池
                        if(_.size(validTemp) != _.size(_.uniq(validTemp))){
                            message.error(appUtils.getString("protection_fsb_same_drPool_error_label"));
                            return;
                        };
                        $scope.poolTable.data = appUtils.encodeForHTML(angular.copy(poolData));
                        $scope.drSiteValue = $("#drSite").widget().getSelectedLabel();
                        $scope.drStorageValue = $("#drStorage").widget().getSelectedLabel();
                        //保存资源池映射信息
                        _.extend(that, {
                            drSiteId: siteIdSelect,
                            drStorageId: storageIdSelect,
                            drStorageValue: $("#drStorage").widget().getSelectedLabel(),
                            poolMapping: angular.copy(poolData)
                        });
                        $scope.noSetting = false;
                        $scope.vm1.noSettingShow = false;
                        that.valid = true;
                        $("#" + constsService.TARGET_STORAGE_POOL_WIN.winId).widget().destroy();
                        $scope.$apply();
                    });
                }
            });
            $scope.title1 = {
                policyTitle: appUtils.getString("protection_create_copy_storage_policy_label"),
                policyDesc: " "
            };
            $scope.title2 = {
                policyTitle: appUtils.getString("ism.drm.protect.group.template"),
                policyDesc: " "
            };
            $scope.isCreatePgFlag = $scope.vm.createFlag;
            $scope.view = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html";
            $scope.ctrl = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl";
            $scope.vm2 = Model.ViewModel.create({
                data: $scope.vm.data,
                pg: $scope.vm.pg,
                ok: $scope.vm.ok,
                createFlag: $scope.vm.createFlag,
                poListIds: $scope.vm.poListIds,
                settingEnable: $scope.vm.settingEnable,
                settingTitle: appUtils.getString("protection.copyrate.policy.label")
            });
            $scope.labelCls = {
                drSite: appUtils.getStringWithColon("site_term_remotesite_label"),
                drStorage: appUtils.getStringWithColon("protection_create_dr_storage_select_label")
            };
            $scope.noSetting = true;
            $scope.poolTable = {
                id: "poolResourceTable",
                data: [],
                enablePagination: false,
                columns: [{
                    "sTitle": appUtils.getString("protection_create_product_pool_label"),
                    "mData": "poolName",
                    "bSortable": false,
                    "sWidth": "25%"
                }, {
                    "sTitle": "",
                    "mData": "",
                    "bSortable": false,
                    "sWidth": "18%"
                }, {
                    "sTitle": appUtils.getString("protection_create_dr_pool_label"),
                    "mData": "drPoolName",
                    "bSortable": false,
                    "sWidth": "25%"
                }],
                renderRow: function(nRow, aData, iDataIndex) {
                    var imgHtml = "<div><img src='/theme/recoverydirector/images/resourceMapping/quickStart/arrow.png'></div>";
                    $("td:eq(1)", nRow).html(imgHtml);
                },
                drawCallback: function() {
                    $("#poolResourceTable .tiny-th-content").eq(0).children('div').removeClass("tiny-th-vertival-line");
                }
            };
            //创建保护组
            if ($scope.vm.createFlag) {
                $scope.$on($scope.vm.event, function() {
                    $scope.vm.valid = $scope.vm1.valid && $scope.vm2.valid;
                    var props = $scope.vm2.data.props;
                    var mappingProps = {};
                    _.each($scope.vm1.poolMapping, function(val){
                        mappingProps[val.poolId] = val.drPoolId
                    });
                    _.extend($scope.vm.pg.props, {
                        storagePoolMapping: JSON.stringify([{
                            srcDevSN: $scope.vm1.poolMapping[0].devSn,
                            tgtDevSN: $scope.vm1.drStorageId,
                            storagePools: mappingProps
                        }])
                    });
                    $scope.vm.data.schedules = $scope.vm2.data.schedules;
                    $scope.vm.data.props = props;
                    $scope.$apply();
                });
            }
            setTimeout(function() {
                var linkDesc = appUtils.getString("protection_object_task_setVolumnWhenNoneExist_des_label");
                $("#setStorageSpanId").html(linkDesc);
            }, 0)
        }
    ];

    return ctrl;
})
