define([], function() {
    "use strict";
    var ctrl = ["$scope", "appUtils", "constsService", "restService", "message", "model",
        function($scope, appUtils, constsService, restService, message, Model) {
            $scope.mountConfig = $scope.viewModel;
            $scope.noSetting = true;
            $scope.mountConfig.noSettingShow = true;
            $scope.mountPolicyText = appUtils.getStringWithColon("protection_auto_mount_label");
            var is_start_db = _.isObject($scope.mountConfig.pg) && _.contains([1,2,3,16], parseInt($scope.mountConfig.pg.poType, 10));
            $scope.isVmware = _.isObject($scope.mountConfig.pg) && _.contains([10], parseInt($scope.mountConfig.pg.poType, 10));
            //快照、双活+快照升级以后，挂载策略默认禁用
            if(!$scope.mountConfig.createFlag && !_.isUndefined($scope.mountConfig.data.props) && _.isUndefined($scope.mountConfig.data.props.AUTOMOUNTCONFIGS)){
                $scope.mountConfig.data.props.AUTOMOUNTCONFIGS = JSON.stringify({enabled: false});
            };
            var _init = function(autoMountConfigs) {
                if (_.isEmpty(autoMountConfigs)) {
                    return;
                } else {
                    $scope.noSetting = false;
                    $scope.mountConfig.noSettingShow = false;
                    $scope.mountConfig.valid = true;
                    $scope.enableMount = autoMountConfigs.enabled;
                    $scope.enableMountTitle = $scope.enableMount ? appUtils.getString("alarm_term_enable_label") : appUtils.getString("alarm_term_disable_label");
                    $scope.mountConfigs = [];
                    if (autoMountConfigs.enabled) {
                        _.each(autoMountConfigs.mountConfigs, function(val) {
                            restService.queryLocalServer([],function(server){
                                if( _.isObject(server) ){
                                    restService.querySites(server.uuid,function(sites){
                                        var useSite = _.filter(sites, function(siteVal){
                                            return siteVal.siteId == val.siteId
                                        });
                                        //查询站点、主机，获取站点、主机名称
                                        !$scope.isVmware && restService.queryHostBySite([val.siteId, 0], function(data) {
                                            if (!_.isEmpty(data)) {
                                                var hosts = Model.util.formatHosts(data);
                                                var useHost = _.filter(hosts, function(hostVal){
                                                    return hostVal.deviceSn == val.hostOrGroupSn
                                                });
                                                var config = {
                                                    mountTime: appUtils.getString("protection_mount_configs_label",val.startTime + "-" + val.endTime, useSite[0].name, useHost[0].name),
                                                    isUnmountPreviousCopy: val.unmountPreviousCopy ? appUtils.getString("common_term_enable_label") : appUtils.getString("common_term_disable_label"),
                                                    isUnmountPreviousChecked: val.unmountPreviousCopy,
                                                    isUnmountDeleteCopyChecked: val.deleteReplica,
                                                    isUnmountDeleteCopy: val.deleteReplica ? appUtils.getString("common_term_enable_label") : appUtils.getString("common_term_disable_label"),
                                                    isDateBase: is_start_db,
                                                    startDbChecked: val.startDB,
                                                    isStartDateBase: val.startDB ? appUtils.getString("common_term_enable_label") : appUtils.getString("common_term_disable_label"),
                                                    preScriptName: function() {
                                                        var pre = _.filter(val.processors, function(item) {
                                                            return item.procName == "mountPreProcessor"
                                                        });
                                                        if (_.isEmpty(pre)) {
                                                            return "--"
                                                        };
                                                        return pre[0].props.scriptName;
                                                    }(),
                                                    postScriptName: function() {
                                                        var pre = _.filter(val.processors, function(item) {
                                                            return item.procName == "mountPostProcessor"
                                                        });
                                                        if (_.isEmpty(pre)) {
                                                            return "--"
                                                        };
                                                        return pre[0].props.scriptName;
                                                    }()
                                                };
                                                $scope.mountConfigs.push(config);
                                                $scope.$apply();
                                            }
                                        })
                                        //vmware一体化备份
                                        if($scope.isVmware){
                                            var extParameters = val.extParameters;
                                            _.isString(extParameters) && (extParameters = JSON.parse(extParameters));
                                            _.isString(extParameters.testHosts) && (extParameters.testHosts = JSON.parse(extParameters.testHosts));
                                            _.isString(extParameters.testNetwork) && (extParameters.testNetwork = JSON.parse(extParameters.testNetwork));
                                            var config = {
                                                mountTime: val.startTime + "-" + val.endTime + appUtils.getString("protection_mount_configs_policy_label") + ":",
                                                productSite: useSite[0].name,
                                                vCenter: extParameters.testHosts[0].remoteVcenterName,
                                                cluster: extParameters.testHosts[0].remoteHostName,
                                                network: extParameters.testNetwork,
                                                isUnmountPreviousCopy: val.unmountPreviousCopy ? appUtils.getString("common_term_enable_label") : appUtils.getString("common_term_disable_label"),
                                                isUnmountPreviousChecked: val.unmountPreviousCopy,
                                                isUnmountDeleteCopyChecked: val.deleteReplica,
                                                isUnmountDeleteCopy: val.deleteReplica ? appUtils.getString("common_term_enable_label") : appUtils.getString("common_term_disable_label"),
                                                startVMChecked: val.startDB,
                                                isStartVM: val.startDB ? appUtils.getString("common_term_enable_label") : appUtils.getString("common_term_disable_label")
                                            };
                                            $scope.mountConfigs.push(config);
                                            $scope.$apply();
                                        }
                                    });
                                }
                            });
                        });
                    };
                };
            };
            $scope.$on("SET_MOUNT_POLICY", function(evt, configs) {
                var autoMountConfigs = angular.copy(configs);
                $scope.mountConfig.data.props['AUTOMOUNTCONFIGS'] = JSON.stringify(autoMountConfigs);
                _init(autoMountConfigs);
                $scope.$apply();
            });
            $scope.text = {
                enableLabel: appUtils.getStringWithColon("protection_unmount_previous_copy_label"),
                preScriptLabel: appUtils.getStringWithColon("protection_pre_script_label"),
                postScriptLabel: appUtils.getStringWithColon("protection_post_script_label"),
                enableDelCopyLabel: appUtils.getStringWithColon("protection_delete_copy_postvious_unmount_label"),
                startDateBase: appUtils.getStringWithColon("protection_startDb_after_mount_label"),
                siteLable: appUtils.getStringWithColon("common_term_remoteSite_label"),
                vcenterLable: appUtils.getStringWithColon("common.term.vCenter.tab"),
                clusterLable: appUtils.getStringWithColon("resource_mapping_cluster"),
                networkLable: appUtils.getStringWithColon("resource_mapping_network"),
                startVM: appUtils.getStringWithColon("protection_startVM_after_mount_label")
            };
            (!_.isEmpty($scope.mountConfig.data.props) && !_.isEmpty($scope.mountConfig.data.props['AUTOMOUNTCONFIGS'])) && _init(JSON.parse($scope.mountConfig.data.props['AUTOMOUNTCONFIGS']));
            setTimeout(function() {
                var linkDesc = appUtils.getString("protection_object_task_setVolumnWhenNoneExist_des_label");
                $("#setMountSpanId").html(linkDesc);
            }, 0)
        }
    ]
    return ctrl;
})
