define([],
    function() {
        var ctrl = ["$scope", "appUtils", "constsService", "restService", "model", "$timeout", "infoTransferredService", "cookieService", "message", function($scope, appUtils, Consts, Rest, Model, $timeout, infoTransferredService, cookieService, message) {
            var resource = appUtils.resource();
            $scope.Consts = Consts;

            $scope.vm = $scope.viewModel;
            $scope.vm.settingShow = appUtils.checkRight("ism.drm.protectgroup.auth.modify");
            $scope.vm.click = openScheduleWin;
            var closeCallback = $scope.vm.closeCallback;

            var pt = $scope.vm.data;
            var pg = $scope.vm.pg;
            var schedules = pt.schedules;


            var scheduleName;
            var scheduleNameText;
            var copyRate;
            //双活+同步环形3DC
            var isSyncAndAsyncRing = false;
            //环形3dc
            var ringSiteStorage = $scope.vm.ringSiteStorage || {};
            function getRingCopyRate(siteId){
                var syncRateRecords = $scope.displaySchedule.replicationSpeedPolicies;
                if( syncRateRecords && _.isString(syncRateRecords) ){
                    syncRateRecords = JSON.parse(syncRateRecords);
                }

                if( _.isArray(syncRateRecords) && syncRateRecords.length != 0 ){
                    var lastLevel;
                    var stage = [];
                    var item = {};

                    var filterData = _.filter(syncRateRecords,function(record){
                        return record.storageSn == siteId;
                    })
                    if( _.isArray(filterData) && filterData.length != 0 ){
                        filterData.forEach(function(record){
                            if(lastLevel != record.syncRateLevel){
                                item.startTime = record.startTime;
                                item.endTime = record.endTime;
                                item.syncRateLevel = record.syncRateLevel;
                                stage.push(angular.copy(item));

                                lastLevel = record.syncRateLevel;
                            }
                            else{
                                item.endTime = record.endTime;
                            }
                        });

                        var rateStr = "";
                        stage.forEach(function(record){
                            rateStr += record.startTime + "-" + record.endTime + "(" + rateMap[record.syncRateLevel] + ")   ";
                        });
                        return rateStr;
                    }
                    else{
                        return resource.get("protection.copyrate.default.config");
                    }
                }
                else{
                    return resource.get("protection.copyrate.default.config");
                }
            };

            var rateMap = {
                1 : resource.get("protection.copyrate.low"),
                2 : resource.get("protection.copyrate.mid"),
                3 : resource.get("protection.copyrate.high"),
                4 : resource.get("protection.copyrate.extremely.high"),
            };

            infoTransferredService.put("createPgModuel", "productSiteId", pg.productSiteId);

            $scope.text = {
                startAt: resource.getWithColon("ism.drm.drp.time.start"),
                endAt: resource.getWithColon("ism.drm.drp.time.end"),
                excutionPeriod: resource.getWithColon("ism.drm.protect.policy.period"),
                periodExclude: resource.getWithColon("ism.drm.protectpolicy.schedule.period.exclude.label"),
                execPoint: resource.getWithColon("ism.drm.protectpolicy.schedule.execPoint.label"),
                policy: resource.getWithColon("protection.term.exeHistory.label"),
                manualPolicy: resource.get("protection.term.exeHistory.value.manual.value"),
                manualPolicyDesc: resource.get("protection.term.exeHistory.value.manual.des.label"),
                noSet: resource.get("site.term.isSetted.value"),
                abortTaskTimeLabel: resource.getWithColon("protection_object_task_setTimePolicy_para_forceStop_label"),
                rpoLabel: resource.getWithColon("protection_term_rpo_policy_label"),
                ringRateTitle: resource.get("protection.copyrate.label"),
                splitLabel: resource.getWithColon("protection_term_clone_split_lable"),
                createSnapLabel: resource.getWithColon("protection_term_clone_split_fail_create_snap"),
                snapTypeTitle: resource.getWithColon("protection_create_snapshot_type_label"),
                storageRespoTitle: resource.getWithColon("pg_create_backuprespo_label"),
                offlineTransferTitle: resource.getWithColon("pg_create_enableofflinetransfer_label"),
                dataLayoutTitle: resource.getWithColon("pg_create_datalayout_label")
            };

            $scope.top = "top";

            var weekMap = {
                1: "ism.drm.protectpolicy.schedule.week1",
                2: "ism.drm.protectpolicy.schedule.week2",
                3: "ism.drm.protectpolicy.schedule.week3",
                4: "ism.drm.protectpolicy.schedule.week4",
                5: "ism.drm.protectpolicy.schedule.week5",
                6: "ism.drm.protectpolicy.schedule.week6",
                7: "ism.drm.protectpolicy.schedule.week7"
            };

            $scope.setSpanId = "setSpanId";
            $scope.showAbortTaskTime = false;
            $scope.showRpoLabel = false;
            //LUN克隆
            $scope.isLunCloneBcv = pg.poType == 11 && pt.type == 16;
            //CDM 一体化备份，双活+一体化备份，一体化备份+双活
            var isSanHyperVault = _.contains([30,31,32], parseInt(pt.type, 10));
            //回显快照类型
            $scope.showSnapType = (isSanHyperVault || pt.type == 19 || pt.type == 2) && !_.isUndefined($scope.vm.scheduleData) && $scope.vm.scheduleData.protectedType != 101;
            //如果是cdm复制端、云备份，不需要显示快照类型
            $scope.vm.cdmDuplicate && ($scope.showSnapType = false);

            if ($scope.vm._3dc || (!_.isUndefined($scope.vm.scheduleData) && $scope.vm.scheduleData.protectedType == 101) || $scope.vm.cdmDuplicate) {
                $scope.setSpanId += $scope.vm._3dc;

                $scope.$watch("vm.scheduleNameText", function(newVal) {
                    if (!newVal) return;
                    scheduleNameText = newVal;
                });

                $scope.$watch("vm.scheduleName", function(newVal) {
                    if (!newVal) return;
                    scheduleName = newVal;
                });

                $scope.$watch("vm.scheduleData", function(newVal) {
                    if (!newVal) return;
                    $scope.vm.scheduleData = newVal;
                });
                //保护站点
                $scope.$watch("vm.sourceSiteId", function(newVal) {
                    if (!newVal) return;
                    $scope.vm.sourceSiteId = newVal;
                });
                //恢复站点
                $scope.$watch("vm.targetSiteId", function(newVal) {
                    if (!newVal) return;
                    $scope.vm.targetSiteId = newVal;
                });

                //3dc需要两个作用域,通过schedule.protectLocation判断,A(0);A-B(1);A-C(2);B-C(3);B(4);
                //双活+快照和一体化备份复用3dc逻辑A(0),B(4);
			var ABLocType = [] , otherLocType = [];
                schedules.forEach(function(sc) {
                    if (sc.protectLocation == 1 || sc.protectLocation == 0) {
                        //CDM需要特殊处理
                        if(isSanHyperVault){
                            sc.protectLocation == 0 && ABLocType.push(sc);
                            sc.protectLocation == 1 && otherLocType.push(sc);
                        }else{
                            ABLocType.push(sc);
                        }
                    } else {
                        otherLocType.push(sc);
                    }
                });
                //相同protectLocation同时存在自动和手动的情况,去掉手动
                if (ABLocType.length > 1) {
                    var scheduleId = "";
                    ABLocType.forEach(function(item) {
                        if (item.scheduleMode == 1) {
                            scheduleId = item.scheduleId;
                        }
                    });
                    appUtils.removeItemFromArray(ABLocType, "scheduleId", scheduleId);
                    appUtils.removeItemFromArray(schedules, "scheduleId", scheduleId);
                }

                if (otherLocType.length > 1) {
                    var scheduleId = "";
                    otherLocType.forEach(function(item) {
                        if (item.scheduleMode == 1) {
                            scheduleId = item.scheduleId;
                        }
                    });
                    appUtils.removeItemFromArray(otherLocType, "scheduleId", scheduleId);
                    appUtils.removeItemFromArray(schedules, "scheduleId", scheduleId);
                }

                //针对openstack的异步复制
                if (pt.type == "22" && ABLocType.length != 0) {
                    $scope.vm._3dc = 1;
                }

                $scope.schedule = $scope.vm._3dc == "1" ? ABLocType[0] : otherLocType[0];
                !_.isEmpty($scope.vm.scheduleData) && ($scope.schedule = $scope.vm.scheduleData);
                $scope.firstScheduleId = $scope.vm._3dc == "1";

                if (!$scope.vm.createFlag && pt.type != 17 && pt.type != 19 && pt.type != 28 && pt.type != 30 && pt.type != 31 && pt.type != 32) {
                    $scope.vm.titleText = getScheduleTitle($scope.schedule);
                };
                //同步+异步环形3DC
                if (pt.type == 3 || pt.type == 5) {
                    getScheduleTitle($scope.schedule);
                };
		}
		else{
                //取策略模版,自动策略模版优先(scheduleMode=0为自动)
                $scope.schedule = appUtils.getItemFromArray(schedules, "scheduleMode", "0") || schedules[0];
                !_.isEmpty($scope.vm.scheduleData) && ($scope.schedule = $scope.vm.scheduleData);
                if (pt.type == "3" || pt.type == "5") {
                    if ($scope.vm.titleText) {
                        scheduleName = $scope.vm.scheduleName;
                        scheduleNameText = $scope.vm.scheduleNameText;
    	    	}
    	    	else{
                        $scope.vm.titleText = getScheduleTitle($scope.schedule);
                    }
                }else if(pt.type == "26" || pt.type == "27"){
                    if(!$scope.vm.titleText){
                        getScheduleTitle($scope.schedule);
                    }
                }
            }
            //快照模板类型，查询所用存储信息Sn，暂时注释，真实环境需要取消注释
            if (_.contains([2, 30, 31, 32], parseInt(pt.type, 10))) {
                if ($scope.vm.createFlag) {
                    pt.type == 2 && Rest.getScheduleSiteInfo([pg.poType, pt.uuid], {
                        data: $scope.vm.poListIds,
                        isShowMsgBox: false,
                        success: function(result) {
                            if (!_.isEmpty(result)) {
                                $scope.schedule.sourceSn = result[0].detail.protectedStorageSN;
                                $scope.schedule.sourceSiteId = result[0].detail.protectedSiteId;
                                $scope.schedule.targetSn = result[0].detail.protectedStorageSN;
                                $scope.schedule.targetSiteId = result[0].detail.protectedSiteId;
                                infoTransferredService.put("getStorageSnModuel", "usedStorageSn", result[0].detail.protectedStorageSN);
                            };
                        }
                    });
                } else {
                    //先查询保护对象poList
                    Rest.queryProtectObjectsByPage({
                        protectgroupId: pg.uuid,
                        _PAGE: appUtils.queryFilter(0, 10000)
                    }, {
                        mask: false,
                        success: function(result) {
                            $scope.copyPolist = result.records;
                            if (!_.isEmpty(result) && !_.isEmpty(result.records) && pt.type == 2) {
                                //查询保护路径
                                Rest.getScheduleSiteInfo([pg.poType, pt.uuid], {
                                    data: result.records,
                                    isShowMsgBox: false,
                                    success: function(data) {
                                        if (!_.isEmpty(data)) {
                                            $scope.schedule.sourceSn = data[0].detail.protectedStorageSN;
                                            $scope.schedule.sourceSiteId = data[0].detail.protectedSiteId;
                                            $scope.schedule.targetSn = data[0].detail.protectedStorageSN;
                                            $scope.schedule.targetSiteId = data[0].detail.protectedSiteId;
                                        }
                                    }
                                });
                            };
                        }
                    })
                }
            };
            //获取系统的时间
            function formatTimeUnit(unit) {
                if (unit < 10) {
                    return "0" + unit;
                }
                return unit;
            };
            var getSystemTime = function(callback) {
                Rest.getSystemTime([], function(systemtime) {
                    var systemDate = appUtils.convertString2Date(systemtime.time);
                    var minDate = new Date(300000 + systemDate.getTime());

                    var minDateStr = minDate.getFullYear() + "-" +
                        formatTimeUnit((minDate.getMonth() + 1)) + "-" +
                        formatTimeUnit(minDate.getDate()) + " " +
                        formatTimeUnit(minDate.getHours()) + ":" +
                        formatTimeUnit(minDate.getMinutes()) + ":" +
                        formatTimeUnit(minDate.getSeconds());
                    _.isFunction(callback) && callback(minDateStr);
                });
            };
            //云备份离线传输修改
            $scope.vm.enableClick = function(){
                message.tipPrompt({
                    content: appUtils.getString("pg_cloudbackup_enable_offline_warn_label"),
                    ok: function(){
                        getSystemTime(function(sysTime){
                            _.extend($scope.schedule.extParameters, {
                                offlineTransferStatus: 1
                            });
                            //自动执行替换开始时间
                            if($scope.schedule.scheduleMode == 0){
                                _.extend($scope.schedule, {
                                    startTime: sysTime
                                });
                            };
                            Rest.modifyPgSchedule([pg.uuid, $scope.schedule.scheduleId], {
                                data: $scope.schedule,
                                success: function(){
                                    message.prompt({
                                        content: appUtils.getString("common_term_operationsyn_success_label"),
                                        ok: function() {
                                            _.isFunction($scope.vm.ok) && $scope.vm.ok();
                                        }
                                    });
                                }
                            });
                        });
                    }
                });
            };
            $scope.vm.pauseClick = function(){
                message.tipPrompt({
                    content: appUtils.getString("pg_cloudbackup_pause_offline_warn_label"),
                    ok: function(){
                        getSystemTime(function(sysTime){
                            _.extend($scope.schedule.extParameters, {
                                offlineTransferStatus: 2
                            });
                            //自动执行替换开始时间
                            if($scope.schedule.scheduleMode == 0){
                                _.extend($scope.schedule, {
                                    startTime: sysTime
                                });
                            };
                            Rest.modifyPgSchedule([pg.uuid, $scope.schedule.scheduleId], {
                                data: $scope.schedule,
                                success: function(){
                                    message.prompt({
                                        content: appUtils.getString("common_term_operationsyn_success_label"),
                                        ok: function() {
                                            _.isFunction($scope.vm.ok) && $scope.vm.ok();
                                        }
                                    });
                                }
                            });
                        });
                    }
                });
            };
            $scope.vm.disableClick = function(){
                message.warn({
                    content: appUtils.getString("pg_cloudbackup_disable_offline_warn_label"),
                    ok: function(){
                        getSystemTime(function(sysTime){
                            _.extend($scope.schedule.extParameters, {
                                offlineTransferStatus: 0
                            });
                            //自动执行替换开始时间
                            if($scope.schedule.scheduleMode == 0){
                                _.extend($scope.schedule, {
                                    startTime: sysTime
                                });
                            };
                            Rest.modifyPgSchedule([pg.uuid, $scope.schedule.scheduleId], {
                                data: $scope.schedule,
                                success: function(){
                                    message.prompt({
                                        content: appUtils.getString("common_term_operationsyn_success_label"),
                                        ok: function() {
                                            _.isFunction($scope.vm.ok) && $scope.vm.ok();
                                        }
                                    });
                                }
                            });
                        });
                    }
                });
            };
            try {
                init();
            } catch (err) {}

            function init() {

                $scope.autoShow = false;
                $scope.manualShow = false;
                $scope.noSettingShow = false;
                $scope.vm.noSettingShow = false;
                //云备份的相关参数展示
                $scope.showCloudBackup = _.contains([2,19,30,31,32], parseInt(pt.type, 10)) && $scope.schedule.protectedType == 101;
                $scope.enableOfflineTransfer = !_.isUndefined($scope.schedule.extParameters) && !_.isUndefined($scope.schedule.extParameters.offlineTransferStatus);
                //云备份的离线传输功能
                $scope.vm.isEnableOffLineTransfer = _.contains([2,19,30,31,32], parseInt(pt.type, 10)) && $scope.schedule.protectedType == 101 && !_.isEmpty($scope.schedule.scheduleId) && $scope.schedule.enable && !_.isUndefined($scope.schedule.extParameters) && !_.isUndefined($scope.schedule.extParameters.offlineTransferStatus);
                //环形3dc的syncRate
                $scope.showRingRate = pt.type == "26" || pt.type == "27" || isSyncAndAsyncRing;
                $scope.displaySchedule = angular.copy($scope.schedule) || {};
                //CDM和双活+快照
                if($scope.showSnapType){
                    $scope.snapShotType = $scope.displaySchedule.protectedType == 100 ? "HyperCDP" : appUtils.getString("vis.snap.name");
                }

                if (angular.isNumber($scope.displaySchedule.startTime)) {
                    $scope.displaySchedule.startTime = appUtils.convertDate2String($scope.displaySchedule.startTime-window.timezoneOffset);
                }
                if (angular.isNumber($scope.displaySchedule.endTime)) {
                    $scope.displaySchedule.endTime = appUtils.convertDate2String($scope.displaySchedule.endTime-window.timezoneOffset);
                }

                //秒级不用展示开始时间、结束时间
                $scope.hideStartTime = $scope.displaySchedule.scheduleMode == "0" && $scope.displaySchedule.periodType == "5";

                $scope.displayProps = angular.copy(_.pick(pt.props, "AUTOMOUNTCONFIGS", "storagePoolMapping", "VIS_CACHE", "CLONE_SPLIT", "COPYRATEVALUE", "COMPRESSION", "ENTRYPTION", "COPYRATE", "FS_Snap_Restore_Num"));

                //云备份的相关参数展示
                if (!_.isEmpty($scope.displaySchedule.extParameters)) {
                    $scope.storageRespo = $scope.displaySchedule.extParameters.repositoryName;
                    if ($scope.enableOfflineTransfer) {
                        $scope.offlineTransfer = $scope.displaySchedule.extParameters.offlineTransferStatus == 1 ? appUtils.getString("common_term_enable_label") : $scope.displaySchedule.extParameters.offlineTransferStatus == 0 ? appUtils.getString("common_term_disable_label") : appUtils.getString("ism.drm.protect.group.stop.label");
                    };
                    $scope.dataLayout = $scope.displaySchedule.extParameters.dataLayout == 0 ? appUtils.getString("common_term_status_normal_label") : appUtils.getString("pg_create_datalayoutcompress_label");
                };
                //离线传输按钮状态
                if ($scope.enableOfflineTransfer) {
                    $scope.vm.enableSetting = $scope.vm.settingEnable && _.contains([0], parseInt($scope.displaySchedule.extParameters.offlineTransferStatus));
                    $scope.vm.pauseSetting = $scope.vm.settingEnable && _.contains([1], parseInt($scope.displaySchedule.extParameters.offlineTransferStatus));
                    $scope.vm.disableSetting = $scope.vm.settingEnable && _.contains([2], parseInt($scope.displaySchedule.extParameters.offlineTransferStatus));
                };
                //日、月、周保留策略和最新副本保留策略

                //数据结构改变，需要从schedule里面获取
                if(!_.isEmpty($scope.displaySchedule.retentionPolicy)){
                     var policyProps = $scope.displaySchedule.retentionPolicy;
                     for(key in policyProps){
                         if(policyProps.hasOwnProperty(key)){
                             $scope.displayProps[key] = policyProps[key];
                         }
                     }
                };
                //schedule的extParameters扩展参数
                if(!_.isEmpty($scope.displaySchedule.extParameters)){
                    var extProps = $scope.displaySchedule.extParameters;
                    for(key in extProps){
                        if(extProps.hasOwnProperty(key)){
                            $scope.displayProps[key] = extProps[key];
                        }
                    }
                    delete $scope.displayProps.dataLayout;
                    delete $scope.displayProps.retryEnable;
                    delete $scope.displayProps.repositoryName;
                    delete $scope.displayProps.retry;
                    delete $scope.displayProps.retryDuration;
                    delete $scope.displayProps.offlineTransferStatus;
                };
                //数据结构改变,从schedule中获取
                $scope.showRpoLabel = _.isUndefined($scope.displaySchedule.enableRpoCheck) ? false : $scope.displaySchedule.enableRpoCheck;
                if(!_.isEmpty($scope.displaySchedule.expectedRPO)){
                    day = $scope.displaySchedule["expectedRPO"].day + (appUtils.isEn() ? " " : "") + appUtils.getString("ism.drm.protectpolicy.schedule.type.day");
                    hour = $scope.displaySchedule["expectedRPO"].hour + (appUtils.isEn() ? " " : "") + appUtils.getString("ism.drm.protectpolicy.schedule.type.hour");
                    minute = $scope.displaySchedule["expectedRPO"].minute + appUtils.getString("ism.drm.protectpolicy.schedule.type.minute");
                    $scope.rpoValue = day + (appUtils.isEn() ? " " : "") + hour + (appUtils.isEn() ? " " : "") + minute;
                };

                if (!$scope.displaySchedule || angular.isUndefined($scope.displaySchedule.scheduleMode)) {
                    $scope.noSettingShow = true;
                    if (!$scope.displaySchedule) {
                        $scope.vm.noSettingShow = true;
                    } else {
                        $scope.vm.noSettingShow = $scope.displaySchedule.enable !== true;
                    };
                    $timeout(createSetScheduleLink);
                } else {
                    if ($scope.displaySchedule.scheduleMode == 1) {
                        $scope.manualShow = true;
                    } else {
                        $scope.autoShow = true;
                    }
                    //备份未启用的场景
                    $scope.vm.noSettingShow = $scope.displaySchedule.enable === false;
                }

                if ($scope.vm.createFlag) {
                    $scope.vm.valid = !$scope.noSettingShow;
                }

                /*
				ng-repeat对象遍历默认按字典排序,所以需要给热备空间(ORACLE_FREEZE_FLAG)和归档空间(ORACLE_CAP_THREASHOLD)加前缀排序
			*/

                //oracle归档空间需要排在热备模式之后且相邻
                //ORACLE_FREEZE_FLAG    -> A_ORACLE_FREEZE_FLAG
                //ORACLE_CAP_THREASHOLD -> B_ORACLE_CAP_THREASHOLD
                var freezeKey = "ORACLE_FREEZE_FLAG";
                var sortFreezeKey = "A_ORACLE_FREEZE_FLAG";
                var capKey = "ORACLE_CAP_THREASHOLD";
                var sortCapKey = "B_ORACLE_CAP_THREASHOLD";

                if ($scope.displayProps) {
                    for (var prop in $scope.displayProps) {
                        if (prop.indexOf("ORACLE_FREEZE_FLAG") != -1) {
                            freezeKey = prop;
                            sortFreezeKey = "A_" + freezeKey;
                        }
                        if (prop.indexOf("ORACLE_CAP_THREASHOLD") != -1) {
                            capKey = prop;
                            sortCapKey = "B_" + capKey;
                        }
                    }
                }
                //如果是一体化备份、双活+一体化备份、一体化备份+双活的远端一致性策略不展示
                if (isSanHyperVault && $scope.schedule.protectLocation == 1 && $scope.schedule.protectedType != 1) {
                    $scope.text.manualPolicy = resource.get("pg_excute_after_duplica_label");
                    delete $scope.displaySchedule.appConsistent;
                    //删除一致性的相关参数
                    delete $scope.displayProps["freezeScript" ];
                    delete $scope.displayProps["thawScript" ];
                    delete $scope.displayProps["queryFreezeStatusScript" ];
                    delete $scope.displayProps["freezeTimeout"];
                    delete $scope.displayProps["hostOrGroupId" ];
                };
                if ((pt.type == "4" || pt.type == "35") && $scope.vm._3dc == 2) {
                    delete $scope.displaySchedule.appConsistent;
                };
                //NAS的双活+一体化备份
                if ((pt.type == "28" && pg.poType == 14) || pt.type == "11" || pt.type == "33") {
                    delete $scope.displaySchedule.appConsistent;
                };
                if (pt.type == "18" && pg.poType == 14) {
                    delete $scope.displaySchedule.appConsistent;
                };
                //华为虚拟机没有一致性策略
                if (pg.poType == 12) {
                    delete $scope.displaySchedule.appConsistent;
                };
                //数据结构改变，需要从schedule里面获取,应用一致性
                if (!_.isUndefined($scope.displaySchedule.appConsistent)) {
                    //oracle
                    if (pg.poType == 1) {
                        $scope.displayProps[sortFreezeKey] = $scope.displaySchedule.appConsistent;
                        if (!_.isEmpty($scope.displaySchedule.extParameters)) {
                            $scope.displayProps[sortCapKey] = $scope.displaySchedule.extParameters.ORACLE_CAP_THREASHOLD;
                        }
                    } else if (pg.poType == 10) {
                        //vmware
                        $scope.displayProps["vmSnapshotFlag"] = $scope.displaySchedule.appConsistent;
                        if ($scope.displaySchedule.appConsistent) {
                            $scope.displayProps["z_vmSnapshotEnableExcute"] = $scope.displayProps.continueAppConsistentFailure;
                        };
                        delete $scope.displayProps.continueAppConsistentFailure;
                    } else {
                        //其它
                        $scope.displayProps["APP_FREEZE_FLAG"] = $scope.displaySchedule.appConsistent;
                    };
                    delete $scope.displayProps.appConsistent;
                };
                //删除界面上不需要显示的属性
                !_.isUndefined($scope.displayProps.continueAppConsistentFailure) && (delete $scope.displayProps.continueAppConsistentFailure);

                //华为虚拟机的几个属性排序
                //数据结构改变，需要从schedule里面获取
                if (!angular.isUndefined($scope.displaySchedule.extParameters) && !_.isUndefined($scope.displaySchedule.extParameters.COMPRESSION)) {
                    $scope.displayProps.A_COMPRESSION = $scope.displaySchedule.extParameters.COMPRESSION;
                    delete $scope.displayProps.COMPRESSION;
                }
                if (!angular.isUndefined($scope.displaySchedule.extParameters) && !_.isUndefined($scope.displaySchedule.extParameters.ENTRYPTION)) {
                    $scope.displayProps.B_ENTRYPTION = $scope.displaySchedule.extParameters.ENTRYPTION;
                    delete $scope.displayProps.ENTRYPTION;
                }
                if (!angular.isUndefined($scope.displaySchedule.extParameters) && !_.isUndefined($scope.displaySchedule.extParameters.FS_Snap_Restore_Num)) {
                    $scope.displayProps.AA_FS_Snap_Restore_Num = $scope.displaySchedule.extParameters.FS_Snap_Restore_Num;
                    delete $scope.displayProps.FS_Snap_Restore_Num;
                }

                copyRate = $scope.displayProps.COPYRATEVALUE;
                delete $scope.displayProps.COPYRATEVALUE;

                if (!angular.isUndefined($scope.displayProps.COMPRESSION)) {
                    $scope.displayProps.A_COMPRESSION = $scope.displayProps.COMPRESSION;
                    delete $scope.displayProps.COMPRESSION;
                }
                if (!angular.isUndefined($scope.displayProps.ENTRYPTION)) {
                    $scope.displayProps.B_ENTRYPTION = $scope.displayProps.ENTRYPTION;
                    delete $scope.displayProps.ENTRYPTION;
                }
                if (!angular.isUndefined($scope.displayProps.FS_Snap_Restore_Num)) {
                    $scope.displayProps.AA_FS_Snap_Restore_Num = $scope.displayProps.FS_Snap_Restore_Num;
                    delete $scope.displayProps.FS_Snap_Restore_Num;
                }

                //快照副本排序
                if( _.has($scope.displayProps, "latestCopies") ){
                    $scope.displayProps.PP_SNAPSHOT_COUNT = $scope.displayProps.latestCopies;
                    delete $scope.displayProps.latestCopies;
                }
                if( _.has($scope.displayProps, "dailyCopies") ){
                    $scope.displayProps.Z_A_dailyRetention = $scope.displayProps.dailyCopies;
                    delete $scope.displayProps.dailyCopies;
                }
                if( _.has($scope.displayProps, "weeklyCopies") ){
                    $scope.displayProps.Z_B_weeklyRetention = $scope.displayProps.weeklyCopies;
                    delete $scope.displayProps.weeklyCopies;
                }
                if( _.has($scope.displayProps, "monthlyCopyies") ){
                    $scope.displayProps.Z_C_monthlyRetention = $scope.displayProps.monthlyCopyies;
                    delete $scope.displayProps.monthlyCopyies;
                }
                //复制一致性速率的显示
                if(!_.isUndefined($scope.displaySchedule.replicationSpeedPolicies)){
                    $scope.displayProps.syncRateRecords = $scope.displaySchedule.replicationSpeedPolicies;
                }
                //由于默认复制速率，界面不显示
                if (_.isUndefined($scope.displayProps.syncRateRecords)) {
                    if(_.contains([0, 1, 3, 4, 5, 6, 18, 20, 21, 22, 23, 24, 26, 27, 33, 35, 36], parseInt(pt.type, 10)) ||
                        (_.contains([30,31,32], parseInt(pt.type, 10)) && $scope.vm.cdmDuplicate)){
                        $scope.displayProps.syncRateRecords = [];
                    }
                };


                function formatHosts(hostOrGroupId) {
                    Rest.queryHostBySite([pg.productSiteId, 0], function(data) {
                        var hosts = [];
                        if (angular.isArray(data)) {
                            data.forEach(function(item) {
                                if (item.isVirtualGroup) {
                                    angular.isArray(item.childResources) && item.childResources.forEach(function(res) {
                                        hosts.push({
                                            deviceSn: res.deviceSn,
                                            name: res.name
                                        });
                                    });
                                } else {
                                    hosts.push({
                                        deviceSn: item.deviceSn,
                                        name: item.name + "(" + appUtils.getString("ism.drm.hostgroup") + ")"
                                    });
                                }
                            });
                        }
                        var findHost = _.findWhere(hosts, {"deviceSn": hostOrGroupId});
                        $scope.displayProps.Z_D_hostOrGroupId = !_.isEmpty(findHost) ? findHost["name"] : "";
                        infoTransferredService.put("hostOrGroupNameModuel", "hostOrGroupName", $scope.displayProps.Z_D_hostOrGroupId);
                        //解决一体化备份设置一致性策略主机，另一端不设置也会显示主机
                        if(pt.type == 30 || pt.type == 31 || pt.type == 32){
                            infoTransferredService.put("hostOrGroupNameModuel", "hostOrGroupName" + $scope.displaySchedule.protectLocation, $scope.displayProps.Z_D_hostOrGroupId);
                        };
                        $scope.$apply();
                    });
                };

                //LUN的一致性策略排序
                if ($scope.vm._3dc) {
                    var props = ["hostOrGroupId", "hostOrGroupName", "freezeScript", "thawScript", "queryFreezeStatusScript", "freezeTimeout"]
                    for (var p in $scope.displayProps) {
                        if (props.indexOf(p.slice(0, -1)) != -1) {
                            (p != p.slice(0, -1) + $scope.displaySchedule.protectLocation) && (delete $scope.displayProps[p]);
                        }
                    }
                    if( pt.type == 6 || pt.type == 19 || (isSanHyperVault && ($scope.schedule.protectLocation != 1 || $scope.schedule.protectedType == 1))) {
                        if (!angular.isUndefined($scope.displayProps["hostOrGroupId"])
                                && "1" == $scope.schedule.appConsistent) {
                            formatHosts($scope.displayProps["hostOrGroupId" ]);
                            delete $scope.displayProps["hostOrGroupName" ];
                        }

                        if (!angular.isUndefined($scope.displayProps["freezeScript" ])) {
                            $scope.displayProps.Z_E_freezeScript = $scope.displayProps["freezeScript" ];
                            delete $scope.displayProps["freezeScript" ];
                        }

                        if (!angular.isUndefined($scope.displayProps["thawScript" ])) {
                            $scope.displayProps.Z_F_thawScript = $scope.displayProps["thawScript" ];
                            delete $scope.displayProps["thawScript" ];
                        }

                        if (!angular.isUndefined($scope.displayProps["queryFreezeStatusScript" ])) {
                            $scope.displayProps.Z_G_queryFreezeStatusScript = $scope.displayProps["queryFreezeStatusScript" ];
                            delete $scope.displayProps["queryFreezeStatusScript" ];
                        }

                        if (!angular.isUndefined($scope.displayProps["freezeTimeout"])) {
                            $scope.displayProps.Z_H_freezeTimeout = $scope.displayProps["freezeTimeout"];
                            delete $scope.displayProps["freezeTimeout"];
                        }
                        delete $scope.displayProps["hostOrGroupId" ];
                    } else if (pt.type == 4) {
                        if ($scope.displaySchedule.protectLocation == 1) {
                            if (!angular.isUndefined($scope.displayProps["hostOrGroupId"]) && "1" == $scope.displayProps["APP_FREEZE_FLAG"]) {
                                formatHosts($scope.displayProps["hostOrGroupId"]);
                                delete $scope.displayProps["hostOrGroupName"];
                            }

                            if (!angular.isUndefined($scope.displayProps["freezeScript"])) {
                                $scope.displayProps.Z_E_freezeScript = $scope.displayProps["freezeScript"];
                                delete $scope.displayProps["freezeScript"];
                            }

                            if (!angular.isUndefined($scope.displayProps["thawScript"])) {
                                $scope.displayProps.Z_F_thawScript = $scope.displayProps["thawScript"];
                                delete $scope.displayProps["thawScript"];
                            }

                            if (!angular.isUndefined($scope.displayProps["queryFreezeStatusScript"])) {
                                $scope.displayProps.Z_G_queryFreezeStatusScript = $scope.displayProps["queryFreezeStatusScript"];
                                delete $scope.displayProps["queryFreezeStatusScript"];
                            }

                            if (!angular.isUndefined($scope.displayProps["freezeTimeout"])) {
                                $scope.displayProps.Z_H_freezeTimeout = $scope.displayProps["freezeTimeout"];
                                delete $scope.displayProps["freezeTimeout"];
                            }
                            delete $scope.displayProps["hostOrGroupId"];

                        } else if ($scope.displaySchedule.protectLocation == 3){
                            delete $scope.displayProps["APP_FREEZE_FLAG"];
                            delete $scope.displayProps["hostOrGroupName"];
                            delete $scope.displayProps["freezeScript"];
                            delete $scope.displayProps["thawScript"];
                            delete $scope.displayProps["queryFreezeStatusScript"];
                            delete $scope.displayProps["freezeTimeout"];
                            delete $scope.displayProps["hostOrGroupId"];
                        }
                    } else if (pt.type == "3" || pt.type == "5"){
                        if (isSyncAndAsyncRing) {
                            //删掉该属性，防止页面重复渲染
                            delete $scope.displayProps["syncRateRecords"];
                            if (!_.isEmpty(ringSiteStorage)) {
                                var siteNameArray_p = ringSiteStorage.detail.protectedSiteName.split(":");
                                var siteNameArray_r = ringSiteStorage.detail.recoverySiteName.split(":");
                                var siteIdArray_p = ringSiteStorage.detail.protectedStorageSN.split(":");
                                var siteIdArray_r = ringSiteStorage.detail.recoveryStorageSN.split(":");
                                if (siteNameArray_p.length == 1) {
                                    $scope.ringRateLabel_A = siteNameArray_p[0] + "->" + siteNameArray_r[0] + ":";
                                    $scope.ringRateLabel_B = siteNameArray_p[0] + "->" + siteNameArray_r[1] + ":";
                                    $scope.ringRate_A = getRingCopyRate(siteIdArray_r[0]);
                                    $scope.ringRate_B = getRingCopyRate(siteIdArray_r[1]);
                                } else {
                                    $scope.ringRateLabel_A = siteNameArray_p[0] + "->" + siteNameArray_r[0] + ":";
                                    $scope.ringRateLabel_B = siteNameArray_p[1] + "->" + siteNameArray_r[0] + ":";
                                    $scope.ringRate_A = getRingCopyRate(siteIdArray_p[0]);
                                    $scope.ringRate_B = getRingCopyRate(siteIdArray_p[1]);
                                }
                            }
                        }
                    }

                } else {
                    if (!angular.isUndefined($scope.displayProps["hostOrGroupId"]) && "1" == $scope.displayProps["APP_FREEZE_FLAG"] ) {
                        formatHosts($scope.displayProps["hostOrGroupId"]);
                        delete $scope.displayProps["hostOrGroupName"];
                    }

                    if (!angular.isUndefined($scope.displayProps["freezeScript"])) {
                        $scope.displayProps.Z_E_freezeScript = $scope.displayProps["freezeScript"];
                        delete $scope.displayProps["freezeScript"];
                    }

                    if (!angular.isUndefined($scope.displayProps["thawScript"])) {
                        $scope.displayProps.Z_F_thawScript = $scope.displayProps["thawScript"];
                        delete $scope.displayProps["thawScript"];
                    }

                    if (!angular.isUndefined($scope.displayProps["queryFreezeStatusScript"])) {
                        $scope.displayProps.Z_G_queryFreezeStatusScript = $scope.displayProps["queryFreezeStatusScript"];
                        delete $scope.displayProps["queryFreezeStatusScript"];
                    }

                    if (!angular.isUndefined($scope.displayProps["freezeTimeout"])) {
                        $scope.displayProps.Z_H_freezeTimeout = $scope.displayProps["freezeTimeout"];
                        delete $scope.displayProps["freezeTimeout"];
                    }

                    delete $scope.displayProps["hostOrGroupId"];
                    //环形3dc的复制速率有两端需要特殊处理 ^_^
                    if(pt.type == "26" || pt.type == "27"){
                        //删掉该属性，防止页面重复渲染
                        delete $scope.displayProps["syncRateRecords"];
                        if(!_.isEmpty(ringSiteStorage)){
                            var siteNameArray_p = ringSiteStorage.detail.protectedSiteName.split(":");
                            var siteNameArray_r = ringSiteStorage.detail.recoverySiteName.split(":");
                            var siteIdArray_p = ringSiteStorage.detail.protectedStorageSN.split(":");
                            var siteIdArray_r = ringSiteStorage.detail.recoveryStorageSN.split(":");
                            if(siteNameArray_p.length == 1){
                                $scope.ringRateLabel_A = siteNameArray_p[0] + "->" + siteNameArray_r[0] + ":";
                                $scope.ringRateLabel_B = siteNameArray_p[0] + "->" + siteNameArray_r[1] + ":";
                                $scope.ringRate_A = getRingCopyRate(siteIdArray_r[0]);
                                $scope.ringRate_B = getRingCopyRate(siteIdArray_r[1]);
                            }else{
                                $scope.ringRateLabel_A = siteNameArray_p[0] + "->" + siteNameArray_r[0] + ":";
                                $scope.ringRateLabel_B = siteNameArray_p[1] + "->" + siteNameArray_r[0] + ":";
                                $scope.ringRate_A = getRingCopyRate(siteIdArray_p[0]);
                                $scope.ringRate_B = getRingCopyRate(siteIdArray_p[1]);
                            }
                        }
                    }
                }



                var periodType = parseInt($scope.displaySchedule.periodType,10);
                //小时和分显示执行时间段
                if(periodType == 0 || periodType == 1 || periodType == 5){
                    $scope.showPeriodExclude = true;
                }
                //天周月显示执行时间点
                else{
                    $scope.showPeriodExclude = false;
                }

                if( $scope.displaySchedule.hours ){
                    var selectOneHour = $scope.displaySchedule.hours.indexOf(",") == -1;
                    var isStorageReplication = ([1,3,4,5,6,17,18,20,28,30,31,32,33,35,36].indexOf( parseInt(pt.type,10) ) != -1);

                    if(periodType == "2" && selectOneHour && isStorageReplication){
                        $scope.showAbortTaskTime = true;
                    }
                }

                //删除不显示的扩展属性
                delete $scope.displayProps.protectionRelation;
                delete $scope.displayProps.siteId;
                //LUN克隆
                if($scope.isLunCloneBcv && !_.isUndefined($scope.displayProps.CLONE_SPLIT)){
                    var lunClonePolicy = angular.copy($scope.displayProps.CLONE_SPLIT);
                    if(_.isString(lunClonePolicy)){
                        lunClonePolicy = JSON.parse(lunClonePolicy)
                    };
                    var minutes = $.trim(lunClonePolicy["split_delay_time"]);
                    $scope.splitValue = _.isEmpty(minutes) || minutes == "0" ? appUtils.getString("protection_term_clone_split_select_start") : appUtils.getString("protection_term_clone_split_defer_time_policy",parseInt(minutes,10));
                    $scope.createEnable = lunClonePolicy["create_snap"];
                    $scope.isCreateSnapShot = $scope.createEnable ? appUtils.getString("alarm_term_enable_label") : appUtils.getString("alarm_term_disable_label");
                    delete $scope.displayProps.CLONE_SPLIT;
                }
                //SAP HANA
                if (pg.poType == 16) {
                    delete $scope.displayProps.SUPPORT_FREEZE_FLAG_DISABLE
                }
                //SNA一体化备份删除AUTOMOUNTCONFIGS,增加快照、双活+快照
                if(pt.type == 30 || pt.type == 31 || pt.type == 32 || pt.type == 2 || pt.type == 19){
                    delete $scope.displayProps.AUTOMOUNTCONFIGS
                }
                //删除脚本参数相关配置
                delete $scope.displayProps.freezeParams;
                delete $scope.displayProps.unfreezeParam;
                delete $scope.displayProps.queryParam;
                delete $scope.displayProps.isUserDefined;
                delete $scope.displayProps.recoveryScriptInfo;
                delete $scope.displayProps.beforeScript;
                delete $scope.displayProps.afterScript;
                delete $scope.displayProps.publicParam;
                delete $scope.displayProps.scriptScheme;
                delete $scope.displayProps.scriptSchemeId;
                delete $scope.displayProps.userFreezeParam;
                delete $scope.displayProps.userUnfreezeParam;
                delete $scope.displayProps.userQueryParam;
                delete $scope.displayProps.beforeParam;
                delete $scope.displayProps.userBeforeParam;
                delete $scope.displayProps.afterParam;
                delete $scope.displayProps.userAfterParam;
                delete $scope.displayProps.BACKUP_PLAN_ID;
                delete $scope.displayProps.BACKUP_PLAN_NAME;
                delete $scope.displayProps.BACKUP_SNAPSHOTLIST;
                delete $scope.displayProps.ORACLE_CAP_THREASHOLD;
                delete $scope.displayProps.CLOUDVAULT_NAME;
                delete $scope.displayProps.CLOUD_SITE_ID;
                //FusionStorage 小Lun复制去掉资源池配对属性
                if(pt.type == 33){
                    delete $scope.displayProps.storagePoolMapping
                }
            }


            /*------------------*/


            //属性key
            $scope.getPropLabel = function(k) {

                var isZh = function() {
                    return cookieService.get("language") == "zh";
                };

                var map = {
                    "VIS_CACHE": resource.getWithColon("protection.modifyPolicy.task.para.snapResourceRatio.label"),
                    "A_ORACLE_FREEZE_FLAG": resource.getWithColon("pg_policy_dataconsisten_label"),
                    "A_ORACLE_FREEZE_FLAG1": resource.getWithColon("pg_policy_dataconsisten_label"),
                    "A_ORACLE_FREEZE_FLAG2": resource.getWithColon("pg_policy_dataconsisten_label"),
                    "A_ORACLE_FREEZE_FLAG0": resource.getWithColon("pg_policy_dataconsisten_label"),
                    "A_ORACLE_FREEZE_FLAG4": resource.getWithColon("pg_policy_dataconsisten_label"),
                    "B_ORACLE_CAP_THREASHOLD": resource.getWithColon("ism.drm.template.schedule.checkCap.label"),
                    "B_ORACLE_CAP_THREASHOLD1": resource.getWithColon("ism.drm.template.schedule.checkCap.label"),
                    "B_ORACLE_CAP_THREASHOLD2": resource.getWithColon("ism.drm.template.schedule.checkCap.label"),
                    "B_ORACLE_CAP_THREASHOLD0": resource.getWithColon("ism.drm.template.schedule.checkCap.label"),
                    "B_ORACLE_CAP_THREASHOLD4": resource.getWithColon("ism.drm.template.schedule.checkCap.label"),
                    "vmSnapshotFlag": resource.getWithColon("protection_VMware_task_setSchedule_option_generateSnapshot_checkbox"),
                    "vmSnapshotFlag1": resource.getWithColon("protection_VMware_task_setSchedule_option_generateSnapshot_checkbox"),
                    "vmSnapshotFlag2": resource.getWithColon("protection_VMware_task_setSchedule_option_generateSnapshot_checkbox"),
                    "vmSnapshotFlag0": resource.getWithColon("protection_VMware_task_setSchedule_option_generateSnapshot_checkbox"),
                    "vmSnapshotFlag4": resource.getWithColon("protection_VMware_task_setSchedule_option_generateSnapshot_checkbox"),
                    "NTFS_APP_FREEZE_FLAG": resource.getWithColon("common_term_dataConsistentProtect_label"),
                    "APP_FREEZE_FLAG": resource.getWithColon("protection_sql_task_setPolicy_option_executeConsist_checkbox"),
                    "APP_FREEZE_FLAG1": resource.getWithColon("protection_sql_task_setPolicy_option_executeConsist_checkbox"),
                    "APP_FREEZE_FLAG2": resource.getWithColon("protection_sql_task_setPolicy_option_executeConsist_checkbox"),
                    "APP_FREEZE_FLAG0": resource.getWithColon("protection_sql_task_setPolicy_option_executeConsist_checkbox"),
                    "APP_FREEZE_FLAG4": resource.getWithColon("protection_sql_task_setPolicy_option_executeConsist_checkbox"),
                    "PP_SNAPSHOT_COUNT": isZh() ? appUtils.getString("com.huawei.ism.drm.policy.snapshot.limit") + appUtils.getString("protection_schedule_snapshot_unit_des") + ":": appUtils.getStringWithColon("com.huawei.ism.drm.policy.snapshot.limit"),
                    "PP_SNAPSHOT_COUNT0": isZh() ? appUtils.getString("com.huawei.ism.drm.policy.snapshot.limit") + appUtils.getString("protection_schedule_snapshot_unit_des") + ":" : appUtils.getStringWithColon("com.huawei.ism.drm.policy.snapshot.limit"),
                    "PP_SNAPSHOT_COUNT4": isZh() ? appUtils.getStringWithColon("com.huawei.ism.drm.policy.snapshot.limit") + appUtils.getString("protection_schedule_snapshot_unit_des") + ":": appUtils.getStringWithColon("com.huawei.ism.drm.policy.snapshot.limit"),
                    "A_COMPRESSION": resource.getWithColon("protection.viewPolicy.task.para.compress.label"),
                    "B_ENTRYPTION": resource.getWithColon("protection.viewPolicy.task.para.encryption.label"),
                    "COPYRATE": resource.getWithColon("protection.viewPolicy.task.para.copySpeedWithoutUnit.label"),
                    "AA_FS_Snap_Restore_Num": resource.getWithColon("protection_HuaweiVM_task_create_selProtectionObject_para_VMRecoveryPoint_label"),
                    "syncRateRecords": resource.getWithColon("protection.copyrate.label"),
                    "Z_A_dailyRetention": isZh() ? appUtils.getString("protection.daysnap.label") + appUtils.getString("protection_schedule_snapshot_unit_des") + ":" : appUtils.getStringWithColon("protection.daysnap.label"),
                    "Z_B_weeklyRetention": isZh() ? appUtils.getString("protection.weeksnap.label") + appUtils.getString("protection_schedule_snapshot_unit_des") + ":" : appUtils.getStringWithColon("protection.weeksnap.label"),
                    "Z_C_monthlyRetention": isZh() ? appUtils.getString("protection.monthsnap.label") + appUtils.getString("protection_schedule_snapshot_unit_des") + ":" : appUtils.getStringWithColon("protection.monthsnap.label"),
                    "Z_D_hostOrGroupId" : appUtils.getStringWithColon("lun_term_dataConsistentProtect_hostOrGroupId"),
                    "Z_E_freezeScript" : appUtils.getStringWithColon("lun_term_dataConsistentProtect_freezeScript"),
                    "Z_F_thawScript" : appUtils.getStringWithColon("lun_term_dataConsistentProtect_thawScript"),
                    "Z_G_queryFreezeStatusScript" : appUtils.getStringWithColon("lun_term_dataConsistentProtect_queryFreezeStatusScript"),
                    "Z_H_freezeTimeout" : appUtils.getStringWithColon("lun_term_dataConsistentProtect_freezeTimeout"),
                    "PP_SNAPSHOT_COUNT1": isZh() ? appUtils.getStringWithColon("com.huawei.ism.drm.policy.snapshot.limit") + appUtils.getString("protection_schedule_snapshot_unit_des") + ":": appUtils.getStringWithColon("com.huawei.ism.drm.policy.snapshot.limit"),
                    "DATABASE_APP_FREEZE_FLAG": resource.getWithColon("pg_policy_dataconsisten_label"),
                    "z_vmSnapshotEnableExcute": resource.getWithColon("pg_vmware_policy_enable_excute_checkbox_label")
                };

                if (pg.poType == 9 && k.indexOf("APP_FREEZE_FLAG") != -1) {
                    k = "NTFS_APP_FREEZE_FLAG";
                }

                if (pg.poType == 11 && k.indexOf("APP_FREEZE_FLAG") != -1) {
                    k = "NTFS_APP_FREEZE_FLAG";
                }
                //数据库类型统一改为应用一致性
                if (_.contains([2,3,15,16], parseInt(pg.poType)) && k.indexOf("APP_FREEZE_FLAG") != -1) {
                    k = "DATABASE_APP_FREEZE_FLAG"
                }

                return map[k] || k;
            };

            $scope.getPeriodExclude = function(sc) {
                if( $scope.showPeriodExclude ){
                    if (angular.isArray(sc.scheduleRanges)) {
                        if (sc.scheduleRanges.length == 0) {
                            return resource.get("ism.drm.protectpolicy.schedule.period.executeAlways.value");
                        } else {
                            var ranges = sc.scheduleRanges;
                            var startTime, endTime;

                            if (ranges.length == 1) {
                                startTime = ranges[0].startTime,
                                    endTime = ranges[0].endTime;
                            } else if (ranges.length == 2) {
                                if( angular.isDate(ranges[0].startTime) ){
                                    startTime = ranges[0].startTime;
                                    endTime = ranges[1].endTime;
                                }
                                else{
                                    if (ranges[0].startTime.indexOf("00:00:") == -1) {
                                        startTime = ranges[0].startTime;
                                        endTime = ranges[1].endTime;
                                    } else {
                                        startTime = ranges[1].startTime;
                                        endTime = ranges[0].endTime;
                                    }
                                }
                            }

                            if (angular.isDate(startTime)) {
                                startTime = appUtils.convertDate2String(startTime.getTime());
                            }
                            if (angular.isDate(endTime)) {
                                endTime = appUtils.convertDate2String(endTime.getTime());
                            }

                            startTime = startTime.match(/\d{2}:\d{2}/)[0];
                            endTime = endTime.match(/\d{2}:\d{2}/)[0];
                            if (endTime == "23:59") {
                                endTime = "00:00";
                            }

                            if(startTime > endTime && endTime != "00:00"){
                                return startTime + " - " + endTime + " " + appUtils.getString("prootection_excute_time_next_day");
                            }else{
                                return startTime + " - " + endTime;
                            }
                        }
                    } else {
                        return resource.get("ism.drm.protectpolicy.schedule.period.executeAlways.value");
                    }
                }
                else{
                    var ret = "--";
                    if(sc.hours){
                        ret = "";

                        var tmpMinutes = parseInt(sc.minutes) < 10 ? "0"+parseInt(sc.minutes) : sc.minutes
                        var hourArr = sc.hours.split(",");
                        appUtils.sort(hourArr);
                        hourArr.forEach(function(h){
                            var tmpHours = parseInt(h) < 10 ? "0"+parseInt(h) : h;
                            ret += tmpHours + ":" + tmpMinutes + ","
                        });

                        ret = ret.replace(/,$/,"");
                    }
                    return ret;
                }
            }

            //属性值
            $scope.getPropDisplay = function(k, v, cls) {
                var checked;
                if (k.indexOf("A_ORACLE_FREEZE_FLAG") != -1) {
                    checked = v == 1;
                } else if (k.indexOf("vmSnapshotFlag") != -1) {
                    checked = v == 1;
                } else if (k.indexOf("APP_FREEZE_FLAG") != -1) {
                    checked = v == 1;
                } else if (k == "A_COMPRESSION") {
                    checked = v == true || v == "true";
                } else if (k == "B_ENTRYPTION") {
                    checked = v == true || v == "true";
                } else if (k == "COPYRATE") {
                    checked = v == true || v == "true";
                } else if (k.indexOf("B_ORACLE_CAP_THREASHOLD") != -1) {
                    checked = v && v != "0";
                } else if (k == "VIS_CACHE") {
                    if (cls) return "";
                    return v + "%";
                } else if(k.indexOf("syncRateRecords")!=-1){
                    if (cls) return "";
                    return getCopyRate();
                } else if(k == "Z_H_freezeTimeout") {
                    return v + "(" + appUtils.getString("common_term_second_label")+ ")";
                } else if(k == "z_vmSnapshotEnableExcute") {
                    checked = v == true || v == "true";
                }
                else {
                    if (cls) return "";
                    return v;
                }

                if (cls) return checked ? "iconbutton-enable" : "iconbutton-disable";

                if (k == "COPYRATE") {
                    checked = v == true || v == "true";
                    return copyRate && checked ? resource.get(checked ? "alarm_term_enable_label" : "alarm_term_disable_label") + "(" + copyRate + "MB/S)" :
                        resource.get(checked ? "alarm_term_enable_label" : "alarm_term_disable_label");
                }

                if (k.indexOf("B_ORACLE_CAP_THREASHOLD") != -1) {
                    var displayCap;

                    if (v && v != "0") {
                        if (v / 1024 >= 1) {
                            displayCap = v / 1024 + "GB";
                        } else {
                            displayCap = v + "MB";
                        }
                    } else {
                        displayCap = "--";
                    }

                    return (v && v != "0") ? resource.get(checked ? "alarm_term_enable_label" : "alarm_term_disable_label") + "(" + displayCap + ")" :
                        resource.get(checked ? "alarm_term_enable_label" : "alarm_term_disable_label");
                }

                return resource.get(checked ? "alarm_term_enable_label" : "alarm_term_disable_label");
            };

            function getCopyRate(){
                var syncRateRecords = $scope.displaySchedule.replicationSpeedPolicies;
                if( syncRateRecords && _.isString(syncRateRecords) ){
                    syncRateRecords = JSON.parse(syncRateRecords);
                }

                if( _.isArray(syncRateRecords) && syncRateRecords.length != 0 ){
                    var lastLevel;
                    var stage = [];
                    var item = {};

                    var filterData = angular.copy(syncRateRecords);
                    if( _.isArray(filterData) && filterData.length != 0 ){
                        filterData.forEach(function(record){
                            if(lastLevel != record.syncRateLevel){
                                item.startTime = record.startTime;
                                item.endTime = record.endTime;
                                item.syncRateLevel = record.syncRateLevel;
                                stage.push(angular.copy(item));

                                lastLevel = record.syncRateLevel;
                            }
                            else{
                                item.endTime = record.endTime;
                            }
                        });

                        var rateStr = "";
                        stage.forEach(function(record){
                            rateStr += record.startTime + "-" + record.endTime + "(" + rateMap[record.syncRateLevel] + ")   ";
                        });
                        return rateStr;
                    }
                    else{
                        return resource.get("protection.copyrate.default.config");
                    }
                }
                else{
                    return resource.get("protection.copyrate.default.config");
                }
            }

            function createSetScheduleLink() {
                var link = "<span style='text-decoration:none;color:#0097e7;cursor:pointer;'>" + resource.get("protection_object_task_setPolicyWhenNoneExist_value_set_value") + "</span>";
                var linkDesc = resource.get("protection_object_task_setPolicyWhenNoneExist_des_label");
                $("#" + $scope.setSpanId).html(linkDesc);
                $("#" + $scope.setSpanId).find("span").unbind().click(openScheduleWin);
            }

            //时间
            $scope.getPeriodInterval = function(sc) {
                var type = sc.periodType,
                    interval = sc.periodInterval,
                    lastDayOfMonth = sc.lastDayOfMonth;

                var every = resource.get("ism.drm.protectpolicy.schedule.every"),
                    runone = resource.get("ism.drm.protectpolicy.schedule.runone");
                var inner = "";

                if (type == "0") {
                    inner = Model.util.concatText(interval, resource.get("ism.drm.protect.policy.minute"));
                } else if (type == "1") {
                    inner = Model.util.concatText(interval, resource.get("ism.drm.protectpolicy.schedule.type.hour"));
                } else if (type == "2") {
                    inner = Model.util.concatText(interval, resource.get("ism.drm.protectpolicy.schedule.type.day"));
                } else if (type == "3") {
                    var daysOfWeek = sc.daysOfWeek.split(","),
                        daysText = "";
                    //星期天放在描述末尾
                    var wkendIndex = daysOfWeek.indexOf("1");
                    if (wkendIndex != -1) {
                        daysOfWeek.splice(wkendIndex, 1);
                    }
                    appUtils.sort(daysOfWeek);
                    daysOfWeek.forEach(function(day) {
                        daysText += resource.get(weekMap[day]) + ",";
                    });
                    if (wkendIndex != -1) {
                        daysText += resource.get(weekMap[1]) + ",";
                    }
                    daysText = daysText.substring(0, daysText.length - 1);

                    if (Model.util.isEn()) {
                        if (daysOfWeek.length > 1 || (daysOfWeek.length == 1 && wkendIndex != -1)) {
                            var lastSepratorIndex = daysText.lastIndexOf(",");
                            daysText = daysText.substring(0, lastSepratorIndex) + " and " + daysText.substring(lastSepratorIndex + 1);
                        }
                        inner = daysText;
                    } else {
                        inner = resource.get("ism.drm.protectpolicy.schedule.type.week") + daysText;
                    }
                } else if (type == "4") {
                    if( lastDayOfMonth == 1 ){
                        if (Model.util.isEn()){
                            inner += "last day of a month";
                        }
                        else{
                            inner =  resource.get("ism.drm.protectpolicy.schedule.type.monthDay") + resource.get("ism.drm.protect.policy.lastDay");
                        }
                    }
                    else{
                        var sortedDays = sc.daysOfMonth;
                        if( angular.isString(sortedDays) ){
                            var dayArr = sc.daysOfMonth.split(",");
                            appUtils.sort(dayArr);
                            sortedDays = dayArr.join(",");
                        }

                        if (Model.util.isEn()){
                            inner += sortedDays + " day of a month";
                        }
                        else{
                            inner = resource.get("ism.drm.protectpolicy.schedule.type.monthDay") + sortedDays + resource.get("ism.drm.protectpolicy.schedule.month.hao");
                        }
                    }
                } else if (type == "5") {
                    inner = Model.util.concatText(interval, resource.get("common_term_second_label"));
                }

                return Model.util.concatText(every, inner);
            };

            $scope.getAbortTaskTime = function(sc){
                return sc.abortTaskTime || "--";
            }

            function getScheduleTitle(sc) {
                var type = pt.type;
                var preTitle = resource.get("ism.drm.protect.group.template");

                if ([3, 4, 5, 6, 19, 26, 27, 35, 36].indexOf(parseInt(type, 10)) == -1) return;

                //创建时,3dc场景查询站点名称,并保存在schedule.name中 ^-^环形3dc场景查询站点名称
                if ($scope.vm.createFlag && (type == 3 || type == 5 || type == 26 || type == 27)) {
                    var poType = pg.poType;
                    var ptUuid = pt.uuid;

                    var config = {};
                    config.data = $scope.vm.poListIds;
                    config.success = function(data) {
                        if ((!angular.isArray(data) || data.length < 2) && type != 26 && type != 27) return;
                        //protectLocation: A(0);A-B(1);A-C(2);B-C(3).
                        if (data[0].protectLocation != 1 && type != 26 && type != 27) {
                            data.reverse();
                        }

                        //同步+异步
                        if (pt.type == "3" || pt.type == "5") {
                            var detail = data[1].detail;
                            $scope.vm.titleText = preTitle + "(" + detail.protectedSiteName + "->" + detail.recoverySiteName + ")";
                            scheduleName = detail.protectedSiteId + ";" + detail.recoverySiteId;
                            scheduleNameText = resource.get("protection.term.scheduleProduction.label", detail.protectedSiteName + "->" + detail.recoverySiteName);
                            //同步+异步的环形
                            if(data[1].protectLocation == 5){
                                $scope.vm.titleText = resource.get("protection.copyrate.policy.label") + "(" + detail.protectedSiteName.replace(":", "+") + "->" + detail.recoverySiteName + ")";
                                scheduleNameText = resource.get("protection.term.scheduleProduction.label", detail.protectedSiteName.replace(":", "+") + "->" + detail.recoverySiteName);
                                ringSiteStorage = data[1];
                                isSyncAndAsyncRing = true;
                            }
                        }else if(pt.type == "26" || pt.type == "27"){
                            //环形3dc设置title
                            var siteNameArray_p = data[0].detail.protectedSiteName.split(":");
                            var siteNameArray_r = data[0].detail.recoverySiteName.split(":");
                            if(siteNameArray_p.length == 1){
                                $scope.vm.titleText = preTitle + "(" + siteNameArray_p[0] + "->" + siteNameArray_r[0] + "+" + siteNameArray_r[1] + ")";
                            }else{
                                $scope.vm.titleText = preTitle + "(" + siteNameArray_p[0] + "+" + siteNameArray_p[1] + "->" + siteNameArray_r[0] + ")";
                            };
                            ringSiteStorage = data[0];
                        }

                        $scope.$digest();
                    };

                    Rest.getScheduleSiteInfo([poType, ptUuid], config);
                } else {
                    if (sc.protectedSiteName && sc.recoverySiteName) {
                        if (sc.protectedSiteName == sc.recoverySiteName) {
                            return preTitle + " (" + sc.protectedSiteName + ")";
                        } else {
                            return preTitle + resource.get(" (" + sc.protectedSiteName + "->" + sc.recoverySiteName + ")");
                        }
                    } else {
                        var text;
                        //B->C
                        if (type == "3" && _.isEmpty(pg.props["hyper-dr-ring-used-resources"])) {
                            text = "array.cascade3dc.second";
                        }
                        //A->B->C
                        else if (type == "4") {
                            text = $scope.firstScheduleId ? "array.cascade3dc.first" : "array.cascade3dc.second";
                        }
                        //A->C
                        else if (type == "5" && _.isEmpty(pg.props["hyper-dr-ring-used-resources"])) {
                            text = "array.concurrent3dc.second";
                        }
                        //A->B,A->C
                        else if (type == "6") {
                            text = $scope.firstScheduleId ? "array.concurrent3dc.first" : "array.concurrent3dc.second";
                        }
                        //3DC ring
                        else if (type == "26" || type == "27" || !_.isEmpty(pg.props["hyper-dr-ring-used-resources"])){
                            //ring的站点关系在pg props里面
                            var siteReation = angular.copy(pg.props["hyper-dr-ring-used-resources"]);
                            //同步+异步环形3dc
                            if(type == "3" || type == "5"){
                                isSyncAndAsyncRing = true;
                            };
                            _.isString(siteReation) && (siteReation = JSON.parse(siteReation));
                            var siteA, siteB, siteC;
                            //由于没有返回站点名称，需要查询站点信息
                            if(type == "26" || type == "3" || type == "5"){
                                Rest.getSiteDetails([siteReation['product.site'][0]],function(resultA){
                                    Rest.getSiteDetails([siteReation['product.site'][1]],function(resultB){
                                        Rest.getSiteDetails([siteReation['recovery.site'][0]],function(resultC){
                                            siteA = [resultA];
                                            siteB = [resultB];
                                            siteC = [resultC];
                                            $scope.vm.titleText = resource.get("protection.copyrate.policy.label") + "(" + siteA[0].name + "+" + siteB[0].name + "->" + siteC[0].name + ")";
                                            $scope.ringRateLabel_A = siteA[0].name + "->" + siteC[0].name + ":";
                                            $scope.ringRateLabel_B = siteB[0].name + "->" + siteC[0].name + ":";
                                            $scope.ringRate_A = getRingCopyRate(siteReation['product.storage'][0]);
                                            $scope.ringRate_B = getRingCopyRate(siteReation['product.storage'][1]);
                                            _.extend(ringSiteStorage,{
                                                detail:{
                                                    protectedSiteName: siteA[0].name + ":" + siteB[0].name,
                                                    protectedStorageSN: siteReation['product.storage'][0] + ":" + siteReation['product.storage'][1],
                                                    recoverySiteName: siteC[0].name
                                                },
                                                protectLocation: 5
                                            });
                                            $scope.$apply();
                                        })
                                    })
                                });
                            }else{
                                Rest.getSiteDetails([siteReation['recovery.site'][0]],function(resultA){
                                    Rest.getSiteDetails([siteReation['recovery.site'][1]],function(resultB){
                                        Rest.getSiteDetails([siteReation['product.site'][0]],function(resultC){
                                            siteA = [resultA];
                                            siteB = [resultB];
                                            siteC = [resultC];
                                            $scope.vm.titleText = resource.get("protection.copyrate.policy.label") + "(" + siteC[0].name + "->" + siteA[0].name + "+" + siteB[0].name + ")";
                                            $scope.ringRateLabel_A = siteC[0].name + "->" + siteA[0].name + ":";
                                            $scope.ringRateLabel_B = siteC[0].name + "->" + siteB[0].name + ":";
                                            $scope.ringRate_A = getRingCopyRate(siteReation['recovery.storage'][0]);
                                            $scope.ringRate_B = getRingCopyRate(siteReation['recovery.storage'][1]);
                                            _.extend(ringSiteStorage,{
                                                detail:{
                                                    protectedSiteName: siteC[0].name,
                                                    recoveryStorageSN: siteReation['recovery.storage'][0] + ":" + siteReation['recovery.storage'][1],
                                                    recoverySiteName: siteA[0].name + ":" + siteB[0].name
                                                },
                                                protectLocation: 5
                                            });
                                        })
                                    })
                                });
                            }
                        }
                        else {
                            text = "";
                        }

                        return preTitle + resource.get(text);
                    }
                }
            };
            //CDM查询阵列是否支持秒级策略
            var isSupportSecondPolicy = false;
            var isSupportCustomSecondPolicy = false;
            if (isSanHyperVault || pt.type == 19 || pt.type == 2) {
                $scope.$watch('schedule.sourceSn', function(newValue, oldValue, scope) {
                    if (_.isEmpty(newValue)) {
                        return;
                    };
                    Rest.queryStorageLicense([newValue], {
                        isShowMsgBox: false,
                        success: function(result) {
                            if (!_.isEmpty(result.LicenseFunction)) {
                                isSupportSecondPolicy = !_.isUndefined(_.find(result.LicenseFunction, function(license) {
                                    return 10001 == license.FeatureId && !!license.FuncSwitch;
                                }));
                                isSupportCustomSecondPolicy = !_.isUndefined(_.find(result.LicenseFunction, function(license) {
                                    return 10003 == license.FeatureId && !!license.FuncSwitch;
                                }));
                            }
                            //exchange 2016,2019不支持秒级的策略
                            try {
                                if (pg.poType == 8) {
                                    if ($scope.vm.createFlag) {
                                        var isDAG = infoTransferredService.get("getExchangeHost", "isChekcedDAG");
                                        if (isDAG && _.contains([4, 5], +pg.props.dbVersion)) {
                                            isSupportSecondPolicy = false;
                                        };
                                    } else {
                                        if (!_.isEmpty($scope.copyPolist) && !_.isEmpty(_.first($scope.copyPolist)) && !_.isEmpty(_.first($scope.copyPolist).props) && _.first($scope.copyPolist).props.IS_CLUSTER == "true" && _.contains([4, 5], +pg.props.dbVersion)) {
                                            isSupportSecondPolicy = false;
                                        };
                                    };
                                };
                            } catch (err) {};
                        }
                    });
                });
            };

            //设置
            function openScheduleWin() {
                var url = pt.editTemplateUrl;
                var win = Consts.TP_SCHEDULE_WIN.get(url);
                if (!win) return;
                //SAN一体化备份、双活+一体化备份的复制端
                if (isSanHyperVault && $scope.vm.cdmDuplicate) {
                    win = angular.copy(Consts.TP_SCHEDULE_WIN.toModifyTemplateLink);
                };
                //传入siteId
                !_.isEmpty($scope.vm.sourceSiteId) && _.extend($scope.schedule, {
                    sourceSiteId: $scope.vm.sourceSiteId
                });
                !_.isEmpty($scope.vm.targetSiteId) && _.extend($scope.schedule, {
                    targetSiteId: $scope.vm.targetSiteId
                });
                win.title = appUtils.getString(win.title);
                win.close = function() {
                    var ptVm = appUtils.getWinData("ModifyTempLink");
                    ptVm && closeCallback && closeCallback(ptVm);
                    var refreshFlag = false;
                    //修改华为虚拟机需要刷新页面(页面报错实际修改成功)
                    if(pt.type == 11 && !$scope.vm.createFlag && !ptVm){
                        refreshFlag = true;
                    }

                    if (ptVm || refreshFlag) {
                        var ok = $scope.vm.ok;
                        angular.isFunction(ok) && ok(ptVm);
                        //保护组创建
                        if ($scope.vm.createFlag) {
                            if ($scope.vm._3dc) {
                                $scope.vm.data = ptVm.data;

                                var schedule = ptVm.data.schedules[0];
                                $scope.vm.schedule = schedule;
                                $scope.vm.valid = ptVm.valid;

                                $scope.schedule = schedule;
                                pt = angular.copy(ptVm.data);
                                //同步加异步的环形3DC
                                if (isSyncAndAsyncRing) {
                                    $scope.vm.ringSiteStorage = ringSiteStorage;
                                };
                                init();
                            } else {
                                //此时$scope.vm绑定指令schedule,改变data时会重新加载controller,刷新页面
                                $scope.vm.data = ptVm.data;
                                $scope.vm.valid = ptVm.valid;
                                //环形3dc
                                if(pt.type == "26" || pt.type == "27"){
                                    $scope.vm.ringSiteStorage = ringSiteStorage;
                                };

                                //缓存名称,避免重复查询
                                $scope.vm.scheduleName = scheduleName;
                                $scope.vm.scheduleNameText = scheduleNameText;
                                //快照
                                if(_.contains([2, 16, 19, 30, 31, 32, 33], parseInt(pt.type))){
                                    var schedule = ptVm.data.schedules[0];
                                    $scope.vm.schedule = schedule;
                                    $scope.vm.valid = ptVm.valid;
                                    $scope.schedule = schedule;
                                    pt = angular.copy(ptVm.data);
                                    init();
                                }
                            }
                        }
                    }

                    $scope.$apply();
                };

                var _pt = angular.copy(pt);

                //传给修改策略模版窗口的额外参数,窗口获取值后需删除
                if ($scope.vm.createFlag) {
                    _pt.extraParam = {
                        poType: pg.poType,
                        fcRestoreNumSet: $scope.vm.fcRestoreNumSet,
                        view: win.content,
                        ctrl: win.controller,
                        schedule: angular.copy($scope.schedule),
                        poListIds: $scope.vm.poListIds,
                        _3dc: $scope.vm._3dc,
                        createFlag: $scope.vm.createFlag,
                        scheduleName: scheduleName,
                        scheduleNameText: scheduleNameText
                    }
                    if(pt.type == "26" || pt.type == "27" || isSyncAndAsyncRing){
                        _.extend(_pt.extraParam,{
                            ringSiteStorage: ringSiteStorage
                        })
                    }
                    //传入是否支持秒级标识
                    if ((isSanHyperVault || pt.type == 19 || pt.type == 2) && !$scope.vm.cdmDuplicate) {
                        _.extend(_pt.extraParam, {
                            isSupportSecondPolicy: isSupportSecondPolicy,
                            isSupportCustomSecondPolicy: isSupportCustomSecondPolicy
                        })
                    };
                } else {
                    _pt.extraParam = {
                        pgId: pg.pgId,
                        pgName: pg.name,
                        poType: pg.poType,
                        fcRestoreNumSet: pt.props.hasOwnProperty("FS_Snap_Restore_Num"),
                        view: win.content,
                        ctrl: win.controller,
                        schedule: angular.copy($scope.schedule),
                        _3dc: $scope.vm._3dc,
                        productSiteId: pg.productSiteId
                    }
                    if(pt.type == "26" || pt.type == "27" || isSyncAndAsyncRing){
                        _.extend(_pt.extraParam,{
                            ringSiteStorage: ringSiteStorage
                        })
                    }
                    if((pt.type == "35" || pt.type == "36") && _.isString($scope.vm.settingTitle)){
                        _.extend(_pt.extraParam,{
                            scheduleTimeText: $scope.vm.settingTitle.slice($scope.vm.settingTitle.indexOf("("))
                        })
                    };
                    if(isSyncAndAsyncRing && (pt.type == "3" || pt.type == "5") && _.isString($scope.vm.titleText)){
                        _.extend(_pt.extraParam,{
                            scheduleTimeText: $scope.vm.titleText.slice($scope.vm.titleText.indexOf("("))
                        })
                    };
                    if((_.contains([4,6], parseInt(pt.type)) || (!isSyncAndAsyncRing && (pt.type == "3" || pt.type == "5"))) && _.isString($scope.vm.settingTitle)){
                        _.extend(_pt.extraParam,{
                            scheduleTimeText: $scope.vm.settingTitle.slice($scope.vm.settingTitle.indexOf("("))
                        })
                    };
                    //传入是否支持秒级标识
                    if ((isSanHyperVault || pt.type == 19 || pt.type == 2) && !$scope.vm.cdmDuplicate) {
                        _.extend(_pt.extraParam, {
                            isSupportSecondPolicy: isSupportSecondPolicy,
                            isSupportCustomSecondPolicy: isSupportCustomSecondPolicy
                        })
                    };
                }

                //oralce可以设置是否启动热备
                if (pg.poType == 1) {
                    if (_.contains([2, 19, 30, 31, 32], parseInt(_pt.type))) {
                        appUtils.addWinSize(win, 0, 120);
                    } else {
                        appUtils.addWinSize(win, 20, 100);
                    }
                }
                //SQLServer、DB2、Exchange可以设置是否做一致性保护
                else if (pg.poType == 2 || pg.poType == 3 || pg.poType == 8 || pg.poType == 9) {
                    if (_.contains([2, 19, 30, 31, 32], parseInt(_pt.type))) {
                        appUtils.addWinSize(win, 0, 120);
                    } else {
                        appUtils.addWinSize(win, 0, 90);
                    }
                }
                //vmware异步复制可以设置静默快照
                else if (pg.poType == 10) {
                    if(_.contains([2, 19, 30, 31, 32], parseInt(_pt.type))){
                        appUtils.addWinSize(win, 0, 120);
                    }else{
                        appUtils.addWinSize(win, 0, 100);
                    }
                }

                //复制速率增加100高度
                if( _pt.type == 1 || _pt.type == 3 || _pt.type == 4 || _pt.type == 5 || _pt.type == 6 ){
                    appUtils.addWinSize(win, 0, 100);
                }
                //SAN一体化
                if((_pt.type == 30 || _pt.type == 31 || _pt.type == 32 || _pt.type == 19) && !_.contains([1,2,3,10], parseInt(pg.poType))){
                    appUtils.addWinSize(win, 0, 120);
                }
                //快照
                if(_pt.type == 2 && !_.contains([1,2,3,10], parseInt(pg.poType))){
                    appUtils.addWinSize(win, 0, 90);
                }
                //华为虚拟机主机复制
                if(_pt.type == 11){
                    appUtils.addWinSize(win, 20, 0);
                }
                //双活+异步复制的环形
                if (_.contains([26,27], parseInt(_pt.type)) && !appUtils.isEn()) {
                    appUtils.addWinSize(win, 0, 50);
                }
                //VMware CDM是否为rdm盘的虚拟机
                if ($scope.vm.createFlag) {
                    $scope.copyPolist = angular.copy(pg.polist);
                };

                appUtils.isEn() && appUtils.addWinSize(win, 30, 0);

                var isPhysicalMode = !_.isUndefined(_.find($scope.copyPolist, function(v, k) {
                    var virtualDisks = angular.fromJson(v["props"]["VirtualDisk"]);
                    return !_.isUndefined(_.findWhere(virtualDisks, {storageType: "physicalMode"}));
                }));

                win.content = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/scheduleWin.html";
                //如果阵列不支持云备份的情况下，不允许设置
                if ($scope.schedule.protectedType == Consts.STORAGE_FEATURE_ENUM.CloudBackup && _.contains([2, 19, 30, 31, 32], parseInt(pt.type, 10))) {
                    Rest.queryStorageLicense([$scope.schedule.sourceSn], {
                        isShowMsgBox: false,
                        success: function(result) {
                            if (!_.isEmpty(result.LicenseFunction)) {
                                var isSupportedCloudBackuo = !_.isUndefined(_.find(result.LicenseFunction, function(license) {
                                    return Consts.STORAGE_FEATURE_ENUM.CloudBackup == license.FeatureId && !!license.FuncSwitch;
                                }));
                                if (isSupportedCloudBackuo) {
                                     appUtils.openWin(win, _pt);
                                } else {
                                    message.error(appUtils.getString("pg_creat_not_supportcloudbackup_error_label"))
                                }
                            } else {
                                message.error(appUtils.getString("pg_creat_not_supportcloudbackup_error_label"))
                            }
                        },
                        fail: function(err){
                            message.error(appUtils.getString("pg_creat_not_supportcloudbackup_error_label"))
                        }
                    });
                } else {
                    appUtils.openWin(win, _pt);
                }
            }
        }];

        return ctrl;
    });
