define([],
    function() {
        var ctrl = ["$scope", "$compile", "appUtils", "constsService", "restService", "model", "$timeout", "mask", "communicationService", "exception", "message", function($scope, $compile, appUtils, Consts, Rest, Model, $timeout, mask, communicationService, exception, message) {
            var resource = appUtils.resource(),
                lookConfigInfo = resource.get("protection_lun_task_seltargetResourcePool_des_info_label"),
                lookConfigInfoHtml = appUtils.getString("protection_lun_task_seltargetResourcePool_des_label", "<a class='link' ng-click='scanStorageInfo()'>" + lookConfigInfo + "</a>");

            var scanMatchDetail = resource.get("protection_lun_task_selPolicy_para_resourcePool_check_button");
            var scanMatchDetailAuto = resource.get("protection_lun_task_selPolicy_para_resourcePool_check_button_auto");
            var copiesCount = 1;

            $scope.text = {
                storageInfo: resource.getWithColon("protection_lun_task_setPolicy_para_storageConfigInfo_label"),
                scan: resource.get("common_term_view_button"),
                descResPool: resource.getWithColon("protection_lun_task_setPolicy_para_configPolicy_label"),
                resPool: resource.getWithColon("common_term_resourcePool_label"),
                create: resource.get("common_term_create_button"),
                manual: resource.get("protection_lun_task_para_targetResourcePool_value_manual_value"),
                auto: resource.get("protection_lun_task_para_targetResourcePool_value_auto_value"),
                manualMatch: resource.get("protection_lun_task_selPolicy_para_resourcePool_satisfy_des_label"),
                manualNotMatch: resource.get("protection_lun_task_selPolicy_para_resourcePool_unsatify_des_label"),
                autoMatch: resource.get("protection_lun_task_selPolicy_para_resourcePool_autoSuccess_des_label"),
                autoNotMatch: resource.get("protection_lun_task_selPolicy_para_resourcePool_autoFail_des_label"),
                scanMatchDetail: resource.get("protection_lun_task_selPolicy_para_resourcePool_check_button"),
                tooltip: resource.get("protection_lun_task_para_targetResourcePool_des_tip"),
                configDesc: resource.get("protection_lun_task_selPolicy_para_resourcePool_auto_des_info_label")
            }

            //创建时才显示存储配置
            $scope.showStoragePanel = $scope.viewModel.createFlag;
            var deviceSN;

            //存储配置
            if ($scope.showStoragePanel) {
                var matchResult = [];

                var modifyLink = "<span id='modifyResLink' class='text-link'>" + resource.get("common_term_edit_button") + "</span>";
                var linkSapn = resource.get("protection_lun_task_selPolicy_para_resourcePool_modifyResPool_label", modifyLink);
                $("#linkSpan").html(linkSapn);

                $timeout(function() {
                    $("#modifyResLink").on("click", function() {
                        $scope.modifyResPool();
                    })
                });

                $scope.showResult = false;

                $scope.configType = {
                    id: "configType",
                    values: [{
                        selectId: "-1",
                        label: resource.get("common_term_pleaseSelect_listbox")
                    }, {
                        selectId: "1",
                        label: $scope.text.auto
                    }, {
                        selectId: "2",
                        label: $scope.text.manual
                    }],
                    selectedId: '-1',
                    defaultSelectid: "-1",
                    change: function() {
                        var selectId = $("#configType").widget().getSelectedId();
                        initConfiyType(selectId);
                        this.selectedId = selectId;
                        $scope.$digest();
                    }
                }

                function initConfiyType(selectId) {
                    if (angular.isUndefined(selectId) || selectId == -1) {
                        $scope.showResult = false;
                        $scope.resPool.disable = true;
                        $("#storageInfoDiv .text-link").not($("#scanStorageInfoSpan")).not($("#scanLink")).removeClass("text-link").addClass("text-link-disabled");
                    } else if (selectId == 1) {
                        $scope.resPool.disable = true;
                        $("#storageInfoDiv .text-link").not($("#scanStorageInfoSpan")).not($("#scanLink")).removeClass("text-link").addClass("text-link-disabled");
                        //修改描述为自动配置
                        $scope.text.scanMatchDetail = scanMatchDetailAuto;
                        queryLunInfo(-1);
                    } else {
                        $scope.resPool.disable = false;
                        $scope.showResult = false;
                        $("#storageInfoDiv .text-link-disabled").removeClass("text-link-disabled").addClass("text-link");
                        //修改描述为手动配置
                        $scope.text.scanMatchDetail = scanMatchDetail;
                        updateResPool(true);
                    }
                }

                function updateResPool(reset) {
                    Rest.getStorageResourcePools([deviceSN, 1], function(data) {
                        if (reset) {
                            $scope.resPool.defaultSelectid = "-1"
                        }
                        $scope.resourcePools = data;
                        appUtils.updateSelectValues("resPool", data, "uuid", "name", resource.get("common_term_pleaseSelect_listbox"));
                    });
                }

                $scope.resPool = {
                    id: "resPool",
                    values: [{
                        selectId: "-1",
                        label: resource.get("common_term_pleaseSelect_listbox")
                    }],
                    defaultSelectid: "-1",
                    change: function() {
                        var uuid = $("#resPool").widget().getSelectedId();
                        if (uuid == -1) {
                            $scope.showResult = false;
                        } else {
                            $scope.crtPool = appUtils.getItemFromArray($scope.resourcePools, "uuid", uuid);
                            queryLunInfo(uuid);
                            $scope.showResult = true;
                        }
                    }
                }




                function isMatchClone(usedLunList, hasLunList) {
                    if (!angular.isArray(usedLunList) || !angular.isArray(hasLunList)) return false;
                    var match = true;
                    //遍历,乘上副本数量,加一个originCount字段保存原始Lun基数
                    usedLunList.map(function(obj) {
                        obj.originCount || (obj.originCount = obj.count);
                        obj.count = obj.originCount * copiesCount;
                    });
                    usedLunList.forEach(function(usedLun) {
                        var result = false;
                        var detail = angular.copy(usedLun);
                        hasLunList.forEach(function(hasLun) {
                            if ((usedLun.capacity + "_" + usedLun.controllerId) == ((hasLun.capacity + "_" + hasLun.controllerId))) {
                                result = hasLun.count >= usedLun.count;
                                //构造匹配详情数据
                                detail.matchCount = [usedLun.count, hasLun.count];
                            }
                        });
                        //构造匹配详情数据
                        if (!detail.matchCount) {
                            detail.matchCount = [usedLun.count, 0];
                        }
                        detail.result = result;
                        matchResult.push(detail);

                        match = match && result;
                    });

                    return match;
                }

                function queryLunInfo(uuid) {
                    matchResult = [];
                    var selectId = $("#configType").widget().getSelectedId();
                    var templateType = $scope.viewModel.data.type;
                    if (uuid == -1) {
                        Rest.getStorageResourcesStatistic([deviceSN, templateType], {
                            data: usedStorageResources,
                            success: callback
                        });
                    } else {
                        Rest.getStoragePoolResourcesStatistic([uuid, templateType], {
                            data: usedStorageResources,
                            success: callback
                        });
                    }

                    function callback(data) {
                        if (data && data.details) {
                            if (isMatchClone(usedLunInfo, data.details)) {
                                //满足
                                $scope.matchSpanCls = "icon-success";
                                $scope.matchDesc = selectId == 1 ? $scope.text.autoMatch : $scope.text.manualMatch;
                                $scope.showResult = true;
                            } else {
                                //不满足
                                $scope.matchSpanCls = "icon-failed";
                                $scope.matchDesc = selectId == 1 ? $scope.text.autoNotMatch : $scope.text.manualNotMatch;
                                $scope.showResult = true;
                            }
                        } else {
                            //不满足
                            $scope.matchSpanCls = "icon-failed";
                            $scope.matchDesc = selectId == 1 ? $scope.text.autoNotMatch : $scope.text.manualNotMatch;
                            $scope.showResult = true;
                        }
                        $scope.$digest();
                    }
                }

                $scope.storageInfoVM = Model.ViewModel.create({
                    titleText: resource.get("protection_lun_term_storageConfiguration_tab")
                });

                $scope.scanStorageInfo = function() {
                    var win = angular.copy(Consts.CLONE_STORAGE_INFO);
                    win.title = resource.get(win.title);
                    win.buttons = [{
                        label: resource.get("common_term_close_button"),
                        handler: function() {
                            $("#" + Consts.CLONE_STORAGE_INFO.winId).widget().destroy();
                        }
                    }];
                    appUtils.openWin(win, usedLunInfo);
                }

                $scope.createResPool = function() {
                    if ($scope.resPool.disable) return;

                    var win = angular.copy(Consts.CREATE_RESOURCE_POOL_WIN);
                    win.data = {
                        deviceSn : deviceSN,
                        filterUuids : _.pluck($scope.viewModel.poListIds,"moUuid")
                    };
                    win.helpId = "createResourcePool";

                    appUtils.showWindow(win, function(obj) {

                        Rest.getStorageResourcePools([deviceSN, 1], function(data) {
                            $scope.resourcePools = data;

                            var vals = [{
                                    selectId: "-1",
                                    label: resource.get("common_term_pleaseSelect_listbox")
                                }],
                                checkedId;
                            angular.forEach(data, function(item) {
                                vals.push({
                                    selectId: item["uuid"],
                                    label: item["name"],
                                    "checked": item["name"] == obj.name
                                });
                                item["name"] == obj.name && (checkedId = item.uuid);
                            });

                            $("#resPool").widget().option("values", vals);

                            checkedId && ($("#resPool").widget().opChecked(checkedId), $scope.resPool.change());

                        });

                        $("#" + Consts.CREATE_RESOURCE_POOL_WIN.winId).widget().destroy();
                    });
                }

                $scope.scanMatchDetal = function() {
                    var win = angular.copy(Consts.CLONE_STORAGE_INFO);
                    win.title = resource.get(win.title);
                    win.buttons = [{
                        label: resource.get("common_term_close_button"),
                        handler: function() {
                            $("#" + Consts.CLONE_STORAGE_INFO.winId).widget().destroy();
                        }
                    }];
                    appUtils.openWin(win, {
                        data: matchResult,
                        type: "scanMatchDetal"
                    });
                }

                initConfiyType();
                //查询保护对象使用的lun信息
                var usedLunInfo = [];
                Rest.getStorageLunsStatistic([$scope.viewModel.pg.poType, $scope.viewModel.data.type], {
                    data: $scope.viewModel.poListIds,
                    success: function(data) {
                        if (data && data.details) {
                            deviceSN = data.deviceSn;
                            usedLunInfo = data.details;
                        }
                    }
                });

                var usedStorageResources = [];
                Rest.getStorageResources([$scope.viewModel.pg.poType, $scope.viewModel.data.type], {
                    data: $scope.viewModel.poListIds,
                    success: function(data) {
                        if (data) {
                            usedStorageResources = angular.copy(data);
                            _.each(usedStorageResources, function(val){
                                delete val.poolId;
                                delete val.poolName;
                            })
                        }
                    }
                });

                $scope.$on($scope.viewModel.event, function() {
                    $scope.viewModel.hideParentError = false;

                    var uuid = $("#resPool").widget().getSelectedId();
                    if (!$scope.resPool.disable && -1 === +uuid) {
                        $scope.viewModel.valid = false;
                        $scope.viewModel.hideParentError = true;

                        message.error(appUtils.getString("common_term_pleaseSelect_listbox_validate",appUtils.getString("common_term_resourcePool_label")));
                        return;
                    }

                    $scope.storageInfoVM.valid = ($("#configType").widget().getSelectedId() != -1 && $scope.showResult && $scope.matchSpanCls == "icon-success");
                    if (!$scope.storageInfoVM.valid) {
                        $scope.viewModel.valid = false;
                        $scope.viewModel.hideParentError = true;
                        return message.error(appUtils.getString("protection_lun_task_seltargetResourcePool_result_storageConfigInvalid_message"));
                    }

                    $scope.viewModel.valid = $scope.protectPanelVM.valid;
                    if (!$scope.viewModel.valid) return;

                    if ($("#configType").widget().getSelectedId() == 1) {
                        $scope.viewModel.pg.props.resourcePoolId = -1;
                    } else {
                        $scope.viewModel.pg.props.resourcePoolId = $scope.crtPool.uuid;
                    }

                    $scope.viewModel.data.schedules = $scope.protectPanelVM.data.schedules;
                    $scope.viewModel.data.props = $scope.viewModel.data.props || {};
                    _.extend($scope.viewModel.data.props, $scope.protectPanelVM.data.props);
                });
            } else {
                $scope.storageInfoVM = Model.ViewModel.create({
                    titleText: resource.get("protection_lun_term_storageConfiguration_tab"),
                    settingShow: appUtils.checkRight(9328),
                    settingEnable: true,
                    settingText: resource.get("site_resourcePool_task_modify_wintitle"),
                    click: function() {
                        $scope.modifyResPool(true);
                    }
                });

                var pooId = $scope.viewModel.pg.props.resourcePoolId;
                if (pooId == -1) {
                    $scope.destResPool = resource.get("protection_lun_task_para_targetResourcePool_value_auto_value");
                    $scope.resPoolName = "--";
                    $scope.storageInfoVM.settingEnable = false;
                } else {
                    $scope.destResPool = resource.get("protection_lun_task_para_targetResourcePool_value_manual_value");

                    var config = {
                        success: function(data) {
                            $scope.crtPool = data;
                            deviceSN = data.deviceSn;
                            $scope.resPoolName = data.name;
                            $scope.$apply();
                        },
                        fail: function(){
                            $scope.resPoolName = "--";
                            $scope.$apply();
                        }
                    };

                    Rest.getStorageResourcePool(pooId,config);
                }
            }

            $scope.modifyResPool = function(modify) {
                if (modify) {
                    if (!$scope.storageInfoVM.settingEnable) return;
                } else {
                    if ($scope.resPool.disable) return;
                }

                var pool = $scope.crtPool;
                if (null === pool.description) {
                    pool.description = "null";
                } else if (null == pool.description) {
                    pool.description = "";
                }

                var win = angular.copy(Consts.CREATE_RESOURCE_POOL_WIN);
                win.data = {
                    deviceSn: deviceSN,
                    "uuid": pool.uuid,
                    "name": pool.name,
                    "description": pool.description,
                    filterUuids : _.pluck($scope.viewModel.poListIds,"moUuid")
                };
                win.helpId = "modifyResourcePool";
                win.title = "site_resourcePool_task_modify_wintitle";

                appUtils.showWindow(win, function() {
                    if (!modify) {
                        Rest.getStorageResourcePools([deviceSN, 1], function(data) {
                            $scope.resourcePools = data;

                            var vals = [{
                                    selectId: "-1",
                                    label: resource.get("common_term_pleaseSelect_listbox")
                                }],
                                checkedId = pool.uuid;
                            angular.forEach(data, function(item) {
                                vals.push({
                                    selectId: item["uuid"],
                                    label: item["name"],
                                });
                            });

                            $("#resPool").widget().option("values", vals);

                            checkedId && ($("#resPool").widget().opChecked(checkedId), $scope.resPool.change());

                        });
                    };

                    $("#" + Consts.CREATE_RESOURCE_POOL_WIN.winId).widget().destroy();
                });
            }

            $scope.protectPanelVM = Model.ViewModel.create({
                data: $scope.viewModel.data,
                pg: $scope.viewModel.pg,
                ok: $scope.viewModel.ok,
                createFlag: $scope.viewModel.createFlag,
                settingTitle: !_.isEmpty($scope.viewModel.pg) ? $scope.viewModel.pg.productSiteName : appUtils.getString("ism.drm.protect.group.template"),
                poListIds: $scope.viewModel.poListIds,
                settingEnable: $scope.viewModel.settingEnable,
                scheduleData: function(){
                    if(_.isArray($scope.viewModel.data.schedules)){
                        return $scope.viewModel.data.schedules[0]
                    };
                    return {protectLocation: 0};
                }(),
                closeCallback: function(ptVm){
                    if(ptVm && ptVm.copiesCount && (copiesCount !== ptVm.copiesCount)){
                        copiesCount = ptVm.copiesCount;
                        //自动配置
                        $scope.configType.selectedId == '1' && queryLunInfo(-1);
                        //手动配置
                        if ($scope.configType.selectedId == '2'){
                            var uuid = $("#resPool").widget().getSelectedId();
                            uuid && uuid != '-1' && queryLunInfo(uuid);
                        }
                    }
                }
            });
            $scope.title = {
                policyTitle: appUtils.getString("array.clone.name"),
                policyDesc: appUtils.getString("array.clone.desc")
            };
            var flag = 1;
            var baseView = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html?flag=";

            $scope.protectPanel = {
                view: baseView + flag,
                ctrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl",
                vm: $scope.protectPanelVM
            }

            setTimeout(function() {
                var optLink = $compile($("<div class='description'>" + lookConfigInfoHtml + "</div>")),
                    optScope = $scope.$new();
                optScope.scanStorageInfo = function() {
                    var win = angular.copy(Consts.CLONE_STORAGE_INFO);
                    win.title = resource.get(win.title);
                    win.buttons = [{
                        label: resource.get("common_term_close_button"),
                        handler: function() {
                            $("#" + Consts.CLONE_STORAGE_INFO.winId).widget().destroy();
                        }
                    }];
                    appUtils.openWin(win, usedLunInfo);
                }
                $("#storageInfoDiv #cloneStorageConf").html(optLink(optScope));

            }, 0);
        }];

        return ctrl;
    });
