define([], function() {
    var ctrl = ["$scope", "appUtils", "constsService", "restService", "model", "infoTransferredService", function($scope, appUtils, constsService, Rest, Model, infoTransferredService) {
        var resource = appUtils.resource();

        $scope.vm = $scope.viewModel;

        var pg = $scope.vm.pg;
        var pt = $scope.vm.data;

        $scope.view1 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelOpenStackVolumn.html";
        $scope.ctrl1 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelOpenStackVolumnCtrl";

        if (pt.type == 21) {
            $scope.view2 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelSyncContent.html";
            $scope.ctrl2 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelSyncContentCtrl";
        } else{
            $scope.view2 = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/schedulePanelBaseContent.html";
            $scope.ctrl2 = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/schedulePanelBaseContentCtrl";
        }

        $scope.vm1 = Model.ViewModel.create({
            pg: $scope.vm.pg,
            ok: $scope.vm.ok,
            _3dc: 1,
            createFlag: $scope.vm.createFlag,
            poListIds: $scope.vm.poListIds,
            titleText: appUtils.getString("rm_term_set_title"),
            settingShow: true,
            noSettingShow: true,
            valid: false,
            click: function() {
                var win = angular.copy(constsService.OPENSTACK_VOLUMN_SETTING_WIN);
                win.title = appUtils.getString("openstack_term_volumn_setting_label");
                win.data = $scope.vm.pg;
                win.helpId = "";
                win.close = function() {
                    $scope.vm1.noSettingShow = false;
                    var volumnSettingData = infoTransferredService.get("VOLUMES_SETTING_MODULE", "VOLUMES_SETTING");
                    if (_.isUndefined(volumnSettingData)) {
                        $scope.$broadcast("OPENSTACK_VOLUMES_INIT", undefined);
                        return;
                    }
                    var props = {
                        drSiteName: infoTransferredService.get("OpenstackSiteLabelModuel", "productSiteLabel"),
                        drFusionSphereName: infoTransferredService.get("OpenstackFusionSphereLabelModuel", "fusionSphereLabel"),
                        drRegionName: infoTransferredService.get("drRegionModuel", "drRegionName"),
                        drProjectName: infoTransferredService.get("drProjectModuel", "drProjectName"),
                        drZoneName: infoTransferredService.get("drZoneNameModuel", "drZoneName")
                    }
                    $scope.$broadcast("OPENSTACK_VOLUMES_INIT", {props: _.extend(volumnSettingData["props"], props), polist: volumnSettingData.polist});
                    _.extend(pg.props, volumnSettingData.props)
                    pg.polist = volumnSettingData.polist;
                    $("#checkPanel").parent().widget().option('isChange',true);
                }
                appUtils.showWindow(win);
            }
        });

        $scope.vm2 = Model.ViewModel.create({
            data: $scope.vm.data,
            pg: $scope.vm.pg,
            ok: $scope.vm.ok,
            _3dc: 2,
            valid: false,
            createFlag: $scope.vm.createFlag,
            poListIds: $scope.vm.poListIds,
            settingEnable: $scope.vm.settingEnable
        });


        if ($scope.vm.createFlag) {
            if(pg){
                if(pg.props){
                    delete pg.props.drFusionSphereName;
                    delete pg.props.drProjectId;
                    delete pg.props.drProjectName;
                    delete pg.props.drRegionId;
                    delete pg.props.drRegionName;
                    delete pg.props.drSiteName;
                    delete pg.props.drZoneName;
                    delete pg.props.projectId;
                    delete pg.props.protectType;
                    delete pg.props.regionId;
                    delete pg.props.storageType;
                    delete pg.props.zoneName;
                }
                delete pg.polist;
            }

            infoTransferredService.remove("VOLUMES_SETTING_MODULE", "VOLUMES_SETTING");

            $scope.$on($scope.vm.event, function() {
                $scope.vm.valid = $scope.vm1.valid && $scope.vm2.valid;
                if ($scope.vm.data.type == 22) {
                    _.size($scope.vm2.data.schedules) > 0 && ($scope.vm2.data.schedules[0].protectLocation = 1);
                }
                if (!$scope.vm.valid) return;
                _.extend($scope.vm.data, $scope.vm2.data);
            });
        }
    }];

    return ctrl;
});
