define([], function() {
    var ctrl = ["$scope", "appUtils", "constsService", "restService", "model", "infoTransferredService", function($scope, appUtils, constsService, restService, Model, infoTransferredService) {

        $scope.panelConfig = $scope.viewModel;
        $scope.model = {
            drSite: "",
            drFusionSphere: "",
            drRegion: "",
            drProject: "",
            drZone: "",
            labels: {
                drSite: appUtils.getStringWithColon("rm_term_dr_site"),
                drFusionSphere: appUtils.getStringWithColon("rm_term_dr_cloud"),
                drRegion: appUtils.getStringWithColon("rm_term_openstack_dr_region"),
                drProject: appUtils.getStringWithColon("rm_term_openstack_dr_project"),
                drZone: appUtils.getStringWithColon("rm_term_openstack_dr_zone"),
            },
            table: {
                "id": "unusedProtectedTable",
                "columns": [{
                    "mData": "volumeId",
                    "bVisible": false
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_name"),
                    "mData": "volumeName",
                    "bSortable": true
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_type"),
                    "mData": "volumeType",
                    "bSortable": true
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_dr_type"),
                    "mData": "drVolumeType",
                    "bSortable": true
                }],
                data: [],
                renderRow: function(nRow, aData, iDataIndex) {}
            }
        }


        function init(event, param) {
            if (!_.isUndefined(param)) {
                $scope.model.drSite = param.props.drSiteName;
                $scope.model.drFusionSphere = param.props.drFusionSphereName;
                $scope.model.drRegion = param.props.drRegionName;
                $scope.model.drProject = param.props.drProjectName;
                $scope.model.drZone = param.props.drZoneName;
                var array = [];
                _.each(param.polist, function(po){
                    _.each(JSON.parse(po.props.volumeConfig), function(volume){
                        _.isUndefined(_.findWhere(array, {volumeId: volume.volumeId}))
                            && array.push(_.pick(volume, "drVolumeType", "volumeId", "volumeName", "volumeType"));
                    });
                });
                $scope.model.table.data = array;
                initSettingPanel(param);
                $scope.$apply();
            }
        }

        function initSettingPanel(param) {
            if (_.isUndefined(param)) {
                $scope.noSetting = true;
                $scope.volumesPanel = false;
                $scope.panelConfig.valid = false;
            } else {
                if (!_.isUndefined(param.drSiteName)
                    || !_.isUndefined(param.drFusionSphereName)
                    || !_.isUndefined(param.drRegionName)
                    || !_.isUndefined(param.drProjectName)
                    || !_.isUndefined(param.drZoneName)
                    || !_.isUndefined(param.polist)) {
                    $scope.noSetting = false;
                    $scope.volumesPanel = true;
                    $scope.panelConfig.valid = true;
                } else {
                    $scope.noSetting = true;
                    $scope.volumesPanel = false;
                    $scope.panelConfig.valid = false;
                }
            }

        }

        $scope.$on("OPENSTACK_VOLUMES_INIT", init);

        initSettingPanel();

        setTimeout(function() {
            var link = "<span style='text-decoration:none;color:#0097e7;cursor:pointer;'>" + appUtils.getString("protection_object_task_setPolicyWhenNoneExist_value_set_value") + "</span>";
            var linkDesc = appUtils.getString("protection_object_task_setVolumnWhenNoneExist_des_label");
            $("#setSpanId").html(linkDesc);
        }, 0);

    }]

    return ctrl;
})
