define([],
    function() {
        var ctrl = ["$scope", "appUtils", "constsService", "restService", "model", "$timeout", function($scope, appUtils, Consts, Rest, Model, $timeout) {
            $scope.Consts = Consts;
            $scope.vm = $scope.viewModel;
            $scope.vm.settingShow = true;
            $scope.vm.click = openScheduleWin;

            var resource = appUtils.resource();
            var pt = $scope.vm.data;
            var pg = $scope.vm.pg;
            var rateMap = {
                1 : resource.get("protection.copyrate.low"),
                2 : resource.get("protection.copyrate.mid"),
                3 : resource.get("protection.copyrate.high"),
                4 : resource.get("protection.copyrate.extremely.high")
            };
            var schedules = pt.schedules || [{}];
            var scheduleName = $scope.vm.scheduleName;
            var scheduleNameText = $scope.vm.scheduleNameText;

            //21表示openstack同步复制
            if ($scope.vm._3dc && pt.type != 21) {
                $scope.$watch("vm.scheduleNameText", function(newVal) {
                    if (!newVal) return;
                    scheduleNameText = newVal;
                });

                $scope.$watch("vm.scheduleName", function(newVal) {
                    if (!newVal) return;
                    scheduleName = newVal;
                });

                //保护站点
                $scope.$watch("vm.sourceSiteId", function(newVal) {
                    if (!newVal) return;
                    $scope.vm.sourceSiteId = newVal;
                });
                //恢复站点
                $scope.$watch("vm.targetSiteId", function(newVal) {
                    if (!newVal) return;
                    $scope.vm.targetSiteId = newVal;
                });

                var preTitle = resource.get("protection.copyrate.policy.label");

                if( !$scope.vm.createFlag ){
                    var schedule = _.findWhere(schedules,{protectLocation:1});
                    if(schedule && schedule.protectedSiteName && schedule.recoverySiteName){
                        $scope.vm.titleText = preTitle + "(" + schedule.protectedSiteName + "->" + schedule.recoverySiteName + ")";
                    }
                    else{
                        $scope.vm.titleText = preTitle + resource.get("array.cascade3dc.first");
                    }

                    $scope.schedule = schedule;
                }
            }

            _.isUndefined($scope.schedule) && ($scope.schedule = schedules[0]);

            $scope.text = {
                copyrate: resource.getWithColon("protection.copyrate.label")
            }
            $scope.setSpanId = "setSpanId_aync";

            $scope.copyrate = getCoryrate();
            $scope.noSettingShow = $scope.vm.createFlag && _.isUndefined($scope.schedule.replicationSpeedPolicies);
            $scope.vm.noSettingShow = $scope.vm.createFlag && _.isUndefined($scope.schedule.replicationSpeedPolicies);
            if (!$scope.vm.createFlag) {
                $scope.vm.noSettingShow = _.isUndefined($scope.schedule.scheduleId);
            };
            $scope.vm.valid = !$scope.noSettingShow;
            if( $scope.noSettingShow ){
                $timeout(createSetScheduleLink);
            }


            function getCoryrate(){
                var syncRateRecords = $scope.schedule.replicationSpeedPolicies;
                if( syncRateRecords && _.isString(syncRateRecords) ){
                    syncRateRecords = JSON.parse(syncRateRecords);
                }
                if( _.isArray(syncRateRecords) && syncRateRecords.length != 0 ){
                    var lastLevel;
                    var stage = [];
                    var item = {};

                    var filterData = angular.copy(syncRateRecords);

                    if( _.isArray(filterData) && filterData.length != 0 ){
                        filterData.forEach(function(record){
                            if(lastLevel != record.syncRateLevel){
                                item.startTime = record.startTime;
                                item.endTime = record.endTime;
                                item.syncRateLevel = record.syncRateLevel;
                                stage.push(angular.copy(item));

                                lastLevel = record.syncRateLevel;
                            }
                            else{
                                item.endTime = record.endTime;
                            }
                        });

                        var rateStr = "";
                        stage.forEach(function(record){
                            rateStr += record.startTime + "-" + record.endTime + "(" + rateMap[record.syncRateLevel] + ")   ";
                        });
                        return rateStr;
                    }
                    else{
                        return resource.get("protection.copyrate.default.config");
                    }
                }
                else{
                    return resource.get("protection.copyrate.default.config");
                }
            }

            function openScheduleWin(){
                var url = pt.editTemplateUrl;
                var win = Consts.TP_SCHEDULE_WIN.get(url,pt.type);
                if (!win) return;

                //传入siteId
                !_.isEmpty($scope.vm.sourceSiteId) && _.extend($scope.schedule, {
                    sourceSiteId: $scope.vm.sourceSiteId
                });
                !_.isEmpty($scope.vm.targetSiteId) && _.extend($scope.schedule, {
                    targetSiteId: $scope.vm.targetSiteId
                });
                win.title = appUtils.getString(win.title);
                win.close = function(){
                    var ptVm = appUtils.getWinData("ModifyTempLink");
                    var refreshFlag = false;
                    //修改华为虚拟机需要刷新页面(页面报错实际修改成功)
                    if(pt.type == 11 && !$scope.vm.createFlag && !ptVm){
                        refreshFlag = true;
                    }

                    if (ptVm || refreshFlag) {
                        var ok = $scope.vm.ok;
                        angular.isFunction(ok) && ok(ptVm);
                        //保护组创建
                        if ($scope.vm.createFlag) {
                            if ($scope.vm._3dc) {
                                $scope.vm.data = ptVm.data;
                                $scope.vm.schedule = ptVm.data.schedules[0];
                                $scope.vm.valid = ptVm.valid;
                                pt = angular.copy(ptVm.data);
                                $scope.schedule = _.findWhere(ptVm.data.schedules,{protectLocation:1});
                                if(pt.type == 21 && _.isUndefined($scope.schedule)){
                                    $scope.schedule = ptVm.data.schedules[0];
                                };
                                $scope.copyrate = getCoryrate();
                                $scope.noSettingShow = _.isUndefined($scope.schedule.replicationSpeedPolicies);
                                $scope.vm.noSettingShow = _.isUndefined($scope.schedule.replicationSpeedPolicies);
                            } else {
                                //此时$scope.vm绑定指令schedule,改变data时会重新加载controller,刷新页面
                                $scope.vm.data = ptVm.data;
                                $scope.vm.valid = ptVm.valid;
                            }
                        }
                    }

                    $scope.$apply();
                }
                var _pt = angular.copy(pt);
                if ($scope.vm.createFlag) {
                    _pt.extraParam = {
                        poType: pg.poType,
                        fcRestoreNumSet: $scope.vm.fcRestoreNumSet,
                        view: win.content,
                        ctrl: win.controller,
                        poListIds: $scope.vm.poListIds,
                        _3dc: $scope.vm._3dc,
                        createFlag: $scope.vm.createFlag,
                        scheduleName: scheduleName,
                        scheduleNameText: scheduleNameText,
                        schedule: angular.copy($scope.schedule)
                    }
                }
                else{
                    _pt.extraParam = {
                        pgId: pg.pgId,
                        pgName: pg.name,
                        poType: pg.poType,
                        fcRestoreNumSet: pt.props.hasOwnProperty("FS_Snap_Restore_Num"),
                        view: win.content,
                        ctrl: win.controller,
                        _3dc: $scope.vm._3dc,
                        scheduleNameText:$scope.vm.titleText,
                        schedule: angular.copy($scope.schedule)
                    };
                }

                win.content = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/scheduleWin.html";
                appUtils.openWin(win, _pt);
            }

            function createSetScheduleLink() {
                var link = "<span style='text-decoration:none;color:#0097e7;cursor:pointer;'>" + resource.get("protection_object_task_setPolicyWhenNoneExist_value_set_value") + "</span>";
                var linkDesc = resource.get("protection_object_task_setPolicyWhenNoneExist_des_label");
                $("#" + $scope.setSpanId).html(linkDesc);
            }
        }];

        return ctrl;
    }
)