define(["tiny-common/UnifyValid", "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/baseCtrl"],
    function(UnifyValid, baseCtrl) {

        var ctrl = ["$scope", "appUtils", "constsService", "restService", "message", "model", "infoTransferredService",
            function($scope, appUtils, Consts, Rest, message, Model, infoTransferredService) {

                //修改策略(scheduleWin.html)或者创建保护组(pgCreateStep3.js),传入viewModel
                var pVm = $scope.viewModel;
                $scope.pt = pVm.data;

                var resource = appUtils.resource();
                var ViewModel = Model.ViewModel;
                var schedule;
                var snapshotKey = "PP_SNAPSHOT_COUNT";
                var tabs = new tinyWidget.Tabs({
                    "id": "myTabs",
                    "setActiveClass": true
                });
                //hypercdp场景下支持的应用,包括纯lun、oracle、db2、sqlserver、hana、vmvare
                var supportHyperCdpApp = _.contains([11,1,3,2,16,10,99], parseInt(pVm.poType, 10));

                //双活+快照
                var _3dc = pVm._3dc;
                if (_3dc) {
                    schedule = pVm.schedule;
                    if($scope.pt.type == 30 || $scope.pt.type == 31 || $scope.pt.type == 32){
                        //CDM远端4改为1,-_-
                        snapshotKey += (_3dc == 1 ? 0 : 1);
                    }else{
                        snapshotKey += (_3dc == 1 ? 0 : 4);
                    };
                    delete schedule.protectedSiteName;
                    delete schedule.recoverySiteName;
                } else {
                    schedule = appUtils.getItemFromArray($scope.pt.schedules, "scheduleMode", "0") || $scope.pt.schedules[0];
                    schedule = pVm.schedule;
                }
                //SAN一体化备份
                var isSanHyperVault = $scope.pt.type == 30 || $scope.pt.type == 31 || $scope.pt.type == 32;
                var isLunSnapShot = $scope.pt.type == 2 && pVm.poType == 11;
                //hana快照
                var isHanaSnapshot = $scope.pt.type == 2 && pVm.poType == 16;
                //是否支持秒级策略(双活+快照)
                var isAddSecondSchedule = _.contains([19, 2], parseInt($scope.pt.type, 10));
                isHanaSnapshot && (isAddSecondSchedule = false);
                //是否支持hyperCDP(快照、双活)
                var isSupportedHyperCdp = _.contains([19, 2], parseInt($scope.pt.type, 10));
                //双活+快照、CDM是否支持hyperCDP、
                $scope.isSupportSnapShotType = (isSanHyperVault || isSupportedHyperCdp) && supportHyperCdpApp;
                //云备份不支持秒级（protectedType为101）
                if(pVm.schedule.protectedType == 101){
                    $scope.isSupportSnapShotType = false;
                };

                //nas的快照、一体化备份、双活+一体化备份
                var isNasTemplate = _.contains([14,17,28], parseInt($scope.pt.type));

                $scope.title = resource.get("protection_term_reserverPolicy_label");

                //spinner值回显
                var remainValue = {};
                //数据结构改变，需要从schedule里面获取
                if(!_.isEmpty(schedule.retentionPolicy)){
                    remainValue = schedule.retentionPolicy;
                };
                //LUN快照选择系统脚本需要给出提示
                var choseSystemScriptTip = function(pgProps, pgName, next){
                    if(_.isEmpty(pgProps.scriptSchemeId)){
                        return;
                    };
                    var isEn = appUtils.isEn();
                    Rest.getPresetScrpitsBySchemeId([pgProps.scriptSchemeId], {
                        success: function(result){
                            if(_.isEmpty(result)){
                                _.isFunction(next) && next();
                            };
                            var beforeScript, afterScript, startScript, stopScript, msg = appUtils.getString("protection_lun_script_select_scheme_msg1", pgName, $.encoder.encodeForHTML(pgProps.scriptScheme));
                            !_.isEmpty(result.steps) && _.each(result.steps, function(item){
                                item.position == "protect-before" && (msg += "<p>" + appUtils.getString("protection_lun_before_script_select_scheme_msg")) + "</p>";
                                item.position == "protect-after" && (msg += "<p>" + appUtils.getString("protection_lun_after_script_select_scheme_msg")) + "</p>";
                                var scriptName = "";
                                scriptName = _.isObject(item.name) ? isEn ? item.name.en : item.name.zh : "";
                                if(_.isString(item.position) && item.position.startsWith("recovery-drilling")){
                                    msg += "<p>" + appUtils.getString("protection_lun_start_script_select_scheme_msg", appUtils.getString("ism.drm.recover.play.drilling.btn.txt"), scriptName) + "</p>"
                                };
                                if(_.isString(item.position) && item.position.startsWith("recovery-clean_drilling")){
                                    msg += "<p>" + appUtils.getString("protection_lun_start_script_select_scheme_msg", appUtils.getString("ism.drm.recover.play.claer.drilling.btn.txt"), scriptName) + "</p>"
                                };
                            });
                            msg += "<br>" + appUtils.getString("protection_lun_script_select_scheme_msg2");
                            if(_.isFunction(next)){
                                message.warn({
                                    content: msg,
                                    ok: function() {
                                        next();
                                    }
                                });
                            };
                        }
                    })
                };

                var protectLocationKey = (pVm._3dc == 1 || _.isUndefined(pVm._3dc)) ? "ProtectLocation_0" : "ProtectLocation_4";
                //CDM远端从4变为1
                if(isSanHyperVault){
                    protectLocationKey = pVm._3dc == 1 ? "ProtectLocation_0" : "ProtectLocation_1"
                };
                var oldDaily = remainValue['dailyCopies'] || 0;
                var oldWeekly = remainValue['weeklyCopies'] || 0;
                var oldMonthly = remainValue['monthlyCopyies'] || 0;

                function countSnapshot(newSnapshot, newDay, newWeek, newMonth){
                    var msg = "";
                    var newSnapshot = parseInt(newSnapshot,10);
                    var newDay = parseInt(newDay,10);
                    var newWeek = parseInt(newWeek,10);
                    var newMonth = parseInt(newMonth,10);
                    var oldDailyI = parseInt(oldDaily,10);
                    var oldWeeklyI = parseInt(oldWeekly,10);
                    var oldMonthlyI = parseInt(oldMonthly,10);
                    var oldSnapshotCountI = parseInt(oldSnapshotCount,10);
                    if(newSnapshot < oldSnapshotCountI){
                        msg += resource.get("ism.drm.snaphost.delete.danger.new",oldSnapshotCountI,newSnapshot);
                    };
                    if(newDay < oldDailyI){
                        msg += resource.get("ism.drm.snaphost.delete.danger.day",oldDailyI,newDay);
                    };
                    if(newWeek < oldWeeklyI){
                        msg += resource.get("ism.drm.snaphost.delete.danger.week",oldWeeklyI,newWeek);
                    };
                    if(newMonth < oldMonthlyI){
                        msg += resource.get("ism.drm.snaphost.delete.danger.month",oldMonthlyI,newMonth);
                    };
                    if(msg != ""){
                        msg += resource.get("ism.drm.snaphost.delete.danger.msg1");
                    }
                    var newCount = newSnapshot + newDay + newWeek + newMonth;
                    var oldCount = oldSnapshotCountI + oldDailyI + oldWeeklyI + oldMonthlyI;
                    if(newCount < oldCount){
                        msg += "<br>" + resource.get("ism.drm.snaphost.delete.danger.msg2",oldCount,newCount)
                    };
                    return msg;
                };
                //查询接口，获取快照是snapshot还是hyperCDP
                var getsnapshotType = function(){
                    var storageSn = schedule.sourceSn;
                    if(_.isEmpty(storageSn)){
                        return;
                    };
                    Rest.queryStorageLicense([storageSn], {
                        isShowMsgBox: false,
                        success: function(result) {
                            if (!_.isEmpty(result.LicenseFunction)) {
                                var isSupportHyperCDP = !_.isUndefined(_.find(result.LicenseFunction, function(license) {
                                    return Consts.STORAGE_FEATURE_ENUM.HyperCDP == license.FeatureId && !!license.FuncSwitch;
                                }));
                                $("#snapShotTypeRadio").widget() && $("#snapShotTypeRadio").widget().opDisabled("cdp", !isSupportHyperCDP);
                            } else {
                                if ($("#snapShotTypeRadio").widget()) {
                                    $("#snapShotTypeRadio").widget().opDisabled("cdp", true);
                                };
                            }
                        },
                        fail: function(err){
                            if ($("#snapShotTypeRadio").widget()) {
                                $("#snapShotTypeRadio").widget().opDisabled("cdp", true);
                            };
                        }
                    });

                };
                //父子页面传递事件，snapshot和CDP切换，相应页签参数要改变
                var changeSnapshotRadio = function(snapType){
                    if(_.isEmpty(snapType)){
                        return;
                    };
                    //修改最新快照保留数量CDP 2048, 非秒为60000
                    if($("#timeTypeSelect").widget().getSelectedId() == "5"){
                        if($("#snapShotTypeRadio").widget().opChecked("cdp")){
                            $scope.model.snapshotNumber.text = "(1 ~ 60000)";
                            $scope.model.snapshotNumber.validate = [{
                                validFn: "rangeValue",
                                params: [1, 60000],
                            },{
                                validFn: "required",
                            },{
                                validFn: "integer"
                            }];
                        }else{
                            if (!pVm.isSupportSecondPolicy) {
                                $scope.model.snapshotNumber.text = "(1 ~ 2048)";
                                $scope.model.snapshotNumber.validate = [{
                                    validFn: "rangeValue",
                                    params: [1, 2048],
                                }, {
                                    validFn: "required",
                                }, {
                                    validFn: "integer"
                                }];
                            } else {
                                $scope.model.snapshotNumber.text = "(1 ~ 256)";
                                $scope.model.snapshotNumber.validate = [{
                                    validFn: "rangeValue",
                                    params: [1, 256],
                                }, {
                                    validFn: "required",
                                }, {
                                    validFn: "integer"
                                }];
                            }
                        }
                    }else{
                        $scope.model.snapshotNumber.text = "(1 ~ 2048)";
                        $scope.model.snapshotNumber.validate = [{
                            validFn: "rangeValue",
                            params: [1, 2048],
                        },{
                            validFn: "required",
                        },{
                            validFn: "integer"
                        }];
                    };
                    //修改是否可以设置副本高级
                    var ishyperCdp = $("#snapShotTypeRadio").widget().opChecked("cdp");
                    var modeTemp = $("#scheduleModeSelect").widget().getSelectedId();
                    var isSecond = $("#timeTypeSelect").widget().getSelectedId();
                    $scope.model.snapshotNumber.disable = !ishyperCdp && modeTemp == "0" && isSecond == "5";
                    if($scope.model.snapshotNumber.disable){
                        $scope.model.snapshotNumber.advance.show = false;
                    };
                    $scope.model.snapshotNumber.advance.content.monthSpinner.max = $("#timeTypeSelect").widget().getSelectedId() == "5" && ishyperCdp ? 256 : 60;
                    $scope.model.snapshotNumber.advance.content.weekSpinner.max = $("#timeTypeSelect").widget().getSelectedId() == "5" && ishyperCdp ? 256 : 52;
                    $scope.model.snapshotNumber.advance.content.daySpinner.max = $("#timeTypeSelect").widget().getSelectedId() == "5" && ishyperCdp ? 256 : 365;
                    $scope.model.snapshotNumber.advance.content.monthSpinner.valueTips = $("#timeTypeSelect").widget().getSelectedId() == "5" && ishyperCdp ? "(0 ~ 256)" : "(0 ~ 60)";
                    $scope.model.snapshotNumber.advance.content.weekSpinner.valueTips = $("#timeTypeSelect").widget().getSelectedId() == "5" && ishyperCdp ? "(0 ~ 256)" : "(0 ~ 52)";
                    $scope.model.snapshotNumber.advance.content.daySpinner.valueTips = $("#timeTypeSelect").widget().getSelectedId() == "5" && ishyperCdp ? "(0 ~ 256)" : "(0 ~ 365)";
                    $scope.$broadcast("CHANGE_SANPSHOT_TYPE", snapType);
                };

                $scope.model = {
                    haveStart: !isNasTemplate,
                	tabTexts: [
                		resource.get("protection.term.schedulePolicy.label"),
                		resource.get("protection_term_reserverPolicy_label"),
                        resource.get("protection_term_concsistentProtectPolicy_tab")
                	],
                    startBack: {
                        id: "startBack",
                        text: pVm.schedule.protectedType == 101 ? appUtils.getString("pg_create_isstartcloudbackup_label") : appUtils.getString("pg_create_isstartquickbackup_label"),
                        value: "",
                        checked: isNasTemplate ? true : (!_.isEmpty(schedule) ? schedule.enable : false),
                        change: function() {
                            var isChecked = $("#" + this.id).widget().option("checked");
                            this.isStart = isChecked;
                            $scope.$apply();
                        }
                    },
                    snapshotNumber: {
                        id: "snapshotNumber",
                        disable: ((isSanHyperVault && _3dc == 1) || isAddSecondSchedule) && pVm.isSupportSecondPolicy && schedule.protectedType != 101,
                        contentChange: function(e, val){
                        	this.value = val;
                        	this.isValid = checkTotalSnap();
                        	$scope.$apply();
                        },
                        isValid: true,
                        promptText: resource.get("protection.createObject.task.setSchedule.snapshot.prompt"),
                        label: resource.getWithColon("com.huawei.ism.drm.policy.snapshot.limit"),
                        text: "(1 ~ 2048)",
                        height: "26px",
                        width: "200px",
                        value: remainValue["latestCopies"] || 5,
                        validate: [{
                            validFn: "rangeValue",
                            params: [1, 2048],
                        }, {
                            validFn: "required",
                        }, {
                            validFn: "integer"
                        }
                        ],
                        advance: {
                            click: function() {
                                this.show = !this.show;
                            },
                            desc: resource.get("protection_schedule_term_snapshotcopy_des"),
                            show: false,
                            text: resource.get("common_term_advance_button"),
                            content: {
                                monthSpinner: {
                                    id: "monthSpinner",
                                    value: Number(remainValue.monthlyCopyies) || 0,
                                    change: function(){
                                    	$scope.model.snapshotNumber.isValid = checkTotalSnap();
                                        this.value || (this.value = 0);
                                    },
                                    min: 0,
                                    max: 60,
                                    width: "78px",
                                    height: "33px",
                                    label: appUtils.getStringWithColon("protection.monthsnap.label"),
                                    text: resource.get("protection.schedule.snapshot.advance.month"),
                                    valueTips: "(0 ~ 60)"
                                },
                                weekSpinner: {
                                    id: "weekSpinner",
                                    value: Number(remainValue.weeklyCopies) || 0,
                                    change: function(){
                                    	$scope.model.snapshotNumber.isValid = checkTotalSnap();
                                        this.value || (this.value = 0);
                                    },
                                    min: 0,
                                    max: 52,
                                    width: "78px",
                                    height: "33px",
                                    label: appUtils.getStringWithColon("protection.weeksnap.label"),
                                    text: resource.get("protection.schedule.snapshot.advance.week"),
                                    valueTips: "(0 ~ 52)"
                                },
                                daySpinner: {
                                    id: "daySpinner",
                                    value: Number(remainValue.dailyCopies) || 0,
                                    change: function(){
                                    	$scope.model.snapshotNumber.isValid = checkTotalSnap();
                                        this.value || (this.value = 0);
                                    },
                                    min: 0,
                                    max: 365,
                                    width: "78px",
                                    height: "33px",
                                    label: appUtils.getStringWithColon("protection.daysnap.label"),
                                    text: resource.get("protection.schedule.snapshot.advance.day"),
                                    valueTips: "(0 ~ 365)"
                                },

                            },
                        },
                    },
                    snapShotType: {
                        id: "snapShotTypeRadio",
                        spacing:{"width": "20px"},
                        width:"100px",
                        values: [{
                            "key" : "snapshot",
                            "text" : appUtils.getString("vis.snap.name"),
                            "checked" : true,
                            "disable" : false
                        },{
                            "key" : "cdp",
                            "text" : "HyperCDP",
                            "checked" : false,
                            "disable" : false
                        }],
                        label: appUtils.getStringWithColon("protection_create_snapshot_type_label"),
                        tips: appUtils.getString("protection_create_snapshot_rw_label"),
                        change: function(){
                            var checkedKey = $("#" + this.id).widget().opChecked("checked");
                            changeSnapshotRadio(checkedKey);
                        }
                    }
                };
                //回显是否允许设置日、周、月的快照保留策略
                if(!_.isUndefined(schedule.periodType) && (isSanHyperVault || isAddSecondSchedule)){
                    $scope.model.snapshotNumber.disable = schedule.protectedType != 100 && schedule.scheduleMode == 0 && (schedule.periodType == "5" || (schedule.periodType == "0" && parseInt(schedule.periodInterval,10) < 5));
                };
                //传递事件,设置是否允许设置日、周、月的快照保留策略
                $scope.$on("DISABLE_SNAPSHOTNUMBER", function(evt, obj){
                    var ishyperCdp = $("#snapShotTypeRadio").widget().opChecked("cdp");
                    $scope.model.snapshotNumber.disable = !ishyperCdp && !obj.modeType && (obj.type == "5" || (obj.type == "0" && parseInt(obj.minute,10) < 5));
                    if($scope.model.snapshotNumber.disable){
                        $scope.model.snapshotNumber.advance.show = false;
                    };
                    //设置最新副本个数
                    var scheduleValue = {
                        scheduleMode : obj.modeType ? "1" : "0",
                        periodType: obj.type
                    };
                    sanSnapshot(scheduleValue, ishyperCdp);
                    //是否可设置应用一致性
                    $scope.$broadcast("DIABLE_SCHEDULEAPP", !obj.modeType && (obj.type == "5" || (obj.type == "0" && parseInt(obj.minute,10) < 15)));
                });
                //回显快照类型
                $scope.$on('SHOW_SNAPSHOTTYPE_TIP', function(evt, obj){
                    $scope.model.snapShotType.tips = obj.isHyperDcp ? appUtils.getString("protection_create_snapshot_rw_label") : appUtils.getString("protection_create_snapshot_rw_label");
                    $scope.$apply();
                });

                if($scope.pt.type == 17 || $scope.pt.type == 28) {
                    $scope.model.snapshotNumber.validate = [{
                            validFn: "rangeValue",
                            params: [1, 2048],
                        }, {
                            validFn: "required",
                        }, {
                            validFn: "integer"
                    }]
                };

                /*---------------------------------------------------
                	             快照设置
                -----------------------------------------------------*/

                $scope.snapshotDesc = resource.getWithColon("com.huawei.ism.drm.policy.snapshot.limit");
                //输入不合法提示(1-512)
                var snapshotInputTip = resource.get("protection_createObject_task_setSchedule_para_snapshotNO_tip", 2048);
                //快照帮助提示
                $scope.snapshotHelpTip = resource.get("protection_createObject_task_setSchedule_para_snapshotNO_des_label");

                $scope.snapshotInputDesc = resource.get("protection_createObject_task_setSchedule_para_snapshotNO_desc");


                $scope.snapshotCountTextbox = {
                    id: "snapshotCountTextbox",
                    validate: "required:" + snapshotInputTip + ";integer:" + snapshotInputTip + ";minValue(1):" + snapshotInputTip + ";maxValue(2048):" + snapshotInputTip,
                    value: remainValue.latestCopies || 5
                };

                var oldSnapshotCount = remainValue.latestCopies;
                var pgName = pVm.pgName;

                /*--------------------------------------------------*/
                //SAN一体化备份的本端策略为秒时，最新副本为1-256
                function sanSnapshot(scheduleVal, ishyperCdp){
                    try{
                        _.isEmpty(scheduleVal) && (scheduleVal = schedule);
                        if(!pVm.isSupportSecondPolicy && !ishyperCdp && scheduleVal.protectedType != 100){
                            return;
                        };
                        if(((isSanHyperVault && _3dc == 1) || isAddSecondSchedule) && scheduleVal.protectedType != 101) {
                            var typeSelect = "";
                            !_.isEmpty($("#snapShotTypeRadio").widget()) && (typeSelect = $("#snapShotTypeRadio").widget().opChecked("checked"));
                            var typeKey = scheduleVal.protectedType;
                            $scope.model.snapshotNumber.validate = [{
                                    validFn: "rangeValue",
                                    params: _.isUndefined(scheduleVal.periodType) ? ((typeSelect == "cdp" || typeKey == "100") ? [1, 60000] : [1, 256]) : scheduleVal.scheduleMode == 0 && scheduleVal.periodType == "5" ? ((typeSelect == "cdp" || typeKey == "100") ? [1,60000] : [1,256]) : [1,2048],
                                }, {
                                    validFn: "required",
                                }, {
                                    validFn: "integer"
                            }];
                            $scope.model.snapshotNumber.text = _.isUndefined(scheduleVal.periodType) ? ((typeSelect == "cdp" || typeKey == "100") ? "(1 ~ 60000)" : "(1 ~ 256)") : scheduleVal.scheduleMode == 0 && scheduleVal.periodType == "5" ? ((typeSelect == "cdp" || typeKey == "100") ? "(1 ~ 60000)" : "(1 ~ 256)") : "(1 ~ 2048)";
                            $scope.model.snapshotNumber.advance.content.monthSpinner.max = (typeSelect == "cdp" || typeKey == "100") && scheduleVal.scheduleMode == 0 && scheduleVal.periodType == "5" ? 256 : 60;
                            $scope.model.snapshotNumber.advance.content.weekSpinner.max = (typeSelect == "cdp" || typeKey == "100") && scheduleVal.scheduleMode == 0 && scheduleVal.periodType == "5" ? 256 : 52;
                            $scope.model.snapshotNumber.advance.content.daySpinner.max = (typeSelect == "cdp" || typeKey == "100") && scheduleVal.scheduleMode == 0 && scheduleVal.periodType == "5" ? 256 : 365;
                            $scope.model.snapshotNumber.advance.content.monthSpinner.valueTips = (typeSelect == "cdp" || typeKey == "100") && scheduleVal.scheduleMode == 0 && scheduleVal.periodType == "5" ? "(0 ~ 256)" : "(0 ~ 60)";
                            $scope.model.snapshotNumber.advance.content.weekSpinner.valueTips = (typeSelect == "cdp" || typeKey == "100") && scheduleVal.scheduleMode == 0 && scheduleVal.periodType == "5" ? "(0 ~ 256)" : "(0 ~ 52)";
                            $scope.model.snapshotNumber.advance.content.daySpinner.valueTips = (typeSelect == "cdp" || typeKey == "100") && scheduleVal.scheduleMode == 0 && scheduleVal.periodType == "5" ? "(0 ~ 256)" : "(0 ~ 365)";
                        };
                    }catch(err){}
                };
                sanSnapshot();

                //时间表VM
                $scope.baseScheduleVM = ViewModel.create({
                    data: {
                        schedule: schedule,
                        props:$scope.pt.props
                    },
                    ptType: $scope.pt.type,
                    _3dc: _3dc,
                    event: Consts.SCHEDULE_DATA_COLLECTION_EVENT,
                    protectLocation: (_3dc == 1 || _.isUndefined(_3dc) ? 0 : 4),
                    createFlag: pVm.createFlag
                });
                //CDM增加秒级识别标识
                if (isSanHyperVault || isSupportedHyperCdp) {
                    _.extend($scope.baseScheduleVM, {
                        isSupportSecondPolicy: pVm.isSupportSecondPolicy,
                        isSupportCustomSecondPolicy: pVm.isSupportCustomSecondPolicy
                    })
                };

                //应用配置VM
                $scope.appScheduleVM = ViewModel.create({
                    poType: pVm.poType,
                    ptType: $scope.pt.type,
                    data: $scope.pt.props,
                    productSiteId: pVm.productSiteId,
                    event: Consts.SCHEDULE_APP_DATA_COLLECTION_EVENT,
                    protectLocation: (_3dc == 1 || _.isUndefined(_3dc) ? 0 : 4),
                    schedule: schedule
                });

                if ($scope.pt.type == 19 || $scope.pt.type == 17) {
                    $scope.appScheduleVM.protectLocation = _3dc == 1 ? 0 : 4;
                }

                if (pVm.poType == 12) {
                    $scope.appScheduleVM = null;
                }

                //NAS+一体化备份的组网只有Vmware有一致性策略(华为虚拟机和纯NAS不支持)
                if($scope.pt.type == 28 && (pVm.poType == 12 || pVm.poType == 14)){
                    $scope.appScheduleVM = null;
                };
                //CDM远端从4变为1
                if(isSanHyperVault){
                    $scope.baseScheduleVM.protectLocation = _3dc == 1 ? 0 : 1;
                    $scope.appScheduleVM.protectLocation = _3dc == 1 ? 0 : 1;
                };
                //CDM的备端没有应用一致性
                if(isSanHyperVault && schedule.protectLocation == 1){
                    $scope.appScheduleVM = null;
                };
                //查询快照类型
                (_.isEmpty(schedule.scheduleId) && $scope.isSupportSnapShotType) && getsnapshotType();
                //改之前schedule的状态
                var oldScheduleStatuas = schedule.enable;
                //监听父级触发事件
                $scope.$on(pVm.event, function() {
                    if (!checkTotalSnap()) {
                    	pVm.valid = false;
                    	return;
                    };

                    //初次标签页被激活的地方
                    var activeTab = $("#myTabs .tinyTabActive");
                    //校验本窗口的全部标签页,并跳转到第一个校验不通过的控件
                    pVm.valid = tabs.tabsOption.every(function(obj, index) {
                        var id = obj.tabId;
                        if ($('#tabtitle-' + id + ':hidden').length) return true; // 如果标签被隐藏了就不校验
                        var bool = UnifyValid.FormValid($('#tabs-' + id), {
                            checkHidden: true,
                            focusInvalid: false
                        });

                        if (!bool) {
                            $('#tabtitle-' + id).click();
                            bool = UnifyValid.FormValid($('#' + id), {
                                checkHidden: false,
                                focusInvalid: true
                            });
                        }
                        return bool;
                    });
                    //校验通过，重置到初次被点击的标签页
                    pVm.valid && activeTab.click();
                    if (!pVm.valid) return;

                    //时间表数据收集
                    $scope.$broadcast($scope.baseScheduleVM.event);
                    if (!(pVm.valid = $scope.baseScheduleVM.valid)) return;


                    //应用数据收集
                    if ($scope.appScheduleVM) {
                        $scope.$broadcast($scope.appScheduleVM.event);
                        if (!(pVm.valid = $scope.appScheduleVM.valid)) return;
                    }
                    //秒级策略不支持日、周、月副本
                    var isDeleteSnapshot = false;
                    try{
                        var scheduleObj = $scope.baseScheduleVM.data.schedule;
                        var isHyperCdp = $("#snapShotTypeRadio").widget().opChecked("cdp");
                        isDeleteSnapshot = ((isSanHyperVault && _3dc == 1) || isAddSecondSchedule) && !isHyperCdp && scheduleObj.scheduleMode == 0 && scheduleObj.periodType == 5;
                    }catch(err){};

                    var latestCopies = $("#snapshotNumber").widget().getValue();
                    var snapKey = _3dc == 1 || _.isUndefined(_3dc) ? 0 : 4;
                    //CDM远端从4变为1
                    if(isSanHyperVault){
                        snapKey = _3dc == 1 ? 0 : 1;
                    };
                    var dayValue;
                    var weekValue;
                    var monthValue;
                    try{
                        dayValue = $("#daySpinner").widget().option("value");
                        weekValue = $("#weekSpinner").widget().option("value");
                        monthValue = $("#monthSpinner").widget().option("value");
                    }catch(err){
                        dayValue = $scope.model.snapshotNumber.advance.content.daySpinner.value;
                        weekValue = $scope.model.snapshotNumber.advance.content.weekSpinner.value;
                        monthValue = $scope.model.snapshotNumber.advance.content.monthSpinner.value;
                    };
                    //保留策略数据收集
                    _.extend($scope.baseScheduleVM.data.schedule, {
                        retentionPolicy: {
                            latestCopies: latestCopies,
                            dailyCopies: isDeleteSnapshot ? 0 : (dayValue || 0),
                            weeklyCopies: isDeleteSnapshot ? 0 : (weekValue || 0),
                            monthlyCopyies: isDeleteSnapshot ? 0 : (monthValue || 0)
                        }
                    });
                    //nas的快照、一体化备份、双活+一体化备份
                    if (isNasTemplate) {
                        _.extend($scope.baseScheduleVM.data.schedule, {
                            protectedType: $scope.pt.type
                        });
                    };
                    //schedule替换
                    $scope.pt.schedules = [$scope.baseScheduleVM.data.schedule];
                    //秒级策略和分钟级小于15分钟不支持设置一致性策略
                    if ($scope.appScheduleVM) {
                        var scheduleTemp = $scope.baseScheduleVM.data.schedule;
                        if (scheduleTemp.scheduleMode == 0 && (scheduleTemp.periodType == 5 || (scheduleTemp.periodType == 0 && scheduleTemp.periodInterval < 15))) {
                            var keyType = "appConsistent";
                            //如果启用应用一致性
                            if ($scope.appScheduleVM.schedule[keyType] == 1) {
                                message.error(appUtils.getString("pg_support_config_policy_error_label"));
                                pVm.valid = false;
                                return;
                            }
                        }
                    };
                    //创建保护组
                    if (pVm.createFlag) {
                        if (_3dc && _.isUndefined($scope.baseScheduleVM.data.schedule.protectLocation)) {
                            $scope.baseScheduleVM.data.schedule.protectLocation = _3dc == 1 ? 0 : 4;
                            //CDM远端从4变为1
                            if(isSanHyperVault){
                                $scope.baseScheduleVM.data.schedule.protectLocation = _3dc == 1 ? 0 : 1;
                            };
                            $scope.baseScheduleVM.data.schedule.name = pVm.scheduleName;
                        }

                        if ($scope.baseScheduleVM.data.schedule.protectedType == Consts.STORAGE_FEATURE_ENUM.CloudBackup) {
                            $scope.baseScheduleVM.data.schedule.name = pVm.scheduleName;
                        }
                        //快照
                        if ($scope.pt.type == 2) {
                            $scope.baseScheduleVM.data.schedule.name = pVm.scheduleName;
                        }
                    }
                    //修改策略
                    else {
                        //如果schedule为空，需要调用增加任务计划时间表，否则调用修改任务计划时间表
                        var reqConf = {
                            "data": schedule,
                            "interceptor": function(next) {
                                var encodePgName = $.encoder.encodeForHTML(pgName);
                                //减少快照个数需要添加高危提示
                                var newSnapshotCount = schedule.retentionPolicy.latestCopies;
                                var newDay = schedule.retentionPolicy.dailyCopies;
                                var newWeek = schedule.retentionPolicy.weeklyCopies;
                                var newMonth = schedule.retentionPolicy.monthlyCopyies;
                                var newMsg = countSnapshot(newSnapshotCount,newDay,newWeek,newMonth);
                                if (newMsg != "") {
                                    var msg = resource.get("ism.drm.snaphost.modify.danger.msg1", encodePgName) + "<br>" +
                                        resource.get("ism.drm.pg.snap.schedule.modify.msg", encodePgName) + newMsg + "<br>" +
                                        resource.get("ism.drm.snaphost.modify.danger.msg3");

                                    message.warn({
                                        content: msg,
                                        ok: function() {
                                            next();
                                        }
                                    });
                                } else {
                                    //手动不做任何提示
                                    if ($scope.baseScheduleVM.data.schedule.scheduleMode == 1) {
                                        //lun快照
                                        if(isLunSnapShot && $scope.pt.props.isUserDefined == "0"){
                                            choseSystemScriptTip($scope.pt.props, encodePgName, next);
                                        }else{
                                            next();
                                        }
                                    } else {
                                        if(isLunSnapShot && $scope.pt.props.isUserDefined == "0"){
                                            choseSystemScriptTip($scope.pt.props, encodePgName, next);
                                        }else{
                                            var msg = resource.get("ism.drm.pg.schedule.modify.msg1", encodePgName) + "<br>" +
                                                resource.get("ism.drm.pg.schedule.modify.msg2", encodePgName) + "<br>" +
                                                resource.get("ism.drm.pg.schedule.modify.msg3");

                                            message.warn({
                                                content: msg,
                                                ok: function() {
                                                    next();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            "success": function() {
                                pVm.defer.resolve();
                            }
                        }
                        if (!_.isEmpty(schedule.scheduleId)) {
                            //启用任务计划直接调用修改
                            if (oldScheduleStatuas === false && schedule.enable === true) {
                                Rest.modifyPgSchedule([pVm.pgId, schedule.scheduleId], reqConf);
                            }
                            //禁用任务计划
                            else if (oldScheduleStatuas === true && schedule.enable === false) {
                                Rest.disableSchedule([pVm.pgId, schedule.scheduleId], reqConf);
                            }
                            //禁用到禁用直接关闭弹窗
                            else if (oldScheduleStatuas === false && schedule.enable === false) {
                                !_.isUndefined($("#ModifyTempLink").widget()) && $("#ModifyTempLink").widget().destroy();
                            }
                            //修改任务计划
                            else {
                                Rest.modifyPgSchedule([pVm.pgId, schedule.scheduleId], reqConf);
                            }
                        } else {
                            if (!schedule.enable) {
                                !_.isUndefined($("#ModifyTempLink").widget()) && $("#ModifyTempLink").widget().destroy();
                                return;
                            }
                            Rest.addPgSchedule([pVm.pgId], reqConf);
                        }
                    }
                });

				function checkTotalSnap(){
					var	snap = $scope.model.snapshotNumber;
					var daySnap = snap.advance.content.daySpinner;
					var monthSnap = snap.advance.content.monthSpinner;
					var weekSnap = snap.advance.content.weekSpinner;
					var sumSnap = sum(snap.value, daySnap.value, monthSnap.value, weekSnap.value);
                    //SAN一体化备份
                    if (isSanHyperVault || isAddSecondSchedule) {
                        if($("#snapShotTypeRadio").widget()){
                            return $("#snapShotTypeRadio").widget().opChecked("checked") == "cdp" ? Number(snap.value) <= 60000 : Number(snap.value) <= 2048
                        }else{
                            return Number(snap.value) <= 2048;
                        }
                    } else {
                        if (sumSnap > 2048) {
                            return false;
                        } else {
                            return true;
                        }
                    }

					function sum(){
						var arr = Array.prototype.slice.call(arguments, 0);
						return arr.reduce(function(a,b){
							return Number(a) + Number(b);
						});
					}
				}

                (function init() {
                    setTimeout(function() {
                        $('#myTabs #tab_head li:eq(0)').click();
                    }, 300);
                })();
            }
        ];
        return ctrl;
    });
