define(["tiny-common/UnifyValid"],
	function(UnifyValid){

	var ctrl = ["$scope", "$controller", "$compile", "appUtils", "constsService","restService","model","message",
	     function($scope, $controller, $compile, appUtils, Consts, Rest, Model, message){
			//修改策略(scheduleWin.html)或者创建保护组(pgCreateStep3.js),传入viewModel
			var pVm = $scope.viewModel;
			$scope.pt = pVm.data;
			$scope.Consts = Consts;
			//执行策略的帮助提示
			var resource = appUtils.resource();
			var defaultConf = resource.getWithColon("protection.copyrate.default.config");
			var defaultConfDesc = resource.get("protection.copyrate.default.config.desc");
			var manualConf   = resource.getWithColon("protection.copyrate.manual.config");
			var manualConfDesc   = resource.get("protection.copyrate.manual.config.desc");
			$scope.copyrateTip =
				"<p>" + defaultConf + "</p>" +
				"<p>" + defaultConfDesc + "</p>" +
				"<p style='margin-top:20px;'>" + manualConf + "</p>" +
				"<p>" + manualConfDesc + "</p>";

			$scope.lowDesc = resource.get("protection.copyrate.low.desc");
			$scope.midDesc = resource.get("protection.copyrate.mid.desc");
			$scope.highDesc = resource.get("protection.copyrate.high.desc");
			$scope.extHighDesc = resource.get("protection.copyrate.extremely.high.desc");
			var tabs = new tinyWidget.Tabs({
	                    "id" : "myTabs",
	                    "setActiveClass" : true
	                });
			$scope.model = {
				tabs: {
					text: [
						resource.get("protection_term_reserverPolicy_label"),
						resource.get("common_term_timePolicy_tab"),
						resource.get("protection_term_concsistentProtectPolicy_tab"),
						resource.get("common_term_clonePolicy_tab")
					],
				},
				copyPolicy: {
					promptText: resource.get("protection.schedule.clone.copyPolicy.promptText"),
					textbox: {
					    id: "textbox",
					    contentChange: function(e, val){
					    	this.value = val;
					    },
					    beforeText: resource.getWithColon("protection.schedule.clone.copyCount"),
					    afterText: "(1 ~ 512)",
					    type: "multi",
					    height: "26px",
					    width: "200px",
					    value: Number($scope.pt.props.PP_SNAPSHOT_COUNT) || 1,
					    validate: [{
					        validFn: "rangeValue",
					        params: [1, 512],
					    }, {
					        validFn: "required",
					    }, {
                            validFn: "integer"
					    }],

					},
				},
			};
			var ViewModel = Model.ViewModel;
			var _3dc = pVm._3dc;
			var schedule = pVm.schedule;
			var pgName = pVm.pgName;
			var ptType = parseInt($scope.pt.type,10);
			var is3dcSync = (ptType == 3 && _3dc == 1) || (ptType == 5 && _3dc == 1);
			if( !schedule && is3dcSync ){
				schedule = {
					protectLocation:1,
					scheduleMode:1
				}
			}

			//查询保护路径
			if (pVm.createFlag && pVm.poType == 11 && ptType == 16) {
				Rest.getScheduleSiteInfo([pVm.poType, $scope.pt.uuid], {
				    data: pVm.poListIds,
				    isShowMsgBox: false,
				    success: function(result) {
				        if (!_.isEmpty(result)) {
				            schedule.sourceSn = result[0].detail.protectedStorageSN;
				            schedule.sourceSiteId = result[0].detail.protectedSiteId;
				            schedule.targetSn = result[0].detail.protectedStorageSN;
				            schedule.targetSiteId = result[0].detail.protectedSiteId;
				        };
				    }
				});
			};

			if( !pVm.createFlag && ptType == 0 && $scope.pt.schedules ){
				schedule = $scope.pt.schedules[0];
			}

			//是否是Lun克隆BCV
			$scope.isLunClone = pVm.poType == 11 && ptType == 16;
			$scope.bcvLun = {
				clonePolicyLabel: appUtils.getString("protection_term_clone_split_policy_label"),
				deferBox: {
					id: "deferSelect",
					text: resource.get("protection_term_clone_split_select_defer"),
					checked: false,
					click: function(){
						$scope.bcvLun.minute.disable = !$("#deferSelect").widget().option("checked");
						!$("#deferSelect").widget().option("checked") && ($scope.bcvLun.minute.value = "");
						$scope.$apply();
					}
				},
				minute: {
					label: resource.get("protection_term_clone_split_message_label"),
					timeText: appUtils.getStringWithColon("protection_term_clone_split_defer_time"),
					timeUnit: resource.get("common_term_minute_plural_label"),
					tips: resource.get("protection_term_clone_split_defer_time_valit"),
					id: "minuteText",
					width:"100px",
					disable: true,
					validate: [{
                         validFn: "required"
                     },{
                         validFn: "rangeValue",
                         params: [1, 1410],
                         errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 1, 1410)
                     },{
                         validFn: "integer"
                     }]
				},
				createSnapshot: {
					id: "createSnapshotBox",
					text: resource.get("protection_term_clone_split_create_snap_box"),
					tips: resource.get("protection_term_clone_split_fail_tips"),
					checked: false
				}
			};

			/*---------------------------------------------------
				              初始化站点名称描述
			-----------------------------------------------------*/
			var scheduleName;
			//异步复制 只显示时间表
			$scope.title = resource.get("common_term_timePolicy_tab");
			$scope.copyRateTitle = resource.get("protection.copyrate.policy.label");
			$scope.copyPolicyLabel = resource.getWithColon("protection.copyrate.policy.label");
			$scope.copyRateLabel = resource.getWithColon("protection.copyrate.label");
			$scope.text = {
                "low" : resource.get("protection.copyrate.low"),
                "mid" : resource.get("protection.copyrate.mid"),
                "high" : resource.get("protection.copyrate.high"),
                "extreHigh" : resource.get("protection.copyrate.extremely.high"),
                "colorPanelTip" : resource.get("protection.copyrate.colorpanel.tip")
            };

			//判断是否是同步复制,同步复制不显示时间表
			$scope.isSync = ptType == 0 || is3dcSync;


			if( [3,4,5,6].indexOf(ptType) != -1 ){
				//创建时,3dc场景查询站点名称,并保存在schedule.name中
				if( pVm.createFlag ){
					scheduleName = pVm.scheduleName;
			    	$scope.title = pVm.scheduleNameText;
			    	if( $scope.isSync ){
			    		$scope.copyRateTitle = $scope.copyRateTitle + pVm.scheduleNameText.slice(pVm.scheduleNameText.indexOf("("));
			    	}
				}
				//修改时,从对象中获取(schedule.[protectedSiteName,recoverySiteName])
				else{
					if( schedule.protectedSiteName && schedule.recoverySiteName ){
						$scope.title = resource.get("protection.term.scheduleProduction.label",schedule.protectedSiteName + "->" + schedule.recoverySiteName);
						if( $scope.isSync && pVm.scheduleNameText ){
							$scope.copyRateTitle = pVm.scheduleNameText;
						}

						delete schedule.protectedSiteName;
						delete schedule.recoverySiteName;
					}
					else{
						//级联同步+异步显示"时间表(一级灾备站点->二级灾备站点)"
						if( $scope.pt.type == "3" ){
							$scope.title = resource.get("protection.term.scheduleProductionToDR3Level.label");
						}
						//并联同步+异步显示"时间表(生产站点->二级灾备站点)"
						else if( $scope.pt.type == "5" ){
							$scope.title = resource.get("protection.term.scheduleProductionToDR2Level.label");
						}else{
							if(_3dc == 1){
								$scope.title = resource.get("protection.term.scheduleProductionToDR1Level.label");
							}
							else{
								var titleKey = schedule.protectLocation == 2 ? "protection.term.scheduleProductionToDR2Level.label" : "protection.term.scheduleProductionToDR3Level.label";
								$scope.title = resource.get(titleKey);
							}
						}

						if( is3dcSync ){
							$scope.copyRateTitle = resource.get("protection.term.scheduleProductionToDR1Level.label");
						}
					}
				}
			}

			var protectLocation = 1;

			if (_3dc) {
				//一体化备份
				if( $scope.pt.type == "17" ){
					protectLocation = _3dc == 1 ? 0 : 4;
				}
				else{
					if(_3dc == 1){
						protectLocation = 1;
					}
					else{
						protectLocation = ($scope.pt.type == 6 || $scope.pt.type == 5) ? 2 : 3;
					}
				}
			}
			//克隆
			if ($scope.pt.type == "16") {
			    protectLocation = 0;
			};

			//是否显示复制速率(阵列异步复制和同步复制显示)
			$scope.showRateSetting = [0,1,3,4,5,6,18,20].indexOf(ptType) != -1;
			if( $scope.showRateSetting ){
				$scope.showRateManualSetting = false;
				$scope.copyRateSelect = {
					id : "copyRateSelect",
					values :[{
						selectId : "1",
						label : resource.get("protection.copyrate.default.config")
					},{
						selectId : "0",
						label : resource.get("protection.copyrate.manual.config")
					}],
					defaultSelectid : "1",
					change : function(){
						$scope.showRateManualSetting = $("#"+$scope.copyRateSelect.id).widget().getSelectedId() == "0";
					}
				}

				var LEVEL_COLOR = {
					4 : "#FF6600",
					3 : "#FFCC00",
					2 : "#00CC66",
					1 : "#01FFFF"
				};

				//点击表格
				$(".time-table td").click(function(){
					var data = {
						level: $(this).data().level || 2 ,
						time: $(this).text()
					};

					var win = angular.copy(Consts.COPYRATE_SETTING_WIN);
					win.title = resource.get(win.title);
					win.close = function(){
						data = appUtils.getWinData();
						if(!_.isObject(data)) return;
						var time = data.time.split("->");
						drawTable(time[0],time[1],data.level);
					}

					appUtils.openWin(win,data);
				});

				var syncRateRecords = $scope.pt.props.syncRateRecords;
				if( syncRateRecords && _.isString(syncRateRecords) ){
					syncRateRecords = JSON.parse(syncRateRecords);
				}

				if( _.isArray(syncRateRecords) && syncRateRecords.length != 0 ){



					var filterData = _.filter(syncRateRecords,function(record){
						return record.protectLocation == protectLocation;
					});

					if(_.isArray(filterData) && filterData.length!=0){
						filterData.forEach(function(record){
							var startTime = record.startTime;
							var endTime = record.endTime;
							var level = record.syncRateLevel;
							drawTable(startTime,endTime,level,true);
						});

						$scope.showRateManualSetting = true;
						$scope.copyRateSelect.defaultSelectid = "0";
					}
				}
			}

			/*--------------------------------------------------*/

			function initBaseAndApp(){
				//时间表VM
				$scope.baseScheduleVM = ViewModel.create({
					data:{schedule:schedule, props: $scope.pt.props},
					ptType: $scope.pt.type,
					event:Consts.SCHEDULE_DATA_COLLECTION_EVENT,
					title: $scope.title,
					titleFirst: true,
					_3dc: _3dc,
					protectLocation: protectLocation
				});

				//应用配置VM
				$scope.appScheduleVM = ViewModel.create({
					poType: pVm.poType,
					ptType: $scope.pt.type,
					data: $scope.pt.props,
					event: Consts.SCHEDULE_APP_DATA_COLLECTION_EVENT,
					protectLocation: protectLocation,
					schedule: schedule
				});
				//LUN克隆策略
				if($scope.isLunClone && !_.isUndefined($scope.pt.props.CLONE_SPLIT)){
					var cloneSplitValue = angular.copy($scope.pt.props.CLONE_SPLIT);
					_.isString(cloneSplitValue) && (cloneSplitValue = JSON.parse(cloneSplitValue));
					var minutes = $.trim(cloneSplitValue['split_delay_time']);
					$scope.bcvLun.deferBox.checked = !(_.isEmpty(minutes) || minutes == "0");
					$scope.bcvLun.minute.disable = _.isEmpty(minutes) || minutes == "0";
					$scope.bcvLun.minute.value = _.isEmpty(minutes) ? "" : parseInt(minutes,10);
					$scope.bcvLun.createSnapshot.checked = cloneSplitValue['create_snap'];
					$scope.$apply();
				};
				//3dc异步+异步并联复制可分站点设置一致性策略
				if( $scope.pt.type == "6" ){
					$scope.appScheduleVM.protectLocation = _3dc == 1 ? 1 : 2;
				}
				//一体化备份
				else if( $scope.pt.type == "17" ){
					$scope.appScheduleVM.protectLocation = _3dc == 1 ? 0 : 4;
				}


				//3dc异步+异步级联复制不能设置应用策略
				if( $scope.pt.type == "4" && _3dc == 2 ){
					$scope.appScheduleVM = null;
				}
				//华为虚拟机
				if( pVm.poType == "12" ){
					$scope.appScheduleVM = null;
				}
			}

			if( $scope.isSync ){
				$("._title").css("margin-top",0);
			}
			else{
				initBaseAndApp();
			}

			/*--------------时间小于15分钟，不允许设置一致性------------------*/
			$scope.$on("DISABLE_SNAPSHOTNUMBER", function(evt, obj) {
				_.isObject(obj) && $scope.$broadcast("DIABLE_SCHEDULEAPP", !obj.modeType && (obj.type == "5" || (obj.type == "0" && parseInt(obj.minute, 10) < 15)));
			});

			//监听父级触发事件
			$scope.$on(pVm.event, function(){
				pVm.valid = true;

				//校验本窗口的全部标签页,并跳转到第一个校验不通过的控件
				pVm.valid = tabs.tabsOption.every(function(obj, index) {
				    var id = obj.tabId;
				    if ($('#tabtitle-' + id + ':hidden').length) return true; // 如果标签被隐藏了就不校验
				    var bool = UnifyValid.FormValid($('#tabs-' + id), {
				        checkHidden: true,
				        focusInvalid: false
				    });

				    if (!bool) {
				        $('#tabtitle-' + id).click();
				        bool = UnifyValid.FormValid($('#' + id), {
				            checkHidden: false,
				            focusInvalid: true
				        });
				    }
				    return bool;
				});
				if (!pVm.valid) return;
				if( !$scope.isSync ){
					//时间表数据收集
					$scope.$broadcast($scope.baseScheduleVM.event);
					if(!(pVm.valid = $scope.baseScheduleVM.valid)) return;

					//应用数据收集
					if( $scope.appScheduleVM ){
						$scope.$broadcast($scope.appScheduleVM.event);
						if(!(pVm.valid = $scope.appScheduleVM.valid)) return;
					}
					//LUN克隆策略数据收集
					if($scope.isLunClone){
						var isSplit = $("#deferSelect").widget().option("checked");
						var creatShot = $("#createSnapshotBox").widget().option("checked");
						var cloneSplit = {
							create_snap: creatShot,
							split_delay_time: $("#minuteText").widget().getValue()
						};
						!isSplit && (delete cloneSplit.split_delay_time);
						cloneSplit = JSON.stringify(cloneSplit);
						_.extend($scope.pt.props,{
							CLONE_SPLIT: cloneSplit
						});
					}

					$scope.pt.schedules = [schedule];
					//@dev:rollback
				}
				pVm.copiesCount = Number($scope.model.copyPolicy.textbox.value);

				if(ptType == 0){
					if(pVm.createFlag){
						$scope.pt.schedules = [{"scheduleMode":1}];
					}
					else{
						$scope.pt.schedules = [schedule];
					}
				}

				if( is3dcSync ){
					$scope.pt.schedules = [schedule];
				}

				if( $scope.showRateSetting ){
					var rateData = [];
					if( $scope.showRateManualSetting ){
						rateData = getRateData();
					}
					if(!pVm.createFlag){
						var peerData = getPeerCopyRate();
						rateData = rateData.concat(peerData);
					}
					$scope.pt.props.syncRateRecords = JSON.stringify(rateData);
				}
				//秒级策略和分钟级小于15分钟不支持设置一致性策略
				if ($scope.appScheduleVM) {
				    var scheduleTemp = $scope.baseScheduleVM.data.schedule;
				    if (scheduleTemp.scheduleMode == 0 && (scheduleTemp.periodType == 5 || (scheduleTemp.periodType == 0 && scheduleTemp.periodInterval < 15))) {
				        var keyType = "appConsistent";
				        //如果启用应用一致性
				        if ($scope.appScheduleVM.schedule[keyType] == 1) {
				            message.error(appUtils.getString("pg_support_config_policy_error_label"));
				            pVm.valid = false;
				            return;
				        }
				    }
				};

				//创建保护组
				if (pVm.createFlag) {
					if( _3dc ){
						//一体化备份
						if( $scope.pt.type == "17" ){
							schedule.protectLocation = 	protectLocation;
						}
						else{
							schedule.protectLocation = 	protectLocation;
							schedule.name = scheduleName;
						}
					}
					else{
						/*---------------------------------------------------
							protectLocation,用于判断3dc类型(A-B,B-C,A-C)
						-----------------------------------------------------*/
						if( !$scope.isSync ){
							schedule.protectLocation = protectLocation;
						}
					}
					//增加protectedType
					_.isUndefined(schedule.protectedType) && (schedule.protectedType = $scope.pt.type);


				}
				else{
					var reqConf = {
						data: schedule,
						interceptor: function(next){
							//手动不做任何提示
							if( $scope.isSync || $scope.baseScheduleVM.data.schedule.scheduleMode == 1 ){
								next();
							}
							else{
								var encodePgName = $.encoder.encodeForHTML(pgName);
								var msg = resource.get("ism.drm.pg.schedule.modify.msg1",encodePgName) + "<br>" +
									resource.get("ism.drm.pg.schedule.modify.msg2",encodePgName) + "<br>" +
									resource.get("ism.drm.pg.schedule.modify.msg3");

								message.warn({
									content: msg,
									ok: function() {
										next();
									}
								});
							}
						},
						success : function(){
							pVm.defer.resolve();
						}
					};
					//修改schedule
					Rest.modifyPgSchedule([pVm.pgId, schedule.scheduleId],reqConf);
					//修改克隆策略
					if($scope.pt.type == "16"){
						Rest.modifyPolicy(pVm.pgId, {
							data: $scope.pt,
							success: function(){}
						});
					};
				}
			});

			function getRateData(){
				var rate = [];
				var lastLevel;
				var crtItem;

				for(var i=0;i<24;i++){
					var time = i>=10?i+":00":"0"+i+":00";
					var level = $(".time-table td:contains("+time+")").data("level") || 2;
					if(level != lastLevel){
						crtItem = {
							startTime: time,
							endTime: ( (i+1)>=10?(i+1)+":00":"0"+(i+1)+":00" ),
							syncRateLevel: level,
							protectLocation: protectLocation
						}
						if( crtItem.endTime == "24:00" ){
							crtItem.endTime = "00:00";
						}
						rate.push(crtItem);
						lastLevel = level;
					}
					else{
						crtItem.endTime = ( (i+1)>=10?(i+1)+":00":"0"+(i+1)+":00" );
						if( crtItem.endTime == "24:00" ){
							crtItem.endTime = "00:00";
						}
					}
				}

				return rate;
			}

			function drawTable(startTime,endTime,level,init){
				var fromHour = parseInt(startTime.split(":")[0],10);
				var toHour   = parseInt(endTime.split(":")[0],10);

				if(toHour == 0){
					toHour = 23;
				}
				else{
					toHour--;
				}

				var color = LEVEL_COLOR[level];

				for(var i=fromHour;i<=toHour;i++){
					var text = i>=10?i+":00":"0"+i+":00";
					$(".time-table td:contains("+text+")").css("background",color).data("level",level);
				}
			}

			function getPeerCopyRate(){
				var old = $scope.pt.props.syncRateRecords;
				if( _.isString(old) ){
					var oldArr = JSON.parse(old);
					if(_.isArray(oldArr)){
						var filterData = _.filter(oldArr,function(record){
							return record.protectLocation != protectLocation;
						});
						return filterData;
					}
				}
				return [];
			}

			function getSelectionValues(length, suffix){
				var arr = [];
				for (var i = 0; i < length ; i++){
					arr.push( {selectId: String(i), label: i+suffix} );
				}
				return arr;
			}
			(function init(){
				setTimeout(function(){
					$('#myTabs #tab_head li:visible:eq(0)').click();
					$('.first_title').hide();
				},300);
			})();
	}];

	return ctrl;
});