define(["tiny-common/UnifyValid"], function(UnifyValid){

	var ctrl = ["$scope", "$timeout", "$controller", "$compile", "appUtils", "constsService","restService","model","message", "infoTransferredService",
	     function($scope, $timeout, $controller, $compile, appUtils, Consts, Rest, Model, message, infoTransferredService){
			//修改策略(scheduleWin.html)或者创建保护组(pgCreateStep3.js),传入viewModel
			var pVm = $scope.viewModel;
			$scope.pt = pVm.data;
			$scope.Consts = Consts;

			//执行策略的帮助提示
			var resource = appUtils.resource();
			$scope.isRateDefault = true;
			$scope.copyRateDesc = resource.get("protection.copyrate.default.config.desc");

			$scope.lowDesc = resource.get("protection.copyrate.low.desc");
			$scope.midDesc = resource.get("protection.copyrate.mid.desc");
			$scope.highDesc = resource.get("protection.copyrate.high.desc");
			$scope.extHighDesc = resource.get("protection.copyrate.extremely.high.desc");
			//同步+异步的环形3DC
			var isSyncAndAsyncRing = _.contains([3,5], parseInt($scope.pt.type)) && pVm._3dc == 2 && (pVm.data.sketch.indexOf("policy_template_3_cascaded_sa_dr_star") != -1 || pVm.data.sketch.indexOf("policy_template_5_concurrent_sa_dr_star") != -1);
			//环形3dc
			var ringSiteInfo = pVm.ringSiteStorage;
			var switchSide = {};
			$scope.is3dcRingPolicy = $scope.pt.type == 26 || $scope.pt.type == 27 || isSyncAndAsyncRing;
			if($scope.is3dcRingPolicy && !_.isUndefined(ringSiteInfo)){
				if($scope.pt.type == 26 || isSyncAndAsyncRing){
					switchSide.title1 = ringSiteInfo.detail.protectedSiteName.split(":")[0] + ">" + ringSiteInfo.detail.recoverySiteName,
					switchSide.storage1 = ringSiteInfo.detail.protectedStorageSN.split(":")[0],
					switchSide.title2 = ringSiteInfo.detail.protectedSiteName.split(":")[1] + ">" + ringSiteInfo.detail.recoverySiteName,
					switchSide.storage2 = ringSiteInfo.detail.protectedStorageSN.split(":")[1],
					switchSide.protectLocation = ringSiteInfo.protectLocation
				}else{
					switchSide.title1 = ringSiteInfo.detail.protectedSiteName + ">" + ringSiteInfo.detail.recoverySiteName.split(":")[0],
					switchSide.storage1 = ringSiteInfo.detail.recoveryStorageSN.split(":")[0],
					switchSide.title2 = ringSiteInfo.detail.protectedSiteName + ">" + ringSiteInfo.detail.recoverySiteName.split(":")[1],
					switchSide.storage2 = ringSiteInfo.detail.recoveryStorageSN.split(":")[1],
					switchSide.protectLocation = ringSiteInfo.protectLocation
				}
			};
			//切换开关
			function switchRate(rateData, storage) {
			    if (_.isEmpty(rateData)) {
			        var ringRateRecords;
			        if (_.isEmpty(schedule.replicationSpeedPolicies)) {
			            ringRateRecords = [{
			                endTime: "00:00",
			                protectLocation: 5,
			                startTime: "00:00",
			                syncRateLevel: 2,
			                storageSn: storage
			            }];
			        } else {
			            ringRateRecords = schedule.replicationSpeedPolicies;
			        }
			        rateData = _.filter(ringRateRecords, function(val) {
			            return val.storageSn == storage
			        })
			    };
			    rateData.forEach(function(record) {
			        var startTime = record.startTime;
			        var endTime = record.endTime;
			        var level = record.syncRateLevel;
			        drawTable(startTime, endTime, level, true);
			    });
			};
			$scope.switchScope = {
				"items": [{
					label: function(){
						try {
						    if (switchSide.title1.split("").length > 20) {
						        return (switchSide.title1.slice(0, 20) + "...")
						    };
						    return switchSide.title1
						} catch (err) {
						    return switchSide.title1
						}
					}(),
					value:"on"
				},{
					label: function(){
						try {
						    if (switchSide.title2.split("").length > 20) {
						        return (switchSide.title2.slice(0, 20) + "...")
						    }
						    return switchSide.title2
						} catch (err) {
						    return switchSide.title2
						}
					}(),
					value:"off"
				}],
				"standard": false,
				"selected": "on",
				"change": function(){
					var selected  = this.selected;
					if(selected == "on"){
						//保存切换前数据switchSide
						_.extend(switchSide,{
							rateData1: getRateData()
						})
						//加载切换后数据switchSide
						switchRate(switchSide.rateData2,switchSide.storage2);
					}else{
						_.extend(switchSide,{
							rateData2: getRateData()
						})
						switchRate(switchSide.rateData1,switchSide.storage2);
					}
				}
			};

			$timeout(function(){
				$(".tiny-switch-middle:eq(1)").attr("title", switchSide.title1);
				$(".tiny-switch-middle:eq(2)").attr("title", switchSide.title2);
			},0)

			var ViewModel = Model.ViewModel;
			var _3dc = pVm._3dc;
			var schedule = pVm.schedule || {};
			var pgName = pVm.pgName;
			var ptType = parseInt($scope.pt.type,10);
			var is3dcSync = (ptType == 3 && _3dc == 1) || (ptType == 5 && _3dc == 1);

			var tabs = new tinyWidget.Tabs({
			        "id": "myTabs",
			        "setActiveClass": true
			});
			//查询保护路径
			if (pVm.createFlag) {
			    Rest.getScheduleSiteInfo([pVm.poType, pVm.data.uuid], {
			        data: pVm.poListIds,
			        isShowMsgBox: false,
			        success: function(result) {
			            if (!_.isEmpty(result)) {
			            	result = _.filter(result, function(vaule) {
							    return vaule.protectLocation == 1;
							});
							if (_.isEmpty(result)) {
							    return;
							};
			                _.isEmpty(schedule.sourceSiteId) && _.extend(schedule, {
			                	sourceSiteId: result[0].detail.protectedSiteId
			                });
			                _.isEmpty(schedule.targetSiteId) && _.extend(schedule, {
			                	targetSiteId: result[0].detail.recoverySiteId
			                });
			            };
			        }
			    });
			};
			$scope.model = {
				tabTexts: [
					resource.get("protection.term.schedulePolicy.label"),
					resource.get("protection.copyrate.policy.label"),
			        resource.get("protection_term_concsistentProtectPolicy_tab")
				],
			}

			if( is3dcSync ){
				_.extend(schedule, {
					protectLocation:1,
					scheduleMode:1
				})
			}

			if( !pVm.createFlag && (ptType == 0 || ptType == 21 || ptType == 23 || ptType == 24) && $scope.pt.schedules ){
				schedule = $scope.pt.schedules[0];
			}

			/*---------------------------------------------------
				              初始化站点名称描述
			-----------------------------------------------------*/
			var scheduleName;
			//异步复制 只显示时间表
			$scope.title = resource.get("common_term_timePolicy_tab");
			$scope.copyRateTitle = resource.get("protection.copyrate.policy.label");
			$scope.copyPolicyLabel = resource.getWithColon("protection.copyrate.policy.label");
			$scope.copyRateLabel = resource.getWithColon("protection.copyrate.label");
			$scope.text = {
                "low" : resource.get("protection.copyrate.low"),
                "mid" : resource.get("protection.copyrate.mid"),
                "high" : resource.get("protection.copyrate.high"),
                "extreHigh" : resource.get("protection.copyrate.extremely.high"),
                "colorPanelTip" : resource.get("protection.copyrate.colorpanel.tip"),
                "3dcRingColorPanelTip": resource.get("protection.copyrate.colorpanel.tip")
            };

			//判断是否是同步复制,同步复制不显示时间表
			$scope.isSync = ptType == 0 || is3dcSync || ptType == 21 || ptType == 23 || ptType == 24;


			if( [3,4,5,6,30,31,32,35,36].indexOf(ptType) != -1 ){
				//创建时,3dc场景查询站点名称,并保存在schedule.name中
				if( pVm.createFlag ){
					scheduleName = pVm.scheduleName;
			    	$scope.title = pVm.scheduleNameText;
			    	if( $scope.isSync ){
			    		$scope.copyRateTitle = $scope.copyRateTitle + pVm.scheduleNameText.slice(pVm.scheduleNameText.indexOf("("));
			    	}
				}
				//修改时,从对象中获取(schedule.[protectedSiteName,recoverySiteName])
				else{
					if( schedule.protectedSiteName && schedule.recoverySiteName ){
						$scope.title = resource.get("protection.term.scheduleProduction.label",schedule.protectedSiteName + "->" + schedule.recoverySiteName);
						if( $scope.isSync && pVm.scheduleNameText ){
							$scope.copyRateTitle = pVm.scheduleNameText;
						}

						delete schedule.protectedSiteName;
						delete schedule.recoverySiteName;
					}
					else{
						//级联同步+异步显示"时间表(一级灾备站点->二级灾备站点)"
						if( $scope.pt.type == "3" ){
							$scope.title = resource.get("protection.term.scheduleProductionToDR3Level.label");
							if (!_.isEmpty(pVm.scheduleTimeText)) {
							    $scope.title = resource.get("common_term_timePolicy_tab") + pVm.scheduleTimeText;
							};
						}
						//并联同步+异步显示"时间表(生产站点->二级灾备站点)"
						else if( $scope.pt.type == "5" ){
							$scope.title = resource.get("protection.term.scheduleProductionToDR2Level.label");
							if (!_.isEmpty(pVm.scheduleTimeText)) {
							    $scope.title = resource.get("common_term_timePolicy_tab") + pVm.scheduleTimeText;
							};
						}else if (($scope.pt.type == "35" || $scope.pt.type == "36" || _.contains([4,6], parseInt($scope.pt.type))) && _.isString(pVm.scheduleTimeText)){
							$scope.title = resource.get("common_term_timePolicy_tab") + pVm.scheduleTimeText;
						}else{
							if(_3dc == 1){
								$scope.title = resource.get("protection.term.scheduleProductionToDR1Level.label");
							}
							else{
								if(!_.contains([30,31,32],parseInt(ptType))){
									var titleKey = schedule.protectLocation == 2 ? "protection.term.scheduleProductionToDR2Level.label" : "protection.term.scheduleProductionToDR3Level.label";
									$scope.title = resource.get(titleKey);
								}
							}
						}

						if( is3dcSync ){
							$scope.copyRateTitle = resource.get("protection.term.scheduleProductionToDR1Level.label");
						}
					}
				}
			}

			var protectLocation = 1;

			if (_3dc) {
				//一体化备份
				if( $scope.pt.type == "17" ){
					protectLocation = _3dc == 1 ? 0 : 4;
				}
				//openstack同步、异步复制
				else if ($scope.pt.type == "22" || $scope.pt.type == "21") {
					protectLocation = 1;
				}
				else{
					if(_3dc == 1){
						protectLocation = 1;
					}
					else{
						protectLocation = ($scope.pt.type == 6 || $scope.pt.type == 5 || $scope.pt.type == 36) ? 2 : 3;
                        //同步+异步的环形3DC
                        if(isSyncAndAsyncRing){
                            protectLocation = 5;
                        };
					}
				}
			}
			//环形3dc
			if($scope.is3dcRingPolicy){
				protectLocation = 5;
			}

			//是否显示复制速率(阵列异步复制和同步复制显示)
			$scope.showRateSetting = [0,1,3,4,5,6,18,20,21,22,23,24,26,27,30,31,32,33,35,36].indexOf(ptType) != -1;
			if( $scope.showRateSetting){
				$scope.showRateManualSetting = false;
				$scope.copyRateSelect = {
					id : "copyRateSelect",
					values :[{
						selectId : "1",
						label : resource.get("protection.copyrate.default.config")
					},{
						selectId : "0",
						label : resource.get("protection.copyrate.manual.config")
					}],
					defaultSelectid : "1",
					change : function(){
						$scope.showRateManualSetting = $("#"+$scope.copyRateSelect.id).widget().getSelectedId() == "0";
					},
					select: function(){
						if($("#"+$scope.copyRateSelect.id).widget().getSelectedId() == "1") {
							$scope.copyRateDesc = resource.get("protection.copyrate.default.config.desc");
						} else {
							$scope.copyRateDesc = $scope.text.colorPanelTip;
						}
					}
				}

				var LEVEL_COLOR = {
					4 : "#FF6600",
					3 : "#FFCC00",
					2 : "#00CC66",
					1 : "#01FFFF"
				};

				//点击表格
				$(".time-table td").click(function(){
					var data = {
						level: $(this).data().level || 2 ,
						time: $(this).text()
					};

					var win = angular.copy(Consts.COPYRATE_SETTING_WIN);
					win.title = resource.get(win.title);
					win.close = function(){
						data = appUtils.getWinData();
						if(!_.isObject(data)) return;
						var time = data.time.split("->");
						drawTable(time[0],time[1],data.level);
					}

					appUtils.openWin(win,data);
				});

				//从schedule中获取
				var syncRateRecords = schedule.replicationSpeedPolicies;
				if( syncRateRecords && _.isString(syncRateRecords) ){
					syncRateRecords = JSON.parse(syncRateRecords);
				}

				if( _.isArray(syncRateRecords) && syncRateRecords.length != 0 ){



					var filterData = angular.copy(syncRateRecords);

					//环形3dc
					if($scope.is3dcRingPolicy){
						filterData = _.filter(filterData,function(val){
							return val.storageSn == switchSide.storage1
						});
					};

					if(_.isArray(filterData) && filterData.length!=0){
						filterData.forEach(function(record){
							var startTime = record.startTime;
							var endTime = record.endTime;
							var level = record.syncRateLevel;
							drawTable(startTime,endTime,level,true);
						});

						$scope.showRateManualSetting = true;
						$scope.copyRateSelect.defaultSelectid = "0";
						$scope.copyRateDesc = $scope.text.colorPanelTip;
					}
				}
			}

			/*--------------------------------------------------*/

			function initBaseAndApp(){
				//时间表VM
				$scope.baseScheduleVM = ViewModel.create({
					data:{schedule:schedule, props: $scope.pt.props},
					ptType: $scope.pt.type,
					event:Consts.SCHEDULE_DATA_COLLECTION_EVENT,
					title: $scope.title,
					titleFirst: true,
					_3dc: _3dc,
					protectLocation: protectLocation
				});

				//应用配置VM
				$scope.appScheduleVM = ViewModel.create({
					poType: pVm.poType,
					ptType: $scope.pt.type,
					data: $scope.pt.props,
					event: Consts.SCHEDULE_APP_DATA_COLLECTION_EVENT,
					protectLocation: protectLocation,
					schedule: schedule
				});

				//3dc异步+异步并联复制可分站点设置一致性策略
				if( $scope.pt.type == "6" || $scope.pt.type == "36"){
					$scope.appScheduleVM.protectLocation = _3dc == 1 ? 1 : 2;
				}
				//一体化备份
				else if( $scope.pt.type == "17" ){
					$scope.appScheduleVM.protectLocation = _3dc == 1 ? 0 : 4;
				}


				//3dc异步+异步级联复制不能设置应用策略
				if( ($scope.pt.type == "4" || $scope.pt.type == "35") && _3dc == 2 ){
					$scope.appScheduleVM = null;
				}
				//华为虚拟机
				if( pVm.poType == "12" ){
					$scope.appScheduleVM = null;
				}
			}

			if( $scope.isSync ){
				$("._title").css("margin-top",0);
			}
			else{
				initBaseAndApp();
			}

			/*-----------时间小于15分钟，不允许设置一致性----------------*/
			$scope.$on("DISABLE_SNAPSHOTNUMBER", function(evt, obj) {
			    _.isObject(obj) && $scope.$broadcast("DIABLE_SCHEDULEAPP", !obj.modeType && (obj.type == "5" || (obj.type == "0" && parseInt(obj.minute, 10) < 15)));
			});

			//监听父级触发事件
			$scope.$on(pVm.event, function(){
				pVm.valid = true;

				//校验本窗口的全部标签页,并跳转到第一个校验不通过的控件
				pVm.valid = tabs.tabsOption.every(function(obj, index) {
				    var id = obj.tabId;
				    if ($('#tabtitle-' + id + ':hidden').length) return true; // 如果标签被隐藏了就不校验
				    var bool = UnifyValid.FormValid($('#tabs-' + id), {
				        checkHidden: true,
				        focusInvalid: false
				    });
				    if (!bool) {
				        $('#tabtitle-' + id).click();
				        bool = UnifyValid.FormValid($('#tabs-' + id), {
				            checkHidden: false,
				            focusInvalid: true
				        });
				    }
				    return bool;
				});
				if (!pVm.valid) return;

				if( !$scope.isSync ){
					//时间表数据收集
					$scope.$broadcast($scope.baseScheduleVM.event);
					if(!(pVm.valid = $scope.baseScheduleVM.valid)) return;

					//应用数据收集
					if( $scope.appScheduleVM ){
						$scope.$broadcast($scope.appScheduleVM.event);
						if(!(pVm.valid = $scope.appScheduleVM.valid)) return;
					}

					$scope.pt.schedules = [schedule];
				}

				if(ptType == 0 || ptType == 21 || ptType == 23 || ptType == 24){
					//同步为手动调度
					_.extend(schedule, {
						"scheduleMode":1
					});
					$scope.pt.schedules = [schedule];
				}

				if( is3dcSync ){
					$scope.pt.schedules = [schedule];
				}

				if( $scope.showRateSetting ){
					var rateData = [];
					if( $scope.showRateManualSetting ){
						//环形3dc
						if($scope.is3dcRingPolicy){
							//点击确认的时候获取值
							if($(".tiny-switch").widget().option("selected") == "on"){
								_.extend(switchSide,{
									rateData1: getRateData()
								})
							}else{
								_.extend(switchSide,{
									rateData2: getRateData()
								})
							};
							//如果没切换到下一端给默认值
							if(_.isEmpty(switchSide.rateData2)){
								//...
								switchSide.rateData2 = [{
									endTime: "00:00",
									startTime: "00:00",
									syncRateLevel: 2
								}];
							};
							//增加storage信息
							_.each(switchSide.rateData2,function(val){
								_.extend(val,{
									storageSn: switchSide.storage2
								})
							});
							_.each(switchSide.rateData1,function(val){
								_.extend(val,{
									storageSn: switchSide.storage1
								})
							});
							//将两端数据合并
							rateData = switchSide.rateData1.concat(switchSide.rateData2);
						}else{
							rateData = getRateData();
						}
					}
					if(!pVm.createFlag){
						var peerData = getPeerCopyRate();
						rateData = rateData.concat(peerData);
					}
					_.extend(schedule, {
						replicationSpeedPolicies: rateData
					});
				}
				//秒级策略和分钟级小于15分钟不支持设置一致性策略
				if ($scope.appScheduleVM) {
				    var scheduleTemp = $scope.baseScheduleVM.data.schedule;
				    if (scheduleTemp.scheduleMode == 0 && (scheduleTemp.periodType == 5 || (scheduleTemp.periodType == 0 && scheduleTemp.periodInterval < 15))) {
				        var keyType = "appConsistent";
				        //如果启用应用一致性
				        if ($scope.appScheduleVM.schedule[keyType] == 1) {
				            message.error(appUtils.getString("pg_support_config_policy_error_label"));
				            pVm.valid = false;
				            return;
				        }
				    }
				};

				//创建保护组
				if (pVm.createFlag) {

					if( _3dc && $scope.pt.type != 21){
						//一体化备份
						if( $scope.pt.type == "17" ){
							schedule.protectLocation = 	protectLocation;
						}
						else{
							schedule.protectLocation = 	protectLocation;
						}
					}
					else{
						/*---------------------------------------------------
							protectLocation,用于判断3dc类型(A-B,B-C,A-C)
						-----------------------------------------------------*/
						if( !$scope.isSync ){
							schedule.protectLocation = protectLocation;
						}
					}
					//增加protectedType
					_.isUndefined(schedule.protectedType) && (schedule.protectedType = $scope.pt.type);

				}
				else{
					var reqConf = {
						data: schedule,
						interceptor: function(next){
							//手动不做任何提示
							if( $scope.isSync || $scope.baseScheduleVM.data.schedule.scheduleMode == 1 ){
								next();
							}
							else{
								var encodePgName = $.encoder.encodeForHTML(pgName);
								var msg = resource.get("ism.drm.pg.schedule.modify.msg1",encodePgName) + "<br>" +
									resource.get("ism.drm.pg.schedule.modify.msg2",encodePgName) + "<br>" +
									resource.get("ism.drm.pg.schedule.modify.msg3");

								message.warn({
									content: msg,
									ok: function() {
										next();
									}
								});
							}
						},
						success : function(){
							pVm.defer.resolve();
						}
					};

					//删除每个模板中的protectedSiteName和recoverySiteName刷新
					_.each(reqConf.data.schedules, function(schedule) {
						if (schedule.hasOwnProperty("protectedSiteName")) {
							delete schedule.protectedSiteName;
						}
						if (schedule.hasOwnProperty("recoverySiteName")) {
							delete schedule.recoverySiteName;
						}
					});

					//修改策略
					Rest.modifyPgSchedule([pVm.pgId, schedule.scheduleId],reqConf);
				}
			});

			function getRateData(){
				var rate = [];
				var lastLevel;
				var crtItem;

				for(var i=0;i<24;i++){
					var time = i>=10?i+":00":"0"+i+":00";
					var level = $(".time-table td:contains("+time+")").data("level") || 2;
					if(level != lastLevel){
						crtItem = {
							startTime: time,
							endTime: ( (i+1)>=10?(i+1)+":00":"0"+(i+1)+":00" ),
							syncRateLevel: level
						}
						if( crtItem.endTime == "24:00" ){
							crtItem.endTime = "00:00";
						}
						rate.push(crtItem);
						lastLevel = level;
					}
					else{
						crtItem.endTime = ( (i+1)>=10?(i+1)+":00":"0"+(i+1)+":00" );
						if( crtItem.endTime == "24:00" ){
							crtItem.endTime = "00:00";
						}
					}
				}

				return rate;
			}

			function drawTable(startTime,endTime,level,init){
				var fromHour = parseInt(startTime.split(":")[0],10);
				var toHour   = parseInt(endTime.split(":")[0],10);

				if(toHour == 0){
					toHour = 23;
				}
				else{
					toHour--;
				}

				var color = LEVEL_COLOR[level];

				for(var i=fromHour;i<=toHour;i++){
					var text = i>=10?i+":00":"0"+i+":00";
					$(".time-table td:contains("+text+")").css("background",color).data("level",level);
				}
			}

			function getPeerCopyRate(){
				var old = schedule.replicationSpeedPolicies;
				if( _.isString(old) ){
					var oldArr = JSON.parse(old);
					if(_.isArray(oldArr)){
						var filterData = _.filter(oldArr,function(record){
							return record.protectLocation != protectLocation;
						});
						return filterData;
					}
				}
				return [];
			}

			(function init() {
			    setTimeout(function() {
			        $('#myTabs #tab_head li:visible:eq(0)').click();
			    }, 300);
			})();
	}];

	return ctrl;
});