define([], function() {
    var ctrl = ["$scope", "$compile", "$sce", "$timeout", "appUtils", "constsService", "restService", "model", "infoTransferredService", "message", function($scope, $compile, $sce, $timeout, appUtils, constsService, restService, Model, infoTransferredService, message) {

        var valid = false;
        $scope.view = "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/openstackVirtual.html";
        $scope.ctrl = "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/openstackVirtualCtrl";
        $scope.vm = Model.ViewModel.create({
            data: {},
            event: "OPENSTACK_VIRTUAL"
        });
        $scope.model = {
            labels: {
                drTitle:appUtils.getString("rm_term_dr_setTitle"),
                drSite: appUtils.getStringWithColon("rm_term_dr_site"),
                drFusionsphere: appUtils.getStringWithColon("rm_term_dr_cloud"),
                drRegion: appUtils.getStringWithColon("rm_term_openstack_dr_region"),
                drProject: appUtils.getStringWithColon("rm_term_openstack_dr_project"),
                drZone: appUtils.getStringWithColon("rm_term_openstack_dr_zone")
            },
            drSiteLabel: infoTransferredService.get("OpenstackSiteLabelModuel", "productSiteLabel"),
            drFusionsphereLabel: infoTransferredService.get("OpenstackFusionSphereLabelModuel", "fusionSphereLabel"),
            productFusionsphereId: infoTransferredService.get("OpenstackFusionSphereIdModuel", "fusionSphereId"),
            productSiteId: infoTransferredService.get("OpenstackSiteIdModuel", "productSiteId"),
            productRegionId: infoTransferredService.get("OpenstackRegionIdModuel", "regionId"),
            productProjectId: infoTransferredService.get("OpenstackProjectIdModuel", "projectId"),
            productZoneName: infoTransferredService.get("OpenstackZoneIdModuel", "zoneName"),
            drRegion: {
                id: "drRegion",
                defaultId: "-1",
                "autoOpen": false,
                text: appUtils.getString("rm_term_openstack_dr_region"),
                width: constsService.W3,
                values: [{
                    "selectId": -1,
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                validate: function() {
                    valid = ("-1" != $("#" + this.id).widget().getSelectedId());
                },
                "closeFn": function(object, evt) {
                    infoTransferredService.put("drRegionModuel", "drRegionName", $("#drRegion").widget().getSelectedLabel());
                },
                "openFn": function(object) {
                    restService.getOpenStackRegions($scope.model.productFusionsphereId, function(result) {
                        var vals = [];
                        _.each(_filter("regionId", $scope.model.productRegionId, result), function(region) {
                            vals.push({
                                selectId: region.regionId,
                                label: region.description
                            })
                        });

                        vals.push({
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        });

                        var regionId = $("#drRegion").widget().getSelectedId(),
                            regionLabel = $("#drRegion").widget().getSelectedLabel();

                        $("#drRegion").widget().option("values", vals);
                        object.open();

                        $("#drRegion").widget().selected = [regionId];
                        $("#drRegion .tiny-select-text").val(regionLabel);
                    });
                },
                select: function() {
                    var regionId = $("#drRegion").widget().getSelectedId();
                    if(regionId != "-1") {
                        $scope.model.drProject.regionId = regionId;
                    };
                    $("#drProject").widget().opChecked("-1");
                    $("#drZone").widget().opChecked("-1");
                },
                query: function() {

                }
            },
            drProject: {
                id: "drProject",
                defaultId: "-1",
                text: appUtils.getString("rm_term_openstack_dr_project"),
                width: constsService.W3,
                values: [{
                    "selectId": -1,
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                validate: function() {
                    valid = ("-1" != $("#" + this.id).widget().getSelectedId());
                },
                select: function() {
                    var projectId = $("#drProject").widget().getSelectedId();
                    if (projectId != "-1") {
                        $scope.model.drProject.projectId = projectId;
                    };
                    $("#drZone").widget().opChecked("-1");
                },
                query: function() {},
                "closeFn": function(object, evt) {
                    infoTransferredService.put("drProjectModuel", "drProjectName", $("#drProject").widget().getSelectedLabel());
                },
                "projectId": "-1",
                "openFn": function(object) {
                    var params = {};
                    params.openstackId = $scope.model.productFusionsphereId;
                    params.enabled = true;
                    restService.getOpenStackProject(params, function(result) {
                        var vals = [];
                        _.each(_filter("projectId", $scope.model.productProjectId, result), function(project) {
                            vals.push({
                                selectId: project.projectId,
                                label: project.projectName
                            })
                        });

                        vals.push({
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        });

                        var projectId = $("#drProject").widget().getSelectedId(),
                            projectLabel = $("#drProject").widget().getSelectedLabel();

                        $("#drProject").widget().option("values", vals);
                        object.open();

                        $("#drProject").widget().selected = [projectId];
                        $("#drProject .tiny-select-text").val(projectLabel);
                    });
                }
            },
            drZone: {
                id: "drZone",
                defaultId: "-1",
                text: appUtils.getString("rm_term_openstack_dr_zone"),
                width: constsService.W3,
                values: [{
                    "selectId": -1,
                    "label": appUtils.getString("common_term_pleaseSelect_listbox")
                }],
                validate: function() {
                    valid = ("-1" != $("#" + this.id).widget().getSelectedId());
                },
                select: function() {

                },
                query: function() {},
                "closeFn": function(object, evt) {
                    infoTransferredService.put("drZoneNameModuel", "drZoneName", $("#drZone").widget().getSelectedLabel());
                },
                "openFn": function(object) {
                    var projectId = $("#drProject").widget().getSelectedId();
                    if (projectId == "-1") {
                        return;
                    }
                    var params = {
                        openstackId: $scope.model.productFusionsphereId,
                        zoneState: true,
                        projectId: projectId,
                        regionId: $("#drRegion").widget().getSelectedId()
                    };
                    restService.getOpenStackZone(params, function(result) {
                        var vals = [];
                        _.each(_filter("zoneName", $scope.model.productZoneName, result), function(zone) {
                            vals.push({
                                selectId: zone.zoneName,
                                label: zone.zoneName
                            })
                        });

                        vals.push({
                            selectId: "-1",
                            label: appUtils.getString("common_term_pleaseSelect_listbox")
                        });

                        var zoneId = $("#drZone").widget().getSelectedId(),
                            zoneLabel = $("#drZone").widget().getSelectedLabel();

                        $("#drZone").widget().option("values", vals);
                        object.open();

                        $("#drZone").widget().selected = [zoneId];
                        $("#drZone .tiny-select-text").val(zoneLabel);
                    });
                }
            }
        }

        //先暂时注释
        function _filter(key, value, map) {
            return map;
        }


        $("#" + constsService.OPENSTACK_VOLUMN_SETTING_WIN.winId).widget().option("buttons", [{
            key: "ok",
            label: appUtils.getString("common_term_confirm_button"),
            focused: true,
            handler: function(event) {
                $.each($scope.model, function(index, model) {
                    if (_.isFunction(model.validate)) {
                        model.validate();
                        if (!valid) {
                            message.error(appUtils.getString("common_term_pleaseSelect_listbox_validate", model.text));
                            return false;
                        }
                    }
                });

                if (!valid) return;
                $scope.$broadcast($scope.vm.event, {
                    "regionId": infoTransferredService.get("OpenstackRegionIdModuel", "regionId"),
                    "projectId": infoTransferredService.get("OpenstackProjectIdModuel", "projectId"),
                    "zoneName": infoTransferredService.get("OpenstackZoneIdModuel", "zoneName"),
                    "drRegionId": $("#drRegion").widget().getSelectedId(),
                    "drProjectId": $("#drProject").widget().getSelectedId(),
                    "drZoneName": $("#drZone").widget().getSelectedId()
                });
            }
        }, {
            key: "cancel",
            label: appUtils.getString('common_term_cancel_button'),
            focused: false,
            handler: function(event) {
                $("#" + constsService.OPENSTACK_VOLUMN_SETTING_WIN.winId).widget().destroy();
            }
        }]);

        (function init() {
            var data = $("#" + constsService.OPENSTACK_VOLUMN_SETTING_WIN.winId).widget().option("data");
            !_.isUndefined(data.props.drRegionId) && ($scope.model.drRegion.values = [{"selectId": data.props.drRegionId, "label": data.props.drRegionName, checked: true}]);
            !_.isUndefined(data.props.drProjectId) && ($scope.model.drProject.values =[{"selectId": data.props.drProjectId, "label": data.props.drProjectName, checked: true}]);
            !_.isUndefined(data.props.drZoneName) && ($scope.model.drZone.values =[{"selectId": data.props.drZoneName, "label": data.props.zoneName, checked: true}]);

            $scope.$apply()
        })()

    }]

    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("openstack-volumn-site-ctrl", ctrl);
    return module;
})
