define([],function(){
    var ctrl = ["$scope","model","appUtils","restService","message",function($scope,Model,appUtils,Rest,message){
        var resource = appUtils.resource();

        $scope.siteLabel = resource.getWithColon("ism.drm.protect.element.site");
        $scope.localStorageLabel = resource.getWithColon("protection_hyperVault_localStorage_label");
        $scope.localFsLabel = resource.getWithColon("protection_hyperVault_localFs_label");
        $scope.remoteStorageLabel = resource.getWithColon("protection_hyperVault_remoteStorage_label");
        $scope.remoteFsLabel = resource.getWithColon("protection_hyperVault_remoteFs_label");

        $scope.contentcls = "formItemTextNoWrap";

        $scope.storageInfoPanelVM = Model.ViewModel.create({
            titleText: resource.get("protection_lun_term_storageConfiguration_tab")
        });

        $scope.protectPanelVM = Model.ViewModel.create({
            data: $scope.viewModel.data,
            pg: $scope.viewModel.pg,
            ok: $scope.viewModel.ok,
            createFlag: $scope.viewModel.createFlag,
            poListIds: $scope.viewModel.poListIds,
            settingEnable: $scope.viewModel.settingEnable,
            event: "CreateHyperVault"
        });

        $scope.protectPanel = {
            view: "app/business/recoverydirector/protection/views/protectiongroup/common/schedule/asSyncsTemplateModifyPanel.html",
            ctrl: "app/business/recoverydirector/protection/controllers/protectiongroup/common/schedule/asSyncsTemplateModifyPanelCtrl",
            vm: $scope.protectPanelVM
        }

        //NAS+一体化备份统一去掉存储配置模块
        //SAN一体化和双活+一体化备份去掉存储配置模块
        $scope.isHyperMetroVault = _.contains([28,30,31,32],parseInt($scope.protectPanelVM.data.type,10));

        $scope.localSiteName = "--";
        $scope.localStorageName = "--";
        $scope.localFsName = "--";
        $scope.remoteSiteName = "--";
        $scope.remoteStorageName = "--";
        $scope.remoteFsName = "--";
        $scope.storageInfoConfiged = true;

        $scope.remoteSite = {
            id: "remoteSite",
            defaultSelectid: "-1",
            values : [{"selectId" : -1,"label" : resource.get("common_term_pleaseSelect_listbox")}],
            select: function(){
                appUtils.resetSelectValues("remoteStorage");
                appUtils.resetSelectValues("remoteFs");

                var siteId = $("#remoteSite").widget().getSelectedId();
                if(siteId == "-1") return;

                var protectionRelation = $scope.viewModel.data.props.protectionRelation;

                protectionRelation = _.isString(protectionRelation) ? JSON.parse(protectionRelation) : protectionRelation

                //查询站点下的存储
                Rest.queryRemoteDevices([protectionRelation.srcResourceProviderSn,siteId],function(data){
                    appUtils.updateSelectValues("remoteStorage",data,"sn","name",appUtils.getString("common_term_pleaseSelect_listbox"));
                });
            }
        }

        $scope.remoteStorage = {
            id: "remoteStorage",
            defaultSelectid: "-1",
            values : [{"selectId" : -1,"label" : resource.get("common_term_pleaseSelect_listbox")}],
            select: function(){
                appUtils.resetSelectValues("remoteFs");

                var storageSN = $("#remoteStorage").widget().getSelectedId();
                if(storageSN == "-1") return;

                //查询远端FS
                var protectionRelation = $scope.viewModel.data.props.protectionRelation;

                protectionRelation = _.isString(protectionRelation) ? JSON.parse(protectionRelation) : protectionRelation

                Rest.getHyperVaultTargetFs([protectionRelation.srcResourceProviderSn,protectionRelation.srcResourceId,storageSN],function(data){
                        appUtils.updateSelectValues("remoteFs",data,"id","name",appUtils.getString("common_term_pleaseSelect_listbox"));
                });
            }
        }

        $scope.remoteFs = {
            id: "remoteFs",
            defaultSelectid: "-1",
            values : [{"selectId" : -1,"label" : resource.get("common_term_pleaseSelect_listbox")}],
            select: function(){

            }
        }

        function init(){
            //SAN一体化
            if($scope.protectPanelVM.data.type == 30 || $scope.protectPanelVM.data.type == 31 || $scope.protectPanelVM.data.type == 32){
                $scope.viewModel.createFlag && addCreateListener();
                return;
            };
            //查询存储配置信息
            var protectionRelation = $scope.viewModel.data.props.protectionRelation;
            protectionRelation = _.isString(protectionRelation) ? JSON.parse(protectionRelation) : protectionRelation;

            if( !_.isObject(protectionRelation) ) return;

            $scope.localSiteName = protectionRelation.srcSiteName;
            $scope.localStorageName = protectionRelation.srcResourceProviderName;
            $scope.localFsName = protectionRelation.srcResourceName;

            var targetResArr = protectionRelation.targetResources;
            //若接口返回了远端信息,则直接显示
            if( _.isArray(targetResArr) && targetResArr.length != 0 ){
                var targetRes = targetResArr[0];
                $scope.remoteSiteName = targetRes.srcSiteName;
                $scope.remoteStorageName = targetRes.srcResourceProviderName;
                $scope.remoteFsName = targetRes.srcResourceName;
                $scope.storageInfoConfiged = true;
            }
            //未返回远端信息,则让用户手动配置
            else if( $scope.viewModel.createFlag ){
                $scope.storageInfoConfiged = false;
                //查询本地服务器上的站点
                Rest.queryLocalServer([],function(server){
                    if( _.isObject(server) ){
                        Rest.querySites(server.uuid,function(sites){
                            appUtils.updateSelectValues("remoteSite",sites,"siteId","name",appUtils.getString("common_term_pleaseSelect_listbox"));
                        });
                    }
                });
            }

            $scope.viewModel.createFlag && addCreateListener();
        }

        function addCreateListener(){
            $scope.$on($scope.viewModel.event, function() {
                $scope.viewModel.hideParentError = false;

                //用户手动配置存储关系,检查配置是否合法  && NAS+一体化备份不用校验
                if( !$scope.storageInfoConfiged && !$scope.isHyperMetroVault){
                    var siteId = $("#remoteSite").widget().getSelectedId();
                    var storageSN = $("#remoteStorage").widget().getSelectedId();
                    var fsId = $("#remoteFs").widget().getSelectedId();
                    var checkOk = checkParams(siteId,storageSN,fsId);
                    if(!checkOk) return;

                    //组装remote protectionRelation
                    var protectionRelation = $scope.protectPanelVM.data.props.protectionRelation;

                    protectionRelation = _.isString(protectionRelation) ? JSON.parse(protectionRelation) : protectionRelation;

                    var siteName = $("#remoteSite").widget().getSelectedLabel();
                    var storageName = $("#remoteStorage").widget().getSelectedLabel();
                    var fsName = $("#remoteFs").widget().getSelectedLabel();

                    protectionRelation.targetResources = [{
                        srcSiteId: siteId,
                        srcSiteName: siteName,
                        srcResourceId: fsId,
                        srcResourceName: fsName,
                        srcResourceProviderSn: storageSN,
                        srcResourceProviderName: storageName
                    }];

                }

                $scope.$broadcast("CreateHyperVault");
                $scope.viewModel.valid = $scope.protectPanelVM.valid;
                if (!$scope.viewModel.valid) return;

                $scope.viewModel.data.schedules = $scope.protectPanelVM.data.schedules;
                _.extend($scope.viewModel.data.props, $scope.protectPanelVM.data.props);

                if (!_.isString(protectionRelation)) {
                    $scope.protectPanelVM.data.props.protectionRelation = JSON.stringify(protectionRelation);
                }
            });
        }

        function checkParams(siteId,storageSN,fsId){
            var errorMsg = ["protection_hyperVault_selectSite_msg","protection_hyperVault_selectRemoteStorage_msg","protection_hyperVault_selectRemoteFs_msg"];
            return [].every.call(arguments,function(item,index){
                if(item == -1){
                    $scope.viewModel.valid = false;
                    $scope.viewModel.hideParentError = true;
                    message.error(resource.get(errorMsg[index]));
                    return false;
                }
                else{
                    return true;
                }
            });
        }

        init();
    }];
    return ctrl;
});
