define(["tiny-common/UnifyValid"],
	function(UnifyValid){

	var ctrl = ["$scope", "appUtils", "constsService","restService","message","model",
	     function($scope, appUtils, Consts, Rest, message, Model){

			var pVm = $scope.viewModel;
			$scope.pt = pVm.data;

			var resource = appUtils.resource();
			var ViewModel = Model.ViewModel;

			var schedule = appUtils.getItemFromArray($scope.pt.schedules,"scheduleMode","0") || $scope.pt.schedules[0];
			schedule.protectLocation = 0;
			var tabs = new tinyWidget.Tabs({
                    "id": "myTabs",
                    "setActiveClass": true
            });

			$scope.model = {
				tabTexts: [
            		resource.get("protection.term.schedulePolicy.label"),
            		resource.get("protection_term_reserverPolicy_label"),
                    resource.get("protection_term_concsistentProtectPolicy_tab")
            	],
			}
			/*---------------------------------------------------
				            快照设置
			-----------------------------------------------------*/
			$scope.snapshotDesc = resource.getWithColon("com.huawei.ism.drm.policy.snapshot.limit");
			//输入不合法提示(1-512)
			var snapshotInputTip = resource.get("protection_createObject_task_setSchedule_para_snapshotNO_tip",512);
			//快照帮助提示
			$scope.snapshotHelpTip = resource.get("protection_createObject_task_setSchedule_para_snapshotNO_des_label");
			$scope.snapshotCountTextbox = {
				id : "snapshotCountTextbox",
				validate : "required:"+snapshotInputTip+";integer:"+snapshotInputTip+";minValue(1):"+snapshotInputTip+";maxValue(512):"+snapshotInputTip,
				value : $scope.pt.props.PP_SNAPSHOT_COUNT || 5
			};

			/*---------------------------------------------------
				            快照资源池比例设置
			-----------------------------------------------------*/
			$scope.visCacheDesc = resource.getWithColon("protection.modifyPolicy.task.para.snapResourceRatio.label");
			$scope.visCacheTextbox = {
				id : "visCacheTextbox",
				validate:  appUtils.numberValidateStr(1,100,resource.get("protection.modifyPolicy.task.para.snapResourceRatio.input.error.msg")),
				value : $scope.pt.props.VIS_CACHE || 10,
				disable: false
			}

			//vis快照保护组副本已激活的情况下，快照资源池的比例应该不能再被修改，界面应该灰化；
			!pVm.createFlag && Rest.queryProtectGroupReplicas([pVm.pgId,1], function(data){
        		$scope.visCacheTextbox.disable = (angular.isArray(data) && data.length > 0);
        		$scope.$digest();
			});

			var oldSnapshotCount = $scope.pt.props.PP_SNAPSHOT_COUNT;
			var pgName = pVm.pgName;

			//时间表VM
			$scope.baseScheduleVM = ViewModel.create({
				data:{schedule:schedule, props: $scope.pt.props},
				event:Consts.SCHEDULE_DATA_COLLECTION_EVENT
			});

			//应用配置VM
			$scope.appScheduleVM = ViewModel.create({
				poType: pVm.poType,
				ptType: $scope.pt.type,
				data: $scope.pt.props,
				event: Consts.SCHEDULE_APP_DATA_COLLECTION_EVENT
			});

			//监听父级触发事件
			$scope.$on(pVm.event, function(){

				//校验本窗口的全部标签页,并跳转到第一个校验不通过的控件
				pVm.valid = tabs.tabsOption.every(function(obj, index) {
				    var id = obj.tabId;
				    if ($('#tabtitle-' + id + ':hidden').length) return true; // 如果标签被隐藏了就不校验
				    var bool = UnifyValid.FormValid($('#tabs-' + id), {
				        checkHidden: true,
				        focusInvalid: false
				    });
				    if (!bool) {
				        $('#tabtitle-' + id).click();
				        bool = UnifyValid.FormValid($('#tabs-' + id), {
				            checkHidden: false,
				            focusInvalid: true
				        });
				    }
				    return bool;
				});
				if (!pVm.valid) return;

				//时间表数据收集
				$scope.$broadcast($scope.baseScheduleVM.event);
				if(!(pVm.valid = $scope.baseScheduleVM.valid)) return;

				//应用数据收集
				$scope.$broadcast($scope.appScheduleVM.event);
				if(!(pVm.valid = $scope.appScheduleVM.valid)) return;

				$scope.pt.props.PP_SNAPSHOT_COUNT = $("#snapshotCountTextbox").widget().getValue();
				$scope.pt.props.VIS_CACHE = $("#visCacheTextbox").widget().getValue();

				$scope.pt.schedules = [$scope.baseScheduleVM.data.schedule];

				//创建保护组
				if (pVm.createFlag) return;
				//修改策略
				var reqConf = {
					"data": $scope.pt,
					"interceptor": function(next) {
						var encodePgName = $.encoder.encodeForHTML(pgName);
						//减少快照个数需要添加高危提示
						var newSnapshotCount = $scope.pt.props.PP_SNAPSHOT_COUNT;
						if (parseInt(newSnapshotCount, 10) < parseInt(oldSnapshotCount, 10)) {
							var msg = resource.get("ism.drm.snaphostForVis.modify.danger.msg1", encodePgName) + "<br>" +
								resource.get("ism.drm.snaphostForVis.modify.danger.msg2", [oldSnapshotCount, newSnapshotCount]) + "<br>" +
								resource.get("ism.drm.snaphostForVis.modify.danger.msg3");

							message.warn({
								content: msg,
								ok: function() {
									next();
								}
							});
						}
						else{
							//手动不做任何提示
							if( $scope.baseScheduleVM.data.schedule.scheduleMode == 1 ){
								next();
							}
							else{
								var msg = resource.get("ism.drm.pg.schedule.modify.msg1",encodePgName) + "<br>" +
									resource.get("ism.drm.pg.schedule.modify.msg2",encodePgName) + "<br>" +
									resource.get("ism.drm.pg.schedule.modify.msg3");

								message.warn({
									content: msg,
									ok: function() {
										next();
									}
								});
							}
						}
					},
					"success": function() {
						pVm.defer.resolve();
					}
				}

				Rest.modifyPolicy(pVm.pgId,reqConf);
			});
			(function init() {
			    setTimeout(function() {
			        $('#myTabs #tab_head li:eq(0)').click();
			    }, 300);
			})();
	}];

	return ctrl;
});