define(["tiny-widgets/Message","tiny-common/UnifyValid"], function(Message,UnifyValid) {
    "use strict";
    var ctrl = ["$scope", "$timeout", "message", "constsService", "restService", "appUtils", function($scope, $timeout, message, constsService, restService, appUtils) {
        var winData = $("#" + constsService.VMWARE_MOUNT_IP_CONFIG_WIN.winId).widget().option("data");
        $scope.isLinux = false;
        $scope.isWindows = false;
        $scope.userNameMessage = appUtils.getString("recovery_vm_ip_set_username_label");
        $scope.model = {
            authenticationTips: appUtils.getString("res_vmware_windows_network_tips"),
            IPV4TITLE: appUtils.getString("protect_object_ip_set_ipv4_label"),
            IPV6TITLE: appUtils.getString("protect_object_ip_set_ipv6_label"),
            IPV4DNSTITLE: appUtils.getString("protect_object_dns_set_ipv4_label"),
            IPV6DNSTITLE: appUtils.getString("protect_object_dns_set_ipv6_label"),
            labels: {
                dnsSetTips: appUtils.getString("res_vmware_linux_network_tips"),
                networkCard: appUtils.getStringWithColon("protect_object_ip_set_networkCard_label"),
                ipv4: appUtils.getStringWithColon("protect_object_ip_label"),
                ipv6: appUtils.getStringWithColon("protect_object_ip_label"),
                firstChoose: appUtils.getStringWithColon("protect_object_dns_first_choose_label"),
                reserveChoose: appUtils.getStringWithColon("protect_object_dns_reserve_label"),
                firstChooseIPv6: appUtils.getStringWithColon("protect_object_dns_first_choose_label"),
                reserveChooseIPv6: appUtils.getStringWithColon("protect_object_dns_reserve_label"),
                gateway: appUtils.getStringWithColon("protect_object_dns_gateway_label"),
                gatewayIPv6: appUtils.getStringWithColon("protect_object_dns_gateway_label"),
                netmask: appUtils.getStringWithColon("protect_object_dns_netmask_label"),
                prefix: appUtils.getStringWithColon("protect_object_network_length_label"),
                userName: appUtils.getStringWithColon("common_term_username_label"),
                password: appUtils.getStringWithColon("common_term_password_label")
            },
            vmsTable: {
                id: "vmsTable",
                columns: [{
                    "mData": "name",
                    "bSortable": false,
                    "sTitle": appUtils.getString("recovery.term.colum.name.title")
                }],
                data: [],
                cellClickActive: function(event, trData) {
                    //刷新右视图
                    if (!_.isEmpty(trData.props) && !_.isEmpty(trData.props.VirtualEthernetCard)) {
                        $scope.isLinux = trData.props.GUESTOSTYPE == "linuxGuest";
                        $scope.isWindows = trData.props.GUESTOSTYPE == "windowsGuest";
                        if($scope.isLinux){
                            $("#linux").css("display","block");
                            $("#windows").css("display","none");
                        };
                        if($scope.isWindows){
                            $("#linux").css("display","none");
                            $("#windows").css("display","block");
                        };
                        if (trData.props.GUESTOSTYPE === "UNKNOW") {
                            var options={
                                type : "confirm",
                                content:appUtils.getString("res_system_info_unkown_label"),
                                buttons:[{
                                    label:tinyLanguage.language.okBtnTitile,
                                    handler:function(){
                                        msg.destroy();
                                    }
                                }]
                            };
                            var msg = new Message(options);
                            msg.show();
                            $("#"+msg.dialogId).parent().find(".ui-dialog-title").html(appUtils.getString("common_message_win_information_title"));
                            $("#"+msg.dialogId).css("min-height","40px");
                            return;
                        };
                        var netWorkCard = trData.props.VirtualEthernetCard;
                        _.isString(netWorkCard) && (netWorkCard = JSON.parse(netWorkCard));
                        if (_.isEmpty(trData.netWorkCard)) {
                            _.extend(trData, {
                                netWorkCard: netWorkCard
                            });
                        };
                        var hasDataFlag = false;
                        $.each(trData.netWorkCard, function(index, value) {
                            if (!_.isUndefined(value.dhcpEnabled4)) {
                                hasDataFlag = true;
                                return false;
                            };
                        });
                        //如果有数据
                        if (!_.isEmpty(winData.vmIpConfigs) && !hasDataFlag) {
                            var checkedCard = _.filter(winData.vmIpConfigs, function(item) {
                                return item.ownerId == trData.uuid || item.ownerId == trData.props.VMUUID || item.ownerId == trData.vmUuid
                            });
                            _.each(trData.netWorkCard, function(cardItem) {
                                _.each(checkedCard, function(setItem) {
                                    _.isString(setItem.value) && (setItem.value = JSON.parse(setItem.value));
                                    if (setItem.value.nicMac == cardItem.macAddress && setItem.value.nicName == cardItem.ethernetCardName) {
                                        _.extend(cardItem, {
                                            openIp4: setItem.value.openIp4,
                                            openIp6: setItem.value.openIp6,
                                            dhcpEnabled4: setItem.value.dhcpEnabled4,
                                            dhcpEnabled6: setItem.value.dhcpEnabled6,
                                            ipVal: setItem.value.ip,
                                            netmaskVal: setItem.value.netmask,
                                            gatewayVal: setItem.value.gateway,
                                            gateway6Val: setItem.value.gateway6,
                                            ipv6List: setItem.value.ipv6List
                                        });
                                        //linux
                                        if (trData.props.GUESTOSTYPE == "linuxGuest") {
                                            _.extend(trData, {
                                                autoDns4: setItem.value.autoDns4,
                                                autoDns6: setItem.value.autoDns6,
                                                preferredDns: setItem.value.preferredDns,
                                                preferredDns6: setItem.value.preferredDns6,
                                                alternateDns: setItem.value.alternateDns,
                                                alternateDns6: setItem.value.alternateDns6
                                            });
                                        } else {
                                            _.extend(cardItem, {
                                                autoDns4: setItem.value.autoDns4,
                                                autoDns6: setItem.value.autoDns6,
                                                preferredDns: setItem.value.preferredDns,
                                                preferredDns6: setItem.value.preferredDns6,
                                                alternateDns: setItem.value.alternateDns,
                                                alternateDns6: setItem.value.alternateDns6
                                            })
                                        }
                                    };
                                    //windows用户名和密码
                                    if(trData.props.GUESTOSTYPE == "windowsGuest" && setItem.name == "PO_OS_NAMEPASSWORD"){
                                        if(setItem.ownerId == trData.uuid || setItem.ownerId == trData.props.VMUUID || setItem.ownerId ==  trData.vmUuid){
                                            _.extend(trData, {
                                                userNameVal: setItem.value.username,
                                                passwordVal: setItem.value.password
                                            });
                                        };
                                    };
                                });
                            });
                        };
                        var contextId = trData.uuid || trData.props.VMUUID || trData.vmUuid;
                        _.each(trData.netWorkCard, function(ipValue, index) {
                            _.extend(ipValue, {
                                nicName: ipValue.ethernetCardName,
                                require: {
                                    ipv4: ipValue.dhcpEnabled4 === false,
                                    netmask: ipValue.dhcpEnabled4 === false,
                                    gateway: ipValue.dhcpEnabled4 === false,
                                    dnsFirstChoose: ipValue.autoDns4 === false,
                                    // 默认IPv6只能手动
                                    // ipv6: true,
                                    // prefix: true,
                                    // gatewayIPv6: true,
                                    ipv6: ipValue.dhcpEnabled6 === false,
                                    prefix: ipValue.dhcpEnabled6 === false,
                                    gatewayIPv6: ipValue.dhcpEnabled6 === false,
                                    dnsFirstChooseIPv6: ipValue.autoDns6 === false
                                },
                                ipSetChange: function() {
                                    var ipSetWay = $("#" + this.ipSetWay.id).widget().opChecked("checked");
                                    if ("auto" == ipSetWay) {
                                        $("#" + this.ipv4.id).widget().option("value", "");
                                        $("#" + this.netmask.id).widget().option("value", "");
                                        $("#" + this.gateway.id).widget().option("value", "");
                                        $("#" + this.ipv4.id).widget().option("disable", true);
                                        $("#" + this.netmask.id).widget().option("disable", true);
                                        $("#" + this.gateway.id).widget().option("disable", true);
                                        this.require.ipv4 = false;
                                        this.require.netmask = false;
                                        this.require.gateway = false;
                                    } else {
                                        this.require.ipv4 = true;
                                        this.require.netmask = true;
                                        this.require.gateway = true;
                                        $("#" + this.ipv4.id).widget().option("disable", false);
                                        $("#" + this.netmask.id).widget().option("disable", false);
                                        $("#" + this.gateway.id).widget().option("disable", false);
                                    };
                                    _.extend(ipValue, {
                                        dhcpEnabled4: ipSetWay == "auto",
                                        dhcpEnabled6: false//IPv6默认为手动获取IP
                                    });
                                },
                                dnsSetChange: function() {
                                    var dnsSetWay = $("#" + this.dnsSetWay.id).widget().opChecked("checked");
                                    if ("auto" == dnsSetWay) {
                                        $("#" + this.dnsFirstChoose.id).widget().option("value", "");
                                        $("#" + this.dnsReserveChoose.id).widget().option("value", "");
                                        $("#" + this.dnsFirstChoose.id).widget().option("disable", true);
                                        $("#" + this.dnsReserveChoose.id).widget().option("disable", true);
                                        this.require.dnsFirstChoose = false;
                                    } else {
                                        this.require.dnsFirstChoose = true;
                                        $("#" + this.dnsFirstChoose.id).widget().option("disable", false);
                                        $("#" + this.dnsReserveChoose.id).widget().option("disable", false);
                                    }
                                    _.extend(ipValue, {
                                        autoDns4: dnsSetWay == "auto"
                                    })
                                },
                                dnsSetChangeIPv6: function() {
                                    var dnsSetWayIPv6 = $("#" + this.dnsSetWayIPv6.id).widget().opChecked("checked");
                                    if ("auto" == dnsSetWayIPv6) {
                                        $("#" + this.dnsFirstChooseIPv6.id).widget().option("value", "");
                                        $("#" + this.dnsReserveChooseIPv6.id).widget().option("value", "");
                                        $("#" + this.dnsFirstChooseIPv6.id).widget().option("disable", true);
                                        $("#" + this.dnsReserveChooseIPv6.id).widget().option("disable", true);
                                        this.require.dnsFirstChooseIPv6 = false;
                                    } else {
                                        this.require.dnsFirstChooseIPv6 = true;
                                        $("#" + this.dnsFirstChooseIPv6.id).widget().option("disable", false);
                                        $("#" + this.dnsReserveChooseIPv6.id).widget().option("disable", false);
                                    }
                                    _.extend(ipValue, {
                                        autoDns6: dnsSetWayIPv6 == "auto"
                                    })
                                },
                                isStartIPv4Change: function() {
                                    var that = this;
                                    var isStartIPv4Flag = $("#" + that.isStartIPv4.id).widget().option("checked");
                                    if (!isStartIPv4Flag) {
                                        // 自灰自动ip按钮
                                        $("#" + that.ipSetWay.id).widget().opDisabled("auto",true);
                                        $("#" + that.ipSetWay.id).widget().opDisabled("manual",true);
                                        // 自灰IP地址、掩码、默认网关
                                        $("#" + that.ipv4.id).widget().option("disable",true);
                                        $("#" + that.netmask.id).widget().option("disable",true);
                                        $("#" + that.gateway.id).widget().option("disable",true);
                                        that.require.ipv4 = false;
                                        that.require.netmask = false;
                                        that.require.gateway = false;

                                        // 若是Windows，对DNS进行处理
                                        if($scope.isWindows){
                                            // 自灰自动DNS按钮
                                            $("#" + that.dnsSetWay.id).widget().opDisabled("auto",true);
                                            $("#" + that.dnsSetWay.id).widget().opDisabled("manual",true);
                                            // 自灰DNS框
                                            $("#" + that.dnsFirstChoose.id).widget().option("disable",true);
                                            $("#" + that.dnsReserveChoose.id).widget().option("disable",true);
                                            that.require.dnsFirstChoose = false;
                                        };
                                    } else {
                                        // 恢复自动ip按钮
                                        $("#" + that.ipSetWay.id).widget().opDisabled("auto",false);
                                        $("#" + that.ipSetWay.id).widget().opDisabled("manual",false);
                                        // 根据当前是否启用自动IP来回显
                                        var isDhcp = _.isUndefined(ipValue.dhcpEnabled4) ? true : ipValue.dhcpEnabled4;
                                        // 若未定义或启用了自动IP4
                                        if(isDhcp){
                                            // 选中自动
                                            $("#" + that.ipSetWay.id).widget().opChecked("auto",true);
                                            $("#" + that.ipSetWay.id).widget().opChecked("manual",false);
                                            // 自灰IP地址、掩码、默认网关
                                            $("#" + that.ipv4.id).widget().option("disable",true);
                                            $("#" + that.netmask.id).widget().option("disable",true);
                                            $("#" + that.gateway.id).widget().option("disable",true);
                                            that.require.ipv4 = false;
                                            that.require.netmask = false;
                                            that.require.gateway = false;
                                        }else{
                                            // 选中手动
                                            $("#" + that.ipSetWay.id).widget().opChecked("auto",false);
                                            $("#" + that.ipSetWay.id).widget().opChecked("manual",true);
                                            // 恢复IP地址、掩码、默认网关
                                            $("#" + that.ipv4.id).widget().option("disable",false);
                                            $("#" + that.netmask.id).widget().option("disable",false);
                                            $("#" + that.gateway.id).widget().option("disable",false);
                                            that.require.ipv4 = true;
                                            that.require.netmask = true;
                                            that.require.gateway = true;
                                        };

                                        // 若是Windows，对DNS进行处理
                                        if($scope.isWindows){
                                            // 恢复自动DNS按钮
                                            $("#" + that.dnsSetWay.id).widget().opDisabled("auto",false);
                                            $("#" + that.dnsSetWay.id).widget().opDisabled("manual",false);
                                            // 根据当前是否启用自动DNS来回显
                                            var isDhcpDNS = _.isUndefined(ipValue.autoDns4) ? true : ipValue.autoDns4;
                                            // 若未定义或启用了自动IP4
                                            if(isDhcpDNS){
                                                // 选中自动
                                                $("#" + that.dnsSetWay.id).widget().opChecked("auto",true);
                                                $("#" + that.dnsSetWay.id).widget().opChecked("manual",false);
                                                // 自灰DNS框
                                                $("#" + that.dnsFirstChoose.id).widget().option("disable",true);
                                                $("#" + that.dnsReserveChoose.id).widget().option("disable",true);
                                                that.require.dnsFirstChoose = false;
                                            }else{
                                                // 选中手动
                                                $("#" + that.dnsSetWay.id).widget().opChecked("auto",false);
                                                $("#" + that.dnsSetWay.id).widget().opChecked("manual",true);
                                                // 恢复DNS框
                                                $("#" + that.dnsFirstChoose.id).widget().option("disable",false);
                                                $("#" + that.dnsReserveChoose.id).widget().option("disable",false);
                                                that.require.dnsFirstChoose = true;
                                            };
                                        };
                                    };
                                    _.extend(ipValue, {
                                        openIp4: isStartIPv4Flag
                                    });
                                },
                                isStartIPv6Change: function() {
                                    var that = this;
                                    var isStartIPv6Flag = $("#" + that.isStartIPv6.id).widget().option("checked");
                                    if (isStartIPv6Flag) {
                                        // 恢复IP地址、掩码长度、默认网关
                                        $("#" + that.gatewayIPv6.id).widget().option("disable",false);
                                        that.gatewayIPv6.disable = false;
                                        that.require.ipv6 = true;
                                        that.require.prefix = true;
                                        that.require.gatewayIPv6 = true;

                                        // 若是Windows，对DNS进行处理
                                        if($scope.isWindows){
                                            // 恢复自动DNS按钮
                                            $("#" + that.dnsSetWayIPv6.id).widget().opDisabled("auto",false);
                                            $("#" + that.dnsSetWayIPv6.id).widget().opDisabled("manual",false);
                                            // 根据当前是否启用自动DNS来回显
                                            var isDhcpDNSIP6 = _.isUndefined(ipValue.autoDns6) ? true : ipValue.autoDns6;
                                            // 若未定义或启用了自动IP6
                                            if(isDhcpDNSIP6){
                                                // 选中自动
                                                $("#" + that.dnsSetWayIPv6.id).widget().opChecked("auto",true);
                                                $("#" + that.dnsSetWayIPv6.id).widget().opChecked("manual",false);
                                                // 自灰DNS框
                                                $("#" + that.dnsFirstChooseIPv6.id).widget().option("disable",true);
                                                $("#" + that.dnsReserveChooseIPv6.id).widget().option("disable",true);
                                                that.require.dnsFirstChooseIPv6 = false;
                                            }else{
                                                // 选中手动
                                                $("#" + that.dnsSetWayIPv6.id).widget().opChecked("auto",false);
                                                $("#" + that.dnsSetWayIPv6.id).widget().opChecked("manual",true);
                                                // 恢复DNS框
                                                $("#" + that.dnsFirstChooseIPv6.id).widget().option("disable",false);
                                                $("#" + that.dnsReserveChooseIPv6.id).widget().option("disable",false);
                                                that.require.dnsFirstChooseIPv6 = true;
                                            };
                                        };
                                        $("#" + that.addRow.iconId).removeClass('iconbutton-add-disabled').addClass('iconbutton-add');
                                        $("#" + that.addRow.textId).removeClass('btn-link-disable').addClass('btn-link');
                                    } else {
                                        // 自灰IP地址、掩码长度、默认网关
                                        $("#" + that.gatewayIPv6.id).widget().option("disable",true);
                                        that.gatewayIPv6.disable = true;
                                        that.require.ipv6 = false;
                                        that.require.prefix = false;
                                        that.require.gatewayIPv6 = false;
                                        // 若是Windows，对DNS进行处理
                                        if($scope.isWindows){
                                            // 自灰自动DNS按钮
                                            $("#" + that.dnsSetWayIPv6.id).widget().opDisabled("auto",true);
                                            $("#" + that.dnsSetWayIPv6.id).widget().opDisabled("manual",true);
                                            // 自灰DNS框
                                            $("#" + that.dnsFirstChooseIPv6.id).widget().option("disable",true);
                                            $("#" + that.dnsReserveChooseIPv6.id).widget().option("disable",true);
                                            that.require.dnsFirstChooseIPv6 = false;
                                        };
                                        $("#" + that.addRow.iconId).removeClass('iconbutton-add').addClass('iconbutton-add-disabled');
                                        $("#" + that.addRow.textId).removeClass('btn-link').addClass('btn-link-disable');
                                    };
                                    _.extend(ipValue, {
                                        openIp6: isStartIPv6Flag
                                    });
                                    _.each(ipValue.ipv6ListArray, function(ipVal){
                                        ipVal.address.disable = !isStartIPv6Flag;
                                        ipVal.prefix.disable = !isStartIPv6Flag;
                                        $("#" + ipVal.address.id).widget().option("disable", !isStartIPv6Flag);
                                        $("#" + ipVal.prefix.id).widget().option("disable", !isStartIPv6Flag);
                                        ipVal.address.require = isStartIPv6Flag;
                                        ipVal.prefix.require = isStartIPv6Flag;
                                        if (isStartIPv6Flag && ipValue.ipv6ListArray.length > 1) {
                                            $("#" + ipVal.removeRow.id).removeClass('iconbutton-fork-disabled').addClass('iconbutton-fork');
                                        } else {
                                            $("#" + ipVal.removeRow.id).removeClass('iconbutton-fork').addClass('iconbutton-fork-disabled');
                                        };
                                        ipVal.removeRow.disable = !isStartIPv6Flag;
                                    });
                                    ipValue.addRow.disable = !isStartIPv6Flag;
                                },
                                isStartIPv4: {
                                    id: "startipv4" + contextId + index,
                                    disable: false,
                                    checked: ipValue.openIp4 || false,
                                    require: false,
                                    text: appUtils.getString("protect_object_enableIPv4_label")
                                },
                                isStartIPv6: {
                                    id: "startipv6" + contextId + index,
                                    text: appUtils.getString("protect_object_enableIPv6_label"),
                                    checked: ipValue.openIp6 || false,
                                    disable: false
                                },
                                ipSetWay: {
                                    id: "ipSetWay" + contextId + index,
                                    values: [{
                                        "key": "auto",
                                        "text": appUtils.getString("protect_object_ip_get_auto_label"),
                                        "checked": _.isUndefined(ipValue.dhcpEnabled4) ? true : ipValue.dhcpEnabled4,
                                        "disable": _.isUndefined(ipValue.openIp4) ? true : !ipValue.openIp4
                                    }, {
                                        "key": "manual",
                                        "text": appUtils.getString("protect_object_ip_set_manual_label"),
                                        "checked": _.isUndefined(ipValue.dhcpEnabled4) ? false : !ipValue.dhcpEnabled4,
                                        "disable": _.isUndefined(ipValue.openIp4) ? true : !ipValue.openIp4
                                    }],
                                    space: {
                                        "height": "23px"
                                    },
                                    layout: "vertical"
                                },
                                dnsSetWay: {
                                    id: "dnsSetWay" + contextId + index,
                                    values: [{
                                        "key": "auto",
                                        "text": appUtils.getString("protect_object_dns_get_auto_label"),
                                        "checked": _.isUndefined(ipValue.autoDns4) ? true : ipValue.autoDns4,
                                        "disable": _.isUndefined(ipValue.openIp4) ? true : !ipValue.openIp4
                                    }, {
                                        "key": "manual",
                                        "text": appUtils.getString("protect_object_dns_set_manuallabel"),
                                        "checked": _.isUndefined(ipValue.autoDns4) ? false : !ipValue.autoDns4,
                                        "disable": _.isUndefined(ipValue.openIp4) ? true : !ipValue.openIp4
                                    }],
                                    space: {
                                        "height": "23px"
                                    },
                                    layout: "vertical"
                                },
                                dnsSetWayIPv6: {
                                    id: "dnsSetWayIPv6" + contextId + index,
                                    values: [{
                                        "key": "auto",
                                        "text": appUtils.getString("protect_object_dns_get_auto_label"),
                                        "checked": _.isUndefined(ipValue.autoDns6) ? true : ipValue.autoDns6,
                                        "disable": _.isUndefined(ipValue.openIp6) ? true : !ipValue.openIp6
                                    }, {
                                        "key": "manual",
                                        "text": appUtils.getString("protect_object_dns_set_manuallabel"),
                                        "checked": _.isUndefined(ipValue.autoDns6) ? false : !ipValue.autoDns6,
                                        "disable": _.isUndefined(ipValue.openIp6) ? true : !ipValue.openIp6
                                    }],
                                    space: {
                                        "height": "23px"
                                    },
                                    layout: "vertical"
                                },
                                ipv4: {
                                    id: "ipv4" + contextId + index,
                                    value: ipValue.ipVal || "",
                                    type: "ipv4",
                                    focused: false,
                                    disable: ipValue.dhcpEnabled4 !== false,
                                    width: 200,
                                    validate: constsService.VALID.IP_STANDARD,
                                    ipReg: /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/,
                                    change: function() {
                                        var that = this;
                                        _.extend(ipValue, {
                                            ipVal: $("#" + that.id).widget().getValue()
                                        })
                                    }
                                },
                                netmask: {
                                    id: "netmask" + contextId + index,
                                    value: ipValue.netmaskVal || "",
                                    type: "ipv4",
                                    focused: false,
                                    disable: ipValue.dhcpEnabled4 !== false,
                                    width: 200,
                                    validate: constsService.VALID.union("required", constsService.VALID.MASK),
                                    maskReg: /^(0.0.0.0|128.0.0.0|192.0.0.0|224.0.0.0|240.0.0.0|248.0.0.0|252.0.0.0|254.0.0.0|255.0.0.0|255.128.0.0|255.192.0.0|255.224.0.0|255.240.0.0|255.248.0.0|255.252.0.0|255.254.0.0|255.255.0.0|255.255.128.0|255.255.192.0|255.255.224.0|255.255.240.0|255.255.248.0|255.255.252.0|255.255.254.0|255.255.255.0|255.255.255.128|255.255.255.192|255.255.255.224|255.255.255.240|255.255.255.248|255.255.255.252|255.255.255.254|255.255.255.255)$/,
                                    change: function() {
                                        var that = this;
                                        _.extend(ipValue, {
                                            netmaskVal: $("#" + that.id).widget().getValue()
                                        })
                                    }
                                },
                                gateway: {
                                    id: "gateway" + contextId + index,
                                    value: ipValue.gatewayVal || "",
                                    type: "ipv4",
                                    focused: false,
                                    disable: ipValue.dhcpEnabled4 !== false,
                                    width: 200,
                                    validate: constsService.VALID.IP_STANDARD,
                                    ipReg: /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/,
                                    change: function() {
                                        var that = this;
                                        _.extend(ipValue, {
                                            gatewayVal: $("#" + that.id).widget().getValue()
                                        })
                                    }
                                },
                                gatewayIPv6: {
                                    id: "gatewayIPv6" + contextId + index,
                                    value: ipValue.gateway6Val || "",
                                    focused: false,
                                    disable: appUtils.toBoolean(ipValue.openIp6) === false,
                                    width: 340,
                                    extendFunction: ["checkIPv6"],
                                    validate: "checkIPv6 : extend function;",
                                    change: function() {
                                        var that = this;
                                        _.extend(ipValue, {
                                            gateway6Val: $("#" + that.id).widget().getValue()
                                        })
                                    }
                                },
                                dnsFirstChoose: {
                                    id: "dnsFirstChoose" + contextId + index,
                                    type: "ipv4",
                                    width: 200,
                                    value: ipValue.preferredDns || "",
                                    disable: ipValue.autoDns4 !== false,
                                    validate: constsService.VALID.IP_STANDARD,
                                    ipReg: /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/,
                                    change: function() {
                                        var that = this;
                                        _.extend(ipValue, {
                                            preferredDns: $("#" + that.id).widget().getValue()
                                        })
                                    }
                                },
                                dnsReserveChoose: {
                                    id: "dnsReserveChoose" + contextId + index,
                                    type: "ipv4",
                                    width: 200,
                                    value: ipValue.alternateDns || "",
                                    disable: ipValue.autoDns4 !== false,
                                    validate: constsService.VALID.IP_STANDARD_NOT,
                                    ipReg: /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/,
                                    change: function() {
                                        var that = this;
                                        _.extend(ipValue, {
                                            alternateDns: $("#" + that.id).widget().getValue()
                                        })
                                    }
                                },
                                dnsFirstChooseIPv6: {
                                    id: "dnsFirstChooseIPv6" + contextId + index,
                                    width: 200,
                                    value: ipValue.preferredDns6 || "",
                                    disable: ipValue.autoDns6 !== false,
                                    extendFunction: ["checkIPv6"],
                                    validate: "checkIPv6 : extend function;",
                                    change: function() {
                                        var that = this;
                                        _.extend(ipValue, {
                                            preferredDns6: $("#" + that.id).widget().getValue()
                                        })
                                    }
                                },
                                dnsReserveChooseIPv6: {
                                    id: "dnsReserveChooseIPv6" + contextId + index,
                                    width: 200,
                                    value: ipValue.alternateDns6 || "",
                                    disable: ipValue.autoDns6 !== false,
                                    validate: "checkIPv6AddDNS : extend function;",
                                    extendFunction: ["checkIPv6AddDNS"],
                                    change: function() {
                                        var that = this;
                                        _.extend(ipValue, {
                                            alternateDns6: $("#" + that.id).widget().getValue()
                                        })
                                    }
                                },
                                open: index == 0,
                                openStatus: index == 0,
                                headClick: function(){
                                    _.each($scope.model.linuxValues,function(obj){
                                        obj.openStatus=false;
                                    });
                                    this.openStatus=!this.open;
                                    $scope.$apply();
                                }
                            })
                            //ipv6支持可以配多个
                            var ipv6ListArray = [];
                            var ipv6Temp = {
                                address: {
                                    id: "ipText" + contextId + "0",
                                    value: "",
                                    disable: false,
                                    width: "260",
                                    require: true,
                                    validate: "checkIPv6 : extend function;",
                                    extendFunction: ["checkIPv6"],
                                    change: function(){
                                        this.value = $("#" + this.id).widget().getValue()
                                    },
                                    getValue: function(){
                                        return this.value
                                    }
                                },
                                prefix: {
                                    id: "prefixText" + contextId + "0",
                                    value: "",
                                    disable: false,
                                    width: "107",
                                    require: true,
                                    validate: [{
                                        validFn: "required"
                                    },{
                                        validFn: "rangeValue",
                                        params: [0, 128],
                                        errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 0, 128)
                                    },{
                                        validFn: "integer"
                                    }],
                                    change: function(){
                                        this.value = $("#" + this.id).widget().getValue()
                                    },
                                    getValue: function(){
                                        return this.value
                                    }
                                },
                                removeRow: {
                                    id: "removeRow" + index + "0",
                                    disable: true,
                                    click: function(row) {
                                        if(this.disable) return;
                                        var indexNum = _.indexOf(ipValue.ipv6ListArray, row, true);
                                        ipValue.ipv6ListArray.splice(indexNum, 1);
                                        ipValue.addRow.disable = !(_.size(ipValue.ipv6ListArray) < 5);
                                        if(_.size(ipValue.ipv6ListArray) == 1){
                                            ipValue.ipv6ListArray[0].removeRow.disable = true;
                                            $("#" + ipValue.ipv6ListArray[0].removeRow.id).removeClass('iconbutton-fork').addClass('iconbutton-fork-disabled');
                                        };
                                        $("#" + ipValue.addRow.iconId).removeClass('iconbutton-add-disabled').addClass('iconbutton-add');
                                        $("#" + ipValue.addRow.textId).removeClass('btn-link-disable').addClass('btn-link');
                                    }
                                }
                            };
                            if (!_.isEmpty(ipValue.ipv6List) && _.isArray(ipValue.ipv6List)) {
                                _.each(ipValue.ipv6List, function(ipv6Item, indexTemp){
                                    var ipv6Obj = {
                                        address: {
                                            id: "ipText" + contextId + indexTemp,
                                            value: ipv6Item.address,
                                            disable: ipValue.dhcpEnabled6 !== false,
                                            require: true,
                                            width: "260",
                                            validate: "checkIPv6 : extend function;",
                                            extendFunction: ["checkIPv6"],
                                            change: function(){
                                                this.value = $("#" + this.id).widget().getValue()
                                            },
                                            getValue: function(){
                                                return this.value
                                            }
                                        },
                                        prefix: {
                                            id: "prefixText" + contextId + indexTemp,
                                            value: ipv6Item.prefix,
                                            disable: ipValue.dhcpEnabled6 !== false,
                                            width: "107",
                                            require: true,
                                            validate: [{
                                                validFn: "required"
                                            },{
                                                validFn: "rangeValue",
                                                params: [0, 128],
                                                errorDetail: appUtils.getString("validate_term_common_value_integer_range_msg", 0, 128)
                                            },{
                                                validFn: "integer"
                                            }],
                                            change: function(){
                                                this.value = $("#" + this.id).widget().getValue()
                                            },
                                            getValue: function(){
                                                return this.value
                                            }
                                        },
                                        removeRow: {
                                            id: "removeRow" + index + indexTemp,
                                            disable: _.size(ipValue.ipv6List) < 2,
                                            click: function(row) {
                                                if(this.disable) return;
                                                var indexNum = _.indexOf(ipValue.ipv6ListArray, row, true);
                                                ipValue.ipv6ListArray.splice(indexNum, 1);
                                                ipValue.addRow.disable = !(_.size(ipValue.ipv6ListArray) < 5);
                                                if(_.size(ipValue.ipv6ListArray) == 1){
                                                    ipValue.ipv6ListArray[0].removeRow.disable = true;
                                                    $("#" + ipValue.ipv6ListArray[0].removeRow.id).removeClass('iconbutton-fork').addClass('iconbutton-fork-disabled');
                                                };
                                                $("#" + ipValue.addRow.iconId).removeClass('iconbutton-add-disabled').addClass('iconbutton-add');
                                                $("#" + ipValue.addRow.textId).removeClass('btn-link-disable').addClass('btn-link');
                                            }
                                        },
                                    };
                                    ipv6ListArray.push(ipv6Obj);
                                });
                            } else {
                                var defaultVal = angular.copy(ipv6Temp);
                                defaultVal.address.disable = true;
                                defaultVal.prefix.disable = true;
                                defaultVal.address.require = false;
                                defaultVal.prefix.require = false;
                                ipv6ListArray.push(defaultVal);
                            };
                            _.isUndefined(ipValue.ipv6ListArray) && _.extend(ipValue, {
                                ipv6ListArray: ipv6ListArray
                            });
                            _.extend(ipValue, {
                                ipv6ListArrayValue: function(){
                                    var that = this;
                                    var ipLists = [];
                                    _.each(that.ipv6ListArray, function(coco){
                                        ipLists.push({
                                            address: coco.address.getValue(),
                                            prefix: coco.prefix.getValue()
                                        });
                                    });
                                    return ipLists;
                                },
                                addRow: {
                                    iconId: "addRowIcon" + index,
                                    textId: "addRowText" + index,
                                    text: appUtils.getString("common_term_addline_button"),
                                    disable:  (_.isArray(ipValue.ipv6ListArray) && _.size(ipValue.ipv6ListArray) == 5 && ipValue.openIp6) || !ipValue.openIp6,
                                    click: function(){
                                        if(this.disable) return;
                                        var tailObj = ipValue.ipv6ListArray[ipValue.ipv6ListArray.length - 1];
                                        var tailObjId = tailObj.address.id;
                                        var tailIndex = +(tailObjId.slice(tailObjId.split("").length - 1)) + 1;
                                        var temp = angular.copy(ipv6Temp);
                                        temp.address.id = "ipText" + contextId + tailIndex;
                                        temp.prefix.id = "prefixText" + contextId + tailIndex;
                                        temp.removeRow.id = "removeRow" + tailIndex;
                                        ipValue.ipv6ListArray.push(temp);
                                        _.each(ipValue.ipv6ListArray, function(rowItem){
                                            rowItem.removeRow.disable = false;
                                        });
                                        this.disable = ipValue.ipv6ListArray.length == 5;
                                    }
                                }
                            });
                        });
                        if ($scope.isLinux) {
				            $scope.model.linuxValues = trData.netWorkCard;

                            _.each(trData.netWorkCard, function(module){
                                module["ipv4Click"] = function(index) {
                                    var thisIP4Title = $("#ipv4Title" + index);
                                    var thisIP6Title = $("#ipv6Title" + index);
                                    var thisIP4Content = $("#ipv4Content" + index);
                                    var thisIP6Content = $("#ipv6Content" + index);
                                    if (!thisIP4Title.hasClass("tinyTabActive")) {
                                        thisIP4Title.addClass("tinyTabActive");
                                        thisIP6Title.removeClass("tinyTabActive");
                                        thisIP4Content.css("display","block");
                                        thisIP6Content.css("display","none");
                                    }
                                }

                                module["ipv6Click"] = function(index) {
                                    var thisIP4Title = $("#ipv4Title" + index);
                                    var thisIP6Title = $("#ipv6Title" + index);
                                    var thisIP4Content = $("#ipv4Content" + index);
                                    var thisIP6Content = $("#ipv6Content" + index);
                                    if (!thisIP6Title.hasClass("tinyTabActive")) {
                                        thisIP6Title.addClass("tinyTabActive");
                                        thisIP4Title.removeClass("tinyTabActive");
                                        thisIP4Content.css("display","none");
                                        thisIP6Content.css("display","block");
                                    }
                                }

                            });
                            // IPv4 DNS的回显
                            if (_.isUndefined(trData.autoDns4) || true === trData.autoDns4) {
                                $scope.model.dnsSetWay.values[0].checked = true;
                            } else {
                                $scope.model.dnsSetWay.values[1].checked = true;
                            };
                            $scope.model.dnsFirstChoose.value = trData.preferredDns || "";
                            $scope.model.dnsFirstChoose.disable = trData.autoDns4 !== false;
                            $scope.model.dnsReserveChoose.value = trData.alternateDns || "";
                            $scope.model.dnsReserveChoose.disable = trData.autoDns4 !== false;
                            $scope.model.require.dnsFirstChoose = trData.autoDns4 === false;
                            // IPv6 DNS的回显
                            if (_.isUndefined(trData.autoDns6) || true === trData.autoDns6) {
                                $scope.model.dnsSetWayIPv6.values[0].checked = true;
                            } else {
                                $scope.model.dnsSetWayIPv6.values[1].checked = true;
                            };
                            $scope.model.dnsFirstChooseIPv6.value = trData.preferredDns6 || "";
                            $scope.model.dnsFirstChooseIPv6.disable = trData.autoDns6 !== false;
                            $scope.model.dnsReserveChooseIPv6.value = trData.alternateDns6 || "";
                            $scope.model.dnsReserveChooseIPv6.disable = trData.autoDns6 !== false;
                            $scope.model.require.dnsFirstChooseIPv6 = trData.autoDns6 === false;
                        } else {
                            $scope.model.windowsValues = trData.netWorkCard;
                            _.each(trData.netWorkCard, function(module){
                                module["ipv4Click"] = function(index) {
                                    var thisIP4Title = $("#ipv4Title_win" + index);
                                    var thisIP6Title = $("#ipv6Title_win" + index);
                                    var thisIP4Content = $("#ipv4Content_win" + index);
                                    var thisIP6Content = $("#ipv6Content_win" + index);
                                    if (!thisIP4Title.hasClass("tinyTabActive")) {
                                        thisIP4Title.addClass("tinyTabActive");
                                        thisIP6Title.removeClass("tinyTabActive");
                                        thisIP4Content.css("display","block");
                                        thisIP6Content.css("display","none");
                                    }
                                }

                                module["ipv6Click"] = function(index) {
                                    var thisIP4Title = $("#ipv4Title_win" + index);
                                    var thisIP6Title = $("#ipv6Title_win" + index);
                                    var thisIP4Content = $("#ipv4Content_win" + index);
                                    var thisIP6Content = $("#ipv6Content_win" + index);
                                    if (!thisIP6Title.hasClass("tinyTabActive")) {
                                        thisIP6Title.addClass("tinyTabActive");
                                        thisIP4Title.removeClass("tinyTabActive");
                                        thisIP4Content.css("display","none");
                                        thisIP6Content.css("display","block");
                                    }
                                }

                            });
                            trData.userNameVal = "administrator";
                            $scope.model.userName.value = "administrator";
                            $scope.model.password.value = trData.passwordVal || "";
                        };
                        $scope.$apply();
                    };
                }
            },
            require: {
                dnsFirstChoose: false,
                dnsFirstChooseIPv6: false
            },
            labelcls: {
                ipSetWay: "tiny_formfield_label_hide",
                dnsSetWay: "tiny_formfield_label_hide"
            },
            contentTdAttr: {
                ipSetWay: {
                    colspan: "2"
                },
                dnsSetWay: {
                    colspan: "2"
                }
            },
            dnsSetWay: {
                id: "dnsSetWayId",
                values: [{
                    "key": "auto",
                    "text": appUtils.getString("protect_object_dns_get_auto_label"),
                    "checked": true,
                    "disable": false
                }, {
                    "key": "manual",
                    "text": appUtils.getString("protect_object_dns_set_manuallabel"),
                    "disable": false
                }],
                space: {
                    "height": "23px"
                },
                layout: "vertical",
                dnsSetChange: function() {
                    var dnsSetWay = $("#dnsSetWayId").widget().opChecked("checked");
                    if ("auto" == dnsSetWay) {
                        $("#dnsFirstChoose").widget().option("value", "");
                        $("#dnsReserveChoose").widget().option("value", "");
                        $("#dnsFirstChoose").widget().option("disable", true);
                        $("#dnsReserveChoose").widget().option("disable", true);
                        $scope.model.require.dnsFirstChoose = false;
                    } else {
                        $scope.model.require.dnsFirstChoose = true;
                        $("#dnsFirstChoose").widget().option("disable", false);
                        $("#dnsReserveChoose").widget().option("disable", false);
                    }
                    _.extend(_.first($("#vmsTable").widget().getTableCheckedItems()), {
                        autoDns4: dnsSetWay == "auto"
                    })
                }
            },
            dnsSetWayIPv6: {
                id: "dnsSetWayIPv6Id",
                values: [{
                    "key": "auto",
                    "text": appUtils.getString("protect_object_dns_get_auto_label"),
                    "checked": true,
                    "disable": false
                }, {
                    "key": "manual",
                    "text": appUtils.getString("protect_object_dns_set_manuallabel"),
                    "disable": false
                }],
                space: {
                    "height": "23px"
                },
                layout: "vertical",
                dnsSetChange: function() {
                    var dnsSetWay = $("#dnsSetWayIPv6Id").widget().opChecked("checked");
                    if ("auto" == dnsSetWay) {
                        $("#dnsFirstChooseIPv6").widget().option("value", "");
                        $("#dnsReserveChooseIPv6").widget().option("value", "");
                        $("#dnsFirstChooseIPv6").widget().option("disable", true);
                        $("#dnsReserveChooseIPv6").widget().option("disable", true);
                        $scope.model.require.dnsFirstChooseIPv6 = false;
                    } else {
                        $scope.model.require.dnsFirstChooseIPv6 = true;
                        $("#dnsFirstChooseIPv6").widget().option("disable", false);
                        $("#dnsReserveChooseIPv6").widget().option("disable", false);
                    }
                    _.extend(_.first($("#vmsTable").widget().getTableCheckedItems()), {
                        autoDns6: dnsSetWay == "auto"
                    })
                }
            },
            dnsFirstChoose: {
                id: "dnsFirstChoose",
                type: "ipv4",
                width: 200,
                value: "",
                disable: true,
                validate: constsService.VALID.IP_STANDARD,
                ipReg: /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/,
                change: function() {
                    _.extend(_.first($("#vmsTable").widget().getTableCheckedItems()), {
                        preferredDns: $("#dnsFirstChoose").widget().getValue()
                    })
                }
            },
            dnsFirstChooseIPv6: {
                id: "dnsFirstChooseIPv6",
                width: 200,
                value: "",
                disable: true,
                extendFunction: ["checkIPv6"],
                validate: "checkIPv6 : extend function;",
                change: function() {
                    _.extend(_.first($("#vmsTable").widget().getTableCheckedItems()), {
                        preferredDns6: $("#dnsFirstChooseIPv6").widget().getValue()
                    })
                }
            },
            dnsReserveChoose: {
                id: "dnsReserveChoose",
                type: "ipv4",
                width: 200,
                value: "",
                disable: true,
                validate: constsService.VALID.IP_STANDARD_NOT,
                ipReg: /^(22[0-3]|2[0-1]\d|1\d{2}|[1-9]\d|[1-9])\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|\d)\.(25[0-5]|2[0-4]\d|1\d{2}|[1-9]\d|[1-9])$/,
                change: function() {
                    _.extend(_.first($("#vmsTable").widget().getTableCheckedItems()), {
                        alternateDns: $("#dnsReserveChoose").widget().getValue()
                    })
                }
            },
            dnsReserveChooseIPv6: {
                id: "dnsReserveChooseIPv6",
                width: 200,
                value: "",
                disable: true,
                validate: "checkIPv6AddDNS : extend function;",
                extendFunction: ["checkIPv6AddDNS"],
                change: function() {
                    _.extend(_.first($("#vmsTable").widget().getTableCheckedItems()), {
                        alternateDns6: $("#dnsReserveChooseIPv6").widget().getValue()
                    })
                }
            },
            userName: {
                id: "userName",
                width: "240px",
                value: "administrator",
                disable: true,
                extendFunction: ["checkUserName"],
                validate: "checkUserName : extend function;",
                change: function() {
                    _.extend(_.first($("#vmsTable").widget().getTableCheckedItems()), {
                        userNameVal: $("#userName").widget().getValue()
                    })
                }
            },
            password: {
                id: "password",
                width: "240px",
                value: "",
                type: "password",
                validate: constsService.VALID.AUTH_PWD,
                passwordIsFocus: false,
                focus: function() {
                    this.passwordIsFocus = true;
                    $("#password").widget().option("value", "");
                    $scope.$apply();
                },
                change: function() {
                    _.extend(_.first($("#vmsTable").widget().getTableCheckedItems()), {
                        passwordVal: $("#password").widget().getValue()
                    })
                }
            },
            linuxValues: [],
            windowsValues: []
        };
        UnifyValid.checkUserName = function() {
            var deviceName = $.trim($("#userName").widget().getValue());
            if (!deviceName) {
                return appUtils.getString("common_term_empty_label");
            }

            if (deviceName.length < 1 || deviceName.length > 128) {
                return appUtils.getString("validate_term_expr_length");
            }

            return "";
        };

        UnifyValid.checkIPv6 = function() {
            var val = this[0].value;
            if (_.isEmpty(val)) {
                return appUtils.getString("common_term_empty_label");
            };
            if (!appUtils.validIPv6Address(val)) {
                return appUtils.getString("validate_term_common_ip_v6_rule_msg");
            }
            return "";
        };

        UnifyValid.checkIPv6AddDNS = function() {
            var val = this[0].value;
            if (_.isEmpty(val)) {
                return "";
            };
            if (!appUtils.validIPv6Address(val)) {
                return appUtils.getString("validate_term_common_ip_v6_rule_msg");
            }
            return "";
        };

        UnifyValid.checkIPv4 = function() {
            var val = this[0].value;
            if (_.isEmpty(val)) {
                return appUtils.getString("common_term_empty_label");
            };
            if (!appUtils.validIPv4Address(val)) {
                return appUtils.getString("validate_term_common_ip_v4_rule_msg");
            }
            return "";
        };

        UnifyValid.checkIPv4AddDNS = function() {
            var val = this[0].value;
            if (_.isEmpty(val)) {
                return "";
            };
            if (!appUtils.validIPv4Address(val)) {
                return appUtils.getString("validate_term_common_ip_v4_rule_msg");
            }
            return "";
        };

        $scope.$on('$destroy', function() {
            delete UnifyValid.checkIPv6;
            delete UnifyValid.checkIPv6AddDNS;
            delete UnifyValid.checkIPv4;
            delete UnifyValid.checkIPv4AddDNS;
            delete UnifyValid.checkUserName;
        });

        //查询保护组中的保护对象,创建时走另外的逻辑
        !winData.createFlag && restService.queryProtectObjectsByPage({
            protectgroupId: !_.isEmpty(winData.pg) ? winData.pg.pgId : winData.pgId,
            _PAGE: appUtils.queryFilter(0, 10000)
        }, {
            success: function(result) {
                $scope.model.vmsTable.data = result.records;
                $scope.$apply();
            },
            callback: function() {
                var vmsWidget = $("#vmsTable").widget();
                var tableData = vmsWidget.getTableData();
                if (!_.isEmpty(tableData)) {
                    vmsWidget.setSelectedRow('uuid', tableData[0].uuid);
                    $("#vmsTable tbody .clickTrColor:eq(0) td").click();
                };
            }
        });
        if(winData.createFlag){
            if(!_.isEmpty(winData.vmsData)){
                _.each(winData.vmsData, function(item){
                    _.extend(item, {
                        "props": {
                            "VirtualEthernetCard": item.props.VirtualEthernetCard,
                            "GUESTOSTYPE": item.props.GUESTOSTYPE
                        }
                    })
                })
            };
            $scope.model.vmsTable.data = winData.vmsData;
            $scope.$apply();
            $timeout(function(){
                var vmsWidget = $("#vmsTable").widget();
                if (!_.isEmpty(vmsWidget)) {
                    var tableData = vmsWidget.getTableData();
                    vmsWidget.setSelectedRow('uuid', tableData[0].uuid);
                    $("#vmsTable tbody .clickTrColor:eq(0) td").click();
                };
            }, 0)
        };
    }];
    var module = angular.module('recoverydirector.recovery.config');
    module.tinyController("vmwareMountIpConfigCtl", ctrl);
    return module;
})
