define([], function() {
    "use strict";
    var ctrl = ["$scope", "$timeout", "appUtils", "restService", "model", "constsService", "message",
        function($scope, $timeout, appUtils, restService, model, constsService, message) {
            var winData = $("#" + constsService.VM_MOUNT_NETWORK_CONFIG_WIN.winId).widget().option("data");
            var _pleaseSelect_label = appUtils.getString("common_term_pleaseSelect_listbox");
            var changePairStatus = function() {
                var selectCount = 0,
                    statusClass = {
                        0: "resource-unpaired png",
                        1: "resource-unselect-all-paired png",
                        2: "resource-paired png"
                    },
                    statusSpan = {
                        0: appUtils.getString("common_term_add_mapping_unmapped"),
                        1: appUtils.getString("common_term_add_mapping_mapping"),
                        2: appUtils.getString("common_term_add_mapping_mapped")
                    };
                var hasEmptyTable = false;
                $.each(tableViewSites, function(index) {
                    var tableId = this.table.id;
                    var tableData = $("#" + tableId).widget().getTableData();
                    if (_.isEmpty(tableData)) {
                        hasEmptyTable = true;
                        return false;
                    }
                    var select = $("#" + tableId).widget().getTableCheckedItems();

                    if (!angular.isArray(select) || 0 == select.length) {
                        return;
                    }
                    selectCount++;
                });
                if (hasEmptyTable) {
                    $scope.networkMapping.pairStatusSpan = statusSpan[0];
                    if ($("#pairStatusId").hasClass(statusClass[2])) {
                        $("#pairStatusId").removeClass(statusClass[2]).addClass(statusClass[0]);
                    }
                    $("#pairStatusId").removeClass(statusClass[1]).addClass(statusClass[0]);
                } else {
                    $scope.networkMapping.pairStatusSpan = statusSpan[selectCount];
                    if (selectCount == 1) {
                        if ($("#pairStatusId").hasClass(statusClass[2])) {
                            $("#pairStatusId").removeClass(statusClass[2]).addClass(statusClass[1]);
                        }
                        $("#pairStatusId").removeClass(statusClass[0]).addClass(statusClass[1]);
                    };
                    if (selectCount == 2) {
                        if ($("#pairStatusId").hasClass(statusClass[1])) {
                            $("#pairStatusId").removeClass(statusClass[1]).addClass(statusClass[2]);
                        }
                        $("#pairStatusId").removeClass(statusClass[0]).addClass(statusClass[2]);
                    }
                };
                if (selectCount == 2) {
                    $scope.networkMapping.addBtn.disable = false;
                    $("#addBtn").css("border", "1px solid #53B8EB");
                } else {
                    $scope.networkMapping.addBtn.disable = true;
                    $("#addBtn").css("border", "1px solid #c3c3c3");
                };
                $scope.$apply();
            };
            var addRow = function() {
                var errorMsg;
                var addObj = {
                    id: [],
                    name: []
                };
                $.each(tableViewSites, function(index) {
                    var tableId = this.table.id;
                    var select = $("#" + tableId).widget().getTableCheckedItems();
                    if (!_.isArray(select) || 0 == select.length) {
                        if (appUtils.isEn()) {
                            errorMsg = _pleaseSelect_label + " " + angular.lowercase(this.title.replace(":", "")) + ".";
                            return false;
                        }
                        errorMsg = _pleaseSelect_label + this.title.replace(":", "") + "。";
                        return false;
                    }
                    addObj.name.push(select[0].name);
                    addObj.id.push(select[0].id);
                });

                if (!_.isUndefined(errorMsg)) {
                    message.error(errorMsg);
                    return;
                }

                $("#mappingViewTable").widget().addTableRows(addObj);

                var widget = $("#productionResTable").widget();
                widget.option("data", _.filter(widget.getTableData(), function(value, key) {
                    return value.id !== _.first(widget.getTableCheckedItems()).id;
                }));
            };
            $scope.networkMapping = {
                pairStatusSpan: appUtils.getString("common_term_add_mapping_unmapped"),
                resource: {
                    title: appUtils.getStringWithColon("common.term.productionResource.label"),
                    table: {
                        "checkbox": false,
                        "columnsDraggable": false,
                        "currPage": 1,
                        "id": "productionResTable",
                        "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                        "totalRecords": 0,
                        "enablePagination": false,
                        "columns": [{
                            "mData": "id",
                            "bSortable": false,
                            "bVisible": false
                        }, {
                            "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                            "mData": "name"
                        }],
                        "data": [],
                        "cellClickActive": changePairStatus
                    },
                    initTable: function() {
                        //创建保护组
                        var vmTableData = [];
                        if (!_.isEmpty($("#virtualHostTable").widget())) {
                            vmTableData = $("#virtualHostTable").widget().getTableData();
                        };
                        $timeout(function(){
                            //创建保护组
                            if (winData.createFlag) {
                                var mappingDataNew = [],
                                    productDatasNew = [];
                                if (!_.isEmpty(vmTableData)) {
                                    _.isArray(vmTableData) && _.each(vmTableData, function(po) {
                                        var netWorks = po.props.VirtualEthernetCard;
                                        _.isString(netWorks) && (netWorks = JSON.parse(netWorks));
                                        !_.isEmpty(netWorks) && _.each(netWorks, function(card) {
                                            if (!_.isEmpty(winData["mappingDatas"])) {
                                                card.id = card.netWorkUuid;
                                                card.name = card.netWorkName;
                                                var mappingId = [];
                                                _.each(winData["mappingDatas"], function(val) {
                                                    mappingId.push(val.srcNetworkId)
                                                });
                                                !_.contains(mappingId, card.id) && productDatasNew.push(_.pick(card, "id", "name"));
                                            } else {
                                                card.id = card.netWorkUuid;
                                                card.name = card.netWorkName;
                                                productDatasNew.push(_.pick(card, "id", "name"));
                                            }
                                        });
                                    });
                                    if (!_.isEmpty(winData["mappingDatas"])) {
                                        _.each(winData["mappingDatas"], function(item) {
                                            var addObj = {
                                                id: [],
                                                name: []
                                            };
                                            addObj.id.push(item.srcNetworkId);
                                            addObj.name.push(item.srcNetworkName);
                                            addObj.id.push(item.remoteNetworkId);
                                            addObj.name.push(item.remoteNetworkName);
                                            mappingDataNew.push(addObj);
                                        })
                                    };
                                    productDatasNew = _.uniq(productDatasNew, false, function(val) {
                                        return val.id
                                    });
                                    $scope.networkMapping.resource.table.data = appUtils.encodeForHTML(productDatasNew);
                                    $scope.networkMapping.mappingViewTable.data = appUtils.encodeForHTML(mappingDataNew);
                                    $scope.$apply();
                                } else {
                                    $scope.networkMapping.resource.table.data = [];
                                    $scope.networkMapping.mappingViewTable.data = [];
                                    $scope.$apply();
                                }
                            };
                        }, 0)
                        //已创建保护组
                        function initTable(result){
                            var mappingData = [],
                                productData = [];
                            if (!_.isEmpty(result) && !_.isEmpty(result.records)) {
                                _.isArray(result.records) && _.each(result.records, function(po) {
                                    var netWorks = po.props.VirtualEthernetCard;
                                    _.isString(netWorks) && (netWorks = JSON.parse(netWorks));
                                    !_.isEmpty(netWorks) && _.each(netWorks, function(card) {
                                        if (!_.isEmpty(winData["mappingDatas"])) {
                                            card.id = card.netWorkUuid;
                                            card.name = card.netWorkName;
                                            var mappingId = [];
                                            _.each(winData["mappingDatas"], function(val) {
                                                mappingId.push(val.srcNetworkId)
                                            });
                                            !_.contains(mappingId, card.id) && productData.push(_.pick(card, "id", "name"));
                                        } else {
                                            card.id = card.netWorkUuid;
                                            card.name = card.netWorkName;
                                            productData.push(_.pick(card, "id", "name"));
                                        }
                                    });
                                });
                                if (!_.isEmpty(winData["mappingDatas"])) {
                                    _.each(winData["mappingDatas"], function(item) {
                                        var addObj = {
                                            id: [],
                                            name: []
                                        };
                                        addObj.id.push(item.srcNetworkId);
                                        addObj.name.push(item.srcNetworkName);
                                        addObj.id.push(item.remoteNetworkId);
                                        addObj.name.push(item.remoteNetworkName);
                                        mappingData.push(addObj);
                                    })
                                };
                                productData = _.uniq(productData, false, function(val) {
                                    return val.id
                                });
                                $scope.networkMapping.resource.table.data = appUtils.encodeForHTML(productData);
                                $scope.networkMapping.mappingViewTable.data = appUtils.encodeForHTML(mappingData);
                                $scope.$apply();
                            } else {
                                $scope.networkMapping.resource.table.data = [];
                                $scope.networkMapping.mappingViewTable.data = [];
                                $scope.$apply();
                            }
                        };
                        var selectedReplica = {};
                        if (!winData.createFlag) {
                            if (!_.isEmpty($("#duplicaListTable").widget())) {
                                selectedReplica = _.first($("#duplicaListTable").widget().getTableCheckedItems());
                                if(_.isEmpty(selectedReplica)){
                                    return;
                                };
                                restService.getCopyProtectgroups({
                                    protectgroupId: winData.pg.pgId,
                                    replicaId: selectedReplica.id
                                }, {
                                    success: initTable
                                });
                            } else {
                                restService.queryProtectObjectsByPage({
                                    protectgroupId: winData.pg.pgId,
                                    _PAGE: appUtils.queryFilter(0, 10000)
                                }, {
                                    success: initTable
                                });
                            }
                        };
                    }
                },
                drResource: {
                    title: appUtils.getStringWithColon("common.term.drResource.label"),
                    table: {
                        "checkbox": false,
                        "columnsDraggable": false,
                        "currPage": 1,
                        "id": "drResTable",
                        "displayLength": constsService.TABLE_COUNT_MAX_PAGE,
                        "totalRecords": 0,
                        "enablePagination": false,
                        "columns": [{
                            "mData": "id",
                            "bSortable": false,
                            "bVisible": false
                        }, {
                            "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                            "mData": "name"
                        }],
                        "data": [],
                        "cellClickActive": changePairStatus
                    },
                    initTable: function() {
                        if (winData.hostUuid == "-1" || winData.vcenterUuid == "-1") {
                            return;
                        };
                        restService.getRecoveryHostNetwork({
                            hostOrClusterId: winData.hostUuid,
                            vcenterUuid: winData.vcenterUuid
                        }, {
                            mask: true,
                            success: function(result) {
                                var drResData = [];

                                _.isArray(result) && _.each(result, function(obj) {
                                    obj.id = obj.remoteNetworkId;
                                    obj.name = obj.remoteNetworkName;
                                    drResData.push(_.pick(obj, "id", "name"));
                                });
                                $scope.networkMapping.drResource.table.data = appUtils.encodeForHTML(drResData);
                                $scope.$apply();
                            },
                            fail: function() {
                                $scope.networkMapping.drResource.table.data = [];
                                $scope.$apply();
                            }
                        });
                    }
                },
                addBtn: {
                    id: "addBtn",
                    text: appUtils.getString("common_term_add_mapping_button"),
                    disable: true,
                    click: function() {
                        addRow();
                        changePairStatus();
                    }
                },
                mappingViewTable: {
                    "title": appUtils.getString("rm_term_wizard_mapping_view_title"),
                    "checkbox": false,
                    "currPage": 1,
                    "columnsDraggable": false,
                    "id": "mappingViewTable",
                    "displayLength": constsService.TABLE_COUNT_PER_PAGE,
                    "totalRecords": 0,
                    "data": [],
                    "enablePagination": false,
                    "columns": [{
                        "mData": "id",
                        "bSortable": false,
                        "bVisible": false
                    }, {
                        "sTitle": appUtils.getString("notify_alarm_term_name_column"),
                        "mData": "name",
                        "sWidth": "90%",
                        "bSortable": false
                    }],
                    "renderRow": function(nRow, aData, iDataIndex) {
                        var nameDiv = "<span class='ellipsisTooltip inlineTrDiv' title='value' style='width:120px!important'>value</span>";
                        var arrow = "<img src='../theme/recoverydirector/images/resourceMapping/arrow_line.png' class='arrow'>";
                        var mappingTypeImg = "<img src='../theme/recoverydirector/images/resourceMapping/network.png' class='network'>";
                        var nameHTML = [];
                        nameHTML.push(mappingTypeImg);
                        nameHTML.push(nameDiv.replace(/value/g, aData.name[0]));
                        nameHTML.push(arrow);
                        nameHTML.push(mappingTypeImg);
                        nameHTML.push(nameDiv.replace(/value/g, aData.name[1]));
                        $('td:eq(0)', nRow).html(nameHTML);
                        $('td:eq(0)', nRow).html("<div style='margin-left:36px'>" + $('td:eq(0)', nRow).html() + "</div>");
                        $('td:eq(0)', nRow).css({
                            "text-align": "center"
                        });
                    },
                    opAreaConfig: [{
                        id: "iconBtnDel",
                        template: "<div class='iconbutton-delete' title='" + appUtils.getString("common_term_delete_button") + "'></div>",
                        clickActive: function() {
                            var row = $("#mappingViewTable").widget().getHoverData()[0];
                            if (_.isUndefined(row)) {
                                return;
                            }
                            $.each(tableViewSites, function(index) {
                                var rowObj = {
                                    id: row.id[index],
                                    name: row.name[index]
                                };
                                this.table.id == "productionResTable" && $("#" + this.table.id).widget().addTableRows(rowObj);
                            });
                            var mappingViewTable = $("#mappingViewTable").widget();
                            var sourceDatas = mappingViewTable.getTableData();
                            appUtils.removeFromArray(sourceDatas, [row], "id");
                            mappingViewTable.option("data", sourceDatas);
                            $("#mappingViewTable .OpButton_main").hide();
                            changePairStatus();
                        }
                    }]
                }
            };
            var tableViewSites = [$scope.networkMapping.resource, $scope.networkMapping.drResource];
            $scope.networkMapping.resource.initTable();
            $scope.networkMapping.drResource.initTable();
        }
    ];
    var module = angular.module("recoverydirector.recovery.config");
    module.tinyController("vm-mount-network-ctrl", ctrl);
    return module;
})
