define(["tiny-common/UnifyValid"], function(UnifyValid) {
    "use strict";
    var ctrl = ["$scope", "appUtils", "restService", "model", "infoTransferredService", "constsService", "message",
        function($scope, appUtils, restService, Model, infoTransferredService, Consts, message) {
            var winData = $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().option("data");
            var defaultValue = {
                disableDel: true,
                startTime: {
                    id: "startTimeDate0",
                    type: "time",
                    timeFormat: "hh:mm",
                    defaultTime: "00:00",
                    width: "80px",
                    disable: true,
                    getVal: function() {
                        return $("#" + this.id).widget().getDateTime();
                    },
                    setVal: function(val) {
                        this.defaultTime = val;
                    }
                },
                endTime: {
                    id: "endTimeData0",
                    type: "time",
                    timeFormat: "hh:mm",
                    defaultTime: "00:00",
                    width: "80px",
                    disable: true,
                    getVal: function() {
                        return $("#" + this.id).widget().getDateTime();
                    },
                    setVal: function(val) {
                        this.defaultTime = val;
                    }
                },
                siteSelect: {
                    id: "siteSelect0",
                    width: "200",
                    text: appUtils.getStringWithColon("common_term_remoteSite_label"),
                    require: false,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    disable: true,
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        restService.querySites([$scope.serverUuid], function(data) {
                            if (!_.isEmpty(data)) {
                                if (!_.isEmpty(winData.pg)) {
                                    data = _.filter(data, function(item) {
                                        return !item.isCloudSite
                                    })
                                };
                                appUtils.updateSelectValues(that.id, data, "siteId", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function() {
                        var that = this;
                        appUtils.resetSelectValues("vCenter" + that.id.slice(10));
                        appUtils.resetSelectValues("cluster" + that.id.slice(10));
                        _.each($scope.model.mountValues, function(item) {
                            item.siteSelect.id == that.id && (item.vCenter.defaultSelectid = "-1");
                            item.siteSelect.id == that.id && (item.cluster.defaultSelectid = "-1");
                            item.siteSelect.id == that.id && (item.netWork.values = []);
                            $scope.$apply();
                        });
                    },
                    getVal: function() {
                        return $("#" + this.id).widget().getSelectedId();
                    },
                    getName: function() {
                        return $("#" + this.id).widget().getSelectedLabel();
                    },
                    setVal: function(val) {
                        this.values = [{
                            selectId: val.id,
                            label: val.label
                        }];
                        this.defaultSelectid = val.id;
                    },
                    validateFn: function() {
                        return $("#" + this.id).widget().getSelectedId() != "-1";
                    }
                },
                vCenter: {
                    id: "vCenter0",
                    text: appUtils.getStringWithColon("common.term.vCenter.tab"),
                    require: false,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    disable: true,
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        var selectSiteId = $("#siteSelect" + that.id.slice(7)).widget().getSelectedId();
                        if ("-1" == selectSiteId) {
                            return;
                        };
                        restService.queryVCenterBySite([selectSiteId], function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data, "vCenterUuid", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function() {
                        var that = this;
                        appUtils.resetSelectValues("cluster" + that.id.slice(7));
                        _.each($scope.model.mountValues, function(item) {
                            item.vCenter.id == that.id && (item.cluster.defaultSelectid = "-1");
                            item.vCenter.id == that.id && (item.netWork.values = []);
                            $scope.$apply();
                        });
                    },
                    getVal: function() {
                        return $("#" + this.id).widget().getSelectedId();
                    },
                    getName: function() {
                        return $("#" + this.id).widget().getSelectedLabel();
                    },
                    setVal: function(val) {
                        this.values = [{
                            selectId: val.id,
                            label: val.label
                        }];
                        this.defaultSelectid = val.id;
                    },
                    validateFn: function() {
                        return $("#" + this.id).widget().getSelectedId() != "-1";
                    }
                },
                cluster: {
                    id: "cluster0",
                    text: appUtils.getStringWithColon("resource_mapping_cluster"),
                    require: false,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("common_term_pleaseSelect_listbox")
                    }],
                    disable: true,
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        var selectVcenterId = $("#vCenter" + that.id.slice(7)).widget().getSelectedId();
                        if ("-1" == selectVcenterId) {
                            return;
                        };
                        restService.getvCenterTestCluster([selectVcenterId], function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data, "uuid", "name", appUtils.getString("common_term_pleaseSelect_listbox"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function() {
                        var that = this;
                        _.each($scope.model.mountValues, function(item) {
                            item.cluster.id == that.id && (item.netWork.values = []);
                            $scope.$apply();
                        });
                    },
                    getVal: function() {
                        return $("#" + this.id).widget().getSelectedId();
                    },
                    getName: function() {
                        return $("#" + this.id).widget().getSelectedLabel();
                    },
                    setVal: function(val) {
                        this.values = [{
                            selectId: val.id,
                            label: val.label
                        }];
                        this.defaultSelectid = val.id;
                    },
                    validateFn: function() {
                        return $("#" + this.id).widget().getSelectedId() != "-1";
                    }
                },
                netWork: {
                    id: "netWork0",
                    text: appUtils.getStringWithColon("resource_mapping_network"),
                    require: false,
                    disable: true,
                    values: [],
                    config: function() {
                        if (this.disable) {
                            return;
                        };
                        var that = this;
                        var hostWidget = $("#cluster" + that.id.slice(7)).widget();
                        var vcenterWidget = $("#vCenter" + that.id.slice(7)).widget();
                        var win = angular.copy(Consts.VM_MOUNT_NETWORK_CONFIG_WIN);
                        win.data = angular.copy(winData);
                        _.extend(win.data, {
                            hostUuid: hostWidget.getSelectedId(),
                            vcenterUuid: vcenterWidget.getSelectedId(),
                            mappingDatas: that.values
                        });
                        win.title = appUtils.getString("protection_vmware_cdm_network_win_label");
                        appUtils.showWindow(win, function() {
                            var data = $("#mappingViewTable").widget().getTableData();
                            var _productionResData = $("#productionResTable").widget().getTableData();
                            if (_.isEmpty(data) || !_.isEmpty(_productionResData)) {
                                message.error(appUtils.getString("protection_vmware_cdm_network_mapping_error_label"));
                                return;
                            };
                            //重置数据
                            that.values = [];
                            _.each(data, function(obj) {
                                that.values.push({
                                    "srcNetworkId": obj.id[0],
                                    "srcNetworkName": obj.name[0],
                                    "remoteNetworkId": obj.id[1],
                                    "remoteNetworkName": obj.name[1]
                                });
                            });
                            $scope.$apply();
                            $("#" + Consts.VM_MOUNT_NETWORK_CONFIG_WIN.winId).widget().destroy();
                        });
                    },
                    getVal: function(){
                        return this.values
                    },
                    setVal: function(val){
                        this.values = val
                    },
                    validateFn: function() {
                        return this.values.length > 0;
                    }
                },
                vmIp: {
                    id: "vmIp0",
                    require: false,
                    text: appUtils.getStringWithColon("protection_mount_vm_ip_set_label"),
                    disable: true,
                    values: [],
                    config: function(){
                        if (this.disable) {
                            return;
                        };
                        var that = this;
                        //设置虚拟机IP
                        var win = angular.copy(Consts.VMWARE_MOUNT_IP_CONFIG_WIN);
                        win.data = angular.copy(winData);
                        if(!_.isEmpty($("#virtualHostTable").widget()) && !_.isEmpty($("#virtualHostTable").widget().getTableData())){
                            _.extend(win.data, {
                                vmsData: $("#virtualHostTable").widget().getTableData()
                            });
                        };
                        _.extend(win.data, {
                            vmIpConfigs: that.values
                        });
                        win.title = appUtils.getString("protection_mount_vm_ip_set_win_label");
                        appUtils.showWindow(win, function(){
                            //先校验参数是否正确
                            var tableData = $("#vmsTable").widget().getTableData();
                            var vaildFlag = true;
                            var vaildDnsFlag = true;
                            var ipconfigArray = [];
                            for (var i = 0; i < tableData.length; i++) {
                                var networkCardVal = tableData[i].netWorkCard;
                                if (_.isEmpty(networkCardVal)) {
                                    continue;
                                };
                                var errorFlag = true;
                                var dnsErrorFlag = true;
                                //先校验
                                for(var j = 0; j < networkCardVal.length; j++){
                                    if(networkCardVal[j].dhcpEnabled4 === false && networkCardVal[j].openIp4){
                                        if(!networkCardVal[j].ipv4.ipReg.test(networkCardVal[j].ipVal)){
                                            errorFlag = false;
                                            break;
                                        };
                                        if(!networkCardVal[j].netmask.maskReg.test(networkCardVal[j].netmaskVal)){
                                            errorFlag = false;
                                            break;
                                        };
                                        if(!networkCardVal[j].gateway.ipReg.test(networkCardVal[j].gatewayVal)){
                                            errorFlag = false;
                                            break;
                                        };
                                    };
                                    if(networkCardVal[j].autoDns4 === false && networkCardVal[j].openIp4){
                                        if(!networkCardVal[j].dnsFirstChoose.ipReg.test(networkCardVal[j].preferredDns)){
                                            dnsErrorFlag = false;
                                            break;
                                        };
                                        if(!_.isEmpty(networkCardVal[j].alternateDns) && !networkCardVal[j].dnsReserveChoose.ipReg.test(networkCardVal[j].alternateDns)){
                                            dnsErrorFlag = false;
                                            break;
                                        };
                                    };
                                    var obj = {
                                        ownerId: winData["createFlag"] ? tableData[i].vmUuid : tableData[i].uuid,
                                        name: "IPV4:" + networkCardVal[j].macAddress,
                                        value: {
                                            nicMac: networkCardVal[j].macAddress,
                                            nicName: networkCardVal[j].nicName,
                                            openIp4: _.isUndefined(networkCardVal[j].openIp4) ? false : networkCardVal[j].openIp4,
                                            openIp6: _.isUndefined(networkCardVal[j].openIp6) ? false : networkCardVal[j].openIp6,
                                            dhcpEnabled4: _.isUndefined(networkCardVal[j].dhcpEnabled4) ? true : networkCardVal[j].dhcpEnabled4,
                                            dhcpEnabled6: _.isUndefined(networkCardVal[j].dhcpEnabled6) ? false : networkCardVal[j].dhcpEnabled6,
                                            ip: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].ipVal : "",
                                            ipv6List: (networkCardVal[j].dhcpEnabled6 !== true && networkCardVal[j].openIp6) ? networkCardVal[j].ipv6ListArrayValue() : [],
                                            netmask: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].netmaskVal : "",
                                            gateway: networkCardVal[j].dhcpEnabled4 === false ? networkCardVal[j].gatewayVal : "",
                                            gateway6: networkCardVal[j].dhcpEnabled6 !== true ? networkCardVal[j].gateway6Val : ""
                                        }
                                    };
                                    //linux
                                    if(tableData[i].props.GUESTOSTYPE == "linuxGuest"){
                                        _.extend(obj.value, {
                                            autoDns4: _.isUndefined(tableData[i].autoDns4) ? true : tableData[i].autoDns4,
                                            autoDns6: _.isUndefined(tableData[i].autoDns6) ? true : tableData[i].autoDns6,
                                            preferredDns: tableData[i].autoDns4 === false ? tableData[i].preferredDns : "",
                                            preferredDns6: tableData[i].autoDns6 === false ? tableData[i].preferredDns6 : "",
                                            alternateDns: tableData[i].autoDns4 === false ? tableData[i].alternateDns : "",
                                            alternateDns6: tableData[i].autoDns6 === false ? tableData[i].alternateDns6 : ""
                                        })
                                    }else{
                                        _.extend(obj.value, {
                                            autoDns4: _.isUndefined(networkCardVal[j].autoDns4) ? true : networkCardVal[j].autoDns4,
                                            autoDns6: _.isUndefined(networkCardVal[j].autoDns6) ? true : networkCardVal[j].autoDns6,
                                            preferredDns: networkCardVal[j].autoDns4 === false ? networkCardVal[j].preferredDns : "",
                                            preferredDns6: networkCardVal[j].autoDns6 === false ? networkCardVal[j].preferredDns6 : "",
                                            alternateDns: networkCardVal[j].autoDns4 === false ? networkCardVal[j].alternateDns : "",
                                            alternateDns6: networkCardVal[j].autoDns6 === false ? networkCardVal[j].alternateDns6 : ""
                                        })
                                    };
                                    ipconfigArray.push(obj);
                                };
                                if("windowsGuest" == tableData[i].props.GUESTOSTYPE){
                                    var userObj = {
                                        ownerId: winData["createFlag"] ? tableData[i].vmUuid : tableData[i].uuid,
                                        name: "PO_OS_NAMEPASSWORD",
                                        value: {
                                            username: tableData[i].userNameVal,
                                            password: tableData[i].passwordVal
                                        }
                                    };
                                    ipconfigArray.push(userObj);
                                };
                                if(!errorFlag){
                                    vaildFlag = false;
                                    break;
                                };
                                if(!dnsErrorFlag){
                                    vaildDnsFlag = false;
                                    break;
                                }
                            };
                            if(!vaildFlag){
                                message.error(appUtils.getString("lego.err.856064"));
                                return;
                            };
                            if(!vaildDnsFlag){
                                message.error(appUtils.getString("protection_dns_error_lable"));
                                return;
                            };
                            that.values = angular.copy(ipconfigArray);
                            $scope.$apply();
                            $("#" + Consts.VMWARE_MOUNT_IP_CONFIG_WIN.winId).widget().destroy();
                        });
                    },
                    getVal: function(){
                        return this.values;
                    },
                    setVal: function(val){
                        this.values = val
                    }
                },
                unmountPreviousCopy: {
                    id: "unmountPreviousCopy0",
                    text: appUtils.getString("protection_unmount_previous_copy_label"),
                    checked: false,
                    disable: true,
                    change: function() {
                        var that = this;
                        var enabled = $("#" + that.id).widget().option("checked");
                        _.each($scope.model.mountValues, function(val) {
                            if (val.unmountPreviousCopy.id == that.id) {
                                val.delCopyPostviousUnmount.display = enabled;
                                enabled && (val.delCopyPostviousUnmount.checked = true);
                            }
                        })
                        if (!enabled) {
                            message.prompt({
                                content: appUtils.getString("dataMount_create_unmount_previous_copy_tip_lable"),
                                ok: function() {
                                    appUtils.closeWin(true);
                                }
                            });
                        }
                    },
                    getVal: function() {
                        return $("#" + this.id).widget().option("checked");
                    },
                    setVal: function(val) {
                        this.checked = val;
                    }
                },
                delCopyPostviousUnmount: {
                    id: "delCopyPostviousUnmount0",
                    text: appUtils.getString("protection_delete_copy_postvious_unmount_label"),
                    checked: true,
                    display: false,
                    getVal: function() {
                        return $("#" + this.id).widget().option("checked");
                    },
                    setVal: function(val) {
                        this.checked = val;
                    }
                },
                startVM: {
                    id: "startVM0",
                    text: appUtils.getString("protection_startVM_after_mount_label"),
                    checked: false,
                    disable: true,
                    getVal: function() {
                        return $("#" + this.id).widget().option("checked");
                    },
                    setVal: function(val) {
                        this.checked = val;
                    }
                },
                delValue: function() {
                    if (this.disableDel) {
                        return;
                    };
                    var mountValues = $scope.model.mountValues;
                    var index = mountValues.indexOf(this);
                    index != -1 && (mountValues.splice(index, 1));
                    disableFirstPolicy();
                }
            };
            //查询本地服务器信息
            restService.queryLocalServer([], function(data) {
                if (data) {
                    $scope.serverUuid = data.uuid;
                };
            });
            //当只有一条挂载策略数据时，才不允许被删除
            function disableFirstPolicy() {
                if (_.size($scope.model.mountValues) == 1) {
                    _.extend($scope.model.mountValues[0], {
                        disableDel: true
                    });
                } else {
                    _.extend($scope.model.mountValues[0], {
                        disableDel: false
                    });
                }
            };
            //自动挂载说明
            $scope.autoMountTooltip = {
                content: appUtils.getString("protection_auto_mount_explain_label"),
                width: "470",
                position:"bottom-right"
            };
            //是否启动虚拟机说明
            $scope.startVmTooltip = {
                content: appUtils.getString("protection_start_vm_explain_label"),
                width: "300",
                position:"bottom-right"
            };
            $scope.text = {
                mountTitle: appUtils.getString("protection_vmware_mount_policy_win_label"),
                timeLabel: appUtils.getString("protection_mount_configs_policy_label"),
                preScriptLabel: appUtils.getStringWithColon("protection_pre_script_label"),
                postScriptLabel: appUtils.getStringWithColon("protection_post_script_label"),
                addBtnLabel: appUtils.getString("common_term_add_button"),
                configLabel: appUtils.getString("ism.drm.settings.menuname")
            };
            $scope.model = {
                enableCheck: {
                    id: "enableMountCheck",
                    text: appUtils.getString("protection_enable_auto_mount_label"),
                    checked: false,
                    change: function() {
                        var enabled = $("#enableMountCheck").widget().option("checked");
                        $scope.model.addBtn.disable = !enabled;
                        if (enabled) {
                            $("#add_icon_btn").removeClass("iconbutton-add-disabled").addClass("iconbutton-add");
                            $("#add_link_btn").removeClass("btn-link-disable").addClass("btn-link");
                        } else {
                            $("#add_icon_btn").removeClass("iconbutton-add").addClass("iconbutton-add-disabled");
                            $("#add_link_btn").removeClass("btn-link").addClass("btn-link-disable");
                        };
                        _.each($scope.model.mountValues, function(val) {
                            val.startTime.disable = !enabled;
                            val.endTime.disable = !enabled;
                            val.siteSelect.disable = !enabled;
                            val.siteSelect.require = enabled;
                            val.vCenter.disable = !enabled;
                            val.vCenter.require = enabled;
                            val.cluster.disable = !enabled;
                            val.cluster.require = enabled;
                            val.netWork.disable = !enabled;
                            val.netWork.require = enabled;
                            val.unmountPreviousCopy.disable = !enabled;
                            val.unmountPreviousCopy.checked = enabled;
                            val.delCopyPostviousUnmount.display = enabled;
                            val.startVM.disable = !enabled;
                            val.startVM.checked = false;
                            val.vmIp.disable = !enabled;
                            if (enabled) {
                                $("#" + val.netWork.id).removeClass("btn-link-disable").addClass("btn-link");
                                $("#" + val.vmIp.id).removeClass("btn-link-disable").addClass("btn-link");
                            } else {
                                $("#" + val.netWork.id).removeClass("btn-link").addClass("btn-link-disable");
                                $("#" + val.vmIp.id).removeClass("btn-link").addClass("btn-link-disable");
                            };
                        });
                        $scope.$apply();
                    },
                    setValue: function(val) {
                        this.checked = val;
                    }
                },
                mountValues: [angular.copy(defaultValue)],
                addBtn: {
                    disable: true,
                    click: function() {
                        if (this.disable) {
                            return;
                        };
                        var addValue = angular.copy(defaultValue);
                        var addId = parseInt($scope.model.mountValues[$scope.model.mountValues.length - 1].startTime.id.slice(13), 10) + 1;
                        _.each(addValue, function(val) {
                            if (!_.isUndefined(val.id) && val.id.indexOf("startTimeDate") != -1) {
                                val.id = "startTimeDate" + addId;
                                val.disable = false;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("endTimeData") != -1) {
                                val.id = "endTimeData" + addId;
                                val.disable = false;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("siteSelect") != -1) {
                                val.id = "siteSelect" + addId;
                                val.disable = false;
                                val.require = true;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("vCenter") != -1) {
                                val.id = "vCenter" + addId;
                                val.disable = false;
                                val.require = true;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("cluster") != -1) {
                                val.id = "cluster" + addId;
                                val.disable = false;
                                val.require = true;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("netWork") != -1) {
                                val.id = "netWork" + addId;
                                val.disable = false;
                                val.require = true;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("vmIp") != -1) {
                                val.id = "vmIp" + addId;
                                val.disable = false;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("unmountPreviousCopy") != -1) {
                                val.id = "unmountPreviousCopy" + addId;
                                val.disable = false;
                                val.checked = true;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("delCopyPostviousUnmount") != -1) {
                                val.id = "delCopyPostviousUnmount" + addId;
                                val.display = true;
                                val.checked = true;
                            };
                            if (!_.isUndefined(val.id) && val.id.indexOf("startVM") != -1) {
                                val.id = "startVM" + addId;
                                val.disable = false;
                                val.checked = false;
                            };
                        });
                        _.extend(addValue, {
                            disableDel: false
                        });
                        $scope.model.mountValues.push(addValue);
                        disableFirstPolicy();
                        $scope.$apply();
                    }
                }
            };
            //回显
            if (!_.isEmpty(winData.data.props.AUTOMOUNTCONFIGS)) {
                var setConfigs = JSON.parse(winData.data.props.AUTOMOUNTCONFIGS);
                $scope.model.enableCheck.setValue(setConfigs.enabled);
                $scope.model.addBtn.disable = !setConfigs.enabled
                if (setConfigs.enabled) {
                    var mountArray = [];
                    _.each(setConfigs.mountConfigs, function(item, index) {
                        var defaultData = angular.copy(defaultValue);
                        var extParameters = item.extParameters;
                        _.isString(extParameters) && (extParameters = JSON.parse(extParameters));
                        _.isString(extParameters.testNetwork) && (extParameters.testNetwork = JSON.parse(extParameters.testNetwork));
                        _.isString(extParameters.testHosts) && (extParameters.testHosts = JSON.parse(extParameters.testHosts));
                        _.isString(extParameters.mountSettings) && (extParameters.mountSettings = JSON.parse(extParameters.mountSettings));
                        _.extend(defaultData, {
                            disableDel: index == 0
                        });
                        //开始时间
                        defaultData.startTime.id = "startTimeDate" + index;
                        defaultData.startTime.disable = false;
                        defaultData.startTime.setVal(item.startTime);
                        //结束时间
                        defaultData.endTime.id = "endTimeData" + index;
                        defaultData.endTime.disable = false;
                        defaultData.endTime.setVal(item.endTime);
                        //挂载站点信息
                        defaultData.siteSelect.id = "siteSelect" + index;
                        defaultData.siteSelect.disable = false;
                        defaultData.siteSelect.require = true;
                        //挂载vcenter
                        defaultData.vCenter.id = "vCenter" + index;
                        defaultData.vCenter.disable = false;
                        defaultData.vCenter.require = true;
                        defaultData.vCenter.setVal({
                            id: extParameters.testHosts[0]["remoteVcenterId"],
                            label: extParameters.testHosts[0]["remoteVcenterName"]
                        });
                        //挂载cluster
                        defaultData.cluster.id = "cluster" + index;
                        defaultData.cluster.disable = false;
                        defaultData.cluster.require = true;
                        defaultData.cluster.setVal({
                            id: extParameters.testHosts[0]["remoteHostId"],
                            label: extParameters.testHosts[0]["remoteHostName"]
                        });
                        //挂载network
                        defaultData.netWork.id = "netWork" + index;
                        defaultData.netWork.disable = false;
                        defaultData.netWork.require = true;
                        defaultData.netWork.setVal(extParameters.testNetwork);
                        //挂载前先卸载已挂载的副本cluster
                        defaultData.unmountPreviousCopy.id = "unmountPreviousCopy" + index;
                        defaultData.unmountPreviousCopy.disable = false;
                        defaultData.unmountPreviousCopy.setVal(item.unmountPreviousCopy);
                        //卸载成功后自动删除副本
                        defaultData.delCopyPostviousUnmount.id = "delCopyPostviousUnmount" + index;
                        defaultData.delCopyPostviousUnmount.display = item.unmountPreviousCopy;
                        _.isBoolean(item.deleteReplica) && defaultData.delCopyPostviousUnmount.setVal(item.deleteReplica);
                        //挂载成功后是否启动虚拟机
                        defaultData.startVM.id = "startVM" + index;
                        defaultData.startVM.disable = false;
                        !_.isUndefined(item.startDB) && defaultData.startVM.setVal(item.startDB);
                        //设置IP
                        defaultData.vmIp.disable = false;
                        defaultData.vmIp.setVal(extParameters.mountSettings);
                        restService.queryLocalServer([], {
                            success: function(server) {
                                if (_.isObject(server)) {
                                    restService.querySites(server.uuid, {
                                        mask: false,
                                        success: function(sites) {
                                            var useSite = _.filter(sites, function(siteVal) {
                                                return siteVal.siteId == item.siteId
                                            });
                                            defaultData.siteSelect.setVal({
                                                id: item.siteId,
                                                label: useSite[0].name
                                            });
                                        }
                                    });
                                }
                            }
                        });
                        //回显vcenter、cluster等信息
                        mountArray.push(defaultData);
                    });
                    $scope.model.mountValues = mountArray;
                    disableFirstPolicy();
                    $scope.$apply();
                }
            };
            $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().option("buttons", [{
                key: "ok",
                label: appUtils.getString("common_term_confirm_button"),
                focused: true,
                handler: function() {
                    var enableMount = $("#enableMountCheck").widget().option("checked");
                    var vaildateFlag = true;
                    for (var i = 0; i < $scope.model.mountValues.length; i++) {
                        if (!$scope.model.mountValues[i].siteSelect.validateFn() && enableMount) {
                            message.error(appUtils.getString("protection_hyperVault_selectSite_msg"));
                            vaildateFlag = false;
                            break;
                        };
                        if (!$scope.model.mountValues[i].vCenter.validateFn() && enableMount) {
                            message.error(appUtils.getString("ism.drm.common.pg.vCenter.info"));
                            vaildateFlag = false;
                            break;
                        };
                        if (!$scope.model.mountValues[i].cluster.validateFn() && enableMount) {
                            message.error(appUtils.getString("common_term_pleaseSelect_listbox_validate",appUtils.getString("resource_mapping_cluster")));
                            vaildateFlag = false;
                            break;
                        };
                        if(!$scope.model.mountValues[i].netWork.validateFn() && enableMount){
                            message.error(appUtils.getString("common_term_pleaseSelect_listbox_validate",appUtils.getString("resource_mapping_network")));
                            vaildateFlag = false;
                            break;
                        };
                    };
                    //未选择站点、vcenter、cluster等信息
                    if (!vaildateFlag) {
                        return;
                    };
                    var mountConfig = [];
                    _.each($scope.model.mountValues, function(item) {
                        var configs = {
                            startTime: item.startTime.getVal(),
                            endTime: item.endTime.getVal(),
                            siteId: item.siteSelect.getVal(),
                            siteName: item.siteSelect.getName(),
                            hostOrGroupSn: item.cluster.getVal(),
                            hostName: item.cluster.getName(),
                            unmountPreviousCopy: item.unmountPreviousCopy.getVal(),
                            startDB: item.startVM.getVal(),
                        };
                        if (item.unmountPreviousCopy.getVal()) {
                            _.extend(configs, {
                                deleteReplica: item.delCopyPostviousUnmount.getVal()
                            });
                        };
                        //vmware参数处理
                        var hostsConfig = [];
                        hostsConfig.push({
                            remoteVcenterId: item.vCenter.getVal(),
                            remoteVcenterName: item.vCenter.getName(),
                            remoteHostId: item.cluster.getVal(),
                            remoteHostName: item.cluster.getName(),
                        });
                        if(!_.isEmpty(item.vmIp.values)){
                            _.each(item.vmIp.values, function(ipItem){
                                !_.isString(ipItem.value) && (ipItem.value = angular.toJson(ipItem.value))
                            })
                        };

                        var extParameters = {
                            testNetwork: angular.toJson(item.netWork.values),
                            testHosts: angular.toJson(hostsConfig)
                        };

                        !_.isEmpty(item.vmIp.values) &&
                        _.extend(extParameters, {mountSettings: angular.toJson(item.vmIp.values)});

                        mountConfig.push(_.extend(configs, {extParameters: extParameters}));
                    });
                    var autoMountConfigs = {
                        enabled: enableMount,
                        mountConfigs: []
                    };
                    enableMount && (_.extend(autoMountConfigs, {
                        mountConfigs: mountConfig
                    }));
                    //修改保护策略
                    if (!winData["createFlag"]) {
                        var modifyConf = angular.copy(winData.data);
                        var modifyMountConfigs = angular.copy(autoMountConfigs);
                        if (modifyMountConfigs.enabled) {
                            _.each(modifyMountConfigs.mountConfigs, function(configVal) {
                                delete configVal.siteName;
                                delete configVal.hostName;
                            });
                        };
                        //修改的策略的时候需要往后台增加一个参数
                        _.extend(modifyMountConfigs, {
                            modifyMountConfigs: true
                        });
                        _.extend(modifyConf.props, {
                            AUTOMOUNTCONFIGS: JSON.stringify(modifyMountConfigs)
                        });
                        //修改校验规则:modify挂载策略时，schedules出入空数组
                        modifyConf.schedules = [];
                        var reqConf = {
                            "data": modifyConf,
                            "interceptor": function(next) {
                                var pgName = winData.pg.name;
                                var encodePgName = $.encoder.encodeForHTML(pgName);
                                var msg = appUtils.getString("ism.drm.pg.schedule.modify.msg1", encodePgName) + "<br>" +
                                    appUtils.getString("ism.drm.pg.schedule.modify.msg2", encodePgName) + "<br>" +
                                    appUtils.getString("ism.drm.pg.schedule.modify.msg3");

                                message.warn({
                                    content: msg,
                                    ok: function() {
                                        next();
                                    }
                                });
                            },
                            "success": function() {
                                $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().destroy();
                                message.prompt({
                                    content: appUtils.getString("common_term_operationsyn_success_label"),
                                    ok: function() {
                                        _.isFunction(winData.ok) && winData.ok();
                                    }
                                });
                            }
                        };
                        restService.modifyPolicy(winData.pg.pgId, reqConf);
                    } else {
                        infoTransferredService.put("SAN_MOUNT_POLICY", "MOUNT_CONFIGS", autoMountConfigs);
                        $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().destroy();
                    }
                }
            }, {
                key: "cancel",
                label: appUtils.getString('common_term_cancel_button'),
                focused: false,
                handler: function() {
                    $("#" + Consts.SAN_MOUNT_POLICY_WIN.winId).widget().destroy();
                }
            }]);
        }
    ];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("vm-mount-policy-ctrl", ctrl);
    return module;
})
