define([], function(){
	var ctrl = ["$scope","cookieService","communicationService","utilService","exception","mask","constsService",
	            function($scope,cookieService,communicationService,utilService,exception, mask,Consts){
		$scope.showTopo = false;
		if(!$scope.$parent.tabShow) return;
		$scope.showTopo = true;

		$scope.getLocalLang = function(){
			return cookieService.get("language");
		};

		//路径
		$scope.getRemouteAddress = function(){
			return location.protocol+"//"+location.host;
		};

		$scope.setTitle = function(){
			document.title="OceanStor BCManager eReplication";
		};

		$scope.loadPageWait = function(){
			mask.show();
		};

		$scope.loadPageClose = function(){
			mask.hide();
		};

		$scope.getIsmToken = function(){
			return cookieService.getToken();
		};

		//检查浏览器是否支持flash
		function flashChecker() {
		    var hasFlash = false;
		    try {
		        hasFlash = Boolean(new ActiveXObject('ShockwaveFlash.ShockwaveFlash'));
		    } catch(err) {
		        hasFlash = ('undefined' != typeof navigator.mimeTypes['application/x-shockwave-flash']);
		    }
		    return hasFlash;
		};

		function init(pgId){
			//pgId
			$scope.getProtectGroupId = function(){
				return pgId;
			};

			var url = "app/business/recoverydirector/protection/views/protectiongroup/common/ProtectGroupTopo.swf?timestamp=" + new Date().getTime();

			var topoHtml = $("#topoObj").html().replace("<!--","").replace("-->","");
			topoHtml = topoHtml.replace("_url_",url);

			$("#topoDiv").html(topoHtml);

			//自适应高度
			var height = $("body").height() - $("#pgTab").offset().top - 10;
			$("#topoDiv").height(height);
		}

		init($scope.$parent.protectGroup.pgId);

		//监听保护组对象的改变
		$scope.$on(Consts.PG_SELECT_EVENT,function(evt,msg){
			init(msg.protectGroup.pgId);
		});

	}];
	var module = angular.module('recoverydirector.protection.config');
	module.tinyController('protection.pg.topology.ctrl', ctrl);
	return module;
});