define( ["tiny-extra-widgets/DualSelectBox","tiny-extra-directives/DualSelectBox"], function() {
	"use strict";
	var ctrl = ["$scope", "message", "constsService", "appUtils", "model", "statusEnumService","restService",
	function($scope, message, Consts, appUtils, Model, Status, Rest) {

				var resource = appUtils.resource();
				var avaliableTableFixer = appUtils.tableFixer("avaliableVmsTable","moUuid");
				var selectedTabelFixer = appUtils.tableFixer("selectedVmsTable","moUuid");
				//缓存选中的vms
				var selectedVms = [];
				//选中vms的搜索条件
				var selectedVmsQuery = "";
				var data = appUtils.getWinData();
				var poLen = data.poLen;
				var G_pg = new Model.ProtectGroup(data.protectGroup);
				var poType = G_pg.poType;
				var page=1, orderBy, orderType, queryCondition;
				var osTypeKey = G_pg.poType == "10" ? "GUSTOS" : "osType";

				$scope.text = {
					avaliableVms : resource.getWithColon("resMapping.term.availableVM.tab"),
					selectedVms : resource.getWithColon("resMapping.term.selectVM.tab")
				};

				$scope.Consts = Consts;

				$scope.model = {
					dualSelectBox : {
						"id" : "dualSelectBox",
						"left-values" : [{
							"title"   : "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftTitle.html",
							"title-type" : "url",
							"content" : "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftContent.html",
							"content-type" : "url"
						}],
						"right-values" : [{
							"title"   : "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightTitle.html",
							"title-type" : "url",
							"content" : "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightContent.html",
							"content-type" : "url",
							"add" : {
								id : "addBtn" ,
								click : function(){
									var checkedItems = avaliableTableFixer.getSelectedRow();

									appUtils.union(selectedVms,checkedItems,"moUuid");

				                	 //更新视图
				                	 _updateSelectedVms(selectedVms);
				                	 updateDisableRow();
				                	}
				                },
				                "remove" : {
				                	id : "removeBtn",
				                	click : function(){
				                		var removeItems = selectedTabelFixer.getSelectedRow();
				                	 //(右表格)从选中表格中移除
				                	 appUtils.removeFromArray(selectedVms,removeItems,"moUuid");
				                	 //(左右表格)移除原来选中
				                	 selectedTabelFixer.remove(removeItems,"moUuid");
				                	 avaliableTableFixer.remove(removeItems,"moUuid");
				                	 //更新视图
				                	 _updateSelectedVms(selectedVms);
				                	 updateDisableRow();
				                	 avaliableTableFixer.selectRow();
				                	}
				                }
				            }],
				            "setting" : {"left-width":"400px","height":"400px","right-width":"440px"}
				        },

				        avaliableVms : {
				        	id : "avaliableVmsTable",
				        	displayLength : Consts.TABLE_COUNT_PER_PAGE,
				        	enablePagination : false,
				        	tableFixer : avaliableTableFixer,
				        	data : [],
				        	checkbox : true,
				        	columns : [ {
				        		"bVisible" : false,
				        		"mData" : "moUuid"
				        	}, {
				        		"sTitle" : resource.get("current_alarm_term_name_column"),
				        		"mData" : "name",
				        		"bSortable" : false
				        	},{
								"sTitle" : "ID",
								"mData" : "props.vmId",
								"bSortable" : false,
								"bVisible" : poType == 12
							}, {
				        		"sTitle" : resource.get("common_term_system_label"),
				        		"mData" : "props." + osTypeKey,
				        		"bSortable" : false
				        	}],
				        	tHeadCheckboxFn : function(){
				        		avaliableTableFixer.click();
							},
				        	click : function(event, cell){
				        		updateDisableRow();
				        		avaliableTableFixer.click();
				        	},
				        	callback:function(oPage){
				        		avaliableTableFixer.pageQuery = true;
				        		page = oPage.currentPage;
				        		pageQuery();
				        	},
				        	drawCallback : function(){
				        		avaliableTableFixer.selectRow();
				        		updateDisableRow();
				        	}
				        },

				        selectedVms : {
				        	id : "selectedVmsTable",
				        	displayLength : Consts.TABLE_COUNT_PER_PAGE,
				        	enablePagination : false,
				        	tableFixer : selectedTabelFixer,
				        	data : [],
				        	checkbox : true,
				        	columns : [ {
				        		"bVisible" : false,
				        		"mData" : "moUuid"
				        	}, {
				        		"sTitle" : resource.get("current_alarm_term_name_column"),
				        		"mData" : "name",
				        		"bSortable" : false
				        	},{
								"sTitle" : "ID",
								"mData" : "props.vmId",
								"bSortable" : false,
								"bVisible" : poType == 12
							}, {
				        		"sTitle" : resource.get("common_term_system_label"),
				        		"mData" : "props." + osTypeKey,
				        		"bSortable" : false
				        	}],
				        	tHeadCheckboxFn : function(){
				        		selectedTabelFixer.click();
							},
				        	click : function(event, cell){
				        		selectedTabelFixer.click();
				        	},
				        	drawCallback : function(){
				        		selectedTabelFixer.selectRow();
				        	}
				        },

				        leftSearchSelect : {
							id : "leftSearchSelect",
							values : [{selectId : "name", label : resource.get("current_alarm_term_name_column")}],
							defaultSelectid : "name"
						},

						rightSearchSelect : {
							id : "rightSearchSelect",
							values : [{selectId : "name", label : resource.get("current_alarm_term_name_column")}],
							defaultSelectid : "name"
						},

						leftSearch : {
							id : "leftSearchBox",
							searchFn : function(query){
								query = appUtils.formatSearchVal(query);
								var key = $("#leftSearchSelect").widget().getSelectedId();
								queryCondition = query ? "extFilter." + key + "=" + query : "";
								pageQuery();
							}
						},

						rightSearch : {
							id : "rightSearchBox",
							searchFn : function(query){
								selectedVmsQuery = $.trim(query);
								_updateSelectedVms(selectedVms);
							}
						},

						checkbox : {
							id : "syncCheckbox",
							text : resource.get("protection.addVM.task.param.startreplication.label"),
							checked : false,
							disable : true
						}
				    };

					var _updateAvaliableVms = appUtils.newUpdateTable($scope.model.avaliableVms,$scope);
					function updateAvaliableVms(data){
						_updateAvaliableVms(data);
					}

					//更新已选择的vms
					var _updateSelectedVms = function(data){
						//单独克隆数据进行页面展示
						data = angular.copy(data);

						//根据过滤条件显示
						if( selectedVmsQuery!="" && angular.isArray(data)){
							var key = $("#rightSearchSelect").widget().getSelectedId();
							var delCnt = 0;
							for(var i=0,len=data.length;i<len;i++){
								var item = data[i-delCnt];
								var itemStr = item[key];

								if( angular.isString(itemStr) && angular.isString(selectedVmsQuery) &&
										itemStr.toUpperCase().indexOf(selectedVmsQuery.toUpperCase()) == -1 ){
									data.splice(i-delCnt++,1);
								}
							}
						}

						var table = $scope.model.selectedVms;
						table.totalRecords = data.length;
						table.data = data;
			            table.enablePagination = data.length > table.displayLength;
			            if( table.enablePagination == false ){
			            	table.curPage = { "pageIndex": 1};
			            }
			            $scope.$apply();
					}

					//刷新可选vm的不可选项
					function updateDisableRow(){
						var tbWidget = $("#avaliableVmsTable").widget();
						if(!tbWidget) return;

						var tbData = tbWidget.getTableData();
						var selectedData = appUtils.intersection(selectedVms,tbData,"moUuid");

						appUtils.enableAllRow("avaliableVmsTable",tbData.length);
						selectedData.forEach(function(item){
							tbWidget.setSelectedRow("moUuid", item["moUuid"]);
							var index = appUtils.getIndexFromArray(tbData,"moUuid",item["moUuid"]);
							appUtils.disableRow("avaliableVmsTable",index);
						});
					}


				  //分页查询
				  function pageQuery(filter){
						var oQuery = {
							protectGroupId : G_pg.pgId,
							poType  : poType,
							_FILTER : queryCondition || "",
							_PAGE   : appUtils.queryFilter(page-1,10,orderBy,orderType)
						};

					  	if( poType == "12" ){
					  		var protectType = G_pg.props.protectType;
		        			if(oQuery._FILTER){
		        				oQuery._FILTER += "&extFilter.protectType="+protectType;
		            		}else{
		            			oQuery._FILTER += "extFilter.protectType="+protectType;
		            		}
		        		}else{
		        			if(oQuery._FILTER){
		        				oQuery._FILTER += "&extFilter.protectType=2";
		            		}else{
		            			oQuery._FILTER += "extFilter.protectType=2";
		            		}
		        		}

						Rest.pageAddQueryAvailableProtectObject(oQuery,updateAvaliableVms);
					}


				    function confirmActoin(){
				    	var msg = appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message1",$.encoder.encodeForHTML(G_pg.name)) + "<br>" + appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message2") + "<br>"
                			+ appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message3");

            		if(G_pg.template.type == 1){
            			message.warn({
            				content : msg,
            				ok:function(){
		            			G_pg.polist = selectedVms;
		            			G_pg.addProtectObject({
		            				"success" : function(){
		            					message.prompt( {
		            						content: appUtils.getString(resource.get("site_term_refresh_message")),
		            						ok: function (){ appUtils.closeWin(true); }
		            					});
		            				},
		            				"poNum" : poLen
		            			});
            				}
            			})
            		} else {
				    	G_pg.polist = selectedVms;
				    	G_pg.addProtectObject({
				    		"success" : function(){
				    			message.prompt( {
				    				content: appUtils.getString(resource.get("site_term_refresh_message")),
				    				ok: function (){ appUtils.closeWin(true); }
				    			});
				    		},
				    		"poNum" : poLen
				    	});
            			}
				    }

				    (function init(){

				    	$("#"+Consts.ADD_PO_WIN.winId).widget().option("buttons",[{
				    		label :  resource.get("common_term_confirm_button"),
				    		handler : confirmActoin
				    	}]);

				    	$scope.syncShow = poType == "12" && G_pg.props.protectType == "HostReplication";
				    	if( $scope.syncShow ){
				    		$scope.model.checkbox.checked = G_pg.props.startDr == "true";
				    	}

				    	pageQuery();
				    }());

				}];

		var module = angular.module("recoverydirector.protection.config");
		module.tinyController("addProtectObjectsCtrl", ctrl);
		return module;
});
