define([], function() {
    "use strict";
    var ctrl = ["$scope", "constsService", "appUtils", "restService", "model",
        function($scope, constsService, appUtils, restService, Model) {
            var _winData = $("#" + constsService.SAN_CREATE_REPLICA_WIN.winId).widget().option("data");
            //查询本地服务器信息
            restService.queryLocalServer([], function(data) {
                if (data) {
                    $scope.serverUuid = data.uuid;
                };
            });
            var isStartDb = !_.isEmpty($scope.$state.params) && _.contains([1,2,3,16], parseInt($scope.$state.params.poType, 10));
            $scope.text = {
                siteInfo: appUtils.getStringWithColon("common_term_remoteSite_label"),
                hostGroups: appUtils.getStringWithColon("protection_object_column_hosts_label"),
                preScript: appUtils.getStringWithColon("protection_pre_script_label"),
                postScript: appUtils.getStringWithColon("protection_post_script_label"),
                SCRIPT_TIP: appUtils.getString("others_script_label")
            };
            $scope.model = {
                enableCheck: {
                    id: "enableAutoMount",
                    text: appUtils.getString("protection_auto_mount_hosts_label"),
                    checked: false,
                    change: function() {
                        var checked = $("#enableAutoMount").widget().option("checked");
                        $scope.model.siteSelect.disable = !checked;
                        $scope.model.siteSelect.require = checked;
                        $scope.model.hostSelect.disable = !checked;
                        $scope.model.hostSelect.require = checked;
                        $("#siteSelect").widget().option("values", [{
                            "selectId": "-1",
                            "label": appUtils.getString("protection_mount_site_select_label")
                        }]);
                        $("#hostSelect").widget().option("values", [{
                            "selectId": "-1",
                            "label": appUtils.getString("protection_mount_hosts_select_label")
                        }]);
                        $scope.model.startDataBase.checked = checked;
                        $scope.model.startDataBase.disable = !checked;
                        $scope.model.preScript.disable = !checked;
                        $scope.model.preScript.value = "";
                        $scope.model.postScript.disable = !checked;
                        $scope.model.postScript.value = "";
                        $scope.$apply();
                    }
                },
                siteSelect: {
                    id: "siteSelect",
                    require: false,
                    width: "300",
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("protection_mount_site_select_label")
                    }],
                    defaultSelectid: "-1",
                    disable: true,
                    openFn: function(object){
                        var that = this;
                        restService.querySites([$scope.serverUuid], function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data, "siteId", "name", appUtils.getString("protection_mount_site_select_label"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function(){
                        $("#hostSelect").widget().option("values", [{
                            "selectId": "-1",
                            "label": appUtils.getString("protection_mount_hosts_select_label")
                        }]);
                    }
                },
                hostSelect: {
                    id: "hostSelect",
                    require: false,
                    width: "300",
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("protection_mount_hosts_select_label")
                    }],
                    defaultSelectid: "-1",
                    disable: true,
                    openFn: function(object) {
                        var that = this;
                        var selectSiteId = $("#siteSelect").widget().getSelectedId();
                        if (selectSiteId == "-1") {
                            object.open();
                            return;
                        };
                        restService.queryHostBySite([selectSiteId, 0], function(data) {
                            if (!_.isEmpty(data)) {
                                var hosts = Model.util.formatHosts(data);
                                appUtils.updateSelectValues(that.id, hosts, "deviceSn", "name", appUtils.getString("protection_mount_hosts_select_label"));
                                object.open();
                            } else {
                                object.open();
                            }
                        })
                    }
                },
                startDataBase: {
                    id: "startDataBase",
                    text: appUtils.getString("protection_startDb_after_mount_label"),
                    display: isStartDb,
                    checked: false,
                    disable: true
                },
                preScript: {
                    id: "preScriptText",
                    value: "",
                    width: "300",
                    disable: true,
                    validate: [{
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }]
                },
                postScript: {
                    id: "postScriptText",
                    value: "",
                    width: "300",
                    disable: true,
                    validate: [{
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }]
                },
            };
            setTimeout(function() {
                var linkDesc = appUtils.getString("protection_object_create_dp_prompt_label");
                $("#createReplicaDiv").html(linkDesc);
            }, 0)
        }
    ];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("create-replica-ctrl", ctrl);
    return module;
})
