define([], function() {
    var ctrl = ["$scope", "$compile", "appUtils", "constsService", "restService", "message",
        function($scope, $compile, appUtils, constsService, restService, message) {
            var winData = $("#" + constsService.ADD_FUSIONSTORAGE_PO_WIN.winId).widget().option("data");
            var tableKey = "moUuid";
            var avaliableTableFixer = appUtils.tableFixer("avaliableVmsTable", tableKey);
            var selectedTabelFixer = appUtils.tableFixer("selectedVmsTable", tableKey);
            var selectedVms = [];
            var selectedVmsQuery = "";
            var page = 1,
                orderBy, orderType, queryCondition;
            var storagePoolMapping = _.isString(winData.props.storagePoolMapping) ? JSON.parse(winData.props.storagePoolMapping) : winData.props.storagePoolMapping;
            storagePoolMapping = _.first(storagePoolMapping);
            //灰化已选的vm
            function updateDisableRow() {
                var tbWidget = $("#avaliableVmsTable").widget();
                if (!tbWidget) return;

                var tbData = tbWidget.getTableData();
                var selectedData = appUtils.intersection(selectedVms, tbData, tableKey);

                appUtils.enableAllRow("avaliableVmsTable", tbData.length);
                selectedData.forEach(function(item) {
                    tbWidget.setSelectedRow(tableKey, item[tableKey]);
                    var index = appUtils.getIndexFromArray(tbData, tableKey, item[tableKey]);
                    appUtils.disableRow("avaliableVmsTable", index);
                });
            };
            //已选择的vms
            var _updateSelectedVms = function(data) {
                data = angular.copy(data);
                if (!data) {
                    data = [];
                }
                //根据过滤条件显示
                if (selectedVmsQuery != "" && angular.isArray(data)) {
                    var key = $("#rightSearchSelect").widget().getSelectedId();
                    var delCnt = 0;
                    for (var i = 0, len = data.length; i < len; i++) {
                        var item = data[i - delCnt];
                        var itemStr = item[key];
                        //按id查找
                        if(key == "vmId"){
                            itemStr = item["props"][key];
                        };

                        if (angular.isString(itemStr) && angular.isString(selectedVmsQuery) &&
                            itemStr.toUpperCase().indexOf(selectedVmsQuery.toUpperCase()) == -1) {
                            data.splice(i - delCnt++, 1);
                        }
                    }
                }

                var table = $scope.model.selectedVms;
                table.totalRecords = data.length;
                table.data = data;
                table.enablePagination = data.length > table.displayLength;
                if (table.enablePagination == false) {
                    table.curPage = {
                        "pageIndex": 1
                    };
                };
                $scope.$apply();
            };
            //查询可用虚拟机
            var pageQuery = function() {
                var deviceSn = winData.poProviderSN;
                var oQuery = {
                    poType: winData.poType,
                    _FILTER: queryCondition || "",
                    _PAGE: appUtils.queryFilter(page - 1, 10, orderBy, orderType),
                    deviceSn: $.base64.encode(deviceSn)
                };
                if (oQuery._FILTER) {
                    oQuery._FILTER += "&extFilter.protectType=StorageArray&filterName=poProtectionType&filterValue=vm";
                } else {
                    oQuery._FILTER += "extFilter.protectType=StorageArray&filterName=poProtectionType&filterValue=vm";
                }
                restService.pageQueryAvailableProtectObject(oQuery, {
                    success: updateAvaliableVms,
                });
            };
            //查询添加虚拟机未配置资源池
            var queryPoolResource = function(poData) {
                _.isEmpty(poData) && (poData = []);
                poData = poData.concat(selectedVms);
                var poParam = [];
                if (!_.isEmpty(poData)) {
                    _.each(poData, function(val) {
                        poParam.push({
                            uuid: val.uuid,
                            moUuid: val.moUuid
                        })
                    })
                };
                if (_.isEmpty(poParam)) {
                    return;
                };
                restService.getStorageResources([winData.poType, winData.template.type], {
                    data: poParam,
                    success: function(result) {
                        if (_.isEmpty(result)) {
                            $scope.model.poolTable.data = [];
                            $scope.$apply();
                            return;
                        };
                        var poolData = appUtils.uniqArrayWithKey(result, "poolId");
                        $scope.model.poolTable.data = appUtils.encodeForHTML(angular.copy(poolData));
                        $scope.$apply();
                    }
                });
            };
            $scope.addFsProtectObjectsWizard = {
                id: "addFsProtectObjectsWizard",
                exclude: [],
                preview: false,
                steps: [{
                    id: "avaliableVms",
                    title: appUtils.getString("protection_fsb_add_vm_step1_label"),
                    templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/addFsProtectObjectsStep1.html"
                }, {
                    id: "poolResource",
                    title: appUtils.getString("protection_fsb_add_vm_step2_label"),
                    templateUrl: "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/addFsProtectObjectsStep2.html"
                }],
                previous: function(param) {},
                load: function(currentStep) {},
                active: function(currentStep) {
                    //先查询保护组保护对象
                    if(currentStep.id == "poolResource"){
                        restService.queryProtectObjectsByPage({
                            protectgroupId: winData.pgId,
                            _PAGE: appUtils.queryFilter(0,1000,"","")
                        },{
                            success: function(result){
                                var protectedData = result.records;
                                queryPoolResource(protectedData);
                            }
                        })
                    };
                },
                finish: function() {
                    var poolTableData = $("#poolResourceTable").widget().getTableData();
                    var mappingProps = storagePoolMapping.storagePools;
                    var poolValid = true;
                    for (var i = 0; i < poolTableData.length; i++) {
                        if (!_.isEmpty($("#" + poolTableData[i].poolId).widget())) {
                            if ($("#" + poolTableData[i].poolId).widget().getSelectedId() == "-1") {
                                poolValid = false;
                                break;
                            };
                            mappingProps[poolTableData[i].poolId] = $("#" + poolTableData[i].poolId).widget().getSelectedId()
                        }
                    };
                    if (!poolValid) {
                        message.error(appUtils.getString("protection_create_no_pool_error_label"));
                        return;
                    };
                    //一个灾备存储池只能对应一个生产存储池
                    var drPoolArray = _.values(mappingProps);
                    if(_.size(drPoolArray) != _.size(_.uniq(drPoolArray))){
                        message.error(appUtils.getString("protection_fsb_same_drPool_error_label"));
                        return;
                    };
                    var poLists = [];
                    if (!_.isEmpty(selectedVms)) {
                        _.each(selectedVms, function(val) {
                            poLists.push({
                                moUuid: val.moUuid,
                                props: {
                                    storagePoolMapping: angular.toJson([{
                                        srcDevSN: storagePoolMapping.srcDevSN,
                                        tgtDevSN: storagePoolMapping.tgtDevSN,
                                        storagePools: mappingProps
                                    }])
                                }
                            })
                        })
                    };
                    if (_.isEmpty(poLists)) {
                        return;
                    };
                    //查询是否存在有待更新的卷，如果有，则需要增加提示会随着保护对象的添加一起更新卷
                    restService.getProtectedDiskInfo([winData.pgId], function(result){
                        var updateVol = _.filter(result, function(val) {
                            return _.contains(["UNPROTECTED", "REMOVED"], val["status"])
                        });
                        if(!_.isEmpty(updateVol)){
                            message.prompt({
                                content: appUtils.getString("protection_fsb_add_update_vol_label"),
                                ok: function(){
                                    restService.addProtectObject([winData.pgId], {
                                        data: poLists,
                                        success: function(result) {
                                            message.success(appUtils.getString("common_term_operation_success_label"));
                                            $("#" + constsService.ADD_FUSIONSTORAGE_PO_WIN.winId).widget().destroy();
                                        }
                                    })
                                }
                            })
                        }else{
                            restService.addProtectObject([winData.pgId], {
                                data: poLists,
                                success: function(result) {
                                    message.success(appUtils.getString("common_term_operation_success_label"));
                                    $("#" + constsService.ADD_FUSIONSTORAGE_PO_WIN.winId).widget().destroy();
                                }
                            })
                        };
                    });
                },
                next: function() {
                    if (_.isEmpty(selectedVms)) {
                        message.error(appUtils.getString("common_term_pleaseSelect_listbox_validate", appUtils.getString("resMapping.term.availableVM.tab")));
                        return false;
                    };
                    return true;
                },
                cancel: function() {
                    var winInstance = $("#" + constsService.ADD_FUSIONSTORAGE_PO_WIN.winId).widget();
                    winInstance.option("data", {
                        close: false
                    });
                    winInstance.destroy();
                }
            };
            $scope.text = {
                productSite: appUtils.getStringWithColon("site.term.localSite.label"),
                productStorage: appUtils.getStringWithColon("common_term_fusionManager_label"),
                poolResource: appUtils.getString("protection_create_set_pool_mapping_title"),
                avaliableVms: appUtils.getStringWithColon("resMapping.term.availableVM.tab"),
                selectedVms: appUtils.getStringWithColon("resMapping.term.selectVM.tab"),
            };
            $scope.model = {
                productSite: {
                    value: winData.productSiteName
                },
                productStorage: {
                    value: !_.isEmpty($("#fusionStorageRepTable").widget()) ? _.first($("#fusionStorageRepTable").widget().getTableData())["providerName"] : ""
                },
                dualSelectBox: {
                    "id": "dualSelectBox",
                    "left-values": [{
                        "title": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftTitle.html",
                        "title-type": "url",
                        "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxLeftContent.html",
                        "content-type": "url"
                    }],
                    "right-values": [{
                        "title": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightTitle.html",
                        "title-type": "url",
                        "content": "app/business/recoverydirector/protection/views/protectiongroup/common/virtualization/dualBoxRightContent.html",
                        "content-type": "url",
                        "add": {
                            id: "addBtn",
                            click: function() {
                                var checkedItems = avaliableTableFixer.getSelectedRow();

                                appUtils.union(selectedVms, checkedItems, tableKey);

                                //更新视图
                                _updateSelectedVms(selectedVms);
                                updateDisableRow();
                            }
                        },
                        "remove": {
                            id: "removeBtn",
                            click: function() {
                                var removeItems = selectedTabelFixer.getSelectedRow();
                                //(右表格)从选中表格中移除
                                appUtils.removeFromArray(selectedVms, removeItems, tableKey);
                                //(左右表格)移除原来选中
                                selectedTabelFixer.remove(removeItems, tableKey);
                                avaliableTableFixer.remove(removeItems, tableKey);
                                //更新视图
                                _updateSelectedVms(selectedVms);
                                updateDisableRow();
                                avaliableTableFixer.selectRow();
                            }
                        }
                    }],
                    "setting": {
                        "left-width": "400",
                        "height": "342px",
                        "right-width": "450px"
                    }
                },
                avaliableVms: {
                    id: "avaliableVmsTable",
                    columnsDraggable: true,
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    enablePagination: false,
                    tableFixer: avaliableTableFixer,
                    data: [],
                    checkbox: true,
                    columns: [{
                        "bVisible": false,
                        "mData": tableKey
                    }, {
                        "sTitle": appUtils.getString("current_alarm_term_name_column"),
                        "mData": "name",
                        "bSortable": false,
                    }, {
                        "sTitle": "ID",
                        "mData": "props.vmId",
                        "bSortable": false,
                    }],
                    tHeadCheckboxFn: function() {
                        avaliableTableFixer.click();
                    },
                    click: function(event, cell) {
                        updateDisableRow();
                        avaliableTableFixer.click();
                    },
                    callback: function(oPage) {
                        avaliableTableFixer.pageQuery = true;
                        page = oPage.currentPage;
                        pageQuery();
                    },
                    drawCallback: function() {
                        avaliableTableFixer.selectRow();
                        updateDisableRow();
                    }
                },
                selectedVms: {
                    id: "selectedVmsTable",
                    columnsDraggable: true,
                    displayLength: constsService.TABLE_COUNT_PER_PAGE,
                    enablePagination: false,
                    tableFixer: selectedTabelFixer,
                    data: [],
                    checkbox: true,
                    columns: [{
                        "bVisible": false,
                        "mData": tableKey
                    }, {
                        "sTitle": appUtils.getString("current_alarm_term_name_column"),
                        "mData": "name",
                        "bSortable": false
                    }, {
                        "sTitle": "ID",
                        "mData": "props.vmId",
                        "bSortable": false,
                    }],
                    tHeadCheckboxFn: function() {
                        selectedTabelFixer.click();
                    },
                    click: function(event, cell) {
                        selectedTabelFixer.click();
                    },
                    drawCallback: function() {
                        selectedTabelFixer.selectRow();
                    }
                },
                leftSearchSelect: {
                    id: "leftSearchSelect",
                    values: [{
                        selectId: "name",
                        label: appUtils.getString("current_alarm_term_name_column")
                    },{
                        selectId: "vmid",
                        label: "ID"
                    }],
                    defaultSelectid: "name"
                },
                rightSearchSelect: {
                    id: "rightSearchSelect",
                    values: [{
                        selectId: "name",
                        label: appUtils.getString("current_alarm_term_name_column")
                    },{
                        selectId: "vmId",
                        label: "ID"
                    }],
                    defaultSelectid: "name"
                },
                leftSearch: {
                    id: "leftSearchBox",
                    searchFn: function(query) {
                        query = appUtils.formatSearchVal(query);
                        var key = $("#leftSearchSelect").widget().getSelectedId();
                        queryCondition = query ? "extFilter." + key + "=" + query : "";
                        if(!_.isEmpty(query)){
                            page = 1;
                            $scope.model.avaliableVms.curPage = {
                                "pageIndex": 1
                            };
                        };
                        pageQuery();
                    }
                },
                rightSearch: {
                    id: "rightSearchBox",
                    searchFn: function(query) {
                        selectedVmsQuery = $.trim(query);
                        _updateSelectedVms(selectedVms);
                    }
                },
                poolTable: {
                    id: "poolResourceTable",
                    enablePagination: false,
                    data: [],
                    columns: [{
                        "sTitle": appUtils.getString("protection_create_product_pool_label"),
                        "mData": "poolName",
                        "bSortable": false
                    }, {
                        "sTitle": "",
                        "mData": "",
                        "bSortable": false
                    }, {
                        "sTitle": appUtils.getString("protection_create_dr_pool_label"),
                        "mData": "",
                        "bSortable": false
                    }],
                    renderRow: function(nRow, aData, iDataIndex) {
                        var drPoolId = (storagePoolMapping.storagePools)[aData.poolId];
                        var optColumn = "<tiny-select id='id' default-selectid='defaultId' values='values' width='width' disable='disable' open-fn='openFn' close-fn='closeFn'></tiny-select>";
                        var optScope = $scope.$new();
                        optScope.id = aData.poolId;
                        if(!_.isEmpty(drPoolId)){
                            restService.queryTargetStorages([aData["devSn"]], {
                                success: function(response) {
                                    if (_.isEmpty(response)) {
                                        return;
                                    };
                                    var drStorages = [];
                                    _.each(response.sites, function(val) {
                                        drStorages = drStorages.concat(val.storages)
                                    });
                                    //去掉重复的
                                    drStorages = appUtils.uniqArrayWithKey(drStorages, "deviceSn");
                                    drStorages = _.filter(drStorages, function(val) {
                                        return val["deviceSn"] == storagePoolMapping.tgtDevSN
                                    })[0];
                                    if (_.isEmpty(drStorages)) {
                                        return;
                                    };
                                    var trPool = _.filter(drStorages.pools, function(val){
                                        return val.poolId == drPoolId
                                    })[0];
                                    optScope.values = [{
                                        selectId: drPoolId,
                                        label: trPool["poolName"]
                                    }];
                                    $scope.$apply();
                                }
                            })
                        }else{
                            optScope.values = [{
                                selectId: "-1",
                                label: appUtils.getString("common_term_pleaseSelect_listbox")
                            }];
                        };
                        optScope.defaultId = !_.isEmpty(drPoolId) ? drPoolId : "-1";
                        optScope.disable = !_.isEmpty(drPoolId);
                        optScope.openFn = function(object) {
                            //查询灾备存储池
                            restService.queryTargetStorages([aData["devSn"]], {
                                success: function(response) {
                                    if (_.isEmpty(response)) {
                                        return;
                                    };
                                    var drStorages = [],
                                        drPool = [];
                                    _.each(response.sites, function(val) {
                                        drStorages = drStorages.concat(val.storages)
                                    });
                                    //去掉重复的
                                    drStorages = appUtils.uniqArrayWithKey(drStorages, "deviceSn");
                                    drStorages = _.filter(drStorages, function(val) {
                                        return val["deviceSn"] == storagePoolMapping.tgtDevSN
                                    })[0];
                                    if (_.isEmpty(drStorages)) {
                                        object.open();
                                        return;
                                    };
                                    _.each(drStorages.pools, function(val) {
                                        drPool.push({
                                            selectId: val.poolId,
                                            label: val.poolName
                                        })
                                    });
                                    drPool.unshift({
                                        selectId: "-1",
                                        label: appUtils.getString("common_term_pleaseSelect_listbox"),
                                        checked: true
                                    });
                                    $("#" + aData.poolId).widget().option("values", drPool);
                                    $scope.$apply();
                                    object.open();
                                }
                            })
                        };
                        var setDrPool = $compile($(optColumn))(optScope);
                        $("td:eq(2)", nRow).html(setDrPool);
                        var imgHtml = "<div><img src='/theme/recoverydirector/images/resourceMapping/quickStart/arrow.png'></div>";
                        $("td:eq(1)", nRow).html(imgHtml);
                    },
                    drawCallback: function() {
                        $("#poolResourceTable .tiny-th-content").eq(0).children('div').removeClass("tiny-th-vertival-line");
                    }
                }
            };
            var updateAvaliableVms = appUtils.newUpdateTable($scope.model.avaliableVms, $scope);
            //初始化
            pageQuery();
        }
    ];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController('storage-add-po-ctrl', ctrl);
    return module;
})
