define([], function() {
    var ctrl = ["$scope", "appUtils", "constsService", "restService", "statusEnumService", "message",
        function($scope, appUtils, constsService, restService, statusEnumService, message) {
            var winData = $("#" + constsService.FUSIONSTORAGE_VOLUME_MANAGE_WIN.winId).widget().option("data");
            var storagePoolMapping = winData.props.storagePoolMapping;
            _.isString(storagePoolMapping) && (storagePoolMapping = JSON.parse(storagePoolMapping));
            var tableData = [];
            $scope.needManage = false;
            $scope.allProtected = false;
            var initTable = function() {
                if (_.isEmpty(winData.uuid)) {
                    return;
                };
                restService.getProtectedDiskInfo([winData.uuid], {
                    success: function(result) {
                        if (_.isEmpty(result)) {
                            return;
                        };
                        $scope.volumeList.data = appUtils.encodeForHTML(result);
                        $scope.volumeList.enablePagination = result.length > 10;
                        $scope.volumeList.totalRecords = result.length;
                        var unProtected = _.filter(result, function(val) {
                            return val["status"] == "UNPROTECTED"
                        });
                        var removed = _.filter(result, function(val) {
                            return val["status"] == "REMOVED"
                        });
                        var expanded = _.filter(result, function(val) {
                            return val["status"] == "EXPANDED"
                        });
                        tableData = angular.copy(result);
                        $scope.needManage = !!_.size(unProtected) || !!_.size(removed) || !!_.size(expanded);
                        $scope.allProtected = !$scope.needManage;
                        if ($scope.needManage) {
                            var noMappingData = _.filter(result, function(item) {
                                return (item.poolId != "--" && !_.isEmpty(item.poolId) && _.isEmpty(storagePoolMapping[0].storagePools[item.poolId]))
                            });
                            //去重
                            noMappingData = appUtils.uniqArrayWithKey(noMappingData, "poolId");
                            $scope.needManageMsg = appUtils.getString("protection_fsb_vol_manage_label", _.size(unProtected), _.size(removed), _.size(expanded));
                            $scope.updateDisk = {
                                text: appUtils.getString("protection_fsb_vol_manage_handle_title"),
                                click: function() {
                                    var removeDisk = _.filter(tableData, function(item) {
                                        return item["status"] == "REMOVED"
                                    });
                                    var unprotectedDisk = _.filter(tableData, function(item) {
                                        return item["status"] == "UNPROTECTED"
                                    });
                                    var win = angular.copy(constsService.FUSIONSTORAGE_VOLUME_UPDATE_WIN);
                                    win.title = appUtils.getString("common_message_win_information_title");
                                    win.data = {
                                        needMappingPool: noMappingData,
                                        pgGroup: winData
                                    };
                                    appUtils.showWindow(win, function() {
                                        var mappingProps = storagePoolMapping[0].storagePools;
                                        if (!_.isEmpty(noMappingData) && !_.isEmpty($("#mappingPoolTable").widget())) {
                                            var poolTableData = $("#mappingPoolTable").widget().getTableData();
                                            var poolValid = true;
                                            for (var i = 0; i < poolTableData.length; i++) {
                                                if (!_.isEmpty($("#" + poolTableData[i].poolId).widget())) {
                                                    if ($("#" + poolTableData[i].poolId).widget().getSelectedId() == "-1") {
                                                        poolValid = false;
                                                        break;
                                                    };
                                                    mappingProps[poolTableData[i].poolId] = $("#" + poolTableData[i].poolId).widget().getSelectedId()
                                                };
                                            };
                                            if (!poolValid) {
                                                message.error(appUtils.getString("protection_create_no_pool_error_label"));
                                                return;
                                            };
                                            //一个灾备存储池只能对应一个生产存储池
                                            var drPoolArray = _.values(mappingProps);
                                            if(_.size(drPoolArray) != _.size(_.uniq(drPoolArray))){
                                                message.error(appUtils.getString("protection_fsb_same_drPool_error_label"));
                                                return;
                                            };
                                        };
                                        var addVol = {
                                            storagePoolMapping: angular.toJson([{
                                                srcDevSN: storagePoolMapping[0].srcDevSN,
                                                tgtDevSN: storagePoolMapping[0].tgtDevSN,
                                                storagePools: mappingProps
                                            }])
                                        };
                                        restService.updateDiskInfo([winData.uuid], {
                                            data: addVol,
                                            success: function(result) {
                                                message.prompt({
                                                    content: appUtils.getString("common_term_operationsyn_success_label"),
                                                    ok: function() {}
                                                });
                                            }
                                        });
                                        $("#" + constsService.FUSIONSTORAGE_VOLUME_UPDATE_WIN.winId).widget().destroy();
                                    });
                                }
                            };
                        };
                        $scope.$apply();
                    },
                    fail: function(err) {
                        tableData = [];
                        $scope.volumeList.data = [];
                        $scope.volumeList.enablePagination = false;
                        $scope.$apply();
                    }
                })
            };
            $scope.allProtectedMsg = appUtils.getString("protection_fsb_vol_all_protected_label");
            $scope.volumeSelect = {
                id: "volumeSelect",
                values: [{
                    "selectId": "-1",
                    "label": appUtils.getString("common_term_all_label")
                }, {
                    "selectId": "PROTECTED",
                    "label": appUtils.getString("protection_fsb_vol_status_protected_label")
                }, {
                    "selectId": "UNPROTECTED",
                    "label": appUtils.getString("protection_fsb_vol_status_unprotected_label")
                }, {
                    "selectId": "REMOVED",
                    "label": appUtils.getString("protection_fsb_vol_status_removed_label")
                }, {
                    "selectId": "RELEASING",
                    "label": appUtils.getString("protection_fsb_vol_status_releasing_label")
                }, {
                    "selectId": "CONFIGING",
                    "label": appUtils.getString("protection_fsb_vol_status_configing_label")
                }, {
                    "selectId": "EXPANDED",
                    "label": appUtils.getString("protection_fsb_vol_status_expanded_label")
                }],
                defaultSelectid: "-1",
                change: function() {
                    var selectId = $("#" + this.id).widget().getSelectedId();
                    if ("-1" == selectId) {
                        $scope.volumeList.data = appUtils.encodeForHTML(tableData);
                        $scope.volumeList.enablePagination = tableData.length > 10;
                        $scope.volumeList.totalRecords = tableData.length;
                    } else {
                        var filterData = _.filter(tableData, function(item) {
                            return item["status"] == selectId
                        });
                        $scope.volumeList.data = appUtils.encodeForHTML(filterData);
                        $scope.volumeList.enablePagination = filterData.length > 10;
                        $scope.volumeList.totalRecords = filterData.length;
                    };
                    $scope.$apply();
                }
            };
            $scope.volumeList = {
                id: "volumeManageList",
                data: [],
                enablePagination: false,
                isDraggedRemember: true,
                columns: [{
                    "sTitle": appUtils.getString("rm_term_volumn_column_product_name"),
                    "mData": "deviceName",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("protection_create_product_pool_label"),
                    "mData": "poolName",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("rm_term_volumn_column_virtual"),
                    "mData": "protectObjects",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("protection_create_dr_pool_label"),
                    "mData": "drVol",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("common_term_status_column"),
                    "mData": "status",
                    "bSortable": false
                }],
                renderRow: function(nRow, aData, iDataIndex) {
                    $("td:eq(4)", nRow).html(statusEnumService.getStatus("PROTECTEDDISK_STATUS", aData["status"]));
                    $("td:eq(2)", nRow).html(_.isEmpty(aData["protectObjects"]) ? "--" : aData["protectObjects"][0].name);
                    $("td:eq(3)", nRow).html(_.isEmpty(aData["recoveryPools"]) ? "--" : aData["recoveryPools"][0].poolName);
                }
            };
            //初始化
            initTable()
        }
    ];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController('storage-volume-manage-ctrl', ctrl);
    return module;
})
