define([], function() {
    var ctrl = ["$scope", "$compile", "appUtils", "constsService", "restService", "statusEnumService",
        function($scope, $compile, appUtils, constsService, restService, statusEnumService) {
            var winData = $("#" + constsService.FUSIONSTORAGE_VOLUME_UPDATE_WIN.winId).widget().option("data");
            var storagePoolMapping = winData.pgGroup.props.storagePoolMapping;
            _.isString(storagePoolMapping) && (storagePoolMapping = JSON.parse(storagePoolMapping));
            //查询保护组存储池映射
            var getStoragePoolMapping = function() {
                if (_.isEmpty(winData.pgGroup) || _.isEmpty(winData.pgGroup.pgId)) {
                    return;
                };
                restService.getProtecionGroupStorageMapping([winData.pgGroup.pgId], {
                    success: function(result) {
                        if (_.isEmpty(result["storagePoolMapping"])) {
                            return;
                        };
                        _.each(result["storagePoolMapping"]["storagePools"], function(drPool, pool) {

                        });
                    }
                })
            };
            $scope.updateConfirmInfo = appUtils.getString("protection_fsb_add_vol_confrim_label");
            $scope.mappingPoolTable = {
                id: "mappingPoolTable",
                show: !!_.size(winData["needMappingPool"]),
                handleTip: appUtils.getStringWithColon("protection_fsb_config_dr_pool_label"),
                columns: [{
                    "sTitle": appUtils.getString("protection_create_product_pool_label"),
                    "mData": "poolName",
                    "sWidth": "130px",
                    "bSortable": false
                }, {
                    "sTitle": "",
                    "mData": "",
                    "bSortable": false
                }, {
                    "sTitle": appUtils.getString("protection_create_dr_pool_label"),
                    "mData": "",
                    "bSortable": false
                }],
                data: angular.copy(winData["needMappingPool"]),
                renderRow: function(nRow, aData, iDataIndex) {
                    var optColumn = "<tiny-select id='id' default-selectid='defaultId' values='values' width='width' disable='disable' open-fn='openFn' close-fn='closeFn'></tiny-select>";
                    var optScope = $scope.$new();
                    optScope.id = aData.poolId;
                    optScope.width = "140";
                    optScope.values = [{
                        selectId: "-1",
                        label: appUtils.getString("common_term_pleaseSelect_listbox")
                    }];
                    optScope.defaultId = "-1";
                    optScope.openFn = function(object){
                        //查询灾备存储池
                        restService.queryTargetStorages([aData["devSn"]], {
                            success: function(response) {
                                if (_.isEmpty(response)) {
                                    return;
                                };
                                var drStorages = [],
                                    drPool = [];
                                _.each(response.sites, function(val) {
                                    drStorages = drStorages.concat(val.storages)
                                });
                                //去掉重复的
                                drStorages = appUtils.uniqArrayWithKey(drStorages, "deviceSn");
                                drStorages = _.filter(drStorages, function(val) {
                                    return val["deviceSn"] == storagePoolMapping[0].tgtDevSN
                                })[0];
                                if (_.isEmpty(drStorages)) {
                                    object.open();
                                    return;
                                };
                                _.each(drStorages.pools, function(val) {
                                    drPool.push({
                                        selectId: val.poolId,
                                        label: val.poolName
                                    })
                                });
                                drPool.unshift({
                                    selectId: "-1",
                                    label: appUtils.getString("common_term_pleaseSelect_listbox"),
                                    checked: true
                                });
                                $("#" + aData.poolId).widget().option("values", drPool);
                                $scope.$apply();
                                object.open();
                            }
                        })
                    };
                    var setDrPool = $compile($(optColumn))(optScope);
                    $("td:eq(2)", nRow).html(setDrPool);
                    var imgHtml = "<div><img src='/theme/recoverydirector/images/resourceMapping/quickStart/arrow.png'></div>";
                    $("td:eq(1)", nRow).html(imgHtml);
                },
                drawCallback: function() {
                    $("#mappingPoolTable .tiny-th-content").eq(0).children('div').removeClass("tiny-th-vertival-line");
                }
            }
        }
    ];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController('storage-volume-update-ctrl', ctrl);
    return module;
})
