define(["tiny-extra-lib/jquery.base64"],
    function() {
	"use strict";
	var ctrl = ["$scope", "message", "constsService", "appUtils", "model", "statusEnumService","restService","communicationService","exception","utilService","mask",
			function($scope, message, Consts, appUtils, Model, Status, Rest,communicationService,exception,utilService,mask) {

				var VM_PROTECT_TYPE = Consts.VM_PROTECT_TYPE;
				var winData = appUtils.getWinData();
				var pg = winData.protectGroup;
				var type = winData.type;
				var page=1;

				var vCenterId = pg.poProviderSN;
				var resource = appUtils.resource();

				var protectionType = winData.protectionType;

				$scope.desc = resource.get("protection_vm_task_addProjectWithinDataStore_des_label");
				if(type == "del"){
					$scope.desc = resource.get("protection_vm_task_delProjectWithinDataStore_des_label");
				}

				$scope.dataStorageText = resource.get("resource_mapping_dataStore");

				var vmwareStorageSnapshotFixer = appUtils.tableFixer("vmwareStorageSnapshot","dataStoreUuid");

				$scope.vmwareStorageSnapshot = {
					id : "vmwareStorageSnapshot",
					displayLength : Consts.TABLE_COUNT_PER_PAGE,
					checkbox: true,
					tableFixer : vmwareStorageSnapshotFixer,
					data : [],
					enablePagination : false,
		            columns : [{
						"bVisible" : false,
						"mData" : "dataStoreUuid"
					},{
						"sTitle" : resource.get("resource_mapping_dataStore"),
						"mData" : "dataStoreName",
						"bSortable" : false
					},{
						"sTitle" : resource.get("protection_vmware_term_relateStorageType_column"),
						"mData" : "usedStorageType",
						"bSortable" : false
					}],
					tHeadCheckboxFn : function(){
						page = 1;
						$scope.virtualHostTable.curPage = {"pageIndex": 1};
			        	vmwareStorageSnapshotFixer.click();
			        	updateVM();
					},
					click : function(event, cell){
						page = 1;
						$scope.virtualHostTable.curPage = {"pageIndex": 1};
						vmwareStorageSnapshotFixer.click(cell,updateVM,updateVM);
					}
				};

				//更新虚拟机表格
				function updateVM(){
					var selectRows = $("#vmwareStorageSnapshot").widget().getTableCheckedItems();
					var datastoreGroupIds = [];
					var queryStr="";
					selectRows && selectRows.forEach(function(row){
						datastoreGroupIds.push(row.groupId);
						queryStr+="datastoreGroupIds="+row.groupId+"&";
					});
					queryStr = queryStr.slice(0,queryStr.length-1);

					if(datastoreGroupIds.length>0){
						var url = "/datastoregroups/action/getVMByDataStoreGroup?" + queryStr + "&protectionType="+protectionType+"&vmType=10&pageSize=10&startPage="+(page-1);
						//华为虚拟机用的字符串
						//san双活
						if(protectionType == "HyperMetro"){
							url = url.replace("vmType=10","vmType=12").replace(/(protectionType=)[\s\S]*?&/,"$15&");
						}

						mask.show();
						communicationService.get(utilService.getResouceUrl(url)).always(function(result) {
			                mask.hide();
			                if (exception.check(result)) {
			                    updateVirtualHostTable(result);
			                }
			            });
					}
					else{
						updateVirtualHostTable();
					}

				}

				var updateVmwareStorageSnapshot = appUtils.newUpdateTable($scope.vmwareStorageSnapshot,$scope,function(){
					//列表不分页
					$scope.vmwareStorageSnapshot.enablePagination = false;
				});

				/************ vmware虚拟机列表  *****************/
				$scope.virtualHostDesc = resource.get("ism.drm.site.vrm.list");

				$scope.virtualHostTable = {
					id : "virtualHostTable",
					displayLength : Consts.TABLE_COUNT_PER_PAGE,
					data : [],
					enablePagination : false,
		            columns : [{
						"sTitle" : resource.get("common_term_name_label"),
						"mData" : "name",
						"bSortable" : false
					},{
						"sTitle" : resource.get("common_term_system_label"),
						"mData" : "osType",
						"bSortable" : false
					}],
					callback:function(oPage){
					    page = oPage.currentPage;
					    updateVM();
					}
				};

				var updateVirtualHostTable = appUtils.newUpdateTable($scope.virtualHostTable,$scope);

				if( type == "add" ){
					//华为虚拟机用的字符串
					//san双活
					if(protectionType == "HyperMetro"){
						Rest.getDataGroupByCloud([$.base64.encode(vCenterId),true,5],function(data){
							var dsSet = getDsSet(data);
							updateVmwareStorageSnapshot(dsSet);
						});
					}
					else{
						Rest.getAvailableDataStoreStorageGroup([vCenterId,protectionType],function(data){
							var dsSet = getDsSet(data);
							updateVmwareStorageSnapshot(dsSet);
						});
					}
				}
				else{
					Rest.queryDatastoreGroup(pg.pgId,function(data){
						var dsSet = getDsSet(data);
						updateVmwareStorageSnapshot(dsSet);
					});
				}

				$("#"+Consts.VM_NAS_PO_MODIFY.winId).widget().option("buttons",[{
                     label :  appUtils.getString("common_term_confirm_button"),
                     handler : function(){
						var selectDs = vmwareStorageSnapshotFixer.getSelectedRow();
						if( !angular.isArray(selectDs) || selectDs.length == 0 ){
							return appUtils.closeWin();
						}

						var dsIds = [];
						selectDs.forEach(function(ds){
							dsIds.push(ds.dataStoreUuid);
						});

                     	var q = {
                     		data : dsIds,
                     		success : function(){
	                 			 message.prompt( {
									 content: appUtils.getString(appUtils.getString("site_term_refresh_message")),
									 ok: function (){ appUtils.closeWin(true); }
		                         });
                     		}
                     	};

                     	if(type == "add"){

                     		if( pg.template.type == 9 || pg.template.type == 1){
                     			var msg = appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message1",$.encoder.encodeForHTML(pg.name)) + "<br>" + appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message2") + "<br>"
                				+ appUtils.getString("protection.VISSnapshot.task.addProtectedObject.danger.message3");

                				message.warn({
                    				content : msg,
                    				ok:function(){
                    					Rest.addDatastoreToProtectGroup(pg.pgId,q);
                    				}
                    			});
                     		}
                     		else{
                     			Rest.addDatastoreToProtectGroup(pg.pgId,q);
                     		}
                     	}
                     	else{
                     		var items = $("#vmwareStorageSnapshot").widget().getTableData();
                     		//不能全选
                     		if( items.length == selectDs.length ){
                     			var msg = resource.get("protection_vm_task_delProjectWithinDataStore_validation_reserveOne_message");
                     			return message.error(msg);
                     		}

                     		var poNames = "";
                 			selectDs.forEach(function(ds){
                 				poNames += $.encoder.encodeForHTML(ds.dataStoreName) + ", ";
							});
							poNames = poNames.slice(0,-2);
							poNames = "<div style='max-width:100px;display:inline-block;vertical-align:bottom;word-wrap:normal;top:0' class='nowrap' title='"+poNames+"'>"+poNames+"</div>"

							var msg;
							if (pg.template.type == 2 || pg.template.type == 14 || pg.template.type == 19 ) {
								msg = appUtils.getString("protection_term_task_removeProtectedObject", $.encoder.encodeForHTML(pg.name), poNames);
							}
                     		else if( pg.template.type == 9 || pg.template.type == 1){
                     			msg = resource.get("protection.VISSnapshot.task.removeProtectedObject.danger.message1",$.encoder.encodeForHTML(pg.name),poNames) + "</br>" +
		        				resource.get("protection.VISSnapshot.task.removeProtectedObject.danger.message2") + "</br>" +
		        				resource.get("protection.VISSnapshot.task.removeProtectedObject.danger.message3");
                     		}
                     		else{
                     			msg = resource.get("ism.drm.protect.group.delete.element.prompt.1",$.encoder.encodeForHTML(pg.name),poNames) + "</br>" +
	        					resource.get("ism.drm.protect.group.delete.element.prompt.2") + "</br>" +
	        					resource.get("ism.drm.protect.group.delete.element.prompt.3");
                     		}

                     		message.warn({
		        				content: msg,
		        				ok: function(){
		        					Rest.removeDatastoreFromProtectGroup(pg.pgId,q);
		        				}
		        			});
                     	}
                     }
				 }]);

				//从dsg中获取ds
				function getDsSet(dsgSet){
					var dsSet = [];
					if(!angular.isArray(dsgSet)) return;
					dsgSet.forEach(function(dsg){
						if( angular.isArray(dsg.datastoreInfo) ){
							dsg.datastoreInfo.forEach(function(ds){
								if(ds){
									ds.groupId = dsg.groupId;
									ds && dsSet.push(ds);
								}
							});
						}
					});
					return dsSet;
				}

	}];

		var module = angular.module("recoverydirector.protection.config");
		module.tinyController("modifyProtectObjectsCtrl", ctrl);
		return module;
});
