define([], function() {
    "use strict";
    var ctrl = ["$scope", "constsService", "appUtils", "restService", "model",
        function($scope, constsService, appUtils, restService, Model) {
            $scope.text = {
                hostGroups: appUtils.getStringWithColon("protection_object_column_hosts_label"),
                preScript: appUtils.getStringWithColon("protection_pre_script_label"),
                postScript: appUtils.getStringWithColon("protection_post_script_label"),
                SCRIPT_TIP: appUtils.getString("others_script_label")
            };
            //查询本地服务器信息
            restService.queryLocalServer([], function(data) {
                if (data) {
                    $scope.serverUuid = data.uuid;
                };
            });
            var isStartDb = !_.isEmpty($scope.$state.params) && _.contains([1,2,3,16], parseInt($scope.$state.params.poType, 10));
            $scope.model = {
                siteSelect: {
                    id: "siteSelect",
                    width: 140,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("protection_mount_site_select_label")
                    }],
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        restService.querySites([$scope.serverUuid], function(data) {
                            if (!_.isEmpty(data)) {
                                appUtils.updateSelectValues(that.id, data, "siteId", "name", appUtils.getString("protection_mount_site_select_label"));
                                object.open();
                            } else {
                                object.open();
                            };
                        });
                    },
                    change: function() {
                        $("#hostSelect").widget().option("values", [{
                            "selectId": "-1",
                            "label": appUtils.getString("protection_mount_hosts_select_label")
                        }]);
                    }
                },
                hostSelect: {
                    id: "hostSelect",
                    width: 140,
                    values: [{
                        "selectId": "-1",
                        "label": appUtils.getString("protection_mount_hosts_select_label")
                    }],
                    defaultSelectid: "-1",
                    openFn: function(object) {
                        var that = this;
                        var selectSiteId = $("#siteSelect").widget().getSelectedId();
                        if (selectSiteId == "-1") {
                            object.open();
                            return;
                        };
                        restService.queryHostBySite([selectSiteId, 0], function(data) {
                            if (!_.isEmpty(data)) {
                                var hosts = Model.util.formatHosts(data);
                                appUtils.updateSelectValues(that.id, hosts, "deviceSn", "name", appUtils.getString("protection_mount_hosts_select_label"));
                                object.open();
                            } else {
                                object.open();
                            }
                        })
                    }
                },
                startDataBase: {
                    id: "startDataBase",
                    text: appUtils.getString("protection_startDb_after_mount_label"),
                    display: isStartDb,
                    checked: true,
                    disable: false
                },
                preScript: {
                    id: "preScript",
                    width: "283",
                    value: "",
                    validate: [{
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }]
                },
                postScript: {
                    id: "postScript",
                    width: "283",
                    value: "",
                    validate: [{
                        validFn: "minSize",
                        params: [4],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "maxSize",
                        params: [32],
                        errorDetail: appUtils.getString("validate_term_script")
                    }, {
                        validFn: "isScript",
                        errorDetail: appUtils.getString("validate_term_script")
                    }]
                }
            };
            setTimeout(function() {
                var linkDesc = appUtils.getString("protection_duplice_mount_prompt_label");
                $("#replicaMountDiv").html(linkDesc);
            }, 0)
        }
    ];
    var module = angular.module("recoverydirector.protection.config");
    module.tinyController("replica-mount-ctrl", ctrl);
    return module;
})
