define([], function() {
	"use strict";
	var ctrl = ["$scope", "message", "constsService", "appUtils", "statusEnumService", "restService",
		function($scope, message, Consts, appUtils, Status, Rest) {
			var data = $("#" + Consts.SHOW_POCONLIST_WIN.winId).widget().option("data");
			var tableArray = data.pro;
			//搜索框变化时的模糊查询
			var searchMethod = function(){
				var selectWidget = $("#pdbListSearch").widget().getSearchboxValue();
				var keyValue = selectWidget.type;
				var searchValue = $.trim(selectWidget.inputValue);
				var queryArray = [];
				var copyArray = angular.copy(tableArray);
				if(keyValue == "0"){
					if(_.isEmpty(searchValue)){
						queryArray = copyArray;
					}else{
						_.each(copyArray,function(val){
							(val.pdbName.toUpperCase().indexOf(searchValue.toUpperCase()) != -1) && queryArray.push(val)
						})
					}
				}else{
					if(_.isEmpty(searchValue)){
						queryArray = copyArray;
					}else{
						_.each(copyArray,function(val){
							($.trim(val.conID).toUpperCase().indexOf(searchValue.toUpperCase()) != -1) && queryArray.push(val)
						})
					}
				}
				$scope.model.table.enablePagination = queryArray.length > 10;
				$scope.model.table.curPage = {"pageIndex":1};
				$scope.model.table.totalRecords = queryArray.length;
				$scope.model.table.data = appUtils.encodeForHTML(queryArray);
				$scope.$apply();
			};

			$scope.model = {
				select: {
					id: "pdbListSearch",
					values: [{selectId: "0", label: appUtils.getString("common_term_name_label")},
					{selectId: "1", label: appUtils.getString("common_term_pdb_id_label")}],
					defaultSelectid: "0",
					showTip: true,
					click: function(){
						searchMethod();
					}
				},
				table: {
					id: "pdbListTable",
					columns: [{
						"sTitle" : appUtils.getString("common_term_name_label"),
						"mData":"pdbName"
					},{
						"sTitle" : appUtils.getString("common_term_pdb_id_label"),
						"mData":"conID"
					}],
					enablePagination: tableArray.length > 10 ? true : false ,
					displayLength: 10,
					totalRecords: tableArray.length,
					data:appUtils.encodeForHTML(tableArray)
				}
			}
		}];

	var module = angular.module("recoverydirector.protection.config");
	module.tinyController("show_pdb_list_ctrl", ctrl);
	return module;
});
